/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.core.internal.utils;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;

public abstract class AbstractListeners<LISTENER, EVENT> {
    private static final System.Logger LOGGER = System.getLogger(AbstractListeners.class.getName());
    private final Set<LISTENER> listeners = new CopyOnWriteArraySet<LISTENER>();

    public boolean add(LISTENER listener) {
        if (!this.listeners.add(listener)) {
            LOGGER.log(System.Logger.Level.DEBUG, "Trying to add listener {0} which is already registered with {1}.", listener, this);
            return false;
        }
        return true;
    }

    public int count() {
        return this.listeners.size();
    }

    public void dispatchEvent(EVENT e) {
        this.listeners.forEach(l -> this.dispatchEvent(e, l));
    }

    public abstract void dispatchEvent(EVENT var1, LISTENER var2);

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public boolean isNotEmpty() {
        return !this.listeners.isEmpty();
    }

    public boolean remove(LISTENER listener) {
        if (!this.listeners.remove(listener)) {
            LOGGER.log(System.Logger.Level.WARNING, "Trying to remove listener {0} which is not registered with {1}.", listener, this);
            return false;
        }
        return true;
    }

    public void removeAll() {
        this.listeners.clear();
    }
}

