/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javaee.wildfly.ide;

import java.io.File;
import java.io.IOException;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.plugins.api.ServerDebugInfo;
import org.netbeans.modules.j2ee.deployment.plugins.api.UISupport;
import org.netbeans.modules.j2ee.deployment.plugins.spi.StartServer;
import org.netbeans.modules.javaee.wildfly.WildflyDeploymentManager;
import org.netbeans.modules.javaee.wildfly.ide.WildflyDeploymentStatus;
import org.netbeans.modules.javaee.wildfly.ide.WildflyOutputSupport;
import org.netbeans.modules.javaee.wildfly.ide.WildflyStartRunnable;
import org.netbeans.modules.javaee.wildfly.ide.WildflyStopRunnable;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class WildflyStartServer
extends StartServer
implements ProgressObject {
    private static final Logger LOGGER = Logger.getLogger(WildflyStartServer.class.getName());
    private static final int AVERAGE_SERVER_INSTANCES = 5;
    private static final RequestProcessor SERVER_CONTROL_RP = new RequestProcessor("JBoss Control", 5);
    private MODE mode;
    private final WildflyDeploymentManager dm;
    private boolean consoleConfigured = false;
    private static final Set<String> IS_DEBUG_MODE_URI = ConcurrentHashMap.newKeySet(5);
    private Vector listeners = new Vector();
    private DeploymentStatus deploymentStatus;

    public WildflyStartServer(DeploymentManager dm) {
        this.dm = (WildflyDeploymentManager)dm;
    }

    private void addDebugModeUri() {
        IS_DEBUG_MODE_URI.add(this.dm.getUrl());
    }

    private void removeDebugModeUri() {
        IS_DEBUG_MODE_URI.remove(this.dm.getUrl());
    }

    private boolean existsDebugModeUri() {
        return IS_DEBUG_MODE_URI.contains(this.dm.getUrl());
    }

    public ProgressObject startDebugging(Target target) {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WildflyStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.DEBUG;
        SERVER_CONTROL_RP.post((Runnable)new WildflyStartRunnable(this.dm, this), 0, 5);
        this.consoleConfigured = true;
        this.addDebugModeUri();
        return this;
    }

    public boolean isDebuggable(Target target) {
        if (!this.existsDebugModeUri()) {
            return false;
        }
        return this.isRunning();
    }

    public boolean supportsStartDebugging(Target target) {
        return true;
    }

    public boolean supportsStartProfiling(Target target) {
        return true;
    }

    public boolean isAlsoTargetServer(Target target) {
        return true;
    }

    public ServerDebugInfo getDebugInfo(Target target) {
        return new ServerDebugInfo("localhost", this.dm.getDebuggingPort());
    }

    public ProgressObject startProfiling(Target target) {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WildflyStartServer.class, (String)"MSG_START_PROFILED_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.PROFILE;
        SERVER_CONTROL_RP.post((Runnable)new WildflyStartRunnable(this.dm, this), 0, 5);
        this.consoleConfigured = true;
        this.removeDebugModeUri();
        return this;
    }

    public boolean supportsStartDeploymentManager() {
        return true;
    }

    public ProgressObject stopDeploymentManager() {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.STOP, StateType.RUNNING, NbBundle.getMessage(WildflyStartServer.class, (String)"MSG_STOP_SERVER_IN_PROGRESS", (Object)serverName)));
        SERVER_CONTROL_RP.post((Runnable)new WildflyStopRunnable(this.dm, this), 0, 5);
        this.removeDebugModeUri();
        return this;
    }

    public ProgressObject startDeploymentManager() {
        String serverName = this.dm.getInstanceProperties().getProperty("displayName");
        this.fireHandleProgressEvent(null, new WildflyDeploymentStatus(ActionType.EXECUTE, CommandType.START, StateType.RUNNING, NbBundle.getMessage(WildflyStartServer.class, (String)"MSG_START_SERVER_IN_PROGRESS", (Object)serverName)));
        this.mode = MODE.RUN;
        SERVER_CONTROL_RP.post((Runnable)new WildflyStartRunnable(this.dm, this), 0, 5);
        this.consoleConfigured = true;
        this.removeDebugModeUri();
        return this;
    }

    public boolean needsStartForTargetList() {
        return false;
    }

    public boolean needsStartForConfigure() {
        return false;
    }

    public boolean needsStartForAdminConfig() {
        return false;
    }

    private boolean isReallyRunning() {
        final InstanceProperties ip = this.dm.getInstanceProperties();
        if (ip == null) {
            return false;
        }
        SafeTrueTest test = new SafeTrueTest(this){
            final /* synthetic */ WildflyStartServer this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    this.result = this.this$0.dm.getClient().isServerRunning(ip.getProperty("root-dir"), ip.getProperty("config_file"));
                }
                catch (Throwable t) {
                    LOGGER.log(Level.INFO, null, t);
                }
            }
        };
        return this.safeTrueTest(test, 10000);
    }

    private boolean safeTrueTest(SafeTrueTest test, int timeout) {
        try {
            new RequestProcessor().post((Runnable)test).waitFinished((long)timeout);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return test.result();
    }

    public boolean isRunning() {
        InstanceProperties ip = this.dm.getInstanceProperties();
        if (ip == null) {
            return false;
        }
        if (!this.isReallyRunning()) {
            WildflyDeploymentManager.setRunningLastCheck(ip, Boolean.FALSE);
            return false;
        }
        WildflyDeploymentManager.setRunningLastCheck(ip, Boolean.TRUE);
        if (!this.consoleConfigured) {
            WildflyOutputSupport outputSupport = WildflyOutputSupport.getInstance(ip, true);
            try {
                outputSupport.start(this.openConsole(), new File(this.dm.getClient().getServerLog()));
                this.consoleConfigured = true;
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return true;
    }

    private InputOutput openConsole() {
        InputOutput io = UISupport.getServerIO((String)this.dm.getUrl());
        if (io == null) {
            return null;
        }
        try {
            io.getOut().reset();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        io.select();
        return io;
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isStopSupported() {
        return true;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[0];
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        this.deploymentStatus = deploymentStatus;
        Vector targets = null;
        WildflyStartServer wildflyStartServer = this;
        synchronized (wildflyStartServer) {
            if (this.listeners != null) {
                targets = (Vector)this.listeners.clone();
            }
        }
        if (targets != null) {
            for (int i = 0; i < targets.size(); ++i) {
                ProgressListener target = (ProgressListener)targets.elementAt(i);
                target.handleProgressEvent(evt);
            }
        }
    }

    MODE getMode() {
        return this.mode;
    }

    void setConsoleConfigured(boolean console) {
        this.consoleConfigured = console;
    }

    static enum MODE {
        RUN,
        DEBUG,
        PROFILE;

    }

    private static abstract class SafeTrueTest
    implements Runnable {
        protected boolean result = false;

        private SafeTrueTest() {
        }

        @Override
        public abstract void run();

        public final boolean result() {
            return this.result;
        }
    }

    static enum ACTION_STATUS {
        SUCCESS,
        FAILURE,
        UNKNOWN;

    }
}

