/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.hints;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.DocTreePath;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.DocTreePathHandle;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.javadoc.hints.Bundle;
import org.netbeans.spi.java.hints.JavaFix;

abstract class AddTagFix
extends JavaFix {
    private final String message;
    private final DocTreePathHandle dtph;
    private final int index;

    private AddTagFix(DocTreePathHandle dtph, String message, int index) {
        super(dtph.getTreePathHandle());
        this.dtph = dtph;
        this.message = message;
        this.index = index;
    }

    protected void performRewrite(JavaFix.TransformationContext ctx) throws Exception {
        WorkingCopy javac = ctx.getWorkingCopy();
        DocTreePath path = this.dtph.resolve((CompilationInfo)javac);
        DocCommentTree docComment = path.getDocComment();
        TreeMaker make = javac.getTreeMaker();
        TagComparator comparator = new TagComparator();
        LinkedList<DocTree> blockTags = new LinkedList<DocTree>();
        DocTree newTree = this.getNewTag(make);
        boolean added = false;
        int count = 0;
        for (DocTree docTree : docComment.getBlockTags()) {
            if (!added && comparator.compare(newTree, docTree) == -1) {
                blockTags.add(newTree);
                added = true;
            }
            if (!added && comparator.compare(newTree, docTree) == 0 && this.index == count++) {
                blockTags.add(newTree);
                added = true;
            }
            blockTags.add(docTree);
        }
        if (!added) {
            blockTags.add(newTree);
        }
        DocCommentTree newDoc = make.DocComment(docComment.getFullBody(), blockTags);
        Tree tree = ctx.getPath().getLeaf();
        javac.rewrite(tree, (DocTree)docComment, (DocTree)newDoc);
    }

    protected abstract DocTree getNewTag(TreeMaker var1);

    public static JavaFix createAddParamTagFix(DocTreePathHandle dtph, final String name, final boolean isTypeParam, int index) {
        return new AddTagFix(dtph, isTypeParam ? Bundle.MISSING_TYPEPARAM_HINT("<" + name + ">") : Bundle.MISSING_PARAM_HINT(name), index){

            @Override
            protected DocTree getNewTag(TreeMaker make) {
                return make.Param(isTypeParam, make.DocIdentifier((CharSequence)name), Collections.emptyList());
            }
        };
    }

    public static JavaFix createAddReturnTagFix(DocTreePathHandle dtph) {
        return new AddTagFix(dtph, Bundle.MISSING_RETURN_HINT(), -1){

            @Override
            protected DocTree getNewTag(TreeMaker make) {
                return make.DocReturn(Collections.emptyList());
            }
        };
    }

    public static JavaFix createAddThrowsTagFix(DocTreePathHandle dtph, final String fqn, int throwIndex) {
        return new AddTagFix(dtph, Bundle.MISSING_THROWS_HINT(fqn), throwIndex){

            @Override
            protected DocTree getNewTag(TreeMaker make) {
                return make.Throws(make.Reference((ExpressionTree)make.Identifier((CharSequence)fqn), null, null), Collections.emptyList());
            }
        };
    }

    public static JavaFix createAddDeprecatedTagFix(DocTreePathHandle dtph) {
        return new AddTagFix(dtph, Bundle.MISSING_DEPRECATED_HINT(), -1){

            @Override
            protected DocTree getNewTag(TreeMaker make) {
                return make.Deprecated(Collections.emptyList());
            }
        };
    }

    public String getText() {
        return this.message;
    }

    private static class TagComparator
    implements Comparator<DocTree> {
        private static final int HIGHER = -1;
        private static final int EQUAL = 0;
        private static final int LOWER = 1;

        private TagComparator() {
        }

        @Override
        public int compare(DocTree t, DocTree t1) {
            if (t.getKind() == t1.getKind()) {
                if (t.getKind() == DocTree.Kind.PARAM) {
                    ParamTree p = (ParamTree)t;
                    ParamTree p1 = (ParamTree)t1;
                    if (p.isTypeParameter() && !p1.isTypeParameter()) {
                        return -1;
                    }
                    if (!p.isTypeParameter() && p1.isTypeParameter()) {
                        return 1;
                    }
                }
                return 0;
            }
            switch (t.getKind()) {
                case AUTHOR: {
                    return -1;
                }
                case VERSION: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR) {
                        return 1;
                    }
                    return -1;
                }
                case PARAM: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION) {
                        return 1;
                    }
                    return -1;
                }
                case RETURN: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM) {
                        return 1;
                    }
                    return -1;
                }
                case EXCEPTION: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN) {
                        return 1;
                    }
                    return -1;
                }
                case THROWS: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION) {
                        return 1;
                    }
                    return -1;
                }
                case SEE: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS) {
                        return 1;
                    }
                    return -1;
                }
                case SINCE: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS || t1.getKind() == DocTree.Kind.SEE) {
                        return 1;
                    }
                    return -1;
                }
                case SERIAL: 
                case SERIAL_DATA: 
                case SERIAL_FIELD: {
                    if (t1.getKind() == DocTree.Kind.AUTHOR || t1.getKind() == DocTree.Kind.VERSION || t1.getKind() == DocTree.Kind.PARAM || t1.getKind() == DocTree.Kind.RETURN || t1.getKind() == DocTree.Kind.EXCEPTION || t1.getKind() == DocTree.Kind.THROWS || t1.getKind() == DocTree.Kind.SEE || t1.getKind() == DocTree.Kind.SINCE) {
                        return 1;
                    }
                    return -1;
                }
                case DEPRECATED: {
                    if (t1.getKind() == DocTree.Kind.UNKNOWN_BLOCK_TAG) {
                        return -1;
                    }
                    return 1;
                }
                case UNKNOWN_BLOCK_TAG: {
                    return 1;
                }
            }
            return 1;
        }
    }
}

