/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.errors;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.TreePath;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.JavaFix;
import org.netbeans.spi.java.hints.JavaFixUtilities;
import org.openide.util.NbBundle;

public final class RemoveUselessCast
implements ErrorRule<Void> {
    public Set<String> getCodes() {
        return Collections.singleton("compiler.warn.redundant.cast");
    }

    public List<Fix> run(CompilationInfo info, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        TreePath path = info.getTreeUtilities().pathFor(offset + 1);
        if (path != null && path.getLeaf().getKind() == Tree.Kind.TYPE_CAST) {
            return Collections.singletonList(new FixImpl(info, path).toEditorFix());
        }
        return Collections.emptyList();
    }

    public void cancel() {
    }

    public String getId() {
        return RemoveUselessCast.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_Remove_Useless_Cast_Fix");
    }

    public String getDescription() {
        return NbBundle.getMessage(RemoveUselessCast.class, (String)"DSC_Remove_Useless_Cast_Fix");
    }

    private static final class FixImpl
    extends JavaFix {
        public FixImpl(CompilationInfo info, TreePath path) {
            super(info, path);
        }

        public String getText() {
            return NbBundle.getMessage(RemoveUselessCast.class, (String)"LBL_FIX_Remove_redundant_cast");
        }

        protected void performRewrite(JavaFix.TransformationContext ctx) {
            WorkingCopy wc = ctx.getWorkingCopy();
            TreePath path = ctx.getPath();
            TypeCastTree tct = (TypeCastTree)path.getLeaf();
            ExpressionTree expression = tct.getExpression();
            while (expression.getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis((Tree)((ParenthesizedTree)expression).getExpression(), (Tree)tct, (Tree)path.getParentPath().getLeaf())) {
                expression = ((ParenthesizedTree)expression).getExpression();
            }
            while (path.getParentPath().getLeaf().getKind() == Tree.Kind.PARENTHESIZED && !JavaFixUtilities.requiresParenthesis((Tree)expression, (Tree)path.getLeaf(), (Tree)path.getParentPath().getParentPath().getLeaf())) {
                path = path.getParentPath();
            }
            wc.rewrite(path.getLeaf(), (Tree)expression);
        }
    }
}

