/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javascript.nodejs.exec;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.Project;
import org.netbeans.spi.project.ui.ProjectOpenedHook;

public final class NodeProcesses {
    private final Map<String, RunInfo> npmScripts = new ConcurrentHashMap<String, RunInfo>();
    private volatile RunInfo projectRun = RunInfo.none();

    public static NodeProcesses forProject(Project project) {
        NodeProcesses processes = (NodeProcesses)project.getLookup().lookup(NodeProcesses.class);
        assert (processes != null) : "NodeProcesses should be found in project " + project.getClass().getName() + " (lookup: " + project.getLookup() + ")";
        return processes;
    }

    public void stop() {
        if (this.projectRun.isRunning()) {
            this.projectRun.stop();
        }
        for (RunInfo runInfo : this.npmScripts.values()) {
            if (!runInfo.isRunning()) continue;
            runInfo.stop();
        }
        this.npmScripts.clear();
    }

    public RunInfo getProjectRun() {
        assert (this.projectRun != null);
        return this.projectRun;
    }

    public void setProjectRun(RunInfo projectRun) {
        assert (projectRun != null);
        this.projectRun = projectRun;
    }

    public RunInfo getNpmScript(String script) {
        assert (script != null);
        RunInfo info = this.npmScripts.get(script);
        if (info != null) {
            return info;
        }
        return RunInfo.none();
    }

    public void setNpmScript(String script, RunInfo runInfo) {
        assert (script != null);
        assert (runInfo != null);
        this.npmScripts.put(script, runInfo);
    }

    public static final class RunInfo {
        private final AtomicReference<Future<Integer>> currentNodeTask;
        private final boolean debug;

        private RunInfo(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask, boolean debug) {
            this.currentNodeTask = currentNodeTask;
            this.debug = debug;
        }

        public static RunInfo run(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask) {
            return new RunInfo(currentNodeTask, false);
        }

        public static RunInfo debug(@NullAllowed AtomicReference<Future<Integer>> currentNodeTask) {
            return new RunInfo(currentNodeTask, true);
        }

        public static RunInfo none() {
            return new RunInfo(null, false);
        }

        public boolean isDebug() {
            return this.debug;
        }

        public boolean isRunning() {
            Future<Integer> nodeTask = this.getCurrentNodeTask();
            return nodeTask != null && !nodeTask.isDone();
        }

        public void stop() {
            Future<Integer> nodeTask = this.getCurrentNodeTask();
            assert (nodeTask != null);
            nodeTask.cancel(true);
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @CheckForNull
        private Future<Integer> getCurrentNodeTask() {
            if (this.currentNodeTask == null) {
                return null;
            }
            return this.currentNodeTask.get();
        }
    }

    public static class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        private final Project project;

        public ProjectOpenedHookImpl(Project project) {
            this.project = project;
        }

        protected void projectOpened() {
        }

        protected void projectClosed() {
            NodeProcesses.forProject(this.project).stop();
        }
    }
}

