/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.module.wizards.shortcut;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.wizards.shortcut.CustomizeScriptPanel;
import org.apache.tools.ant.module.wizards.shortcut.IntroPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectFolderPanel;
import org.apache.tools.ant.module.wizards.shortcut.SelectKeyboardShortcutPanel;
import org.apache.tools.ant.module.wizards.shortcut.ShortcutWizard;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

final class ShortcutIterator
implements WizardDescriptor.Iterator<ShortcutWizard> {
    private transient int index;
    private transient List<WizardDescriptor.Panel<ShortcutWizard>> panels;
    private transient ShortcutWizard wiz;
    private transient ChangeSupport cs = new ChangeSupport((Object)this);

    ShortcutIterator() {
    }

    private List<WizardDescriptor.Panel<ShortcutWizard>> createPanels() {
        ArrayList<WizardDescriptor.Panel<ShortcutWizard>> _panels = new ArrayList<WizardDescriptor.Panel<ShortcutWizard>>();
        _panels.add(new IntroPanel.IntroWizardPanel());
        _panels.add(new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_select_menu_to_add_to"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_TEXT_menu_locn"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_display_name_for_menu"), DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)"Menu")), true, "wizdata.folder.menu"));
        _panels.add(new SelectFolderPanel.SelectFolderWizardPanel(NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_select_toolbar"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_TEXT_toolbar_locn"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_display_name_for_toolbar"), DataFolder.findFolder((FileObject)FileUtil.getConfigFile((String)"Toolbars")), false, "wizdata.folder.tool"));
        _panels.add(new SelectKeyboardShortcutPanel.SelectKeyboardShortcutWizardPanel());
        _panels.add(new CustomizeScriptPanel.CustomizeScriptWizardPanel());
        return _panels;
    }

    private String[] createSteps() {
        return new String[]{NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_choose_options"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_add_to_menu"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_add_to_toolbar"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_make_keyboard_shortcut"), NbBundle.getMessage(ShortcutIterator.class, (String)"SI_LBL_cust_script")};
    }

    void initialize(ShortcutWizard wiz) {
        this.wiz = wiz;
        this.index = 0;
        this.panels = this.createPanels();
        ((IntroPanel.IntroWizardPanel)this.panels.get(0)).initialize(wiz);
        String[] steps = this.createSteps();
        for (int i = 0; i < this.panels.size(); ++i) {
            Component c = this.panels.get(i).getComponent();
            if (steps[i] == null) {
                steps[i] = c.getName();
            }
            if (!(c instanceof JComponent)) continue;
            JComponent jc = (JComponent)c;
            jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
            jc.putClientProperty("WizardPanel_contentData", steps);
        }
    }

    public String name() {
        return NbBundle.getMessage(ShortcutIterator.class, (String)"TITLE_x_of_y", (Object)(this.index + 1), (Object)this.panels.size());
    }

    boolean showing(String prop) {
        Boolean s = (Boolean)this.wiz.getProperty(prop);
        return s == null || s != false;
    }

    private boolean showing(int index) throws NoSuchElementException {
        switch (index) {
            case 0: {
                return true;
            }
            case 1: {
                return this.showing("wizdata.show.menu");
            }
            case 2: {
                return this.showing("wizdata.show.tool");
            }
            case 3: {
                return this.showing("wizdata.show.keyb");
            }
            case 4: {
                return this.showing("wizdata.show.cust");
            }
        }
        throw new NoSuchElementException();
    }

    public boolean hasNext() {
        for (int i = this.index + 1; i < this.panels.size(); ++i) {
            if (!this.showing(i)) continue;
            return true;
        }
        return false;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
        while (!this.showing(this.index)) {
            ++this.index;
        }
        if (this.index == 1) {
            this.fireChangeEvent();
        }
    }

    public void previousPanel() throws NoSuchElementException {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
        while (!this.showing(this.index)) {
            --this.index;
        }
    }

    public WizardDescriptor.Panel<ShortcutWizard> current() {
        return this.panels.get(this.index);
    }

    public final void addChangeListener(ChangeListener l) {
        this.cs.addChangeListener(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        this.cs.removeChangeListener(l);
    }

    protected final void fireChangeEvent() {
        this.cs.fireChange();
    }
}

