/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.modules.websvc.saas.spi.ConsumerFlavorProvider;
import org.openide.util.Lookup;

public class SaasTransferable<T>
implements Transferable {
    public static final Set<DataFlavor> WSDL_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WSDL_METHOD_FLAVOR, ConsumerFlavorProvider.WSDL_METHOD_NODE_FLAVOR));
    public static final Set<DataFlavor> WADL_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WADL_METHOD_FLAVOR, ConsumerFlavorProvider.WADL_METHOD_NODE_FLAVOR));
    public static final Set<DataFlavor> WSDL_PORT_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.PORT_FLAVOR, ConsumerFlavorProvider.PORT_NODE_FLAVOR));
    public static final Set<DataFlavor> WSDL_SERVICE_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.WSDL_SERVICE_FLAVOR, ConsumerFlavorProvider.WSDL_SERVICE_NODE_FLAVOR));
    public static final Set<DataFlavor> CUSTOM_METHOD_FLAVORS = new HashSet<DataFlavor>(Arrays.asList(ConsumerFlavorProvider.CUSTOM_METHOD_FLAVOR, ConsumerFlavorProvider.CUSTOM_METHOD_NODE_FLAVOR));
    private final T transferData;
    private final Set<DataFlavor> flavors;

    public SaasTransferable(T transferData, Set<DataFlavor> flavors) {
        this.transferData = transferData;
        this.flavors = flavors;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.flavors.toArray(new DataFlavor[0]);
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return this.flavors.contains(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(flavor)) {
            throw new UnsupportedFlavorException(flavor);
        }
        return this.transferData;
    }

    public static Transferable addFlavors(Transferable transfer) {
        Collection providers = Lookup.getDefault().lookupAll(ConsumerFlavorProvider.class);
        Transferable result = transfer;
        for (ConsumerFlavorProvider p : providers) {
            result = p.addDataFlavors(result);
        }
        return result;
    }
}

