/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.errors;

import java.io.IOException;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.eclipse.jgit.lfs.internal.LfsText;

public class CorruptMediaFile
extends IOException {
    private static final long serialVersionUID = 1L;
    private Path mediaFile;
    private long expectedSize;
    private long size;

    public CorruptMediaFile(Path mediaFile, long expectedSize, long size) {
        super(MessageFormat.format(LfsText.get().inconsistentMediafileLength, mediaFile, expectedSize, size));
        this.mediaFile = mediaFile;
        this.expectedSize = expectedSize;
        this.size = size;
    }

    public Path getMediaFile() {
        return this.mediaFile;
    }

    public long getExpectedSize() {
        return this.expectedSize;
    }

    public long getSize() {
        return this.size;
    }
}

