/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.api;

import com.sun.source.tree.Scope;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.util.Assert;
import java.util.function.Predicate;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class JavacScope
implements Scope {
    private static final Predicate<Symbol> VALIDATOR = sym -> {
        sym.apiComplete();
        return sym.kind != Kinds.Kind.ERR;
    };
    protected final Env<AttrContext> env;

    static JavacScope create(Env<AttrContext> env) {
        if (env.outer == null || env.outer == env) {
            return new JavacScope((Env)env){

                @Override
                public Iterable<? extends Element> getLocalElements() {
                    Scope.CompoundScope result = new Scope.CompoundScope(this.env.toplevel.packge);
                    result.prependSubScope(this.env.toplevel.toplevelScope);
                    result.prependSubScope(this.env.toplevel.namedImportScope);
                    return result.getSymbols(VALIDATOR);
                }
            };
        }
        return new JavacScope(env);
    }

    private JavacScope(Env<AttrContext> env) {
        this.env = Assert.checkNonNull(env);
    }

    @Override
    public JavacScope getEnclosingScope() {
        if (this.env.outer != null && this.env.outer != this.env) {
            return JavacScope.create(this.env.outer);
        }
        return new JavacScope(this.env){

            @Override
            public ScopeType getScopeType() {
                return ScopeType.STAR_IMPORT;
            }

            @Override
            public JavacScope getEnclosingScope() {
                return new JavacScope(this.env){

                    @Override
                    public ScopeType getScopeType() {
                        return ScopeType.MODULE_IMPORT;
                    }

                    @Override
                    public JavacScope getEnclosingScope() {
                        return null;
                    }

                    @Override
                    public Iterable<? extends Element> getLocalElements() {
                        return this.env.toplevel.moduleImportScope.getSymbols(VALIDATOR);
                    }
                };
            }

            @Override
            public Iterable<? extends Element> getLocalElements() {
                return this.env.toplevel.starImportScope.getSymbols(VALIDATOR);
            }
        };
    }

    @Override
    public TypeElement getEnclosingClass() {
        return this.env.outer == null || this.env.outer == this.env ? null : this.env.enclClass.sym;
    }

    @Override
    public ExecutableElement getEnclosingMethod() {
        return this.env.enclMethod == null ? null : this.env.enclMethod.sym;
    }

    @Override
    public Iterable<? extends Element> getLocalElements() {
        return ((AttrContext)this.env.info).getLocalElements();
    }

    public Env<AttrContext> getEnv() {
        return this.env;
    }

    public ScopeType getScopeType() {
        return ScopeType.ORDINARY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof JavacScope)) return false;
        JavacScope javacScope = (JavacScope)other;
        if (!this.env.equals(javacScope.env)) return false;
        if (this.getScopeType() != javacScope.getScopeType()) return false;
        return true;
    }

    public int hashCode() {
        return this.env.hashCode() + this.getScopeType().hashCode();
    }

    public String toString() {
        return "JavacScope[env=" + this.env + ", scope type=" + (Object)((Object)this.getScopeType()) + "]";
    }

    private static enum ScopeType {
        ORDINARY,
        STAR_IMPORT,
        MODULE_IMPORT;

    }
}

