/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import java.util.function.Predicate;

public class Iterators {
    private static final Iterator<?> EMPTY = Collections.emptyIterator();

    public static <T> Iterator<T> emptyIterator() {
        return EMPTY;
    }

    public static <I, O> Iterator<O> createCompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> converter) {
        return new CompoundIterator<I, O>(inputs, converter);
    }

    public static <E> Iterator<E> createFilterIterator(final Iterator<E> input, final Predicate<E> test) {
        return new Iterator<E>(){
            private E current = this.update();

            private E update() {
                while (input.hasNext()) {
                    Object sym = input.next();
                    if (!test.test(sym)) continue;
                    return sym;
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public E next() {
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                Object res = this.current;
                this.current = this.update();
                return res;
            }
        };
    }

    private static class CompoundIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> inputs;
        private final Function<I, Iterator<O>> converter;
        private Iterator<O> currentIterator = Iterators.emptyIterator();

        public CompoundIterator(Iterable<I> inputs, Function<I, Iterator<O>> converter) {
            this.inputs = inputs.iterator();
            this.converter = converter;
        }

        @Override
        public boolean hasNext() {
            while (true) {
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                if (!this.inputs.hasNext()) break;
                this.currentIterator = this.converter.apply(this.inputs.next());
            }
            return false;
        }

        @Override
        public O next() {
            while (!this.currentIterator.hasNext() && this.inputs.hasNext()) {
                this.currentIterator = this.converter.apply(this.inputs.next());
            }
            return this.currentIterator.next();
        }
    }
}

