/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.framework.ui.commands;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.php.api.framework.ui.commands.RefreshPhpModuleRunnable;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommand;
import org.netbeans.modules.php.spi.framework.commands.FrameworkCommandSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public final class FrameworkCommandChooser
extends JPanel {
    private static final long serialVersionUID = 24058452121416402L;
    private static final Object NO_TASK_ITEM = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.no.task", new String[0]);
    private static final Object NO_MATCHING_TASK_ITEM = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.no.matching.task", new String[0]);
    private static final ExecutorService EXECUTOR = Executors.newCachedThreadPool();
    private static boolean debug;
    private static FrameworkCommand lastTask;
    private static boolean keepOpened;
    private static final Map<String, Map<FrameworkCommand, ParameterContainer>> PROJECT_TO_TASK;
    private final FrameworkCommandSupport frameworkCommandSupport;
    private final List<FrameworkCommand> allTasks = new ArrayList<FrameworkCommand>();
    private final JTextField taskParametersComboBoxEditor;
    private JButton runButton;
    private boolean refreshNeeded;
    private JCheckBox debugCheckbox;
    private JScrollPane helpScrollPane;
    private JTextPane helpTextPane;
    private JCheckBox keepOpenedCheckBox;
    private JLabel matchingTaskLabel;
    private JList<Object> matchingTaskList;
    private JScrollPane matchingTaskSP;
    private JLabel previewLabel;
    private JTextField previewTextField;
    private JSplitPane splitPane;
    private JTextField taskField;
    private JPanel taskFieldPanel;
    private JLabel taskHint;
    private JLabel taskLabel;
    private JLabel taskParamLabel;
    private JComboBox<String> taskParametersComboBox;

    private FrameworkCommandChooser(FrameworkCommandSupport frameworkCommandSupport, JButton runButton) {
        assert (frameworkCommandSupport != null);
        assert (runButton != null);
        this.frameworkCommandSupport = frameworkCommandSupport;
        this.runButton = runButton;
        this.initComponents();
        this.taskParametersComboBoxEditor = (JTextField)this.taskParametersComboBox.getEditor().getEditorComponent();
        this.matchingTaskList.setCellRenderer(new FrameworkCommandRenderer());
        this.debugCheckbox.setSelected(debug);
        this.keepOpenedCheckBox.setSelected(keepOpened);
        this.keepOpenedCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                keepOpened = e.getStateChange() == 1;
            }
        });
        this.refreshNeeded = this.reloadAllTasks();
        this.refreshTaskList();
        this.taskField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FrameworkCommandChooser.this.refreshTaskList();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrameworkCommandChooser.this.refreshTaskList();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrameworkCommandChooser.this.refreshTaskList();
            }
        });
        this.preselectLastlySelected();
        this.initTaskParameters();
        this.updateHelp();
        this.updatePreview();
    }

    public static void open(final FrameworkCommandSupport frameworkCommandSupport) {
        assert (frameworkCommandSupport != null);
        assert (EventQueue.isDispatchThread()) : "must be called from EDT";
        String frameworkName = frameworkCommandSupport.getFrameworkName();
        final JButton runButton = new JButton(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.runButton", new String[0]));
        final FrameworkCommandChooser chooserPanel = new FrameworkCommandChooser(frameworkCommandSupport, runButton);
        String title = FrameworkCommandChooser.getMessage("FrameworkCommandChooser.title", frameworkName, frameworkCommandSupport.getPhpModule().getDisplayName());
        runButton.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.runButton.accessibleDescription", frameworkName));
        FrameworkCommandChooser.setRunButtonState(runButton, chooserPanel);
        chooserPanel.matchingTaskList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                FrameworkCommandChooser.setRunButtonState(runButton, chooserPanel);
                chooserPanel.initTaskParameters();
                chooserPanel.updateHelp();
                chooserPanel.updatePreview();
            }
        });
        final JButton refreshButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)refreshButton, (String)FrameworkCommandChooser.getMessage("FrameworkCommandChooser.refreshButton", new String[0]));
        refreshButton.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.refreshButton.accessibleDescription", frameworkName));
        refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                refreshButton.setEnabled(false);
                runButton.setEnabled(false);
                chooserPanel.reloadTasks(new Runnable(){
                    final /* synthetic */ 4 this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void run() {
                        assert (EventQueue.isDispatchThread()) : "is EDT";
                        refreshButton.setEnabled(true);
                        FrameworkCommandChooser.setRunButtonState(runButton, chooserPanel);
                    }
                });
            }
        });
        Object[] options = new Object[]{refreshButton, runButton, DialogDescriptor.CANCEL_OPTION};
        DialogDescriptor descriptor = new DialogDescriptor((Object)chooserPanel, title, false, options, (Object)runButton, 0, null, null);
        descriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        final Dialog dialog = DialogDisplayer.getDefault().createDialog(descriptor);
        dialog.getAccessibleContext().setAccessibleName(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.accessibleName", frameworkName));
        dialog.getAccessibleContext().setAccessibleDescription(FrameworkCommandChooser.getMessage("FrameworkCommandChooser.accessibleDescription", frameworkName));
        if (chooserPanel.refreshNeeded) {
            refreshButton.setEnabled(false);
            runButton.setEnabled(false);
            chooserPanel.reloadTasks(new Runnable(){

                @Override
                public void run() {
                    assert (EventQueue.isDispatchThread()) : "is EDT";
                    refreshButton.setEnabled(true);
                    FrameworkCommandChooser.setRunButtonState(runButton, chooserPanel);
                }
            });
        }
        runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!chooserPanel.keepOpenedCheckBox.isSelected()) {
                    dialog.setVisible(false);
                    dialog.dispose();
                }
                FrameworkCommand task = chooserPanel.getSelectedTask();
                debug = chooserPanel.debugCheckbox.isSelected();
                lastTask = task;
                chooserPanel.storeParameters();
                frameworkCommandSupport.runCommand(new FrameworkCommandSupport.CommandDescriptor(task, chooserPanel.getParameters(), debug), new RefreshPhpModuleRunnable(frameworkCommandSupport.getPhpModule()));
            }
        });
        dialog.setVisible(true);
    }

    void initTaskParameters() {
        FrameworkCommand task = this.getSelectedTask();
        ArrayList<String> params = new ArrayList<String>();
        params.add("");
        params.addAll(this.getStoredParams(task));
        this.taskParametersComboBox.setModel(new DefaultComboBoxModel<String>(params.toArray(new String[0])));
        this.preselectLastSelectedParam(task);
        this.taskParametersComboBoxEditor.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.processUpdate();
            }

            private void processUpdate() {
                FrameworkCommandChooser.this.updatePreview();
            }
        });
    }

    void updateHelp() {
        final FrameworkCommand task = this.getSelectedTask();
        if (task == null) {
            this.updateHelp(null);
        } else if (task.hasHelp()) {
            this.updateHelp(task.getHelp());
        } else {
            this.updateHelp(FrameworkCommandChooser.getMessage("LBL_PleaseWait", new String[0]));
            EXECUTOR.submit(new Runnable(){
                final /* synthetic */ FrameworkCommandChooser this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    final String help = task.getHelp();
                    SwingUtilities.invokeLater(new Runnable(){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void run() {
                            this.this$1.this$0.updateHelp(help);
                        }
                    });
                }
            });
        }
    }

    void updateHelp(String help) {
        assert (SwingUtilities.isEventDispatchThread()) : "must be run in EDT";
        if (help != null) {
            if (help.startsWith("<html>")) {
                this.helpTextPane.setContentType("text/html");
            } else {
                this.helpTextPane.setContentType("text/plain");
            }
        }
        this.helpTextPane.setText(help);
        this.helpTextPane.setCaretPosition(0);
    }

    void updatePreview() {
        FrameworkCommand task = this.getSelectedTask();
        String preview = null;
        if (task != null) {
            preview = task.getPreview() + " " + this.taskParametersComboBoxEditor.getText();
        }
        this.previewTextField.setText(preview);
    }

    private void preselectLastSelectedParam(FrameworkCommand task) {
        ParameterContainer params = this.getTasksToParams().get(task);
        if (params == null) {
            return;
        }
        String lastSelected = params.getLastSelected();
        if (lastSelected == null) {
            this.taskParametersComboBox.setSelectedItem("");
            return;
        }
        for (int i = 0; i < this.taskParametersComboBox.getItemCount(); ++i) {
            String item = this.taskParametersComboBox.getItemAt(i);
            if (!item.equals(lastSelected)) continue;
            this.taskParametersComboBox.setSelectedIndex(i);
            break;
        }
    }

    private Map<FrameworkCommand, ParameterContainer> getTasksToParams() {
        FileObject sourceDirectory = this.frameworkCommandSupport.getPhpModule().getSourceDirectory();
        if (sourceDirectory == null) {
            return Collections.emptyMap();
        }
        String prjDir = sourceDirectory.getPath();
        Map<FrameworkCommand, ParameterContainer> result = PROJECT_TO_TASK.get(prjDir);
        if (result == null) {
            result = new HashMap<FrameworkCommand, ParameterContainer>();
            PROJECT_TO_TASK.put(prjDir, result);
        }
        return result;
    }

    private List<String> getStoredParams(FrameworkCommand task) {
        if (task == null) {
            return Collections.emptyList();
        }
        Map<FrameworkCommand, ParameterContainer> tasksToParams = this.getTasksToParams();
        ParameterContainer stored = tasksToParams.get(task);
        if (stored == null) {
            return Collections.emptyList();
        }
        ArrayList<String> result = new ArrayList<String>(stored.getParams());
        Collections.sort(result);
        return result;
    }

    private String getParameters() {
        Object selected = this.taskParametersComboBox.getSelectedItem();
        return selected.toString().trim();
    }

    private static void setRunButtonState(JButton runButton, FrameworkCommandChooser chooserPanel) {
        runButton.setEnabled(chooserPanel.getSelectedTask() != null);
    }

    private void storeParameters() {
        ParameterContainer params;
        FileObject sourceDirectory = this.frameworkCommandSupport.getPhpModule().getSourceDirectory();
        if (sourceDirectory == null) {
            return;
        }
        String prjDir = sourceDirectory.getPath();
        Map<FrameworkCommand, ParameterContainer> taskToParams = PROJECT_TO_TASK.get(prjDir);
        if (taskToParams == null) {
            taskToParams = new HashMap<FrameworkCommand, ParameterContainer>();
            PROJECT_TO_TASK.put(prjDir, taskToParams);
        }
        if ((params = taskToParams.get(this.getSelectedTask())) == null) {
            params = new ParameterContainer();
            taskToParams.put(this.getSelectedTask(), params);
        }
        String currentParam = this.getParameters();
        params.addParam(currentParam);
        params.setLastSelected(currentParam);
    }

    private void preselectLastlySelected() {
        if (lastTask == null) {
            return;
        }
        for (FrameworkCommand task : this.allTasks) {
            if (!lastTask.equals(task)) continue;
            this.matchingTaskList.setSelectedValue(task, true);
            break;
        }
        this.initTaskParameters();
    }

    private boolean reloadAllTasks() {
        this.allTasks.clear();
        List<FrameworkCommand> commands = this.frameworkCommandSupport.getFrameworkCommands();
        if (commands != null) {
            this.allTasks.addAll(commands);
            return false;
        }
        return true;
    }

    private void refreshTaskList() {
        String filter = this.taskField.getText().trim();
        DefaultListModel<Object> model = new DefaultListModel<Object>();
        List<FrameworkCommand> matching = Filter.getFilteredTasks(this.allTasks, filter);
        for (FrameworkCommand task : matching) {
            model.addElement(task);
        }
        this.matchingTaskList.setModel(model);
        if (model.isEmpty()) {
            if (this.allTasks.isEmpty()) {
                model.addElement(NO_TASK_ITEM);
            } else {
                model.addElement(NO_MATCHING_TASK_ITEM);
            }
        }
        this.matchingTaskList.setSelectedIndex(0);
        this.initTaskParameters();
    }

    private void reloadTasks(final Runnable uiFinishAction) {
        final Object task = this.matchingTaskList.getSelectedValue();
        final JComponent[] comps = new JComponent[]{this.matchingTaskSP, this.matchingTaskLabel, this.matchingTaskLabel, this.matchingTaskList, this.taskLabel, this.taskField, this.debugCheckbox, this.taskParamLabel, this.taskParametersComboBox, this.taskHint};
        this.setEnabled(comps, false);
        this.matchingTaskList.setListData((Object[])new Object[]{FrameworkCommandChooser.getMessage("FrameworkCommandChooser.reloading.tasks", this.frameworkCommandSupport.getFrameworkName())});
        this.frameworkCommandSupport.refreshFrameworkCommandsLater(new Runnable(){
            final /* synthetic */ FrameworkCommandChooser this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                EventQueue.invokeLater(new Runnable(){
                    final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.this$0.reloadAllTasks();
                        this.this$1.this$0.refreshTaskList();
                        this.this$1.this$0.matchingTaskList.setSelectedValue(task, true);
                        uiFinishAction.run();
                        this.this$1.this$0.setEnabled(comps, true);
                        this.this$1.this$0.taskField.requestFocus();
                    }
                });
            }
        });
    }

    private void setEnabled(JComponent[] comps, boolean enabled) {
        for (JComponent comp : comps) {
            comp.setEnabled(enabled);
        }
    }

    private FrameworkCommand getSelectedTask() {
        Object val = this.matchingTaskList.getSelectedValue();
        if (val != null && !NO_MATCHING_TASK_ITEM.equals(val) && !NO_TASK_ITEM.equals(val)) {
            return (FrameworkCommand)val;
        }
        return null;
    }

    private static String getMessage(String key, String ... args) {
        return NbBundle.getMessage(FrameworkCommandChooser.class, (String)key, (Object[])args);
    }

    private void initComponents() {
        this.debugCheckbox = new JCheckBox();
        this.taskLabel = new JLabel();
        this.taskFieldPanel = new JPanel();
        this.taskField = new JTextField();
        this.taskHint = new JLabel();
        this.taskParamLabel = new JLabel();
        this.taskParametersComboBox = new JComboBox();
        this.matchingTaskLabel = new JLabel();
        this.splitPane = new JSplitPane();
        this.matchingTaskSP = new JScrollPane();
        this.matchingTaskList = new JList();
        this.helpScrollPane = new JScrollPane();
        this.helpTextPane = new JTextPane();
        this.previewTextField = new JTextField();
        this.previewLabel = new JLabel();
        this.keepOpenedCheckBox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.debugCheckbox, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.text"));
        this.debugCheckbox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.AccessibleContext.accessibleName"));
        this.debugCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.debugCheckbox.AccessibleContext.accessibleDescription"));
        this.taskLabel.setLabelFor(this.taskField);
        Mnemonics.setLocalizedText((JLabel)this.taskLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.text"));
        this.taskFieldPanel.setLayout(new BorderLayout());
        this.taskField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                FrameworkCommandChooser.this.taskFieldKeyPressed(evt);
            }
        });
        this.taskFieldPanel.add((Component)this.taskField, "North");
        this.taskField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskField.AccessibleContext.accessibleName"));
        this.taskField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskField.AccessibleContext.accessibleDescription"));
        this.taskHint.setLabelFor(this);
        Mnemonics.setLocalizedText((JLabel)this.taskHint, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.text"));
        this.taskFieldPanel.add((Component)this.taskHint, "South");
        this.taskHint.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.AccessibleContext.accessibleName"));
        this.taskHint.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskHint.AccessibleContext.accessibleDescription"));
        this.taskParamLabel.setLabelFor(this.taskParametersComboBox);
        Mnemonics.setLocalizedText((JLabel)this.taskParamLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.text"));
        this.taskParametersComboBox.setEditable(true);
        this.matchingTaskLabel.setLabelFor(this.matchingTaskList);
        Mnemonics.setLocalizedText((JLabel)this.matchingTaskLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.text"));
        this.splitPane.setBorder(null);
        this.splitPane.setDividerLocation(150);
        this.splitPane.setDividerSize(5);
        this.splitPane.setOrientation(0);
        this.matchingTaskList.setFont(new Font("Monospaced", 0, 12));
        this.matchingTaskList.setSelectionMode(0);
        this.matchingTaskList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                FrameworkCommandChooser.this.matchingTaskListMouseClicked(evt);
            }
        });
        this.matchingTaskSP.setViewportView(this.matchingTaskList);
        this.matchingTaskList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskList.AccessibleContext.accessibleName"));
        this.matchingTaskList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskList.AccessibleContext.accessibleDescription"));
        this.splitPane.setTopComponent(this.matchingTaskSP);
        this.matchingTaskSP.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskSP.AccessibleContext.accessibleName"));
        this.matchingTaskSP.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskSP.AccessibleContext.accessibleDescription"));
        this.helpTextPane.setEditable(false);
        this.helpScrollPane.setViewportView(this.helpTextPane);
        this.helpTextPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpTextPane.AccessibleContext.accessibleName"));
        this.helpTextPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.helpTextPane.AccessibleContext.accessibleDescription"));
        this.splitPane.setRightComponent(this.helpScrollPane);
        this.previewTextField.setEditable(false);
        this.previewLabel.setLabelFor(this.previewTextField);
        Mnemonics.setLocalizedText((JLabel)this.previewLabel, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.keepOpenedCheckBox, (String)NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.keepOpenedCheckBox).addComponent(this.splitPane, GroupLayout.Alignment.LEADING, -1, 510, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskLabel).addComponent(this.taskParamLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskParametersComboBox, 0, 410, Short.MAX_VALUE).addComponent(this.taskFieldPanel, -1, 410, Short.MAX_VALUE))).addComponent(this.matchingTaskLabel, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.previewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.previewTextField, -1, 424, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.taskLabel).addComponent(this.taskFieldPanel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.taskParamLabel).addComponent(this.taskParametersComboBox, -2, 21, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.matchingTaskLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.splitPane, -1, 257, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.previewTextField, -2, -1, -2).addComponent(this.previewLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keepOpenedCheckBox)));
        this.taskLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.AccessibleContext.accessibleName"));
        this.taskLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskLabel.AccessibleContext.accessibleDescription"));
        this.taskFieldPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskFieldPanel.AccessibleContext.accessibleName"));
        this.taskFieldPanel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskFieldPanel.AccessibleContext.accessibleDescription"));
        this.taskParamLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.AccessibleContext.accessibleName"));
        this.taskParamLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParamLabel.AccessibleContext.accessibleDescription"));
        this.taskParametersComboBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParametersComboBox.AccessibleContext.accessibleName"));
        this.taskParametersComboBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.taskParametersComboBox.AccessibleContext.accessibleDescription"));
        this.matchingTaskLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.AccessibleContext.accessibleName"));
        this.matchingTaskLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.matchingTaskLabel.AccessibleContext.accessibleDescription"));
        this.splitPane.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.splitPane.AccessibleContext.accessibleName"));
        this.splitPane.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.splitPane.AccessibleContext.accessibleDescription"));
        this.previewTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewTextField.AccessibleContext.accessibleDescription"));
        this.previewLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.AccessibleContext.accessibleName"));
        this.previewLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.previewLabel.AccessibleContext.accessibleDescription"));
        this.keepOpenedCheckBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.AccessibleContext.accessibleName"));
        this.keepOpenedCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.keepOpenedCheckBox.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(FrameworkCommandChooser.class, (String)"FrameworkCommandChooser.AccessibleContext.accessibleDescription"));
    }

    private void handleNavigationKeys(KeyEvent evt) {
        Object actionKey = this.matchingTaskList.getInputMap().get(KeyStroke.getKeyStrokeForEvent(evt));
        boolean isListScrollAction = "selectPreviousRow".equals(actionKey) || "selectPreviousRowExtendSelection".equals(actionKey) || "selectNextRow".equals(actionKey) || "selectNextRowExtendSelection".equals(actionKey) || "scrollUp".equals(actionKey) || "scrollUpExtendSelection".equals(actionKey) || "scrollDown".equals(actionKey) || "scrollDownExtendSelection".equals(actionKey);
        int selectedIndex = this.matchingTaskList.getSelectedIndex();
        int modelSize = this.matchingTaskList.getModel().getSize();
        if ("selectNextRow".equals(actionKey) && selectedIndex == modelSize - 1) {
            this.matchingTaskList.setSelectedIndex(0);
            this.matchingTaskList.ensureIndexIsVisible(0);
            return;
        }
        if ("selectPreviousRow".equals(actionKey) && selectedIndex == 0) {
            int last = modelSize - 1;
            this.matchingTaskList.setSelectedIndex(last);
            this.matchingTaskList.ensureIndexIsVisible(last);
            return;
        }
        if (isListScrollAction) {
            Action action = this.matchingTaskList.getActionMap().get(actionKey);
            action.actionPerformed(new ActionEvent(this.matchingTaskList, 0, (String)actionKey));
            evt.consume();
        }
    }

    private void taskFieldKeyPressed(KeyEvent evt) {
        this.handleNavigationKeys(evt);
    }

    private void matchingTaskListMouseClicked(MouseEvent evt) {
        if (this.runButton.isEnabled() && evt.getClickCount() == 2) {
            this.runButton.doClick();
        }
    }

    static {
        keepOpened = false;
        PROJECT_TO_TASK = new HashMap<String, Map<FrameworkCommand, ParameterContainer>>();
    }

    private static class FrameworkCommandRenderer
    extends JLabel
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = -132456132469679879L;

        public FrameworkCommandRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.setName("ComboBox.listRenderer");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                Color bgColor = list.getBackground();
                Color bgColorDarker = new Color(Math.abs(bgColor.getRed() - 10), Math.abs(bgColor.getGreen() - 10), Math.abs(bgColor.getBlue() - 10));
                this.setBackground(index % 2 == 0 ? bgColor : bgColorDarker);
                this.setForeground(list.getForeground());
            }
            this.setFont(list.getFont());
            if (value instanceof FrameworkCommand) {
                FrameworkCommand task = (FrameworkCommand)value;
                String descripton = task.getDescription();
                StringBuilder text = new StringBuilder(100);
                text.append("<html>");
                text.append("<b>").append(task.getDisplayName()).append("</b>");
                if (descripton != null) {
                    text.append(" : ").append(descripton);
                }
                text.append("</html>");
                this.setText(text.toString());
            } else {
                this.setText(value.toString());
            }
            return this;
        }
    }

    private static class ParameterContainer {
        private final Set<String> params = new HashSet<String>();
        private String lastSelected;

        private ParameterContainer() {
        }

        public void addParam(String param) {
            this.params.add(param);
        }

        public String getLastSelected() {
            return this.lastSelected;
        }

        public void setLastSelected(String lastSelected) {
            this.lastSelected = lastSelected;
        }

        public Set<String> getParams() {
            return this.params;
        }
    }

    static final class Filter {
        private final String filter;
        private final List<FrameworkCommand> tasks;

        private Filter(List<FrameworkCommand> tasks, String filter) {
            this.tasks = tasks;
            this.filter = filter;
        }

        static List<FrameworkCommand> getFilteredTasks(List<FrameworkCommand> allTasks, String filter) {
            Filter f = new Filter(allTasks, filter);
            return f.filter();
        }

        private List<FrameworkCommand> filter() {
            ArrayList<FrameworkCommand> matching = new ArrayList<FrameworkCommand>();
            Pattern pattern = StringUtils.getPattern((String)this.filter);
            if (pattern != null) {
                for (FrameworkCommand task : this.tasks) {
                    String command = StringUtils.implode(Arrays.asList(task.getCommands()), (String)" ");
                    Matcher m = pattern.matcher(command);
                    if (!m.matches()) continue;
                    matching.add(task);
                }
            } else {
                ArrayList<FrameworkCommand> exact = new ArrayList<FrameworkCommand>();
                for (FrameworkCommand task : this.tasks) {
                    String filterLC;
                    String command = StringUtils.implode(Arrays.asList(task.getCommands()), (String)" ");
                    String taskLC = command.toLowerCase(Locale.ENGLISH);
                    if (taskLC.startsWith(filterLC = this.filter.toLowerCase(Locale.ENGLISH))) {
                        exact.add(task);
                        continue;
                    }
                    if (!taskLC.contains(filterLC)) continue;
                    matching.add(task);
                }
                matching.addAll(0, exact);
            }
            return matching;
        }
    }
}

