/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.lib.api.properties;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.css.lib.api.properties.GrammarResolver;
import org.netbeans.modules.css.lib.api.properties.GrammarResolverResult;
import org.netbeans.modules.css.lib.api.properties.GroupGrammarElement;
import org.netbeans.modules.css.lib.api.properties.Node;
import org.netbeans.modules.css.lib.api.properties.PropertyDefinition;
import org.netbeans.modules.css.lib.api.properties.ResolvedToken;
import org.netbeans.modules.css.lib.api.properties.Token;
import org.netbeans.modules.css.lib.api.properties.ValueGrammarElement;
import org.netbeans.modules.css.lib.properties.GrammarParser;
import org.openide.filesystems.FileObject;

public class ResolvedProperty {
    private final GrammarResolverResult grammarResolverResult;
    private static final Pattern FILTER_COMMENTS_PATTERN = Pattern.compile("/\\*.*?\\*/");
    private PropertyDefinition propertyModel;

    public static ResolvedProperty resolve(FileObject context, PropertyDefinition propertyModel, CharSequence propertyValue) {
        return new ResolvedProperty(context, propertyModel, propertyValue);
    }

    public ResolvedProperty(FileObject context, PropertyDefinition propertyModel, CharSequence value) {
        this(propertyModel.getGrammarElement(context), ResolvedProperty.filterComments(value));
        this.propertyModel = propertyModel;
    }

    public ResolvedProperty(PropertyDefinition propertyModel, CharSequence value) {
        this(propertyModel.getGrammarElement(null), ResolvedProperty.filterComments(value));
        this.propertyModel = propertyModel;
    }

    public ResolvedProperty(GroupGrammarElement groupGrammarElement, String value) {
        this.grammarResolverResult = GrammarResolver.resolve(groupGrammarElement, value);
    }

    public ResolvedProperty(GrammarResolver grammarResolver, String value) {
        this.grammarResolverResult = grammarResolver.resolve(value);
    }

    public ResolvedProperty(String grammar, String value) {
        this(GrammarParser.parse(grammar), value);
    }

    public List<Token> getTokens() {
        return this.grammarResolverResult.tokens();
    }

    public List<ResolvedToken> getResolvedTokens() {
        return this.grammarResolverResult.resolved();
    }

    public PropertyDefinition getPropertyDefinition() {
        return this.propertyModel;
    }

    public boolean isResolved() {
        return this.grammarResolverResult.success();
    }

    public List<Token> getUnresolvedTokens() {
        return this.grammarResolverResult.left();
    }

    public Set<ValueGrammarElement> getAlternatives() {
        return this.grammarResolverResult.getAlternatives();
    }

    public synchronized Node getParseTree() {
        return this.grammarResolverResult.getParseTree();
    }

    private static String filterComments(CharSequence text) {
        Matcher m = FILTER_COMMENTS_PATTERN.matcher(text);
        StringBuilder b = new StringBuilder(text);
        while (m.find()) {
            int to;
            int from = m.start();
            if (from == (to = m.end())) continue;
            char[] spaces = new char[to - from];
            Arrays.fill(spaces, ' ');
            String replacement = new String(spaces);
            b.replace(from, to, replacement);
        }
        return b.toString();
    }
}

