/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.projects;

import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.core.jaxws.nodes.JaxWsNode;
import org.netbeans.modules.websvc.project.api.ServiceDescriptor;
import org.netbeans.modules.websvc.project.api.WebService;
import org.netbeans.modules.websvc.project.spi.WebServiceImplementation;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;

public class AntJAXWSService
implements WebServiceImplementation {
    private Service service;
    private Project prj;
    private JaxWsModel jaxWsModel;

    public AntJAXWSService(JaxWsModel jaxWsModel, Service service, Project prj) {
        this.jaxWsModel = jaxWsModel;
        this.service = service;
        this.prj = prj;
    }

    public String getIdentifier() {
        return this.service.getImplementationClass();
    }

    public boolean isServiceProvider() {
        return true;
    }

    public WebService.Type getServiceType() {
        return WebService.Type.SOAP;
    }

    public ServiceDescriptor getServiceDescriptor() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Node createNode() {
        SourceGroup[] srcGroups = ProjectUtils.getSources((Project)this.prj).getSourceGroups("java");
        String implClass = this.service.getImplementationClass();
        for (SourceGroup srcGroup : srcGroups) {
            FileObject srcRoot = srcGroup.getRootFolder();
            FileObject implClassFo = this.getImplementationClass(implClass, srcRoot);
            if (implClassFo == null) continue;
            return new JaxWsNode(this.jaxWsModel, this.service, srcRoot, implClassFo);
        }
        return null;
    }

    private FileObject getImplementationClass(String implClass, FileObject srcRoot) {
        if (implClass != null && srcRoot != null) {
            return srcRoot.getFileObject(implClass.replace('.', '/') + ".java");
        }
        return null;
    }
}

