/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.operations;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.api.validation.adapters.NotificationLineSupportAdapter;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.MavenValidators;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.modelcache.MavenProjectCache;
import org.netbeans.modules.maven.operations.Bundle;
import org.netbeans.validation.api.AbstractValidator;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Severity;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ValidatorUtils;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;
import org.openide.DialogDescriptor;
import org.openide.LifecycleManager;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class RenameProjectPanel
extends JPanel {
    private final NbMavenProjectImpl project;
    private ValidationGroup vg;
    private NotificationLineSupport nls;
    private JCheckBox cbArtifactId;
    private JCheckBox cbDisplayName;
    private JCheckBox cbFolder;
    private JLabel lblRename;
    private JTextField txtArtifactId;
    private JTextField txtDisplayName;
    private JTextField txtFolder;
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    static final int MAX_WORK = 100;

    RenameProjectPanel(NbMavenProjectImpl prj) {
        this.initComponents();
        SwingValidationGroup.setComponentName((JComponent)this.txtFolder, (String)Bundle.NAME_Folder());
        SwingValidationGroup.setComponentName((JComponent)this.txtArtifactId, (String)Bundle.NAME_Artifact());
        this.project = prj;
        String folder = this.project.getProjectDirectory().getNameExt();
        this.txtFolder.setText(folder);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                MavenProject prj = RenameProjectPanel.this.project.getOriginalMavenProject();
                final String dn = prj.getName();
                final String artId = prj.getArtifactId();
                SwingUtilities.invokeLater(new Runnable(){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void run() {
                        this.this$1.RenameProjectPanel.this.txtArtifactId.setText(artId);
                        this.this$1.RenameProjectPanel.this.txtDisplayName.setText(dn);
                        this.this$1.RenameProjectPanel.this.lblRename.setText(Bundle.RenameProjectPanel_lblRename_text2(dn));
                    }
                });
            }
        });
        FileObject pomFO = this.project.getProjectDirectory().getFileObject("pom.xml");
        if (pomFO == null) {
            this.cbArtifactId.setEnabled(false);
            this.cbDisplayName.setEnabled(false);
            this.cbFolder.setEnabled(false);
            this.txtArtifactId.setEnabled(false);
            this.txtDisplayName.setEnabled(false);
            this.txtFolder.setEnabled(false);
        }
    }

    void createValidations(DialogDescriptor dd) {
        this.nls = dd.createNotificationLineSupport();
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new NotificationLineSupportAdapter(this.nls), new DialogDescriptorAdapter(dd)});
        this.vg.add((Object)this.txtFolder, (Validator)new OptionalValidator(this.cbFolder, (Validator<String>)ValidatorUtils.merge((Validator)StringValidators.REQUIRE_NON_EMPTY_STRING, (Validator)ValidatorUtils.merge((Validator)StringValidators.REQUIRE_VALID_FILENAME, (Validator)new FileNameExists(FileUtil.toFile((FileObject)this.project.getProjectDirectory().getParent()))))));
        this.vg.add((Object)this.txtArtifactId, (Validator)new OptionalValidator(this.cbArtifactId, MavenValidators.createArtifactIdValidators()));
        this.checkEnablement();
    }

    private void checkEnablement() {
        this.txtArtifactId.setEnabled(this.cbArtifactId.isSelected());
        this.txtDisplayName.setEnabled(this.cbDisplayName.isSelected());
        this.txtFolder.setEnabled(this.cbFolder.isSelected());
    }

    private void initComponents() {
        this.lblRename = new JLabel();
        this.cbDisplayName = new JCheckBox();
        this.txtDisplayName = new JTextField();
        this.cbArtifactId = new JCheckBox();
        this.txtArtifactId = new JTextField();
        this.cbFolder = new JCheckBox();
        this.txtFolder = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.lblRename, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.lblRename.text"));
        this.cbDisplayName.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbDisplayName, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbDisplayName.text"));
        this.cbDisplayName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbDisplayNameActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbArtifactId, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbArtifactId.text"));
        this.cbArtifactId.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbArtifactIdActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.cbFolder, (String)NbBundle.getMessage(RenameProjectPanel.class, (String)"RenameProjectPanel.cbFolder.text"));
        this.cbFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RenameProjectPanel.this.cbFolderActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblRename, GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbArtifactId).addComponent(this.cbDisplayName).addComponent(this.cbFolder)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.txtDisplayName, -1, 258, Short.MAX_VALUE).addComponent(this.txtArtifactId, -1, 258, Short.MAX_VALUE).addComponent(this.txtFolder, -1, 258, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.lblRename).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbDisplayName).addComponent(this.txtDisplayName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbArtifactId).addComponent(this.txtArtifactId, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cbFolder).addComponent(this.txtFolder, -2, -1, -2)).addContainerGap(82, Short.MAX_VALUE)));
    }

    private void cbDisplayNameActionPerformed(ActionEvent evt) {
        this.vg.performValidation();
        this.checkEnablement();
    }

    private void cbArtifactIdActionPerformed(ActionEvent evt) {
        this.vg.performValidation();
        this.checkEnablement();
    }

    private void cbFolderActionPerformed(ActionEvent evt) {
        this.vg.performValidation();
        this.checkEnablement();
    }

    void renameProject() {
        final boolean artId = this.cbArtifactId.isSelected();
        final boolean dname = this.cbDisplayName.isSelected();
        final boolean folder = this.cbFolder.isSelected();
        final String newArtId = this.txtArtifactId.getText().trim();
        final String newDname = this.txtDisplayName.getText().trim();
        final String newFolder = this.txtFolder.getText().trim();
        RequestProcessor.getDefault().post(new Runnable(){
            final /* synthetic */ RenameProjectPanel this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<Object> opers = new ArrayList<Object>();
                if (artId) {
                    opers.add(new ArtIdOperation(newArtId));
                }
                if (dname) {
                    opers.add(new DNameOperation(newDname));
                }
                FileObject pomFO = this.this$0.project.getProjectDirectory().getFileObject("pom.xml");
                Utilities.performPOMModelOperations((FileObject)pomFO, opers);
                if (folder) {
                    ProgressHandle handle = ProgressHandle.createHandle((String)Bundle.RenameProject());
                    handle.start(100);
                    try {
                        this.this$0.checkParentProject(this.this$0.project, newFolder);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    try {
                        RenameProjectPanel.doMoveProject(handle, this.this$0.project, newFolder, this.this$0.project.getProjectDirectory().getParent());
                    }
                    catch (Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        handle.finish();
                    }
                }
            }
        });
    }

    private void checkParentProject(NbMavenProjectImpl project, String newName) throws IOException {
        Project[] prjs;
        for (Project prj : prjs = OpenProjects.getDefault().getOpenProjects()) {
            List modules;
            NbMavenProjectImpl parentProject;
            if (prj.getProjectDirectory().equals(project.getProjectDirectory()) || (parentProject = (NbMavenProjectImpl)prj.getLookup().lookup(NbMavenProjectImpl.class)) == null || (modules = parentProject.getOriginalMavenProject().getModules()) == null || modules.isEmpty()) continue;
            String oldName = project.getProjectDirectory().getNameExt();
            if (modules.contains(oldName)) {
                this.rename(parentProject, oldName, newName);
                return;
            }
            File projectDir = project.getPOMFile().getParentFile();
            File parentDir = parentProject.getPOMFile().getParentFile();
            oldName = FileUtilities.relativizeFile(parentDir, projectDir);
            if (!modules.contains(oldName)) continue;
            String relNewName = FileUtilities.relativizeFile(parentDir, new File(projectDir.getParent(), newName));
            this.rename(parentProject, oldName, relNewName);
        }
    }

    private void rename(Project parentProject, final String oldName, final String newName) {
        FileObject pomFO = parentProject.getProjectDirectory().getFileObject("pom.xml");
        ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){
            final /* synthetic */ RenameProjectPanel this$0;
            {
                this.this$0 = this$0;
            }

            public void performOperation(POMModel model) {
                List modules = model.getProject().getModules();
                if (modules != null && modules.contains(oldName)) {
                    model.getProject().removeModule(oldName);
                    model.getProject().addModule(newName);
                }
            }
        };
        Utilities.performPOMModelOperations((FileObject)pomFO, Collections.singletonList(operation));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doMoveProject(ProgressHandle handle, Project project, String nueFolderName, FileObject newTarget) throws Exception {
        boolean originalOK = true;
        Project main = OpenProjects.getDefault().getMainProject();
        boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
        FileObject target = null;
        try {
            int totalWork = 100;
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            RenameProjectPanel.close(project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject projectDirectory = project.getProjectDirectory();
            NbMavenProjectImpl impl = (NbMavenProjectImpl)project.getLookup().lookup(NbMavenProjectImpl.class);
            File pomFile = impl.getPOMFile();
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001;
            FileLock lock = projectDirectory.lock();
            try {
                target = projectDirectory.move(lock, newTarget, nueFolderName, null);
            }
            finally {
                lock.releaseLock();
            }
            int lastWorkDone = (int)currentWorkDone;
            if (lastWorkDone < (int)(currentWorkDone += workPerFileAndOperation)) {
                handle.progress((int)currentWorkDone);
            }
            originalOK = false;
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            MavenProjectCache.clearMavenProject(pomFile);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            assert (nue != null);
            assert (nue != project) : "got same Project for " + String.valueOf(projectDirectory) + " and " + String.valueOf(target);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            RenameProjectPanel.open(nue, wasMain);
            handle.progress(totalWork);
            handle.finish();
        }
        catch (Exception e) {
            if (originalOK) {
                RenameProjectPanel.open(project, wasMain);
            } else {
                assert (target != null);
                ProjectManager.getDefault().clearNonProjectCache();
                Project nue = ProjectManager.getDefault().findProject(target);
                if (nue != null) {
                    RenameProjectPanel.open(nue, wasMain);
                }
            }
            throw e;
        }
    }

    private static void close(Project prj) {
        LifecycleManager.getDefault().saveAll();
        OpenProjects.getDefault().close(new Project[]{prj});
    }

    private static void open(Project prj, boolean setAsMain) {
        OpenProjects.getDefault().open(new Project[]{prj}, false);
        if (setAsMain) {
            OpenProjects.getDefault().setMainProject(prj);
        }
    }

    private static class OptionalValidator
    extends AbstractValidator<String> {
        private final JCheckBox checkbox;
        private final Validator<String> delegate;

        OptionalValidator(JCheckBox cb, Validator<String> validator) {
            super(String.class);
            this.checkbox = cb;
            this.delegate = validator;
        }

        public void validate(Problems problems, String compName, String model) {
            if (this.checkbox.isSelected()) {
                this.delegate.validate(problems, compName, (Object)model);
            }
        }
    }

    private static class FileNameExists
    extends AbstractValidator<String> {
        private final File parent;

        FileNameExists(File parent) {
            super(String.class);
            assert (parent.isDirectory() && parent.exists());
            this.parent = parent;
        }

        public void validate(Problems problems, String compName, String model) {
            File newDir = new File(this.parent, model);
            if (newDir.exists()) {
                problems.add("Folder with name '" + model + "' already exists.", Severity.FATAL);
            }
        }
    }

    private static class DNameOperation
    implements ModelOperation<POMModel> {
        private final String name;

        DNameOperation(String nm) {
            this.name = nm;
        }

        public void performOperation(POMModel model) {
            model.getProject().setName(this.name);
        }
    }

    private static class ArtIdOperation
    implements ModelOperation<POMModel> {
        private final String artifactId;

        ArtIdOperation(String art) {
            this.artifactId = art;
        }

        public void performOperation(POMModel model) {
            model.getProject().setArtifactId(this.artifactId);
        }
    }
}

