/*
 * This file is part of gtkD.
 *
 * gtkD is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version, with
 * some exceptions, please read the COPYING file.
 *
 * gtkD is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with gtkD; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110, USA
 */

// generated automatically - do not change
// find conversion definition on APILookup.txt
// implement new conversion functionalities the gir-to-d pakage


module gio.UnixMountEntry;

private import gio.IconIF;
private import gio.c.functions;
public  import gio.c.types;
private import glib.ListG;
private import glib.Str;
private import glib.c.functions;
private import gobject.ObjectG;


/**
 * Defines a Unix mount entry (e.g. `/media/cdrom`).
 * This corresponds roughly to a mtab entry.
 */
public class UnixMountEntry
{
	/** the main Gtk struct */
	protected GUnixMountEntry* gUnixMountEntry;
	protected bool ownedRef;

	/** Get the main Gtk struct */
	public GUnixMountEntry* getUnixMountEntryStruct(bool transferOwnership = false)
	{
		if (transferOwnership)
			ownedRef = false;
		return gUnixMountEntry;
	}

	/** the main Gtk struct as a void* */
	protected void* getStruct()
	{
		return cast(void*)gUnixMountEntry;
	}

	/**
	 * Sets our main struct and passes it to the parent class.
	 */
	public this (GUnixMountEntry* gUnixMountEntry, bool ownedRef = false)
	{
		this.gUnixMountEntry = gUnixMountEntry;
		this.ownedRef = ownedRef;
	}


	/** */
	public static GType getType()
	{
		return g_unix_mount_entry_get_type();
	}

	/**
	 * Compares two Unix mounts.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.compare] instead.
	 *
	 * Params:
	 *     mount1 = first [struct@GioUnix.MountEntry] to compare
	 *     mount2 = second [struct@GioUnix.MountEntry] to compare
	 *
	 * Returns: `1`, `0` or `-1` if @mount1 is greater than, equal to,
	 *     or less than @mount2, respectively
	 */
	public static int compare(UnixMountEntry mount1, UnixMountEntry mount2)
	{
		return g_unix_mount_compare((mount1 is null) ? null : mount1.getUnixMountEntryStruct(), (mount2 is null) ? null : mount2.getUnixMountEntryStruct());
	}

	/**
	 * Makes a copy of @mount_entry.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.copy] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a new [struct@GioUnix.MountEntry]
	 *
	 * Since: 2.54
	 */
	public static UnixMountEntry copy(UnixMountEntry mountEntry)
	{
		auto __p = g_unix_mount_copy((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct());

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(UnixMountEntry)(cast(GUnixMountEntry*) __p, true);
	}

	/**
	 * Frees a Unix mount.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.free] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 */
	public static void free(UnixMountEntry mountEntry)
	{
		g_unix_mount_free((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct());
	}

	/**
	 * Gets the device path for a Unix mount.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.get_device_path] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a string containing the device path
	 */
	public static string getDevicePath(UnixMountEntry mountEntry)
	{
		return Str.toString(g_unix_mount_get_device_path((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()));
	}

	/**
	 * Gets the filesystem type for the Unix mount.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.get_fs_type] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a string containing the file system type
	 */
	public static string getFsType(UnixMountEntry mountEntry)
	{
		return Str.toString(g_unix_mount_get_fs_type((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()));
	}

	/**
	 * Gets the mount path for a Unix mount.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.get_mount_path] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry] to get the mount path for
	 *
	 * Returns: the mount path for @mount_entry
	 */
	public static string getMountPath(UnixMountEntry mountEntry)
	{
		return Str.toString(g_unix_mount_get_mount_path((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()));
	}

	/**
	 * Gets a comma separated list of mount options for the Unix mount.
	 *
	 * For example: `rw,relatime,seclabel,data=ordered`.
	 *
	 * This is similar to [func@GioUnix.MountPoint.get_options], but it takes
	 * a [struct@GioUnix.MountEntry] as an argument.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.get_options] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a string containing the options, or `NULL` if not
	 *     available.
	 *
	 * Since: 2.58
	 */
	public static string getOptions(UnixMountEntry mountEntry)
	{
		return Str.toString(g_unix_mount_get_options((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()));
	}

	/**
	 * Gets the root of the mount within the filesystem. This is useful e.g. for
	 * mounts created by bind operation, or btrfs subvolumes.
	 *
	 * For example, the root path is equal to `/` for a mount created by
	 * `mount /dev/sda1 /mnt/foo` and `/bar` for
	 * `mount --bind /mnt/foo/bar /mnt/bar`.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.get_root_path] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a string containing the root, or `NULL` if not supported
	 *
	 * Since: 2.60
	 */
	public static string getRootPath(UnixMountEntry mountEntry)
	{
		return Str.toString(g_unix_mount_get_root_path((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()));
	}

	/**
	 * Guesses whether a Unix mount entry can be ejected.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.guess_can_eject] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: true if @mount_entry is deemed to be ejectable; false otherwise
	 */
	public static bool guessCanEject(UnixMountEntry mountEntry)
	{
		return g_unix_mount_guess_can_eject((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()) != 0;
	}

	/**
	 * Guesses the icon of a Unix mount entry.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.guess_icon] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a [iface@Gio.Icon]
	 */
	public static IconIF guessIcon(UnixMountEntry mountEntry)
	{
		auto __p = g_unix_mount_guess_icon((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct());

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(IconIF)(cast(GIcon*) __p, true);
	}

	/**
	 * Guesses the name of a Unix mount entry.
	 *
	 * The result is a translated string.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.guess_name] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a newly allocated translated string
	 */
	public static string guessName(UnixMountEntry mountEntry)
	{
		auto retStr = g_unix_mount_guess_name((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct());

		scope(exit) Str.freeString(retStr);
		return Str.toString(retStr);
	}

	/**
	 * Guesses whether a Unix mount entry should be displayed in the UI.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.guess_should_display] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: true if @mount_entry is deemed to be displayable; false otherwise
	 */
	public static bool guessShouldDisplay(UnixMountEntry mountEntry)
	{
		return g_unix_mount_guess_should_display((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()) != 0;
	}

	/**
	 * Guesses the symbolic icon of a Unix mount entry.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.guess_symbolic_icon] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: a [iface@Gio.Icon]
	 *
	 * Since: 2.34
	 */
	public static IconIF guessSymbolicIcon(UnixMountEntry mountEntry)
	{
		auto __p = g_unix_mount_guess_symbolic_icon((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct());

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(IconIF)(cast(GIcon*) __p, true);
	}

	/**
	 * Checks if a Unix mount is mounted read only.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.is_readonly] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: true if @mount_entry is read only; false otherwise
	 */
	public static bool isReadonly(UnixMountEntry mountEntry)
	{
		return g_unix_mount_is_readonly((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()) != 0;
	}

	/**
	 * Checks if a Unix mount is a system mount.
	 *
	 * This is the Boolean OR of
	 * [func@GioUnix.is_system_fs_type], [func@GioUnix.is_system_device_path] and
	 * [func@GioUnix.is_mount_path_system_internal] on @mount_entry’s properties.
	 *
	 * The definition of what a ‘system’ mount entry is may change over time as new
	 * file system types and device paths are ignored.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.is_system_internal] instead.
	 *
	 * Params:
	 *     mountEntry = a [struct@GioUnix.MountEntry]
	 *
	 * Returns: true if the Unix mount is for a system path; false otherwise
	 */
	public static bool isSystemInternal(UnixMountEntry mountEntry)
	{
		return g_unix_mount_is_system_internal((mountEntry is null) ? null : mountEntry.getUnixMountEntryStruct()) != 0;
	}

	/**
	 * Gets a [struct@GioUnix.MountEntry] for a given mount path.
	 *
	 * If @time_read is set, it will be filled with a Unix timestamp for checking
	 * if the mounts have changed since with
	 * [func@GioUnix.mount_entries_changed_since].
	 *
	 * If more mounts have the same mount path, the last matching mount
	 * is returned.
	 *
	 * This will return `NULL` if there is no mount point at @mount_path.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.at] instead.
	 *
	 * Params:
	 *     mountPath = path for a possible Unix mount
	 *     timeRead = return location for a timestamp
	 *
	 * Returns: a [struct@GioUnix.MountEntry]
	 */
	public static UnixMountEntry at(string mountPath, out ulong timeRead)
	{
		auto __p = g_unix_mount_at(Str.toStringz(mountPath), &timeRead);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(UnixMountEntry)(cast(GUnixMountEntry*) __p, true);
	}

	/**
	 * Gets a [struct@GioUnix.MountEntry] for a given file path.
	 *
	 * If @time_read is set, it will be filled with a Unix timestamp for checking
	 * if the mounts have changed since with
	 * [func@GioUnix.mount_entries_changed_since].
	 *
	 * If more mounts have the same mount path, the last matching mount
	 * is returned.
	 *
	 * This will return `NULL` if looking up the mount entry fails, if
	 * @file_path doesn’t exist or there is an I/O error.
	 *
	 * Params:
	 *     filePath = file path on some Unix mount
	 *     timeRead = return location for a timestamp
	 *
	 * Returns: a [struct@GioUnix.MountEntry]
	 *
	 * Since: 2.84
	 */
	public static UnixMountEntry for_(string filePath, out ulong timeRead)
	{
		auto __p = g_unix_mount_entry_for(Str.toStringz(filePath), &timeRead);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(UnixMountEntry)(cast(GUnixMountEntry*) __p, true);
	}

	/**
	 * Determines if @mount_path is considered an implementation of the
	 * OS.
	 *
	 * This is primarily used for hiding mountable and mounted volumes
	 * that only are used in the OS and has little to no relevance to the
	 * casual user.
	 *
	 * Params:
	 *     mountPath = a mount path, e.g. `/media/disk` or `/usr`
	 *
	 * Returns: true if @mount_path is considered an implementation detail
	 *     of the OS; false otherwise
	 */
	public static bool isMountPathSystemInternal(string mountPath)
	{
		return g_unix_is_mount_path_system_internal(Str.toStringz(mountPath)) != 0;
	}

	/**
	 * Checks if the Unix mount points have changed since a given Unix time.
	 *
	 * Unlike [func@GioUnix.mount_entries_changed_since], this function can work
	 * reliably without a [class@GioUnix.MountMonitor] running, as it accesses the
	 * static mount point information (such as `/etc/fstab` on Linux), which has a
	 * valid modification time.
	 *
	 * It is more efficient to use [signal@GioUnix.MountMonitor::mountpoints-changed]
	 * to be signalled of changes to the mount points, rather than polling using
	 * this function. This function is more appropriate for infrequently determining
	 * cache validity.
	 *
	 * Params:
	 *     time = a timestamp
	 *
	 * Returns: true if the mount points have changed since @time; false otherwise
	 */
	public static bool pointsChangedSince(ulong time)
	{
		return g_unix_mount_points_changed_since(time) != 0;
	}

	/**
	 * Gets a list of [struct@GioUnix.MountPoint] instances representing the Unix
	 * mount points.
	 *
	 * If @time_read is set, it will be filled with the mount timestamp, allowing
	 * for checking if the mounts have changed with
	 * [func@GioUnix.mount_points_changed_since].
	 *
	 * Params:
	 *     timeRead = return location for a timestamp
	 *
	 * Returns: a list of the Unix
	 *     mount points
	 */
	public static ListG mountPointsGet(out ulong timeRead)
	{
		auto __p = g_unix_mount_points_get(&timeRead);

		if(__p is null)
		{
			return null;
		}

		return new ListG(cast(GList*) __p, true);
	}

	/**
	 * Checks if the Unix mounts have changed since a given Unix time.
	 *
	 * Deprecated: Use [func@GioUnix.mount_entries_changed_since] instead.
	 *
	 * Params:
	 *     time = a timestamp
	 *
	 * Returns: true if the mounts have changed since @time; false otherwise
	 */
	public static bool mountsChangedSince(ulong time)
	{
		return g_unix_mounts_changed_since(time) != 0;
	}

	/**
	 * Gets a list of [struct@GioUnix.MountEntry] instances representing the Unix
	 * mounts.
	 *
	 * If @time_read is set, it will be filled with the mount timestamp, allowing
	 * for checking if the mounts have changed with
	 * [func@GioUnix.mount_entries_changed_since].
	 *
	 * Deprecated: Use [func@GioUnix.mount_entries_get] instead.
	 *
	 * Params:
	 *     timeRead = return location for a timestamp
	 *
	 * Returns: a list of the
	 *     Unix mounts
	 */
	public static ListG mountsGet(out ulong timeRead)
	{
		auto __p = g_unix_mounts_get(&timeRead);

		if(__p is null)
		{
			return null;
		}

		return new ListG(cast(GList*) __p, true);
	}

	/**
	 * Gets a [struct@GioUnix.MountEntry] for a given file path.
	 *
	 * If @time_read is set, it will be filled with a Unix timestamp for checking
	 * if the mounts have changed since with
	 * [func@GioUnix.mount_entries_changed_since].
	 *
	 * If more mounts have the same mount path, the last matching mount
	 * is returned.
	 *
	 * This will return `NULL` if looking up the mount entry fails, if
	 * @file_path doesn’t exist or there is an I/O error.
	 *
	 * Deprecated: Use [func@GioUnix.MountEntry.for] instead.
	 *
	 * Params:
	 *     filePath = file path on some Unix mount
	 *     timeRead = return location for a timestamp
	 *
	 * Returns: a [struct@GioUnix.MountEntry]
	 *
	 * Since: 2.52
	 */
	public static UnixMountEntry mountFor(string filePath, out ulong timeRead)
	{
		auto __p = g_unix_mount_for(Str.toStringz(filePath), &timeRead);

		if(__p is null)
		{
			return null;
		}

		return ObjectG.getDObject!(UnixMountEntry)(cast(GUnixMountEntry*) __p, true);
	}
}
