/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.metrics;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;
import org.apache.hadoop.metrics2.lib.MutableRatesWithAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@Metrics(about="Per method RPC metrics", context="rpcdetailed")
public class RpcDetailedMetrics {
    static final String DEFERRED_PREFIX = "Deferred";
    static final String OVERALL_PROCESSING_PREFIX = "Overall";
    @Metric
    MutableRatesWithAggregation rates;
    @Metric
    MutableRatesWithAggregation deferredRpcRates;
    @Metric
    MutableRatesWithAggregation overallRpcProcessingRates;
    static final Logger LOG = LoggerFactory.getLogger(RpcDetailedMetrics.class);
    final MetricsRegistry registry;
    final String name;

    public MutableRatesWithAggregation getOverallRpcProcessingRates() {
        return this.overallRpcProcessingRates;
    }

    RpcDetailedMetrics(int port) {
        this.name = "RpcDetailedActivityForPort" + port;
        this.registry = new MetricsRegistry("rpcdetailed").tag("port", "RPC port", String.valueOf(port));
        LOG.debug(this.registry.info().toString());
    }

    public String name() {
        return this.name;
    }

    public static RpcDetailedMetrics create(int port) {
        RpcDetailedMetrics m = new RpcDetailedMetrics(port);
        return DefaultMetricsSystem.instance().register(m.name, null, m);
    }

    public void init(Class<?> protocol) {
        this.rates.init(protocol);
        this.deferredRpcRates.init(protocol, DEFERRED_PREFIX);
        this.overallRpcProcessingRates.init(protocol, OVERALL_PROCESSING_PREFIX);
    }

    public void addProcessingTime(String rpcCallName, long processingTime) {
        this.rates.add(rpcCallName, processingTime);
    }

    public void addDeferredProcessingTime(String name, long processingTime) {
        this.deferredRpcRates.add(name, processingTime);
    }

    public void addOverallProcessingTime(String rpcCallName, long overallProcessingTime) {
        this.overallRpcProcessingRates.add(rpcCallName, overallProcessingTime);
    }

    public void shutdown() {
        DefaultMetricsSystem.instance().unregisterSource(this.name);
    }
}

