/*
 * Copyright (c) 1992, Bruno Grossniklaus, grossnik@iam.unibe.ch
 * 
 * I added new features for special use at the IAM and fixed some bugs.
 * 
 */

/*
 * Copyright (c) 1990, William C. Ogden, ogden@nmsu.edu
 * 
 * Permission is granted to copy and distribute this file in modified or
 * unmodified form, for noncommercial use, provided (a) this copyright notice
 * is preserved, (b) no attempt is made to restrict redistribution of this
 * file, and (c) this file is not distributed as part of any collection whose
 * redistribution is restricted by a compilation copyright.
 */



#include <stdio.h>
#include <sys/param.h>
#include <sys/types.h>
#include <xview/xview.h>
#include <xview/canvas.h>
#include <xview/panel.h>
#include <xview/scrollbar.h>
#include <xview/svrimage.h>
#include <xview/termsw.h>
#include <xview/text.h>
#include <xview/tty.h>
#include <xview/xv_xrect.h>
#include <xview/dragdrop.h>
#include <xview/cursor.h>
#include <xview/notice.h>
#include <gdd.h>

#include <sys/stat.h>
#include <unistd.h>

#include "bc_edit.h"



extern void
load_clip()
{
	Textsw_status   status;

	xv_set(Bc_clip_buffer_popup->clip_buffer_popup_textplane,
	       TEXTSW_STATUS, &status,
	       TEXTSW_FILE, clipfile_name,
	       TEXTSW_FIRST, 0, NULL);
}



extern          Notify_func
update_clip()
{
	struct stat     buf;
	static time_t   last_time;

	stat(clipfile_name, &buf);

	/* if changed */
	if (buf.st_mtime != last_time) {
		last_time = buf.st_mtime;

		load_clip();
		load_clip();	/* do it twice because once does not work
				 * arrg! */
	}
	return (NOTIFY_DONE);
}



extern void
copy()
{
	char            sys_command[BUFSIZ];
	int             result;

	unlink(clipfile_name);

	if ((infile = fopen(clipfile_name, "w")) == NULL) {
		fprintf(PRINT_TO, "bibcard: could not open clip file. \n");
	} else {
		print_item(current_item);
	}
	fclose(infile);
	if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup, XV_SHOW))
		load_clip();
}


extern void
add_to_buffer()
{
	int             result;

	if ((infile = fopen(clipfile_name, "a")) == NULL) {
		fprintf(PRINT_TO, "bibcard: could not append to clip file. \n");

	} else {

		print_item(current_item);
	}
	fclose(infile);
	if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup, XV_SHOW))
		load_clip();


}


extern void
add_selection_to_buffer()
{
	int             result;

	Ref             ref_list;
	SLIST           sel_list, prev, next;


	if ((infile = fopen(clipfile_name, "a")) == NULL) {
		fprintf(PRINT_TO, "bibcard: could not append to clip file. \n");

	} else {
		selection_save_abbrev_flag = FALSE;
		print_selections();
	}
	fclose(infile);
	if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup, XV_SHOW))
		load_clip();
}


extern void
paste()
{
	int             locx = 0;
	int             locy = 0;

	paste_flag = merge_flag = TRUE;

	if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup, XV_SHOW)) {
		if ((int) xv_get(Bc_clip_buffer_popup->clip_buffer_popup_textplane, TEXTSW_LENGTH, NULL) > 1) {
			if (textsw_store_file(Bc_clip_buffer_popup->clip_buffer_popup_textplane, clipfile_name, locx, locy)
			    != NULL) {
				notice_prompt(Bc_clip_buffer_popup->clip_buffer_popup_controls, NULL,
					      NOTICE_MESSAGE_STRINGS,
					      "Error saving clipfile", NULL,
					      NOTICE_BUTTON_YES, "Continue",
					      NULL);
				return;
			} else {

				if (loadFile(clipfile_name) == OK) {
					mod_flag = TRUE;
					mod_for_find_flag = TRUE;
				}
				paste_flag = merge_flag = FALSE;
				do_title();
			}
		}
	} else {
		loadFile(clipfile_name);
		paste_flag = merge_flag = FALSE;
		mod_flag = TRUE;
		mod_for_find_flag = TRUE;
		do_title();
	}
}


extern void
add_item()
{
	Ref             ref;
	char            value[BUFSIZ];
	int             i;

	if ((ref = (Reference *) malloc(sizeof(Reference))) == NULL) {
		fprintf(PRINT_TO, "bibcard: no memory for add");
		exit(ERROR);
	}
	bzero((char *) ref, sizeof(Reference));

	ref->next = current_item->next;
	ref->prev = current_item;

	/* set ref type to default ref type */
	strcpy(ref->ref_type, ref_types_show_fct[default_ref_type].ref_type_token);
	if (current_item == last_item)
		last_item = ref;
	else
		current_item->next->prev = ref;

	/* set default ns fields */
	i = (int) xv_get(Bc_properties_popup->properties_popup_textplane, TEXTSW_CONTENTS, NULL, value, BUFSIZ - 1);
	if (i == BUFSIZ -1) {
	  fprintf (PRINT_TO, "bibcard: default non standard fields too long. \n");
	} 
	if (i != 0) {
	  SET_STR (ref->nsfield, value);
	}

	current_item->next = ref;
	current_item = ref;
	mod_flag = TRUE;
	mod_for_find_flag = TRUE;
	show_current_item();
}



extern void
duplicate_item()
{
	Ref             ref, old;
	int             i;

	old = current_item;
	if ((ref = (Reference *) malloc(sizeof(Reference))) == NULL) {
		fprintf(PRINT_TO, "bibcard: no memory for duplicate");
		exit(ERROR);
	}
	bzero((char *) ref, sizeof(Reference));

	strcpy(ref->ref_type, old->ref_type);

	for (i = 1; i < num_of_fields; i++) {
		SET_STR(ref->field[i], old->field[i]);
		ref->open_char[i] = old->open_char[i];
		ref->close_char[i] = old->close_char[i];
	}

	SET_STR(ref->annote, old->annote);
	SET_STR(ref->nsfield, old->nsfield);

	ref->next = current_item->next;
	ref->prev = current_item;

	if (current_item == last_item)
		last_item = ref;
	else
		current_item->next->prev = ref;

	current_item->next = ref;
	current_item = ref;
	mod_flag = TRUE;
	mod_for_find_flag = TRUE;
	show_current_item();
}



extern void
delete_item()
{
	Ref             ref;

	if (last_item == first_item)
		new_bib();

	else {
		if (current_item == last_item) {
			last_item = current_item->prev;
			current_item->prev->next = NULL;
			ref = current_item;
			current_item = current_item->prev;
			free(ref->nsfield);
			free(ref->annote);
			free(ref);

		} else if (current_item == first_item) {
			first_item = current_item->next;
			current_item->next->prev = NULL;
			ref = current_item;
			current_item = current_item->next;
			free(ref->nsfield);
			free(ref->annote);
			free(ref);

		} else {
			current_item->next->prev = current_item->prev;
			current_item->prev->next = current_item->next;
			ref = current_item;
			current_item = current_item->next;
			free(ref->nsfield);
			free(ref->annote);
			free(ref);
		}

		show_current_item();
		mod_flag = TRUE;
		mod_for_find_flag = TRUE;
		if (update_flag == UPDATE_ON)
			update_cite_list();
		do_title();
	}
}
