{$IFDEF WINDOWS}
{$N-,V-,W-,G+}
{$ELSE}
{$E-,N-,V-}
{$ENDIF}

Unit bibvars;

Interface

Uses
{$IFDEF WINDOWS}
  WinDos, WObjects, WinTypes, WinProcs, streams, commdlg, strings, ole,
  wbibbin,
{$ELSE}
  Dos, Objects, streams, bibdisp,
{$ENDIF}
  lfnunit;


Const
{$IFDEF WINDOWS}
  ProgramVersion: string[10] = '2.2';
  IsDosVersion = false; IsWindowsVersion = true;
{$ELSE}
  ProgramVersion: string[10] = '2.0';
  IsDosVersion = true;  IsWindowsVersion = false;
{$ENDIF}

  K1 = 1024; K16 = 16*K1; K64 = 64*K1;

{$IFDEF WINDOWS}
  MaxMaxBig=32752;
  MaxField=50;            { Max number of fields                  }
  MaxBibFiles=9;          { Max number of bibliography files      }
{$ELSE}
  MaxMaxBig=65520;        { Max size of BIG fields                }
  MaxField=38;            { Max number of fields                  }
  MaxBibFiles=8;          { Max number of bibliography files      }
{$ENDIF}
  MaxPattOper=36;         { Max number of pattern operations      }
  MaxPattCrit=20;         { Max number of pattern criteria        }
  MaxOverView=3;          { Max number of Overview fields         }
  MaxEolStrings=8;        { Max number of EOL strings             }
  MinFileBufSize=512;     { Min size of text file buffer          }
  MaxFileBufSize=65520;   { Max size of text file buffer          }
  MaxLookForSort=5;       { Number of lines to look for sort info }
  MaxListArr=440;         { Number of items in an on screen list  }
  MaxVidModes=11;         { Maximal number of user-defined modes  }
  MaxFieldStrLen=32;      { Max length of field name              }
  MemoryPoolSize=10240;   { Min heap memory to keep free          }
  NSortKeys=3;            { Max number of sort keys               }
  MaxArticles=255;        { Max number of articles (words)        }
  MaxTags=K64;            { Max number of tags                    }
  MaxUserMenuItems=8;     { Max number of User-defined menu items }
  ListArrRecLen=40;
  ListArrRec2Len=15;
  
  MaxBuffStack    = maxfield+46; { Max depth of buffer stack      }
  StringIndex     = MaxField+1;  { Index of string value field    }
  StringFieldName  : string[10] = '_string';
  StringTypeName   : string[10] = 'string';
  PreambleEntryName: string[11] = '{preamble}';
  PreambleTypeName : string[11] = 'preamble';

  { Pattern-related }

  PattFlag_NOT      = 1;
  PattFlag_CaseSen  = 2;
  PattFlag_Regexp   = 4;
  Patt_AND          = -1;        Patt_OR            = -2;
  Patt_NULL         = -3;
  PattField_Name    = #0;
  PattField_All     = #252;      PattField_Undec    = #253;
  PattField_Tagged  = #254;      PattField_Type     = #255;
  PattStr_Name  : string[10] = '_name';   PattStr_Undec: string[14] = '_undeclared';
  PattStr_Tagged: string[10] = '_tagged'; PattStr_Type : string[10] = '_type';
  PattStr_All   : string[10] = '_all';
  PattUnique = 3;
  PattCaseStrings: array[boolean] of string[12] = ('_CaseOff'  ,'_CaseOn'  );
  PattRegStrings:  array[boolean] of string[12] = ('_RegexpOff','_RegexpOn');
  PatternExt: String[10] = '.ptn';

  NSortCriteria=NSortKeys+2;
  
  lbrace =#123; rbrace = #125; { Can't write these explicitly in the code! }

  TeXLett:     set of char = ['A'..'Z','a'..'z',#21,#128..#255];
  CommentSet:  set of char = ['%','!','#',';'];
  NameForbid:  set of char = [#0..#20,#22..#32,',','\',lbrace,rbrace,'%','@'];
  FileNameSet: set of char = ['!','#'..')',#45,#46,'0'..':','@'..'Z','\',
                              '`'..#123,#125,'~','_'];
  ScreenInitialized: boolean = false;
  UnInitialized:     boolean = true;
  AllEntriesTagged:  boolean = false;

  { File edit actions }

  Ac_Insert   = 1;  Ac_Delete = 2; Ac_Replace = 3;
  Ac_Import   = 4;  Ac_Export = 5; Ac_Sort    = 6;
  Ac_Reformat = 7;  Ac_Index  = 8; Ac_Add     = 9;
  Ac_Strings  = 10;

  { Search flags }

  CaseSenMatch = 1; RegexpMatch  = 2; ExactMatch   = 4;

  { ShowFormat constituents }

  sf_NOP    = #0;  { Null operation }
  sf_bf     = #1;  { Boldface.      }
  sf_Attrib = 128; { Beginning of attribute range (bf, color, case)    }
  sf_EndAtt = #2;  { End attribute range (bf, color, case)             }
  sf_CR     = #3;  { \cr.  Character after is number of lines          }
  sf_If     = #4;  { \if.  After that, a list of fields and operations }
    sfIf_field = 128; {Fields appear as 128+number                  }
    sfIf_type  = 50;  { entries as 50+number                        }
    sfIf_AND   = '*'; sfif_OR = '+'; sfif_NOT = '^'; { *,^,+ appear as themselves. }
    sfIf_Display  = #255; { Display                                 }
    sfIf_WinPrint = #254; { Windows printer                         }
    sfIf_Dos      = #253; { DOS version of BibDB                    }
    sfIf_Windows  = #252; { Windows version of BibDB                }
    sfIf_true     = #251; { true                                    }
    sfIf_false    = #250; { false                                   }
    sfIf_LastForm = 249;  { LastForm to LastForm+1-NumUserFormats = }
                          {Specific file formats                    }
    sfIf_Header   = #50;  { File header (i.e. Type=0)               }
  sf_ElseIf = #5; { \elseif. Same as \if. Also \else appears as \elseif() }
  sf_EndIf  = #6; { end of logical block of \if and \elseif               }
  sf_Field  = #7; { <field> : }
    sfFld_Offset  = 128;  { Next character is 128+field number }
    sfFld_flFull  = #249; { Full path name of current file     }
    sfFld_flDrive = #250; { Current file drive                 }
    sfFld_flPath  = #251; { Current file path                  }
    sfFld_flName  = #252; { Current file name                  }
    sfFld_flExt   = #253; { Current file extension             }
    sfFld_Name    = #254; { entry name                         }
    sfFld_Type    = #255; { entry type                         }
  sf_Field1 = #8;  { [[field]]. Next character is sfFld_Offset+field number }
  sf_Field2 = #11; { <<field>>. Next character is sfFld_Offset+field number }
  sf_Field3 = #19; { <<<field>>>. Character following is sfFld_Offset+field number }
  sf_FldName= #21; { [field]. Next character is sfFld_Offset+field number   }
  sf_TAB    = #9;  { Reserved (TAB)}
  sf_LF     = #10; { Reserved (LF) }
  sf_EOL    = #13; { Reserved (CR) }
  sf_Color  = #12; { \color. Character after is color attribute }
  sf_Quote  = #14; { Quote next character verbatim              }
  sf_UpCase = #15; { Upper case    }
  sf_DnCase = #16; { Lower case    }
  sf_DefCase= #17; { Default case  }
  sf_End    = #18; { END directive }
  sf_FF     = #20; { \FF, Form Feed for Windows printing only, ignored by others   }
{  #22 - \text.}
{$IFDEF OldParse}
  sf_Bslash = #23; { Explicit "\"    }
  sf_Lbrace = #24; { Explicit lbrace }
  sf_Rbrace = #25; { Explicit rbrace }
  sf_sColon = #26; { Explicit ";"    }
  sf_langle = #27; { Explicit "<"    }
  sf_rangle = #28; { Explicit ">"    }
{$ENDIF}
  sf_EndBrace = 200; { #200+i - Closing brace of level i }

  EmptyFieldChar = #1;
  File_Clipboard = #14;

{$IFDEF WINDOWS}
  AnyFile   = faAnyFile;
  Directory = faDirectory;
  SysFile   = faSysFile;
  ReadOnly  = faReadOnly;
{$ELSE}
  faAnyFile   = AnyFile;
  faDirectory = Directory;
  faSysFile   = SysFile;
  faReadOnly  = ReadOnly;
  faVolumeID  = VolumeID;
  faHidden    = Hidden;
{$ENDIF}

{$IFDEF WINDOWS}
  BibTeXHelpName = 'bibtex';
  DDETimeout = 10000;

  BibTeXStr: PChar = 'BibTeX'; CommaStr: PChar = 'Comma delimited';
  TibStr   : PChar = 'Tib';    ReferStr: PChar = 'Refer';

  AnyFileFilter = 'Any file'#0'*.*'#0#0;

  { User-defined menu items }
  cm_FirstUserExpField  = 600;
  cm_FirstUserFormat    = 700;
  cm_FirstUserPattField = 800;
  cm_FirstPattHeirarchy = 4000;

  { Font identifiers }
  LabelFont       = 0;  NormalFont      = 1;  BoldFont      = 2;
  HyperFont       = 17;
  PrintLabelFont  = 18; PrintNormalFont = 19; PrintBoldFont = 20;
  PrintHyperFont  = 35; PageHeaderFont  = 36;
  FieldEditFont   = 37;
  PattTextFont    = 38; PattFieldFont   = 39; PattOpFont    = 40;
  StatusBarFont   = 41; ShowFormatFont  = 42;
  FirstFontIndex  = 0;  LastFontIndex   = 42;

  { User messages }
  bib_TbButtonPressed = wm_User;
  bib_ArrowKeys       = wm_User+1;
  bib_ClickedOnField  = wm_User+2;
  bib_StatusBoxClick  = wm_User+3;
  bib_DlgAccels       = wm_User+4;
  bib_DlgHelp         = wm_User+5;
  bib_KbHook          = wm_User+6;
  bib_EnterIdle       = wm_User+7;
  bib_CloseObjTest    = wm_User+8;
  bib_RetrieveURL     = wm_User+9;
  bib_GetInstNumber   = wm_User+10;
  bib_Update          = wm_User+11;
  bib_FindRep         = wm_User+12;
  bib_ObjectMsg       = wm_User+13;

  { Constants used to check key status in wmChar and similar messages }
  wmChar_ExtendedKey   = $01000000;
  wmChar_AltPressed    = $20000000;
  wmChar_KeyWasDown    = $40000000;
  wmChar_BeingReleased = $80000000;

  { Win 95 3-D }
  DS_3DLOOK = 4;

  EditEntry_Modify = 1; EditEntry_Add    = 2;
  EditEntry_Import = 3; EditEntry_Export = 4;

  Str_Literal = 0;

  ENameClick_Copy   = 0; ENameClick_CopyEx = 1; ENameClick_String = 2;

  { Hyperlinks }
  Hyper_cite  = 1; Hyper_run = 2; Hyper_DDE  = 3; Hyper_Help = 4;
  Hyper_HRef  = 5; Hyper_FTP = 6; Hyper_Mail = 7; Hyper_User = 8;
  HClass_off  = 0; HClass_on = 1;
  HRun_Verify = 2;
  MaxHyperTypes = 255;

                 { From BibDisp }

  MaxMenu          = 22;  { Max number of pulldown menu items }
  MaxTopLine       = 11;  { Max number of Topline  menu items }
  MaxMenuStack     = 4;   { Max submenu depth                 }
  MaxMenuItemWidth = 64;  { Max width of a mouse menu item    }

{$ENDIF}
                        { TopLine menu constants }
                         
  CMainNext = 1; CMainBack = 2; CMainFile = 3; CMainEdit = 4; CMainGoto = 5;
  CMainAdd  = 6; CMainImp  = 7; CMainExp  = 8; CMainPatt = 9; CMainMisc = 10;
  CMainQuit = 11;

  CEditType    = 1; CEditName   = 2;  CEditWhich = 3; CEditFields = 4;
  CEditDefault = 5; CEditEdit   = 6;  CEditView  = 7; CEditSave   = 8;
  CEditQuit    = 9; CEditFinish = 10;

  CPattAdd   = 1; CPattAND  = 2; CPattOR   = 3; CPattNOT   = 4; CPattBS   = 5;
  CPattClear = 6; CPattFile = 7; CPattMode = 8; CPattOnOff = 9; CPattSave = 10;
  CPattQuit  = 11;

                       { Submenu constants }

  { File submenu constants }

  CFile_Open     = 1;  CFile_Change    = 2;  CFile_Link  = 3;  CFile_Sort  = 4;
  CFile_Reformat = 5;  CFile_Index     = 6;  CFile_Exit  = 7;  CFile_Shell = 8;
  CFile_ReadOnly = 9;  CFile_Translate = 10; CFile_Close = 11;
  CFile_List     = 12; CFile_AutoIndex = $FF;

  { Edit submenu constants }
  
  CEdit_Entry   = 1; CEdit_Copy     = 2;  CEdit_Cut    = 3;  CEdit_Paste  = 4;
  CEdit_Replace = 5; CEdit_Clear    = 6;  CEdit_Tag    = 7;  CEdit_TagAll = 8;
  CEdit_TagTeX  = 9; CEdit_UntagAll = 10; CEdit_DelAll = 11;
  CEdit_DelTagged = 12; CEdit_Bookmark = 13;
  CEdit_PasteClip = 14; CEdit_RepClip  = 15;

  { Goto submenu constants }

  CGoto_Next     = 1; CGoto_Back   = 2;  CGoto_First    = 3;  CGoto_Last  = 4;
  CGoto_Bookmark = 5; CGoto_List   = 6;  CGoto_Overview = 7;  CGoto_Label = 8;
  CGoto_Number   = 9; CGoto_Search = 11; CGoto_Tag      = 12; CGoto_SearchNext=13;
  CGoto_LabelNext=14;
 
  { Import, Export, Add positions }

  CIns_EOF    = 1; CIns_BeforeCurr = 2; CIns_AfterCurr  = 3;
  CIns_Num    = 4; CIns_EntryList  = 5; CIns_FirstEntry = 6; CIns_Sorted = 7;

  { Pattern menu }

  CPatt_OnOff  = 1; CPatt_Edit      = 2; CPatt_Macro = 3; CPatt_Stream = 4;
  CPatt_Tagged = 8; CPatt_AllFields = 9; CPatt_User  = 10;

  { Import submenu constants }
  
  CImp_Format = 8;

  { Export submenu constants }

  CExp_Current = 1; CExp_All    = 2;  CExp_Range  = 3; CExp_Tagged = 4;
  CExp_Ofile   = 5; CExp_Format = 6;  CExp_Fields = 7; CExp_New    = 8;
  CExp_Clear   = 9; CExp_Rec    = 10;

  { Export | Fields submenu constants }

  CExpFields_Full = 1; CExpFields_Labels = 2; CExpFields_Specified = 3;
  CExpFields_User = 4;

  { Misc submenu constants }

  CMisc_About    = 1;  CMisc_Count    = 2;  CMisc_Vmode       = 4;
  CMisc_View     = 5;  CMisc_Suspend  = 6;  CMisc_Preferences = 7;
  CMisc_Soptions = 8;  CMisc_Foptions = 9;  CMisc_CD          = 10;
  CMisc_Strings  = 12; CMisc_SaveOpts = 13; CMisc_Encoding    = 14;
  CMisc_TagNew   = 15; CMisc_CacheMenu= 16;

  { Misc | Cache submenu constants }

  CMisc_SaveCache= 1; CMisc_ClearCache  = 2;

  { Misc | Sort options submenu constants }

  CSortMode_Default = 1; CSortMode_Current = 2; CSortMode_Export = 3;

  { Misc | Save options submenu constants }

  CMiscSave_Prefs   = 1; CMiscSave_Regs = 2; CMiscSave_Sort = 3;
  CMiscSave_Formats = 4; CMiscSave_Exit = 5; CMiscSave_All  = 6;
  CMiscSave_Windows = 7;

  { Entry Edit | Edit submenu constants }

  CEntEd_MoveFld = 1; CEntEd_CopyFld  = 2; CEntEd_EraseFld = 3;
  CEntEd_AddFld  = 4; CEntEd_RemFld   = 5; CEntEd_CutEnt   = 6;
  CEntEd_CopyEnt = 7; CEntEd_PasteEnt = 8; CEntEd_ClearEnt = 9;

  { EntryEdit | View submenu constants }

  CEntEdView_All = 1; CEntEdView_Braces = 2;

  { Entry Edit | Quit submenu constants }

  CEdQuit_Skip = 51; CEdQuit_Term = 52; CEdQuit_Abort = 53;

  { Pattern edit | Add submenu constants }

  CPattAdd_name = 1; CPattAdd_Type = 2; CPattAdd_Tagged = 3;
  CPattAdd_All  = 4; CPattAdd_Same = 5; CPattAdd_Other  = 6;
  CPattAdd_User = 7;

  { Pattern edit | File submenu constants }

  CPattFile_Load = 1; CPattFile_Save = 2;

  { File format constants }
  
  BibTeXFormat     = 1; CommaDelimited   = 2; TibFormat = 3; ReferFormat = 4;
  LastImportFormat = 4; FirstUserFormat  = LastImportFormat+1;
  MaxUserFormats   = 8; LastExportFormat = LastImportFormat+MaxUserFormats;

  ExpHyper_Ignore = 0; ExpHyper_Resolve = 1; ExpHyper_HTML = 2;

  { Allowed values for CheckDuplicate }

  AllowDuplicate = 0; DuplicateCaseOn = 1; DuplicateCaseOff = 2;
  DuplicateCaseWarn = 3;
  
type

{$IFDEF WINDOWS}
  { TP 6 compatibility }
  SearchRec = TSearchRec;
  Registers = TRegisters;
  DateTime  = TDateTime;
  TextRec   = TTextRec;

  ItemStringType = string[MaxMenuItemWidth];
{$ELSE}
  PChar = ^Char;
  PWord = ^Word;
  PLongint = ^longint;
{$ENDIF}
  PBoolean = ^Boolean;
  BigType = array[1..MaxMaxBig+1] of char;
  BigTypePtr = ^BigType;
  FieldStr = string[MaxFieldStrLen];
  EntryRec = record
    nentry: Word;
    LastField: byte;
    index,BigIndex: array[0..Maxfield+1] of byte;
    Blen   : array[1..Maxfield] of Word;
    BigFree: array[1..Maxfield] of boolean;
    {----}
    name,EntryType  : string;
    field  : array[1..Maxfield] of fieldstr;
    content: array[1..Maxfield] of string;
    EntryNum,RealNum: word;
    beginning,ending: longint;
    Big: array[1..Maxfield] of BigTypePtr;
{$IFDEF WINDOWS}
    BinList: PBinList;
{$ENDIF}
  end;
  EntryRecPtr = ^EntryRec;
  { Just what is saved in the clipboard as one block }
  SaveEntryRec = record
    nentry: Word;
    LastField: byte;
    index,BigIndex: array[0..Maxfield+1] of byte;
    Blen   : array[1..Maxfield] of Word;
    BigFree: array[1..Maxfield] of boolean;
{$IFNDEF WINDOWS}
    name,EntryType: string;
    field  : array[1..Maxfield] of fieldstr;
    content: array[1..Maxfield] of string;
{$ENDIF}
  end;
  PattFieldStr = string[MaxField+3];
  PatRec = record
    noper,npatt : byte;
    on : boolean;
    operation : array[1..MaxPattOper] of ShortInt;
    flag      : array[1..MaxPattOper] of byte;
    field     : array[1..MaxPattCrit] of PattFieldStr;
    patrn     : array[1..MaxPattCrit] of string;
  end;
  PatRecPtr = ^PatRec;
  TagType = array[0..((MaxTags div 16)-1)] of Word;
  BibFilesType = record
    name,marked: string;
    entrynum,realnum,EntryStart,RealStart: Word;
    PatOn,RO,Ex: boolean;
    PatNum,Place,Time: LongInt;
  end;
  BibFilesArrayType = array[1..MaxBibFiles] of BibFilesType;
  FileBuffer = array[1..MaxFileBufSize] of Char;
  ListArrRec = string[ListArrRecLen];
  ListArr = array[0..MaxListArr+1] of ListArrRec;
  ListArrPtr = ^ListArr;
  ListArrRec2 = string[ListArrRec2Len];
  ListArr2 = array[0..MaxListArr+1] of ListArrRec2;
  ListArrPtr2 = ^ListArr2;
  SpecArr = array[1..maxfield+2] of Word;
  FieldArr = array[0..maxfield+1] of boolean;
  PFieldArr = ^FieldArr;
  ShownRec = record
    x1,x2,y1,y2 : array[1..50] of longint;
    who: array[1..50] of ShortInt;
    nshown: byte;
  end;
  ShowFormatType = record
    len: integer;
    p: BigTypePtr;
  end;
  ShowFormatPtr = ^ShowFormatType;
{  AltFieldStrType = array[1..MaxField+1] of PString;}
  RequiredType = array[1..maxfield+1,0..maxfield+1] of ShortInt;
  EditFieldsType = array[1..maxfield+1] of string[maxfield+1];
  FlistMenuType = array[1..MaxMenu,0..maxfield+1] of byte;
  ErrorFormatType = (Init, config, normal);
  StringSortType = (StrSortOff,StrSortAscend,StrSortDescend);
  AddSort2NewType = (AddToNoNew,AddToAllNew,AddToSortedNew);
  SortKeyType = string;
  ConfigSortType = record
    SortKey: array[1..NSortKeys,boolean] of SortKeyType;
    SortPatternFile: string;
    NameAsc: array[boolean] of boolean;
    KeyAsc,NullKeyFirst: array[1..NSortKeys,boolean] of boolean;
    PattFirst,UsePatternFile,SortPatternExists: boolean;
    MixedCollation,SortingOn: boolean;
    SortTypeOrder: string[NSortCriteria];
    StringNameSort: StringSortType;
  end;
  ConfigSortPtr = ^ConfigSortType;
  SortRecType = record
    place,size: longint;
    Patt: boolean;
    Ereal: Word;
    name: string;
    Keys: array[1..NSortKeys] of string;
  end;
  SortRecPtr = ^SortRecType;
  DetectNumericType = (NeverDetect, AlwaysDetect, NumericOnly);
  TibMacrosType     = (NotImpOrExp,ImpOnly,ExpOnly,ImpAndExp);
  LabelModeType     = (OffLabelMode,VerifyLabelMode,AutoLabelMode);
  VerificationType  = (VerifyOff,VerifyLabel,VerifyEntry);
  KeepModeType      = (DontKeep, KeepInMemory, KeepInStream);
  KeepStackRec = record
    Mode: KeepModeType;
    P: Pointer;
    Klen: Word;
    VFilePos: LongInt;
  end;
  KeepStackArr = array[1..MaxBuffStack] of KeepStackRec;
  PathListPtr = ^PathListRec;
  PathListRec = record
    Next,Back: PathListPtr;
    P: PString;
  end;
  ConfigEnvFoundType = record
    Parameters, Memory, PcConfig, Sort, Mouse, VideoModes, BibTeX,
    CommaDelimited, Tib, Refer, ExportFormat, Colors, ShortWords, Fields,
    ExportFields, PatternFields, EntryTypes, Registers, ShowFormat,
    Windows, DESQview: boolean;
  end;
  OptionsModifiedType = record
    Preferences,Sort,Registers,Formats
{$IFDEF WINDOWS}
    ,WindowsParams,Fields,PattHeirarchies
{$ENDIF}
    : boolean;
  end;
  DumpFileListType = array[1..LastExportFormat] of string;
  MenuStringType = array[1..MaxMenu] of Pstring;
{$IFDEF WINDOWS}
  InitialSizeRec = record
    X,Y,W,H: integer;
  end;
  InitialSizePtr = ^InitialSizeRec;
  FontTypesType = record
    Color: LongInt;
    LogFont: TLogFont;
    Font: HFont;
    Height,Ascent,Descent,PointSize: integer;
    Initialized,Default: boolean;
  end;
  FontTypesArray = array[FirstFontIndex..LastFontIndex] of FontTypesType;
  CustColorType = array [0..15] of Longint;
  ENameClickRec = record
    S: PString;
    action: integer;
  end;
  HyperTypeRec = record
    pre,app,TeXMacro: PString;
    Flags,Htype: integer;
  end;
  HyperTypePtr = ^HyperTypeRec;
  HyperTypesArrType = array[1..MaxHyperTypes] of HyperTypeRec;
  HyperTypesArrPtr  = ^HyperTypesArrType;
  HyperlinkFlagsRec = record
    html,latex,on: boolean;
  end;
  WWWBrowserType = record
    Name,Path,DDEService,RegKey: PChar;
    LoadURLString,LoadFileString: PString;
    Active,SendsURLReturn: boolean;
  end;
{$ENDIF}
  MixedSortOrderType = array[0..255] of byte;
  PrintColorStrArr = array[FirstUserFormat..LastExportFormat,1..17,1..2] of Pstring;
  FieldParamsRec = record
    AltName: PString;
    Capitalize,Authorlike,Numeric,ProtectCase,ProtectCap: boolean;
  end;
  FieldParamsPtr = ^FieldParamsRec;
  FieldParamsArr = array[1..MaxField+1] of FieldParamsRec;

const
  CEnd = -1;

{$IFNDEF WINDOWS}  
type
  ChecksumType = record
    BibCRC,BibSize,OvrCRC,OvrSize: longint;
  end;
  
const
  Correct: ChecksumType = (BibCRC:        0;
                           BibSize:       0;
                           OvrCRC:        0;
                           OvrSize:       0);
{$ENDIF}

var

  { Colors }
{$IFNDEF WINDOWS}  
  EntryNorm,EntryBright,EntryRev,EditBorder: Byte;
  EditNorm,EditRev,EditBright: Byte;
  ListNorm,ListRev,ListBright: Byte;
  DialogNorm,DialogBright,DialogRev: Byte;
  PatternNorm,PatternBorder,CScrBarPatt: Byte;
  CScrBarEntry,CScrBarEdit,CScrBarEdField,CScrBarFinsert: Byte;
  SpecialColors: array[1..16] of byte;
{$ENDIF}

  { Buffers }

  bibbuf: ^FileBuffer;
  MemoryPos: byte;
  MemoryMode: KeepModeType;
  BuffStackInd: byte;
  ClipBoardEmpty,UseVirtualMemory,ForceKeepInStream: Boolean;
  ClipboardName,ClipboardType: PString;
  KeepStack: ^KeepStackArr;
{$IFNDEF WINDOWS}
  ClipboardMode: KeepModeType;
  ClipboardPosition: byte;
{$ELSE}
  CFBibDB: word;
{$ENDIF}
  ClipboardString: Boolean;
  AuxBufSize: Word;          { Various temporary file buffer size }
  
  { Options and flags }
  
  BibReadOnly, UseAutoCap, SwapOn, StickyList: boolean;
  ExecSwap, RetainNullFields, SaveOptsOnExit: Boolean;
  ReportMemory, AllowShell, UseWindowsClipboard: Boolean;
  AlwaysRead, IndexVerbatim, ConfirmESCQuit: boolean;
  linked, debug, XmsExists, EmsExists, HardwareCur: Boolean;
  EolDisplay, TildeToSpace, EditOnlyStrings, LeaveConfirm: Boolean;
  EscapeBraces,ForbidEditing,FastRead,WrapEOF2BOF: Boolean;
  StringsBeforeEntries,IncludePreambles,StripExtraBraces: boolean;
  AutoBuildIndex,TagNewEntries: boolean;
  DelimitBrace: array[boolean] of boolean;
  FieldParams: ^FieldParamsArr;
  {
  CapField,Numeric,AuthorLike,ProtectCase,ProtectCap: array[1..maxfield+1] of Boolean;
  AltFieldStr: ^AltFieldStrType;
  }
  SwapMode, Noverview: Integer;
  Verbosity, CheckDuplicate: Byte;
  OverView: array[1..MaxOverView] of PString;
  EolString: array[1..MaxEolStrings] of Pstring;
  NEolStrings: integer;
  DetectNumeric: DetectNumericType;
  DosArgString: Pstring;
  ConfigEnvFound: ConfigEnvFoundType;
  OptionsModified: OptionsModifiedType;
  StringTypeInd,PreambleTypeInd: integer;
{$IFDEF WINDOWS}
  SaveWinOptsOnExit: boolean;
{$ENDIF}

  { Search }
  
  DefSearchScope,SearchString,LabelSearchString: Pstring;
  LabelSticky, LabelCase ,LabelRegexp : boolean;
  SearchSticky,SearchCase,SearchRegexp: boolean;

  { File format specific }

  TibLabels,ReferLabels: string[MaxFieldStrLen];
  TibMacros: TibMacrosType;
  BoldfaceOn, BoldfaceOff: array[FirstUserFormat..LastExportFormat] of Pstring;
  PrintColorStr:   ^PrintColorStrArr;
  EndLineString:   array[FirstUserFormat..LastExportFormat] of Pstring;
  UserFormatName:  array[FirstUserFormat..LastExportFormat] of PString;
  UserFormatChars: string[MaxUserFormats];
  NumUserFormats,LastFileFormat: byte;
  CommaSeparator: char;
  DefExtension: array[1..LastExportFormat] of Pstring;
  Verify:       array[1..LastImportFormat] of VerificationType;
  DumpFileList: ^DumpFileListType;
  DumpLabelsOnly: boolean;
  LineWidth:      array[1..LastExportFormat] of longint;
  ExpHyperFormat: array[FirstUserFormat..LastExportFormat] of integer;
  FormatModes:    array[1..LastExportFormat] of PString;

  { Entry stuff }
  
{$IFDEF WINDOWS}
  Entry: EntryRecPtr;
{$ENDIF}
  NumberOfTypes: integer;
  required: ^RequiredType;
  FieldLast,DefFieldLast,OrigFieldLast,IniFieldLast: integer;
  LastReadLine: Pstring;
  MaxBig: Word;
  MaxNumberBig: integer;
  Tags: TagType;
  LastRealNum: longint;

  { Files }
  
  bib: text;
  BibName,DumpName: PString;
  FileBufSize,NumberOfEntries: Word;
{$IFNDEF WINDOWS}
  SwapDir: string;
  HelpFileExtension: PString;
{$ENDIF}
  BibFiles: ^BibFilesArrayType;
  BibRing: array[1..MaxBibFiles] of byte;
  BibInRing,BibRingNum: Byte;
  CurrentBibFile: Integer;
  TexAuxFile,IndexFileName,PreambleName: Pstring;
  ProgramFile, ConfigFile: Pstring;
  DumpFirstTime,DumpFileExists,DumpToPrinter,BibFileExists: Boolean;
  DisableIndexFile,AtStartOfFile,ConfigFileBacked,UsePreamble: boolean;
  UnixBib,UnixDump,UseIndexFile,CopyFromIndexFile,VerifyIndexFile: boolean;
  ImportFormat,ExportFormat: byte;
  BackupExtension,IndexExtension: PString;
  ConfigBackExtension: PString;
  TexInputList: PathListPtr;
{$IFDEF WINDOWS}
  BstInputList: PathListPtr;
{$ENDIF}
{  IndexRec: SortRecType;}
  EndOfIndexHeader: longint;
  MaxFileHandles: word;
  
  { Pattern }
  
  PatternNumber: LongInt;
  
  { Sorting }
  
  AddSort2New: AddSort2NewType;
  SortNewFiles,SortedByDefault: boolean;
{  MixedSortOrder: array[0..255] of byte;}
  MixedSortOrder: ^MixedSortOrderType;
  ConfigSortMode,CurrentSortMode,ExportSortMode: ConfigSortPtr;
  SortPattModeDef,SortPattModeCur,SortPattModeExp: KeepModeType;
  SortPattPosDef,SortPattPosCur,SortPattPosExp: Byte;

  Dmenustr,PmenuStr: MenuStringType;
  PmenuChoice, DmenuChoice: FlistMenuType;
  DMenuChars,PMenuChars: string[40];
  DMenuNum,PMenuNum: byte;

{$IFNDEF WINDOWS}
  { Menus and menu hooks}
  
  EntryEditMenu, EntryModifyMenu, StringEditMenu, StringModifyMenu: TopMenuType;
  MainMenu, PattEditMenu : TopMenuType;
  ImpMenu, GotoMenu, ImpSortedMenu, UsedFieldsMenu: MouseMenuRecPtr;
  DmenuWidth, PmenuWidth: Byte;
  GotoChars: string[MaxMenu];
  MenuOfCurrentFiles,MenuOfCurrentFiles2: array[1..MaxBibFiles] of ^ItemStringType;
  ImpFormatCheck: array[1..LastImportFormat] of ^char;
  ExpFormatCheck: array[1..LastExportFormat] of ^char;
  PrinterTypeCheck: array[1..MaxUserFormats] of ^char;
  ViewAllCheck,StringsCheck,SaveOnExitCheck: ^char;
  EdEnViewAllCheck,EdEnStripBracesCheck,TagNewCheck: ^char;
  ChooseExpPosition: array[1..LastExportFormat] of ^boolean;
  AddMenuOn,EdMoveFieldOn,EdCopyFieldOn: ^boolean;
  ImpSubMenu: ^MouseMenuRecPtr;

{$ENDIF}

  { 8-bit stuff }
  
{$IFNDEF WINDOWS}
  TagChar: char;       { Check mark in code page 437, "*" in others }
  MenuCheckChar: char; { Check mark in code page 437, "X" in others }
{$ENDIF}

  { Globals }
  
  DebugLevel,BreakupLength: integer;
  ShowFormat: array[boolean] of ShowFormatType;
  BookMark: Pstring;
  TypeField, TypeEntry: ListArrPtr;
  shown: ShownRec;
  ErrorFormat: ErrorFormatType;
  FirstShowBuf: boolean;
  DumpFields: FieldArr;
  DumpUndecFields: boolean;
  EditFields,DefEditFields: ^EditFieldsType;
  LabelTemplate: Pstring;
  DefNullLabels: Pstring;
  LabelMode: LabelModeType;
  Articles: array[1..MaxArticles] of Pstring;
  Narticles: integer;
  ProgramDir: Pstring;
  BinaryFields: PString;
{$IFDEF WINDOWS}
  ProgramDate, ProgramTime: PChar;
  Pattern: PatRecPtr;
{$ELSE}
  StartupDir,EditLoadFile: string;
  ProgramDate, ProgramTime: Pstring;
{$ENDIF}
  MacroCommand,failure,EntryModified: boolean;
  InputStr,CommandStr,OutputStr: PString;
  BeginOfShowFormat: longint;
  EnglishInterface: boolean;
                              { Mainly GUI stuff }
{$IFDEF WINDOWS}

  { Section names in the .INI file }
  GeneralSec,ColorsSec,FontsSec,PositionsSec,HyperlinkSec: PChar;
  NameClickSec,PrintingSec,AbbrevSec,ToolbarSec,ObjectsSec,ImagesSec: PChar;
  HeirarchySec: PChar;
  PattHeirNameN: PChar;

{ Classes }
  BibDBMainWinClass, BibDBEdPattClass,    BibDBEdWinClass  : PChar;
  BibDBToolbarClass, BiBDBStatusBoxClass, BibDBHelpBarClass: PChar;
  BibDBDispArea,     BibDBDispAreaDblClk, BibDBENameCPass  : PChar;
  BibDBENameNoCPass, BibDBTestObjClass,   BibDBEditWindowClass: PChar;

{ Window size & position }
  MainWinSize,EdEnSize,EdFieldSize,EntryListSize: InitialSizeRec;
  FindFileSize,PattFieldSize, DispDupsSize: InitialSizeRec;
  OverviewSize,PattEditSize,BrowseFilesSize: InitialSizeRec;
  WhichFieldsSize,OneFieldSize,InsertAbbrevSize: InitialSizeRec;
  EdStringsSize,EdAbbrevsSize,ViewAbbrevsSize: InitialSizeRec;
  EdShowFormSize: InitialSizeRec;

{ Cursors }
  FingerCursor,ArrowCursor,CrossCursor,HyperCursor: HCursor;
  HourglassCursor,WaitingCursor,CoffeeCupCursor,GuitarCursor: HCursor;

{ Colors }
  CustColors: ^CustColorType;
  TagColor,FilenameColor,DupEntriesColor,ENameBackColor: Longint;
  ENameBackBrush: HBrush;

{ Misc }
  MainW,CurrentWindow,EdShowFormat,EdEnWindow: PWindow;
  HMainW,FindRepWnd: Hwnd;
  UsingSortedMenu,UseCoffeeCup,UseToolbar: boolean;
  UseCtl3D,DdeIsActive,EnhancedMode,FirstInstance,DdeEnabled: boolean;
  DisplayBibTeXHelp,Win95,Win95_3d: boolean;
  SysFontHeight,SysFontWidth,PattIndLen: Word;
  Fonts: ^FontTypesArray;
  IniFile,HelpFile,BibTeXHelpFile,PattHeirFile,MenuSizeString: PChar;
  EListColWidthStr: PString;
  MainIcon: Hicon;
  NameClickCtrl,NameClickShift,NameClickCtrlShift: ENameClickRec;
  NameClickMenuString: PString;
  SystemMenu_SystemID: word;
  BibTeXHelpMode: integer;
  TopMargin,BottomMargin,LeftMargin,RightMargin: integer;
  PrintToFile,PrintEntryHeader,PrintPageHeader: boolean;
  EntrySeparation: integer;
  StartupMinimized,StartupMaximized,MainWinActive,MainMenuActive: boolean;
  PrintingFields: PFieldArr;
  PrintUndecFields: boolean;
  HPDevMode,HPDevNames: THandle;
  AmWaiting,SuspendedWaiting: boolean;
  WinYieldCounter,WinYieldStep: integer; { Background processing }
  SearchFieldStr: String[MaxField+10];
  UseSearchFields: boolean;
  InstNumber: longint;

  { DDE }
  ServiceName: PChar;

  { Hyperlinks }
  HyperlinkFlags: HyperlinkFlagsRec;
  HyperTypesArr: HyperTypesArrPtr;
  NHyperTypes,MaxHyperTypeLen: integer;
  { WWW }
  WWWBrowserList,WWWUploadDir: PChar;
  WWWBrowser: WWWBrowserType;
  RetrievingURLDlg: PWindowsObject;
  WWWBeginProgressOn: boolean;
  { Email }
  UseMAPI: boolean;
  { OLE }
  ObjectTeXMacro: PString;
  ResolveObjects: boolean;
  StdObjectIcon: HIcon;
  { Images }
  ImageTeXMacro,HTMLImages: PString;
  UseGraphicsFilters,IconizeImages: boolean;
{$ELSE}
  COMSPEC: string;
  CurrentMode,Currentlen,NVidModes: byte;
  VmodeList: array[1..MaxVidModes] of byte;
  WideScreenMouse: boolean;
{$ENDIF}
  SearchStrNegate: boolean;
  StartupTime: TDateTime;



implementation

var
  i: word;

begin
  EnglishInterface:=true;
  BreakupLength:=1000;
  bibbuf:=Nil;
  TypeField:=Nil; TypeEntry:=Nil;
  TexInputList:=Nil; BinaryFields:=Nil;
  ShowFormat[true].p:=Nil; ShowFormat[false].p:=Nil;
  ShowFormat[true].len:=0; ShowFormat[false].len:=0;

  New(BibName); New(DumpName);
  New(SearchString); New(LabelSearchString);
  New(DefSearchScope);
  New(Required);
  New(ProgramDir); ProgramDir^:='';
  New(ClipboardName); New(ClipboardType);
  New(Bookmark); New(LabelTemplate);
  New(MixedSortOrder);
  New(LastReadLine);
  New(KeepStack);
  New(PrintColorStr);

{  New(AltFieldStr);}
  New(FieldParams);
  for i:=1 to MaxField+1 do FieldParams^[i].AltName:=Nil;

  LFNNew(bib,true);   { Init the Bib file variable as an LFN-able text file }

  for i:=1 to LastExportFormat do DefExtension[i]:=Nil;
  BackupExtension:=Nil; IndexExtension:=Nil; ConfigBackExtension:=Nil;

  for i:=1 to 255 do SearchString^[i]:=Chr(i); SearchString^[0]:=#255;
  SearchString^:=Copy(SearchString^,1,Ord('A'));
  for i:=Ord('a') to Ord('z') do
    SearchString^:=SearchString^ + chr(i)+chr(i-Ord('a')+Ord('A'));
  SearchString^:=SearchString^+'[\]^_`' +
{      'AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz[\]^_`' +}
      Copy(SearchString^,Ord('z')+1,255-Ord('z'));
  for i:=1 to 255 do MixedSortOrder^[i]:=Pos(Chr(i),SearchString^);
  MixedSortOrder^[0]:=0;
{$IFDEF WINDOWS}
  BstInputList:=Nil;
  MenuSizeString:=Nil;
{$ELSE}
  StartupDir:='';
  for i:=1 to MaxBibFiles do
  begin
    MenuOfCurrentFiles[i]:=Nil;
  end;
  ClipboardPosition:=0;
{$ENDIF}
  LFNFSplit(LFNLongName(LFNFExpand(ParamStr(0))),ProgramDir,Nil,Nil);
  if ProgramDir^[length(ProgramDir^)]<>'\' then ProgramDir^:=ProgramDir^+'\';
  for i:=1 to length(ProgramDir^) do
    if ProgramDir^[i] in ['A'..'Z'] then
      ProgramDir^[i]:=Chr(Ord(ProgramDir^[i])-Ord('A')+Ord('a'));

  SearchString^:=''; LabelSearchString^:='';  DefSearchScope^:='';
  ClipboardName^:=''; ClipboardType^:='';
  for i:=1 to MaxArticles do Articles[i]:=Nil;
                              { Buffer stack }
  MemoryMode:=DontKeep; MemoryPos:=0;
  SortPattPosDef:=0; SortPattPosCur:=0; SortPattPosExp:=0;
  SortPattModeDef:=DontKeep; SortPattModeCur:=DontKeep; SortPattModeExp:=DontKeep;
  BuffStackInd:=0;
  for i:=1 to MaxBuffStack do
  with KeepStack^[i] do
  begin
    P:=Nil; Klen:=0; VFilePos:=-1;
  end;
  New(DumpFileList); FillChar(DumpFileList^,sizeof(DumpFileListType),0);
  New(BibFiles);
  ProgramFile:=Nil; ConfigFile:=Nil;
  New(TexAuxFile); New(IndexFileName); New(PreambleName);
  New(DefNullLabels);
  New(ConfigSortMode); New(CurrentSortMode); New(ExportSortMode);
  ProgramDate:=Nil; ProgramTime:=Nil;
  MacroCommand:=false; Failure:=false;
  InputStr:=Nil; OutputStr:=Nil; CommandStr:=Nil;
  New(EditFields); New(DefEditFields);
  StringsBeforeEntries:=true;
  SearchStrNegate:=false;
  LastRealNum:=0;
{$IFDEF WINDOWS}
  EnhancedMode:=(GetWinFlags and wf_Enhanced)>0;
  Entry:=Nil; Pattern:=Nil;
  CustColors:=Nil;
  MainW:=Nil; HMainW:=0;
  New(EListColWidthStr);
  New(InputStr); New(OutputStr); New(CommandStr);
  CurrentWindow:=Nil;
  FirstInstance:=false;
  DdeEnabled:=false;
  DdeIsActive:=false;
  NameClickCtrl.S:=Nil; NameClickShift.S:=Nil;
  NameClickCtrlShift.S:=Nil;
  NameClickMenuString:=Nil;
  BibTeXHelpFile:=Nil;
  SystemMenu_SystemID:=0;
  GetMem(PrintingFields,MaxField+10);
  i:=LoWord(GetVersion);
  Win95:=(LoByte(i)>=4) or ((LoByte(i)=3) and (HiByte(i)>=90));
  MainWinActive:=false; MainMenuActive:=false;
  WinYieldCounter:=0; WinYieldStep:=1;
  SearchFieldStr:=''; UseSearchFields:=false;
  { Hyperlinks }
  New(HyperTypesArr); NHyperTypes:=0; MaxHyperTypeLen:=0;
  for i:=1 to MaxHyperTypes do
  with HyperTypesArr^[i] do
  begin
    pre:=Nil; app:=Nil; TeXMacro:=Nil; Htype:=0;
  end;
  ObjectTeXMacro:=Nil;
  ImageTeXMacro:=Nil; HTMLImages:=Nil;
  RetrievingURLDlg:=Nil;
  WWWBeginProgressOn:=false;
  ServiceName:=Nil;
  InstNumber:=0;
  EdShowFormat:=Nil;
  FindRepWnd:=0;
  EdEnWindow:=Nil;
  ENameBackBrush:=0;
  StdObjectIcon:=0;
{$ENDIF}
  with StartupTime do
  begin
    GetDate(Year,Month,Day,I);
    GetTime(Hour,Min,Sec,I);
  end;
end.
