$ !!! ======================================================================
$ !!!  @VAX-VMS-shell{
$ !!!     filename        = "pphlp.com",
$ !!!     version         = "1.0",
$ !!!     date            = "19 July 1992",
$ !!!     time            = "14:05:50.47 ",
$ !!!     author          = "Norman Gray",
$ !!!     address         = "Department of Physics
$ !!!                        Open University
$ !!!                        Milton Keynes
$ !!!                        MK7 6AA, UK",
$ !!!     e-mail          = "N.O.Gray@open.ac.uk (Internet)",
$ !!!     telephone       = "+44 908 652279",
$ !!!     FAX             = "+44 908 653744",
$ !!!     archived        = "Aston, SHSU",
$ !!!     keywords        = "hlp-files, VMS, help",
$ !!!     abstract        = "This file is part of the PPHLP package, which
$ !!!                        allows both printed manuals and VMS help library
$ !!!                        modules to be prepared from a single file.",
$ !!!     codetable       = "ISO/Ascii",
$ !!!     checksum        = "22288 163 899 6257",
$ !!!     docstring       = "This is the DCL com-file which drives the PPhlp
$ !!!                        package.  It does so by parsing the command line
$ !!!                        and the input file specifications, and preparing a
$ !!!                        file pphlpdefs.tex, which is read in during the
$ !!!                        next stage, when this file LaTeX's the principal 
$ !!!                        file, pphlp.tex.  It finally renames the files
$ !!!                        pphlp.dvi and pphlp.lis to match the name of the
$ !!!                        original .hlp file.
$ !!!                        
$ !!!                        The checksum field above contains a CRC-16
$ !!!                        checksum as the first value, followed by the
$ !!!                        equivalent of the standard UNIX wc (word 
$ !!!                        count) utility output of lines, words, and
$ !!!                        characters.  This is produced by Robert 
$ !!!                        Solovay's checksum utility."
$ !!! }
$ !!! ======================================================================
$!+ This procedure will prettyprint an |.hlp| file by \LaTeX ing the file
$!  |pphlp.tex|.
$!
$!  The only parameter is the name of the file to be set---the routine first
$!  searches for a file with extension |.help|, then for |.hlp|.
$!
$!  Information is passed to |pphlp.tex| via the file |pphlpdefs.tex|, which
$!  supplies the documentstyle, and has the following definitions:
$!
$!  \medskip
$!  \begin{tabular}{lp{4in}}
$!  |\pphlpstyleoptions & The style options to be used.\\
$!  |\pphlpname|    & The full file name, including version number.\\
$!  |\pphlphead|    & The bare file name, without directory and extension. \\
$!  |\pphlpextra|   & Any extra information which might be of use.  This isn't
$!		    currently used. \\
$!  |\pphlppreamble|& Commands to go in the preamble.
$!  \end{tabular}
$!
$!  When this com file is invoked, extra documentstyle options may be provided
$!  by prefixing them on the command line with a hyphen, so that
$!  \begin{center}\tt
$!  pphlp -acsfigs,twocolumn helpfile
$!  \end{center}
$!  would set the file |helpfile.hlp| with the |[twoside,acsfigs,twocolumn]|
$!  options.
$!
$!  Also, commands may be inserted into the preamble, by prefixing them with a
$!  plus sign, so that
$!  \begin{center}\tt
$!  pphlp +\makeindex helpfile
$!  \end{center}
$!  would insert the |\makeindex| command into the preamble.
$!
$!  Finally, extra qualifiers may be added to the LaTeX command.
$!  \medskip
$!\-
$
$   source_dir := phut:[util.local.pphlp]
$
$   param = 0
$!   docopts = "twoside"
$   docopts = ""
$   preamble = ""
$   quals = ""
$   fname_p = ""
$   parse_loop:
$	param = param + 1
$	if p'param .eqs. "" then goto finished_parse
$	ch1 = f$extract (0,1,p'param)
$	if ch1 .eqs. "-"
$	then
$	    if docopts .eqs. ""
$	    then
$		docopts = f$edit (f$extract (1,99,p'param), "lowercase")
$	    else
$		docopts = docopts + "," + -
		    f$edit (f$extract (1,99,p'param), "lowercase")
$	    endif
$	else
$	if ch1 .eqs. "+"
$	then
$	    preamble = preamble + -
		    f$edit (f$extract (1,99,p'param), "lowercase") + " "
$	else
$	if ch1 .eqs. "/"
$	then
$	    quals = quals + p'param
$	else
$	    fname_p = p'param
$	endif
$	endif
$	endif
$	goto parse_loop
$
$   finished_parse:
$
$   if fname_p .eqs. "" then inquire fname_p "Which file? "
$
$   fname = f$search (f$parse (fname_p,".help")) ! check it exists, and fill in version number
$   if fname .eqs. ""
$   then
$	fname = f$search (f$parse (fname_p,".hlp"))
$	if fname .eqs. ""
$	then
$	    write sys$output f$fao ("File !AS not found.", -
		f$parse (fname_p,".hlp",,,"syntax_only"))  ! doesn't check dir'y exists
$	    exit
$	endif
$   endif
$
$   outfilename = f$parse (fname,,,"name")      ! just filename
$
$
$   open/write argfile pphlpdefs.tex
$   write argfile "{\catcode`\$=11 \catcode`\_=11"   ! so we can read in ...
$   if docopts .nes. "" then -
	write argfile f$fao ("\gdef\pphlpstyleoptions{!AS}", docopts)
$   write argfile f$fao ("\gdef\pphlpname{!AS}", -
        f$edit (fname, "lowercase"))                ! full file name
$   write argfile f$fao ("\gdef\pphlphead{!AS}", -
	f$edit (outfilename, "lowercase"))	    ! file name
$   write argfile f$fao ("\gdef\pphlpextra{last revised !AS}", -
        f$file(fname,"cdt"))    ! file creation date
$   if preamble .nes. "" then -
	write argfile f$fao ("\gdef\pphlppreamble{!AS}", preamble)
$   write argfile "}"
$   close argfile
$
$   define/user sys$input sys$command
$   on error then continue
$   latex 'source_dir'pphlp 'quals' ! which reads in |prettydefs.tex|
$   rename/nolog pphlp.dvi,.lis 'outfilename
$   delete/noconfirm/nolog pphlpdefs.tex;*
$!  +Only the |.dvi| and |.lis| files are renamed---the |.aux| is left as it
$!  is.  If there are cross-references within the prettyprinted file, then the
$!  |.aux| file containing them must be called |pphlp.aux| if \LaTeX\ is to
$!  find it. \-
$
$   write sys$output ""
$   write sys$output "Output written on ",f$parse(outfilename,".DVI")
$   write sys$output "Transcript written on ",f$parse(outfilename,".LIS")
$   write sys$output ""
$
$   EXIT
