# graphicx.perl  by Ross Moore  <ross@mpce.mq.edu.au>  98/1/7
# same as ...
#
# graphics.perl by Herbert Swan <dprhws.edp.Arco.com>  12-22-95
#
# Extension to LaTeX2HTML V 96.1 to supply support for the "graphics"
# and "graphicx" standard LaTeX2e packages.
#
# extended and revised for LaTeX2HTML V 98.1 
# by Ross Moore <ross@mpce.mq.edu.au>  98/1/7
#
# Change Log:
# ===========
#  - Extended \includegraphics to simply include an existing pixel image file
#    provided one of the appropriate type (jpeg,gif,png) already exists,
#    rather than always punt to latex to create an image;
#    optionally, copies the image into the HTML directory.
#    Also, minor tweaks to \graphicspath.
#
#    Question: Should some options to \includegraphics (eg. rotate, clip...) 
#    disable the reuse of the pixel image, or is it a valid assumption that
#    such an image file will already be appropriately formatted?  Or, does
#    there need to be some option to control it.  
#    Also, there's no mechanism (yet) to put a meaningful alt attribute.
#    Bruce Miller <bruce.miller@nist.gov>  2001-01-23

package main;

# BRM: These are the extensions that we'll look specifically for.
$GRAPHICS_EXTENSIONS=['png','jpg','jpeg','gif'];
# BRM: Whether to copy existing graphics files into the html tree.
$COPY_GRAPHICS = 0 unless defined($COPY_GRAPHICS);
# BRM: The path to search for graphics files (extended by \graphicspath)
@GRAPHICS_PATH = () unless defined(@GRAPHICS_PATH);

# Suppress option-warning messages:

sub do_graphics_dvips {
}
sub do_graphicx_dvips {
}

# BRM: modified to remove \Q ..\E from replacement patterns.
# and to save the declared path.
sub do_cmd_graphicspath {
    local($_) = @_;
    local($paths);
    $paths = &missing_braces unless (
	(s/$next_pair_pr_rx/$paths=$2;''/e)
	||(s/$next_pair_rx/$paths=$2;''/e));
    $paths = &revert_to_raw_tex($paths);

    #RRM: may only work correctly for Unix    
    # $dd  holds the directory-delimiter, usually / 
    $paths =~ s/\s*({|})\s*/$1/g;
    local(@paths) = split (/}/, $paths);
    if ($DESTDIR eq $FILE) {
	# given paths are relative to parent directory
	map(s|^{([^/~\.\$\\][^}]*)|{..$dd$1|, @paths);
	map(s/^{\.\Q$dd\E/{\.\.\Q$dd\E/, @paths);
    } elsif ($DESTDIR eq '.') {
	# paths are already relative to working directory
    } else { 
	# specify full paths, by prepending source directory
	map(s|^{([^/~\.\$\\][^}]*)|{$orig_cwd$dd$1|, @paths);
	map(s/^{\.\Q$dd\E/{$orig_cwd\Q$dd\E/, @paths);
    }

    $paths = join('}', @paths).'}';
    map(s/^{//,@paths);		# Strip leading { and trailing $dd
    map(s/\Q$dd\E$//,@paths);
    @GRAPHICS_PATH = (@GRAPHICS_PATH,@paths);

    $latex_body .= "\n\\graphicspath{$paths}\n\n" unless ($PREAMBLE);
    $_
}

sub do_cmd_DeclareGraphicsRule {
    local($_) = @_;
    local($arg1,$arg2,$arg3,$arg4);
    $arg1 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg1=$&;''/e)
	||(s/$next_pair_rx/$arg1=$&;''/e));
    $arg2 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg2=$&;''/e)
	||(s/$next_pair_rx/$arg2=$&;''/e));
    $arg3 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg3=$&;''/e)
	||(s/$next_pair_rx/$arg3=$&;''/e));
    $arg4 = &missing_braces unless (
	(s/$next_pair_pr_rx/$arg4=$&;''/e)
	||(s/$next_pair_rx/$arg4=$&;''/e));

    # need a full path to the filename
    $arg4 =~ s/(\#1)/$orig_cwd$dd$1/g
	unless ($arg4 =~ /^\Q$dd\E|\Q$env_key\E/);

    $latex_body .= "\n".&revert_to_raw_tex(
	'\DeclareGraphicsRule'.$arg1.$arg2.$arg3.$arg4)."\n";
    $_;
}

# Utility: Find a file in one of a set of directories, with one of a
# set of file extensions.
sub find_file {
  my($name,$dirs,$exts)=@_;

  $dirs = [@$dirs,$texfilepath]; # Include the tex source dir.
  # file name may already have an absolute or partial path
  my @comps=split(/\Q$dd\E/,$name);
  $name=$comps[$#comps];
  if($comps[0] eq ''){		# Started w/$dd => absolute path (too unixy!?!)
    $dirs = [join($dd,@comps[0..$#comps-1])]; }
  elsif(@comps > 0){		# else prepend path components, if any
    my $pre=join($dd,@comps[0..$#comps-1]);
    $dirs = [map("$_$dd$pre",@$dirs)]; }

  # file name may already have an extension. If so, we're stuck with it (?)
  if($name =~ /^(.*)\.([^\.]*)$/){
    return '' unless grep($2 eq $_, @$exts);
    $name = $1; $exts = [$2]; }

  # Now start searching.
  my($dir,$ext);
  foreach $dir (@$dirs){
    foreach $ext (@$exts){
      my $file = "$dir$dd$name.$ext";
      return $file if (-f $file); }}
  return ''; }

# Another utility: copy a file into the HTML tree.
# returns the relative path to the file.
# This is a little too unixy, but I'd like to check & preserve timestamps.
sub maybe_copy_file {
  my($src)=@_;
  my @comps=split(/\Q$dd\E/,$src);
  my $dst=".$dd".$comps[$#comps];

  # L2hos->Copy($src,$dst); # Now, copy to HTML tree
  # Use unix cp so we can preserve timestamp
  if(!(-f $dst) || (-M $dst > -M $src)){
    system("cp -p $src $dst") 
      && warn "Couldn't copy $src to HTML tree: $!\n"; }
  return $dst;
}


# ignore clipping request ?
sub do_cmd_includegraphicsstar { do_cmd_includegraphics(@_); }

sub do_cmd_includegraphics {
  local($_)=@_;
  my($parms)=get_next_optional_argument();
  local($file);
  $file = &missing_braces unless (
       (s/$next_pair_pr_rx/$file=$2;''/e)
     ||(s/$next_pair_rx/$file=$2;''/e));
  $parms = &revert_to_raw_tex($parms);
  $file = &revert_to_raw_tex($file);
  my $after = $_;

  # Should probably test $parms to see that it is appropriate to subst gif.
  my $grfile = find_file($file,[@GRAPHICS_PATH],$GRAPHICS_EXTENSIONS);
  my $image;
  if($grfile){			# Found an image file!
    $grfile = maybe_copy_file($grfile) if $COPY_GRAPHICS;
    $image = embed_image($grfile,'external image',0,"Image $grfile",
			 '','','','','',''); }
  else {			# Otherwise, put in images.tex as usual.
    $image =  process_in_latex("\\includegraphics[$parms]\{$file\}"); }
  join('',$image,$after); }


&process_commands_wrap_deferred (<<_RAW_ARG_CMDS_);
graphicspath # {}
_RAW_ARG_CMDS_

&process_commands_in_tex (<<_RAW_ARG_CMDS_);
rotatebox # [] # {} # {}
scalebox # {} # [] # {}
reflectbox # {}
resizeboxstar # {} # {} # {}
resizebox # {} # {} # {}
_RAW_ARG_CMDS_

&process_commands_nowrap_in_tex (<<_RAW_ARG_CMDS_);
DeclareGraphicsExtensions # {}
#DeclareGraphicsRule # {} # {} # {} # {}
psfragstar # {} # {}
psfrag # {} # {}
_RAW_ARG_CMDS_

&ignore_commands( <<_IGNORED_CMDS_);
setkeys # {} # {}
_IGNORED_CMDS_

1;	# Must be last line

