#######################################################################
# SGMLSPL script produced automatically by the script sgmlspl.pl
#
# Document Type: article (gellmu)
# Output Type: various forms of HTML
# Author:  William F. Hammond <hammond@math.albany.edu>
# Begun:   19980707
# With-help-from: Tim Kohl <tkohl@it.bu.edu>
# Last-revison: check the file system datestamp or the http header
#
########################################################################

$WhoAmI = "htmlgart.pl";
print STDERR $0, " *** ", $WhoAmI, "\n";

# Do this before invoking SGMLS

$utf8On = 0;
if($ENV{"GELLMU_UTF8"} == 1){
    use utf8;
    $utf8On = 1;
    print STDERR "  ***  " . $WhoAmI . ": UTF-8 Enabled\n";
};

use SGMLS;			# Use the SGMLS package.
use SGMLS::Output;		# Use stack-based output.

#
# global variables -- key strings to think about
#
# Please change the next few lines for links to suit your situation.
#   They apply to all documents passing through the processing specified
#   by this code.  You may wish to add options in this package that can
#   be used to override its defaults.

# Default StyleSheet Directory
# IMPORTANT: Many web browsers will not accept stylesheets from
#            http servers different from the one serving content
# This MUST be configured LOCALLY.

$styleDir = "../webstyle";  # Likely not what you want but should work for
         # things in "doc" and "examples" subdirs of the distribution.
         # The next line _may_ be what you want for serving through HTTP.
#  $styleDir = "/~" . $ENV{"USER"} . "/style";
#
if(exists $ENV{"GELLMU_StyleDir"}){
    $styleDir = $ENV{"GELLMU_StyleDir"};
};

# Default CSS StyleSheet Name
$cssName = "mxh.css";  # the CSS sheet found in GELLMU distributions
if( exists $ENV{"GELLMU_CSSName"} ){
    $cssName = $ENV{"GELLMU_CSSName"};
};

$cssPath = "";  #  Is  cssName  relative to  styleDir ?
                #  NOT if it is an absolute url with scheme (like http://...)
                #   or if it begins with "/" or "./" or "../".
if($cssName eq ""){
    $cssPath = "";
}
elsif( !(( $cssName =~ /^[A-Za-z]+:\/\// ) || ( $cssName =~ /^\// ) || ( $cssName =~ /^\./ ) || ($styleDir eq "")) ){
    $cssPath = $styleDir . "/" . $cssName;
}
elsif( (exists $ENV{"GELLMU_CSSName"}) && ($ENV{"GELLMU_CSSName"} eq "") ){
    $cssPath = "";
}
else{
    $cssPath = $cssName;
};

# Should the UMSS not be used?  (See http://www.w3.org/Math/XSL/)

$useumss = 0;
if(exists $ENV{"GELLMU_NoUMSS"}){
    if($ENV{"GELLMU_NoUMSS"} == 0){
	$useumss = 1;
    };
};

# Should XLink be used for anchors found in <text> in math mode?
$xlinkflag = 1;
if(exists $ENV{"GELLMU_XLink"}){
    if($ENV{"GELLMU_XLink"} eq "0"){
	$xlinkflag = 0;
    };
};

# Markup technician
# Used for linking to document producer's email, which may be invisible
# WARNING: This can lead to spam.  As of 26 May 2004 not used by default.
# Enable it by giving $showmailto the value 1.
$showmailto = 0;

$MadeUrl = "mailto:nobody\@localhost";
if($ENV{"GELLMU_MadeUrl"} ne ""){
    $MadeUrl = $ENV{"GELLMU_MadeUrl"};
};

# Visible Authoring Contact Label and URL
$AdminName = "AUTHOR";
$AdminUrl = "file://localhost" . $ENV{"HOME"} . "/public_html/";
if($ENV{"GELLMU_AdminUrl"} ne ""){
    $AdminUrl = $ENV{"GELLMU_AdminUrl"};
};

# Name for web comments -- often "webmaster"
# See the variable $showmailto

$CommentName = "COMMENT";
$CommentUrl = "mailto:nobody\@localhost";
if($ENV{"GELLMU_CommentUrl"} ne ""){
    $CommentUrl = $ENV{"GELLMU_CommentUrl"};
};

# Default surtitle (such as might appear in web browser's border)
$defaultSurtitle="A GELLMU Demonstration";

if($ENV{"GELLMU_SurTitle"} ne ""){
    $defaultSurtitle = $ENV{"GELLMU_SurTitle"};
};

# Global Variables -- flags and numbers to think about

# Let's not depend on time zone being cross-platform
# This is keyed on the last entry in the array version of localtime()

@GTimeZone = ();

# If you want local time, then adapt and uncomment the next line
# @GTimeZone = ("EST", "EDT");

# Month names
@GMonth = ("January", "February", "March", "April", "May", "June",
   "July", "August", "September", "October", "November", "December");

# Abbreviated month names
@GMoY = ("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep",
   "Oct", "Nov", "Dec");

# Abbreviated day-of-week names
@GDoW = ("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat");

@Alphabetic = qw(o A B C D E F G H I J K L M N O P Q R S T U V W X Y Z
		 AA BB CC);
@alphabetic = qw(O a b c d e f g h i j k l m n o p q r s t u v w x y z
		 aa bb cc);
@Roman = qw(0 I II III IV V VI VII VIII IX X XI XII XIII XIV XV XVI
	     XVII XVIII XIX XX XXI XXII XXIII XXIV XXV XXVI XXVII
	     XXVIII XXIX);
@roman = qw(0 i ii iii iv v vi vii viii ix x xi xii xiii xiv xv xvi
	     xvii xviii xix xx xxi xxii xxiii xxiv xxv xxvi xxvii
	     xxviii xxix);

# Level of the least significant "section" type unit to be numbered
#   as in LaTeX, except that the GELLMU to command (to change this)
#   is \secnumdepth  Example:  \secnumdepth{-2}  (to turn off all sec nos)
$secnumdepth = 3;  # Number sections, sub, and subsub (no "parts" yet)
$tocunitlength = 0;
$currtocdepth = 0;

# Use  $nobanner = 1  to hide the GELLMU banner at article end by default.
# Use  \nobanner  or  \banner  in article preamble to override default.
$nobanner = 1;

# Use  $nogratlinks = 1  to turn off gratuitous links by default.
# Use  \nogratlinks  or  \gratlinks  in article preamble to override default.
$nogratlinks = 1;

######################################################################

$anchopt = "";
$anchref = "";
$arrtabflag = ();
$asstbodyflag = 0;
$asstbodyhpar = 0;
$asstid = "";
$asstname = "";
@authoraddr = ();
@authoremail = ();
@authorname = ();
$authorseq = 0;
$artsubtitle = "";
$arttitle = "";
$basefile = ""; # basename without suffix of SGML input file known in parse
$baseloc = ""; # dirname of web address of this document
$baseurl = ""; # computed as $baseloc . "/" . $basefile . ".html"
$bibliseq = 0;
$bibprefix = "BibLabel-";
$binargid = 0;
# $binomdepth = 0; # not recursive for now
$binoml = "";
$binomu = "";
$bodymaketitle = 0;
$clemp=">";
@cond = ();       # setOf condition expression
$copynotice = "";
@coordseq = ();  # seq. position of <coord> arg in <vect> at $vectdepth
@csep = ();      # $csep[$vectdepth][$j] = j-th field in <csep> at $vectdepth
@csepn = ();     # number of coord separator fields in <csep> at $vectdepth
$csepq = 0;
$ctratt = "";
$ctrbc = "";
$ctrbo = "";
$datestr = "";
@deco = ();       # $deco[$ousetdepth] -- decoration for overset, underset
@denm = ();
$docbase = "";  # url for HTML version
$emphdepth = 0; # track emph nesting to enable order 2 handling
$enumdepth=0;   # for "type", i.e., 1, a, i, A
$eqakey = "";  # value of label key for current <eqnarray>
$eqatag = "";  # visible labeling tag for current <eqnarray> or <eqnline>
$eqatagstring = "";
$eqinhpar = 0;
$eqlabelcount = 0;
$eqnarowseq = 0;
$eqnamode = 0;
$eqnkey = "";  # last value in <eqnkey>
$eqnrow = "";   # collector for content of <eqnrow>
$eqnser = "";  # last value in <eqnser>
# eqn tagging is not yet fully implemented
$eqntag = "";  # content of <eqntag> (in equation or eqnarray)
#
$eqrkey = "";  # value of label key in current <eqnrow>
$eqrtag = "";  # visible labeling tag for current <eqnrow>
$equkey = "";  # value of label key for current <equation>
@expr = ();       # $expr[$ousetdepth] -- base for mscript, overset, underset
$fncount = 0;
@fnote=();
$fnsvhpar = 0;   # variable for saving $hpar_on across a footnote
@fracconlist = ("mlg", "msup", "msub", "pow", "sarg", "sum", "int", "prod",
                "sqrt", "radicand", "bal", "balbr", "balsb", "balab",
                "balvbr", "lbalbr", "rbalbr", "norm", "absval", "transp",
                "neg", "Sym", "Bc0", "sipbody", "lower", "upper");
$fracconregexp = '^(' . join('|', @fracconlist) . ')$';
$fracdepth=0;
$fracser=0;
@frid=();
$haveanchopt = 0;
$havedate = 0;
@haveemail = ();
$havetitle = 0;
$haveUglyRadical = 0;    # 0 if your audience installs the special fonts
$hpar_on = 0;      # state for HTML <p>
$inanch = 0;
$inanchopt = 0;
$isxml = 0;
$itemlabel="";
$labelinitem="";
%labelinfo;
@labelkeys=();
%labelsecunits=();
%labelseqs=();  # needed here?
%labelsers=();
%labelserseqs=();
%labelsids=();
%labeltypes=(); # needed here?
$lackMathGlyphs = 1;   # 0 if your audience has non Moz-distribution glyphs
$lgcnt = 0;  # logical for successful opening of contents data as GCNT
$lglbl = 0;  # logical for successful opening of label info file as GLBL
$listdepth = 0;
@lleft = ();      # mscript lower left
@lright = ();     # mscript lower right
$maketitle = 0;
$markdraft = 0;
$mathml = 0;
$mathmlc = 0;
$mathmlp = 0;
$mathns = "http://www.w3.org/1998/Math/MathML";
@metanames=();
$metanum=0;
@metavalues=();
%mtabaval=();
$new_sec = 0; $sec_level = 0; $sec_serial = 0; $subsec_serial = 0;
$noMathStyle = 1;        # color mathbb red, mathcal blue, mathfrak green
$notitle = 0;
@numr=();
$numrsq = 0;
$oldlabelflag=0;
$ousetdepth = 0;  # used for mscript, overset, underset, setOf
$outname = "HTML";
@paraslist = ("par", "parb", "paragraph", "subparagraph");
$parasregexp = '^(' . join('|', @paraslist) . ')$';
$para_on = 0;    # state for "par" and normal "parb"
@parm = ();       # setOf parameter expression
$parqv_ser = 0;  # serial for "parb" inside "quotation" or "verse"
$passcdata = 0;
@radicand=();
@radx=();
$sec_hdr_num = 0;
$sech_os = "";
$sepregexp = '\\\\';  # regexp for field separator in label aux file
@simpleradicand=();
$sopt = "";
$sprefix="";
$stolvl = 0;
@store = ();
$stretchChallenged = 1;  # another font issue?
$subsubsec_serial = 0;
$sunit="";
$sunitflag=0;
@sqrtarg=();
$sqrtdepth = 0;
@sqrtopt=();
$stemname="";
$suffixHtml=".html";    # $suffixHtml and $suffixXhtml are used to compute
$suffixXhtml=".xhtml";  # the HTML <base>; actual suffix comes from driver
$sumdepth=0;
@sumsub=();
@sumsubseq=();
@sumsup=();
@sumsupseq=();
$surtitle="";
@tabalen=();     # length of @tabasum at given tabdepth
@tabarg=();
@tabrowcurr=(); # table row for current depth held until beginning of next
@tabrowseq=();  # seq. no. of current table row at current depth
@tabrowtype=(); # name (tr, trule, or emprow) of curr. tbl. row at curr. depth
@tabaseq=();     # sequence of current cell at given tabdepth
@tabasym=();     # column types in tabarg at given tabdepth; one of c,l,p,r
@tabasyn=();     # column extras in tabarg at given tabdepth
%tabaval=();
$tabdepth = 0;
@tabopt=();
$tdtdbc = 0;
$thebiblilabel="";
$thisbibkey = "";
$thisbiblabel = "";
$thiscitekey = "";
$thiscitenote="";
$thiscitetext="";
$todaystr = "";
@uleft = ();      # mscript upper left
@unirow = (); # 0 (false) or 1 (true) for table at $tabdepth
              #   where cellspacing and cellpadding are zero-ed
$unknown_elements=0;
@uright = ();     # mscript upper right
$vectdepth = 0;
$xhtml = 0;
$xhtmlstrict = 0;

# Global state variables
$gmath_on = 0; $imath_on=0; $dmath_on=0; $emath_on=0;
$emathstar_on = 0; $sv_gmath_on = 0;
$verb_on = 0;

# Static strings for clpr alignment in tabular and array
$tabaval{c}=' align="center"';
$tabaval{l}=' align="left"';
$tabaval{p}='';
$tabaval{r}=' align="right"';
$mtabaval{c}=' columnalign="center"';
$mtabaval{l}=' columnalign="left"';
$mtabaval{p}='';
$mtabaval{r}=' columnalign="right"';

# Argument processing

$pname = $0;
$pname =~ s/^.*\///;
$usage = "Usage:  " . $pname . " " . $1 . 
    " < {nsgmls-ESIS}  " . "[ -xhtml | -mathml ]\n";
$arglen = scalar(@ARGV);
if ($arglen >= 2){
    print STDERR $usage;
    exit(1);
}
elsif(($arglen == 1) && ($ARGV[0] eq "-xhtml" )){
    $xhtml = 1;
    $outname = "XHTML";
    $clemp = " />";
    print STDERR "      Writing XHTML 1.0 Transitional\n";
}
elsif(($arglen == 1) && ($ARGV[0] eq "-xhtml11" )){
    $xhtml = 1;
    $xhtmlstrict = 1;
    $outname = "XHTML";
    $clemp = " />";
    print STDERR "      Writing XHTML 1.1 Basic\n";
}
elsif(($arglen == 1) && ($ARGV[0] eq "-cmathml")){
    $mathml = 1;
    $mathmlc = 1;
    $xhtml = 1;
    $xhtmlstrict = 1;
    $outname = "XHTML+MathML";
    $clemp = " />";
    print STDERR "      Writing XHTML 1.1 + Content MathML 2.0\n";
}
elsif(($arglen == 1) && ($ARGV[0] eq "-pmathml")){
    $mathml = 1;
    $mathmlp = 1;
    $xhtml = 1;
    $xhtmlstrict = 1;
    $outname = "XHTML+MathML";
    $clemp = " />";
    print STDERR "      Writing XHTML 1.1 + Presentation MathML 2.0\n";
}
elsif(($arglen == 1) && ($ARGV[0] eq "-mathml")){
    $mathml = 1;
    $mathmlp = 1;   # for now: presentation MathML is default
    $xhtml = 1;
    $xhtmlstrict = 1;
    $outname = "XHTML+MathML";
    $clemp = " />";
    print STDERR "      Writing XHTML 1.1 + MathML 2.0\n";
}
elsif($arglen == 1){
    print STDERR "Unrecognized first argument: ", $ARGV[0], "\n";
    exit(1);
};


if($xhtmlstrict == 1){
    $ctratt = "class=\"display\"";
    $ctrbo = "<div class=\"display\">";
    $ctrbc = "</div>";
}
else{
    $ctratt = "align=\"center\"";
    $ctrbo = "<center>";
    $ctrbc = "</center>";
};

#
# Document Handlers.
#

sgml('start', sub{
    my $dt = 1;
    if($xhtml == 1){
	if($mathml == 1){
	    $dt = '<?xml version="1.0" encoding="UTF-8"' . "?>\n";
	    if($useumss == 1){
		$dt = $dt . '<?xml-stylesheet type="text/xsl"'
		. ' href="' . $styleDir;
		if($mathmlc == 1){
		    $dt = $dt . '/mathml.xsl"?>' . "\n";
		}
		else{
		    $dt = $dt . '/pmathml.xsl"?>' . "\n";
		};
	    };
	    if($cssPath ne ""){
		$dt = $dt . '<?xml-stylesheet type="text/css" href="';
		$dt = $dt . $cssPath . '"?>' . "\n";
	    };
	    $dt = $dt
	. '<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1 plus MathML 2.0//EN" '
	. '"http://www.w3.org/Math/DTD/mathml2/xhtml-math11-f.dtd"' . ">\n";
	}
	elsif($xhtmlstrict == 1){
	    $dt = '<?xml version="1.0" encoding="UTF-8"' . "?>\n";
	    if($cssPath ne ""){
		$dt = $dt . '<?xml-stylesheet type="text/css" href="';
		$dt = $dt . $cssPath . '"?>' . "\n";
	    };
	    $dt = $dt . "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.1//EN\""
		.  "\"xhtml11.dtd\">\n"; # should be an http uri
	}
	else{
	    $dt= "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
	    if($cssPath ne ""){
		$dt = $dt . '<?xml-stylesheet type="text/css" href="';
		$dt = $dt . $cssPath . '"?>' . "\n";
	    };
	    $dt = $dt
	. "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n"
	. "    \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n";
	};
    }
    else{
   $dt = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n";
    };
    output($dt);
});

sgml('end', sub{
    output("\n");
    if($unknown_elements > 0){
	print STDERR "***** WARNING: ", $unknown_elements,
              " unknown elements;\n";
	if($isxml == 0){
	    print STDERR "      Was the document filtered to XML first?\n";
	};
    };
    if($currtocdepth != 0){
	print STDERR $WhoAmI, " WARNING: currtocdepth not zero at end,\n",
	"   value ", $currtocdepth, "\n";
    };
    if($emphdepth != 0){
	print STDERR $WhoAmI, " WARNING: emphdepth not zero at end,\n",
	"   value ", $emphdepth, "\n";
    };
    if($enumdepth != 0){
	print STDERR $WhoAmI, " WARNING: enumdepth not zero at end,\n",
	"   value ", $enumdepth, "\n";
    };
    if($fracdepth != 0){
	print STDERR $WhoAmI, " WARNING: fracdepth not zero at end,\n",
	"   value ", $fracdepth, "\n";
    };
    if($listdepth != 0){
	print STDERR $WhoAmI, " WARNING: listdepth not zero at end,\n",
	"   value ", $listdepth, "\n";
    };
    if($ousetdepth != 0){
	print STDERR $WhoAmI, " WARNING: ousetdepth not zero at end,\n",
	"   value ", $tabdepth, "\n";
    };
    if($sqrtdepth != 0){
	print STDERR $WhoAmI, " WARNING: sqrtdepth not zero at end,\n",
	"   value ", $sqrtdepth, "\n";
    };
    if($sumdepth != 0){
	print STDERR $WhoAmI, " WARNING: sumdepth not zero at end,\n",
	"   value ", $sumdepth, "\n";
    };
    if($tabdepth != 0){
	print STDERR $WhoAmI, " WARNING: tabdepth not zero at end,\n",
	"   value ", $tabdepth, "\n";
    };
    if($vectdepth != 0){
	print STDERR $WhoAmI, " WARNING: vectdepth not zero at end,\n",
	"   value ", $tabdepth, "\n";
    };
});

#
# Element Handlers.
#

# Element: article
sgml('<article>', sub{
    my $stem = $_[0]->attribute("stem")->value;
    if($stem ne ""){
	$stemname = $stem;
	my $flbl = $stemname . ".xlb";
	my $fcnt = $stemname . ".xcn";
	$lglbl = open(GLBL, $flbl);
	$lgcnt = open(GCNT, $fcnt);
	if($lglbl == 0){ # test label file
	    print STDERR $WhoAmI, " WARNING:\n",
                  "  Failed to open label info file \"", $flbl,
                  "\" for reading.\n";
	}
	else{   # Good file -- let's read it.
        # Line format:  key  seq  container  section-id [ series  series-seq ]
	    my $inline = "";
	    my @tarray=();
	    my $tkey = "";
	    while($inline = <GLBL>){
		chomp($inline);
		@tarray = (split(/$sepregexp/, $inline));
		$tkey = shift @tarray;
		@{$labelinfo{$tkey}} = @tarray;
		@labelkeys = (keys %labelinfo);
	    };
	    my $nkeys = scalar @labelkeys;
	    if($nkeys > 0){
		my $test = scalar @tarray;
		if(($test == 4) || ($test == 6)){
		    foreach $tkey (@labelkeys){
			$labelsids{$tkey} = @{$labelinfo{$tkey}}[2];
			$labelsecunits{$tkey} = @{$labelinfo{$tkey}}[3];
			$labelsers{$tkey} = @{$labelinfo{$tkey}}[4];
			$labelserseqs{$tkey} = @{$labelinfo{$tkey}}[5];
		    };
		}
		elsif(($test == 3) || ($test == 5)){
		    $oldlabelflag = 1;
		    print STDERR "ltxgart.pl: Old label aux file format\n";
		    foreach $tkey (@labelkeys){
			$labelsids{$tkey} = @{$labelinfo{$tkey}}[2];
			$labelsers{$tkey} = @{$labelinfo{$tkey}}[3];
			$labelserseqs{$tkey} = @{$labelinfo{$tkey}}[4];
		    };
		}
		else{
		    print STDERR
			$WhoAmI, ": Label aux file not in correct format\n";
		};
            # # Debug output
		# foreach $tkey (@labelkeys){
		#     print STDERR "Label key \"$tkey\" is in series",
                #       " \"$labelsers{$tkey}\", seq. $labelserseqs{$tkey}\n";
		# };
	    };
	}; # end of if test label file
	if($lgcnt == 0){  # test contents file
	    print STDERR $WhoAmI, " WARNING:\n",
            "  Failed to open contents info file \"", $fcnt,
            "\" for reading.\n";
	};
    } # end of case where article has a stem
    else{
	print STDERR
            $WhoAmI, " WARNING: No stem attribute for root element.";
    };
    if($xhtml == 1){
	output("<html xmlns=\"http://www.w3.org/1999/xhtml\">\n");
    }
    else{
	output("<html>\n");
    };
});
sgml('</article>', sub{
    output("</html>\n");
    if($lglbl != 0){
	close(GLBL);
    };
    if($lgcnt != 0){
	close(GCNT);
    };
});

# Element: preamble
sgml('<preamble>', sub{
    push_output('string');
    $surtitle = $defaultSurtitle;
});
sgml('</preamble>', sub{
    my $pos = pop_output;
    my $jc = 1;
    my $os = "<head>\n";
    if(($utf8On == 1) && ($xhtml == 0)){
	$os = $os . '<meta http-equiv="Content-Type"' 
	    . ' content="text/html; charset=UTF-8"' . $clemp . "\n";
    };
    if($cssPath ne ""){
	$os = $os . '<link rel="stylesheet" type="text/css"' . ' href="'
	    . $cssPath . '"' . $clemp . "\n";
    };
# $showmailto is 0 by default because of spam
    if($showmailto != 0){
	$os = $os . "<link rev=\"made\" href=\"" . $MadeUrl . '"'
	    . $clemp ."\n";
    };
    if($docbase ne ""){
	$os = $os . "<base " . $docbase . $clemp . "\n";
    }
    elsif(($baseloc ne "") && ($basefile ne "")){
	$os = $os . '<base href="' . $baseurl . '"' . $clemp . "\n";
    };
    while($jc <= $metanum){
	$metavalues[$jc] =~ s/\"/\&\#x0022;/g;
	$os = $os . '<meta name="' . $metaname[$jc] . '" content="' 
	    . plain_string($metavalues[$jc]) . '"' . $clemp . "\n";
	$jc++;
    }
    $os = $os . "<title>" . $surtitle . "</title>\n";
    $os = $os ."</head>\n";
    output($os);
});

# Element: surtitle
sgml('<surtitle>',sub{
    push_output('string');
});
sgml('</surtitle>', sub{
    $surtitle = pop_output;
    $metanum++;
    $metaname[$metanum]="surtitle";
    $metavalues[$metanum] = $surtitle;
});

# Element: title
sgml('<title>', sub{
    push_output('string');
});
sgml('</title>', sub{
    $arttitle = pop_output;
    $metanum++;
    $metaname[$metanum]="title";
    $metavalues[$metanum]= $arttitle;
});

# Element: subtitle
sgml('<subtitle>', sub{
    push_output('string');
});
sgml('</subtitle>', sub{
    $artsubtitle = pop_output;
    $metanum++;
    $metaname[$metanum]="subtitle";
    $metavalues[$metanum]= $artsubtitle;
});

# Element: base
sgml('<base>', sub{
    push_output('string');
});
sgml('</base>', sub{
    $docbase = pop_output;
});

# Element: baseloc
sgml('<baseloc>', sub{
    push_output('string');
});
sgml('</baseloc>', sub{
    my $es = "";
    $baseloc = pop_output;
    my $event = $_[1];
    $basefile = $event->file;
    $basefile =~ s/  *//g;
    $basefile =~ s|^.*/||;
    $basefile =~ s/\..*$//;
    $baseloc =~ s|/$||;
    if($xhtml == 1){
	$baseurl = $baseloc . "/" . $basefile . $suffixXhtml;
    }
    else{
	$baseurl = $baseloc . "/" . $basefile . $suffixHtml;
    };
#    print {"STDERR"} " baseloc: ", $baseloc ,"\n";
#    print {"STDERR"} "basefile: ", $basefile, "\n";
#    print {"STDERR"} " baseurl: ", $baseurl, "\n";
});

# Element: author
sgml('<author>', sub{
    push_output('string');
    $authorseq++;
    $haveemail[$authorseq] = 0;
    $authoraddr[$authorseq] = "";
    $authoremail[$authorseq] = "";
});
sgml('</author>', sub{
    my $pos = pop_output;
    $authorname[$authorseq] = $pos;
    # no harm if an address with possible 'eaddr' appears in 'author'
    #    just less flexible
    $metanum++;
    $metaname[$metanum]="author";
    $metavalues[$metanum]= $pos;
});

# Element: body
sgml('<body>', \&open_artbody);
# sgml('<document>', \&open_artbody);
sub open_artbody{
    my $bodytag = "";
    my $os = "";
    if($xhtmlstrict == 1){
	$bodytag = "<body>\n";
    }
    else{
	$bodytag = "<body bgcolor=\"#ffffff\" text=\"#000000\"\nlink=\"#0000ee\" vlink=\"#0000bb\" alink=\"#ff0000\">\n";
    };
    $os = $bodytag;
    if(exists $ENV{GELLMU_OriginLabel}){
	my $gorglabel = $ENV{GELLMU_OriginLabel};
	if($gorglabel ne ""){
	    if($xhtmlstrict == 1){
		$os = $os . '<div><a id="' . $gorglabel . '"></a>'. "</div>\n";
	    }
	    else{
		$os = $os . '<div><a id="' . $gorglabel . '" name="'
		    . $gorglabel . '"></a>' . "</div>\n";
	    };
	};
    };
    if( (($bodymaketitle == 0)&&($maketitle == 0)) || ($maketitle == 1) ){
	$os = $os . do_maketitle();
    };
    if ($markdraft == 1){
	$os = $os . "<h5 " . $ctratt . "> D R A F T </h5>\n";
    };
    output($os);
}
sgml('</body>', \&end_artbody);
# sgml('</document>', \&end_artbody);
sub end_artbody{
    my $os = "";
# #    my $ds = `date`;
# #    $ds =~ s/\n//;
#    my $ds = scalar localtime();
    my @tv = ();
    if (scalar(@GTimeZone) > 0){
	@tv = localtime();
    }
    else{
	@tv = gmtime();
    };
    my $yr = 1900 + $tv[5];
    my $jk = 0;
    while($jk < 3){
	$tv[$jk] = sprintf("%02d", $tv[$jk]);
	$jk++;
    };
    my $timestamp = $tv[2] . ":" . $tv[1] . ":" . $tv[0];
    my $ds = $GDoW[$tv[6]] . " " . $tv[3] . " " . $GMoY[$tv[4]] . " "
	. $yr . " at " . $timestamp;
    if(scalar(@GTimeZone) > 0){
	$ds = $ds . " " . $GTimeZone[$tv[8]];
    }
    else{
	$ds = $ds . " GMT";
    };
    my $ts = "";
    if($fncount > 0){
	$os = "<hr" . $clemp . "\n<h3>Footnotes</h3>\n<ol>\n";
	my $jj = 1;
        my $id = "";
	$hpar_on = 0; # Don't want list code to write '</p>'
	while($jj <= $fncount){
	    if($xhtmlstrict == 1){
		$os = $os . '<li><a id="fnote' . $jj . '" href="#revfnote'
		    . $jj . '">*</a> ' . $fnote[$jj] . "</li>\n";
	    }
	    else{
		$os = $os . '<li><a name="fnote' . $jj . '" id="fnote'
		    . $jj . '" href="#revfnote' . $jj . '">*</a> '
		    . $fnote[$jj] . "</li>\n";
	    };
	    $jj++;
	};
	$os = $os . "</ol>\n";
	output($os);
    };
# Code for end of html document anchors
    if($nogratlinks == 0){
	$ts = $ts . "<hr" . $clemp . "\n<p " . $ctratt . "><a href=\"";
	$ts = $ts . $AdminUrl . "\">" . $AdminName . "</a>\n";
	if($showmailto == 1){
	    $ts = $ts . "&#xA0;|&#xA0;\n";
	    $ts = $ts . "<a href=\"" . $CommentUrl . "\">" . $CommentName
		. "</a>";
	};
	$ts = $ts . "</p>\n";
    };
    if($nobanner == 0){
	$ts = $ts . "<p>\n[Processed from ";
	$ts = $ts . "<a href=\"http://www.albany.edu/~hammond/gellmu/\">";
	$ts = $ts . "GELLMU</a> to " . $outname . ": " . $ds . "]</p>\n";
    };
    $ts = $ts . "</body>\n";
    output($ts);
}

# Element: math  -- inline math
sgml('<math>', sub{
    if($mathml == 1){
	on_mathml();
    }
    else{
	on_math();
    };
});
sgml('</math>', sub{
    if($mathml == 1){
	off_mathml();
    }
    else{
	off_math();
    };
});

sgml('<math0>', \&on_math);
sgml('</math0>', \&off_math);

# Element: tmath  -- inline math delimited by "$ ... $" instead of
#                   by "\math{ ... }  (in case we care)
# Element: tmath  -- inline math
sgml('<tmath>', sub{
    if($mathml == 1){
	on_mathml();
    }
    else{
	on_math();
    };
});
sgml('</tmath>', sub{
    if($mathml == 1){
	off_mathml();
    }
    else{
	off_math();
    };
});

sgml('<displaymath0>', "$ctrbo\n");
sgml('</displaymath0>', "\n$ctrbc\n");

# Element: displaymath  -- displayed math
sgml('<displaymath>', sub{
    local ($dmelement, $dmevent) = @_;
    local $dmathpan = $_[0]->parent->name;
    if($mathml == 1){
	on_dmathml();
    }
    else{
	on_dmath();
    };
});
sgml('</displaymath>', sub{
    local $dmathpan = $_[0]->parent->name;
    if($mathml == 1){
	off_dmathml();
    }
    else{
	off_dmath();
    };
});

# Element: sup  -- behavior depends on whether  $gmath_on  is set.
sgml('<sup>', sub{push_output('string');});
sgml('</sup>', sub{
    my $s = pop_output;
    my $pan = $_[0]->parent->name;
    if($gmath_on == 1){
	if($pan eq "sum"){
	    $sumsupseq[$sumdepth]++;
	    if($sumsupseq[$sumdepth] == 1){
		$sumsup[$sumdepth] = $s;
	    }
	    else{
		output("^{" . $s . "}");
	    };
#	    print {"STDERR"} "Sup:     pop: ", $s, "\n";
#	    print {"STDERR"} "      parent: ", $pan, "\n";
#	    print {"STDERR"} "    sumdepth: ", $sumdepth, "\n";
#	    print {"STDERR"} "   sumsupseq: ", $sumsupseq[$sumdepth], "\n";
	}
	elsif(length($s) == 1){
	    output("^{" . $s . "}");
	}
	else{
	    output("^{" . $s . "}");
	};
    }
    else{
	my $os = "<sup>" . $s . "</sup>";
	output($os);
    };
});

# Element: sub  -- behavior depends on whether  $gmath_on  is set.
sgml('<sub>', sub{push_output('string');});
sgml('</sub>', sub{
    my $s = pop_output;
    my $pan = $_[0]->parent->name;
    if($gmath_on == 1){
	if($pan eq "sum"){
	    $sumsubseq[$sumdepth]++;
	    if($sumsubseq[$sumdepth] == 1){
		$sumsub[$sumdepth] = $s;
	    }
	    else{
		output("_{" . $s . "}");
	    };
#	    print {"STDERR"} "Sub:     pop: ", $s, "\n";
#	    print {"STDERR"} "      parent: ", $pan, "\n";
#	    print {"STDERR"} "    sumdepth: ", $sumdepth, "\n";
#	    print {"STDERR"} "   sumsubseq: ", $sumsubseq[$sumdepth], "\n";
	}
	elsif(length($s) == 1){
	    output("_{" . $s . "}");
	}
	else{
	    output("_{" . $s . "}");
	};
    }
    else{
	my $os = "<sub>" . $s . "</sub>";
	output($os);
    };
});

# Element: msup  -- behavior depends on whether  $gmath_on  is set.
sgml('<msup>', sub{push_output('string');});
sgml('</msup>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = $pos;
    my $name = $elt->name;
    my $par = $elt->parent;
    my $pan = $par->name;
    if($gmath_on == 1){
	if($mathml == 1){
	    my $chld = $elt->attribute("mchld")->value;
	    my @chlds = split(',', $chld);
	    my $nchld = scalar(@chlds);
	    if($nchld > 1){
		$os = "<mrow>" . $os . "</mrow>";
	    };
	    my $seq = $elt->attribute("mseq")->value;
	    if($pan =~ /^(sum|prod|int)$/){
		$sumsupseq[$sumdepth]++;
	    };
	    if( ($pan =~ /^(sum|prod|int)$/) &&
		( ($seq == 1) ||
		  (($seq==2) && ($sumsub[$sumdepth] ne "") ) ) ){
		$sumsup[$sumdepth] = $os;
	    }
	    elsif($store[$stolvl] ne ""){
		if($seq == 1){
		    print STDERR $WhoAmI, ": WARNING -- Stored content (",
		    $store[$stolvl], ") passed, stolvl ", $stolvl, ', for "',
		    $name, '" with seq = 1 at line ', $ev->line, "\n";
		};
		# if($stolvl != 1){
		#    print STDERR $WhoAmI, ": COMMENT -- stolvl is ",
		#    $stolvl, ' for "', $name, '" in "', $pan, '" at line ',
		#    $ev->line, "\n";
		# }
		my $parchld = $par->attribute("mchld")->value;
		my @sybs = split(',',$parchld);
		if(!($sybs[$seq-1] eq $name)){
		    print STDERR $WhoAmI, ': WARNING -- Seq no mismatch for "',
		    $name, '"at l. ', $ev->line, "\n";
		    print STDERR "     Parent elt. ", $pan,
		    " with child list: ", $parchld, "\n";
		    print STDERR "     Elt att mseq: ", $seq,
		    "; parent lookup: ", $sybs[$seq-1], "\n";
		};
		# Is there a previous subscript for MathML's msubsup ?
		if(($seq >= 2) && ($sybs[$seq-2] eq "msub") && ($stolvl >=2)){
		    my $tsup = $os;
		    my $tsub = $store[$stolvl];
		    $store[$stolvl] = "";
		    $stolvl--;
		    my $tbase = $store[$stolvl];
		    $store[$stolvl] = "";
		    $stolvl--;
		    if($tbase eq ""){
			$tbase = "<mi>?</mi>";
		    };
		    $os = "<msubsup>".$tbase . $tsub . $tsup ."</msubsup\n>";
		}
		else{
		    $os = "<msup>" . $store[$stolvl] . $os . "</msup\n>";
		    $store[$stolvl] = "";
		    $stolvl--;  # msup
		};
		if($sybs[$seq] =~ /^(msub|msup|pow|sarg)$/){
		    $stolvl++;  #msup
		    $store[$stolvl] = $os;
		}
		else{
		    output($os);
		};
	    }
	    else{
		print STDERR $WhoAmI, ": WARNING -- Superscript (", $pos
		    , ') dangles in element "', $pan, '", seq = ', $seq, "\n";
		output("_{" . $os . "}");
	    };
	}
	elsif($pan =~ /^(sum|prod|int)$/){
	    $sumsupseq[$sumdepth]++;
	    if($sumsupseq[$sumdepth] == 1){
		$sumsup[$sumdepth] = $os;
	    }
	    else{
		output("^{" . $os . "}");
	    };
	}
	else{
	    output("^{" . $os . "}");
	};
    }
    else{
	print STDERR $WhoAmI, ': WARNING -- "', $name
	    , '" found outside of math in "', $pan, '" at line '
	    , $ev->line, "\n";
	my $os = "<sup>" . $os . "</sup>";
	output($os);
    };
});

# Element: msub  -- behavior depends on whether  $gmath_on  is set.
sgml('<msub>', sub{push_output('string');});
sgml('</msub>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = $pos;
    my $name = $elt->name;
    my $par = $elt->parent;
    my $pan = $par->name;
    if($gmath_on == 1){
	if($mathml == 1){
	    my $chld = $elt->attribute("mchld")->value;
	    my @chlds = split(',', $chld);
	    my $nchld = scalar(@chlds);
	    if($nchld > 1){
		$os = "<mrow>" . $os . "</mrow>";
	    };
	    my $seq = $elt->attribute("mseq")->value;
	    if($pan =~ /^(sum|prod|int)$/){
		$sumsubseq[$sumdepth]++;
	    };
	    if(($pan =~ /^(sum|prod|int)$/) && ($seq == 1)){
		$sumsub[$sumdepth] = $os;
	    }
	    elsif($store[$stolvl] ne ""){
		if($seq == 1){
		    print STDERR $WhoAmI, ": WARNING -- Stored content ("
			. $store[$stolvl] . ") passed, stolvl ", $stolvl,
			', for msub with seq = 1 at line ', $ev->line, "\n";
		};
		# if($stolvl != 1){
		#    print STDERR $WhoAmI, ": COMMENT -- stolvl is ",
		#    $stolvl, ' for "', $name, '" in "', $pan, '" at line ',
		#    $ev->line, "\n";
		# }
		my $parchld = $par->attribute("mchld")->value;
		my @sybs = split(',',$parchld);
		if(!($sybs[$seq-1] eq $name)){
		    print STDERR $WhoAmI, ': WARNING -- Seq no mismatch for "',
		    $name, '"at l. ', $ev->line, "\n";
		    print STDERR "     Parent elt. ", $pan,
		    " with child list: ", $parchld, "\n";
		    print STDERR "     Elt att mseq: ", $seq,
		    "; parent lookup: ", $sybs[$seq-1], "\n";
		};
		if($sybs[$seq] eq "msup"){  # msup code will use msubsup
		    $stolvl++;  # msub for msubsup
		    $store[$stolvl] = $os;
		}
		else{
		    $os = "<msub>" . $store[$stolvl] . $os . "</msub\n>";
		    $store[$stolvl] = "";
		    $stolvl--;  # msub
		    if($sybs[$seq] =~ /^(msub|pow|sarg)$/){
			$stolvl++;  # msub
			$store[$stolvl] = $os;
		    }
		    else{
			output($os);
		    };
		};
	    }
	    else{
		print STDERR $WhoAmI, ": WARNING -- Dangling subscript ("
		    . $pos . ") in element \"" . $pan . "\", seq = "
		    . $seq . "\n";
		output("_{" . $os . "}");
	    };
	}
	elsif($pan =~ /^(sum|prod|int)$/){
	    $sumsubseq[$sumdepth]++;
	    if($sumsubseq[$sumdepth] == 1){
		$sumsub[$sumdepth] = $os;
	    }
	    else{
		output("_{" . $os . "}");
	    };
	}
	else{
	    output("_{" . $os . "}");
	};
    }
    else{
	print STDERR $WhoAmI, ': WARNING -- "', $name
	    , '" found outside of math in "', $pan, '" at line '
	    , $ev->line, "\n";
	my $os = "<sub>" . $os . "</sub>";
	output($os);
    };
});

# Element: par
# Minimized removal of asstbody code (in favor of CSS)
sgml('<par>', sub{
    $para_on = 1;
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    # output("</em></p>\n<p><em>");
	    output("</p>\n<p>");
	}
	else{
	    # output("</em>\n<p><em>");
	    output("\n<p>");
	};
	$asstbodyhpar = 1;
    }
    else{
	if($hpar_on == 1){
	    output("</p>\n<p>");
	}
	else{
	    output("\n<p>");
	};
	$hpar_on = 1;
    };
});
sgml('</par>', sub{
    $para_on = 0;
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    # output("</em></p>\n<em>");
	    output("</p>\n");
	    $asstbodyhpar = 0;
	};
    }
    else{
	if($hpar_on == 1){
	    output("</p>\n");
	    $hpar_on = 0;
	};
    };
});

# Element: parb
sgml('<parb>', sub{
    my $pan = $_[0]->parent->name;
    if($pan eq "verbatim"){
	output("\n");
	return;
    };
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    # output("</em></p>\n<p><em>");
	    output("</p>\n<p>");
	}
	else{
	    # output("</em>\n<p><em>");
	    output("\n<p>");
	}
	$asstbodyhpar = 1;
    }
    else{
	if($hpar_on == 1){
	    output("</p>\n<p>");
	}
	else{
	    output("\n<p>");
	};
	$hpar_on = 1;
    };
    if(($pan ne "quote") && ($pan ne "quotation") && ($pan ne "verse")){
	$para_on = 1;
    }
    else{
	$parqv_ser++;
    };
});
sgml('</parb>', sub{
    my $pan = $_[0]->parent->name;
    if($pan eq "verbatim"){
	return;
    };
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    # output("</em></p>\n<em>");
	    output("</p>\n");
	    $asstbodyhpar = 0;
	};
    }
    else{
	if($hpar_on == 1){
	    output("</p>\n");
	    $hpar_on = 0;
	};
    }
    if(($pan ne "quote") && ($pan ne "quotation") && ($pan ne "verse")){
	$para_on = 0;
    }
});

# Element: display
sgml('<display>', sub{
    $tabdepth++;
    my $elt = $_[0];
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    output("</p>\n$ctrbo<table class=\"gdisplay\"><tbody><tr><td>\n");
	    $asstbodyhpar = 0;
	}
	else{
	    output("\n$ctrbo<table class=\"gdisplay\"><tbody><tr><td>\n");
	};
    }
    else{
	my $os = "";
	my $frame = $elt->attribute("frame")->value;
	my $datts = ' class="gdisplay"';
	if($frame ne ""){
	    $datts = $datts . ' style="padding: 1ex; border: 0.3ex solid;"';
	};
	if($hpar_on == 1){
	    $os = "</p>\n$ctrbo<table" . $datts . "><tbody><tr><td>\n";
	    $hpar_on = 0;
	}
	else{
	    $os = "\n$ctrbo<table" . $datts . "><tbody><tr><td>\n";
	};
	output($os);
    };
});
sgml('</display>', sub{
    $tabdepth--;
    my $pan = $_[0]->parent->name;
    if(($pan =~ /$parasregexp/)&&($tabdepth == 0)){
	if($asstbodyflag == 1){
	    # output("</td></tr></tbody></table>$ctrbc\n<p><em>");
	    output("</td></tr></tbody></table>$ctrbc\n<p>");
	    $asstbodyhpar = 1;
	}
	else{
	    output("</td></tr></tbody></table>$ctrbc\n<p>");
	    $hpar_on = 1;
	};
    }
    else{
	if($asstbodyflag == 1){
	    # output("</td></tr></tbody></table>$ctrbc\n<em>");
	    output("</td></tr></tbody></table>$ctrbc\n");
	}
	else{
	    output("</td></tr></tbody></table>$ctrbc\n");
	};
    };
});

sgml('<display0>', "$ctrbo\n");
sgml('</display0>', "\n$ctrbc\n");

sgml('<display2>', sub{
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	output("\n</p><p " . $ctratt . ">\n");
    }
    else{
	output("\n<p " . $ctratt . ">\n");
    }
});
sgml('</display2>', sub{
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	output("</p>\n<p>");
    }
    else{
	output("</p>\n");
    }
});

# Element: quote -- semi-LaTeX-like quote (in paragraph only)
sgml('<quote>', sub{
    if($hpar_on == 1){
	$hpar_on = 0;
	output("</p>\n");
    };
    $parqv_ser = 0;
    push_output('string');
});
sgml('</quote>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    my $bs = "";
    my $ts = "";
    my $es = "";
    if(($pan ne "par")&&($pan ne "parb")){
	$es = $es . 'ELEMENT quote: PARENT "' . $pan
            . '" is not PAR or PARB' . "\n";
	print {"STDERR"} $es;
	$hpar_on = 0;
	$bs = $bs . "<blockquote>\n";
	$ts = $ts . "</blockquote>\n";
    }
    else{
	$bs = $bs . "<blockquote>\n";
	$ts = $ts . "</blockquote>\n<p>";
	$hpar_on = 1;
    }
    $os = $bs . $pos . $ts;
    output($os);
});

# Element: quotation
sgml('<quotation>', sub{
    $parqv_ser = 0;
    if($hpar_on == 1){
	$hpar_on = 0;
	output("</p><blockquote>\n");
    }
    else{
	output("<blockquote>\n");
    }
});
sgml('</quotation>', sub{
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	$hpar_on = 1;
	output("</blockquote>\n<p>");
    }
    else{
	output("</blockquote>\n");
    }
});

# Element: verb -- possibly headed for LaTeX "\verb+...+"
sgml('<verb>', "<kbd>");
sgml('</verb>', "</kbd>");

# Element: verb* -- possibly headed for LaTeX "\verb-...-"
sgml('<verb*>', "<kbd>");
sgml('</verb*>', "</kbd>");

# Element: text
sgml('<text>', sub{
    if($gmath_on == 1){
	$sv_gmath_on = 1;
	$gmath_on = 0;
    };
    push_output('string');
});
sgml('</text>', sub{
    my $pos = pop_output;
    my $os = $pos;
    if($sv_gmath_on == 1){
	$sv_gmath_on = 0;
	$gmath_on = 1;
	if($mathml == 1){
	    $os = $os = "<mtext";
	    my $chld = $_[0]->attribute("mchld")->value;
	    if((($chld ne "") && ($chld ne "Cd0"))){
		if($chld eq "bold"){
		    $os = $os . ' mathvariant="bold" class="strong"';
		}
		elsif($chld eq "emph"){
		    $os = $os . ' mathvariant="italic" class="emphasized"';
		}
		elsif($chld eq "quostr"){
		    $os = $os . ' mathvariant="monospace" class="stringtext"';
		}
		elsif($chld =~ /(anch|urlanch|cite|bold|emph|quostr)/){
		    # some day? mlink and mspan would be nice here
		    # mix and match namespaces if xlinkflag = 0
		    if($xlinkflag == 0){
			$os = $os . ' xmlns="http://www.w3.org/1999/xhtml"';
		    };
		}
		else{
		    # Should there be something else?
		    ;
		};
	    };
	    $os = $os . "\n>" . $pos . "</mtext\n>";
	};
    };
    output($os);
});

# Element: mbox
sgml('<mbox>', sub{
    if($gmath_on == 1){
	$sv_gmath_on = 1;
	$gmath_on = 0;
    };
    push_output('string');
});
sgml('</mbox>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($sv_gmath_on == 1){
	$sv_gmath_on = 0;
	$gmath_on = 1;
    };
    if(($gmath_on == 1) && ($mathml == 1)){
	my $par = $elt->parent;
	my $pan = $par->name;
	my $type = $elt->attribute("type")->value;
	my $mt = "mi";
	if($type eq "operator"){
	    $mt = "mo";
	};
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($chld eq "bold"){
	    $os = '<' . $mt . ' mathvariant="bold" fontweight="bold" '
		. 'fontstyle="normal">' . $pos . '</' . $mt . '>';
	}
	elsif($chld eq "emph"){
	    $os = '<' . $mt . ' mathvariant="italic" fontstyle="italic">'
		. $pos . '</' . $mt . '>';
	}
	elsif($chld eq "slnt"){
	    $os = '<' . $mt . ' mathvariant="italic" fontstyle="italic">'
		. $pos . '</' . $mt . '>';
	}
	elsif($chld eq "quostr"){
	    $os = '<' . $mt . ' mathvariant="monospace">' . $pos . '</'
		. $mt . '>';
	}
	elsif($chld eq "Cd0"){
	    $os = '<' . $mt. '>' . $pos . '</' . $mt . '>';
	}
	else{
	    # mrow with mtext in HTML namespace should be safe
	    $os = "<mrow><mtext\n";
	    if($xlinkflag == 0){
		$os = $os . ' xmlns="http://www.w3.org/1999/xhtml"';
	    };
	    $os = $os . '>' . $pos . "</mtext></mrow>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "mbox")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"mbox\" at l. ", $ev->line,
	    "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mbox
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = $pos;
	output($os);
    };
});

# Element: regch
sgml('<regch>', sub{
    if($gmath_on == 1){
	$sv_gmath_on = 1;
	$gmath_on = 0;
    };
    push_output('string');
});
sgml('</regch>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($sv_gmath_on == 1){
	$sv_gmath_on = 0;
	$gmath_on = 1;
    };
#   enclosing with mtext may be wrong if an accent or a style is involved
    if(($gmath_on == 1) && ($mathml == 1)){
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld > 1){
	    print STDERR $WhoAmI, " *** WARNING: Elt. regch has children "
		, $chld, "\n";
	};
	if(!($chld =~ /^(Cd0|bold|emph|slnt|Em0)$/)){
	    print STDERR $WhoAmI, " *** WARNING: Elt. regch has sole child "
		, $chld, "\n";
	};
	if($chld eq "bold"){
	    $os = '<mi mathvariant="bold" fontweight="bold" fontstyle="normal">' . $pos . "</mi>";
	}
	elsif($chld eq "emph"){
	    $os='<mi mathvariant="italic" fontstyle="italic">'.$pos."</mi>";
	}
	elsif($chld eq "slnt"){
	    $os='<mi mathvariant="italic" fontstyle="italic">'.$pos."</mi>";
	}
	elsif($chld eq "Cd0"){
	    $os='<mi mathvariant="normal" fontstyle="normal">'.$pos."</mi>";
	}
	elsif($chld eq "Em0"){
	    $os = '<mi>' . $pos . "</mi>";
	}
	else{
	    # mrow with mtext in HTML namespace should be safe
	    $os = "<mrow><mtext\n";
	    if($xlinkflag == 0){
		$os = $os . ' xmlns="http://www.w3.org/1999/xhtml"';
	    };
	    $os = $os . '>' . $pos . "</mtext></mrow>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # regch
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = $pos;
	output($os);
    };
});

# Element: bpar -- obsolete, was used as shortref for PARB
sgml('<bpar>', "");
sgml('</bpar>', "");

# Element: itemize -- we may or may not be inside a paragraph.
sgml('<itemize0>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
    # We could check for CDATA here (and elsewhere) before doing this.
	$os = $os . "</p>\n";
    }
    $os = $os . "<ul>\n";
    output($os);
});
sgml('</itemize0>', sub{
    my $os = "</ul>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	$os = $os . "<p>\n";
    }
    output($os);
});

# Element: itemize -- we may or may not be inside a paragraph.
sgml('<itemize>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
    # We could check for CDATA here (and elsewhere) before doing this.
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($hpar_on == 1)){
	#    $hpar_on = 0;
	#    $os = $os . "</p>\n";
	# };
    };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $os = $os . "<ul>\n";
    output($os);
});
sgml('</itemize>', sub{
    my $os = "</ul>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element: enumerate -- we may or may not be inside a paragraph.
sgml('<enumerate>', sub{
    $enumdepth++;
    if($enumdepth > 4){
	print STDERR "Warning: enumeration depth greater than 4\n";
    };
    my $os = "";
    my $dp = ($enumdepth -1)%4;
    my @entypes = ("1", "a", "i", "A");
    my $type = $entypes[$dp];
    my @classes = ("decimal", "lower-alpha", "lower-roman", "upper-alpha");
    my $class = $classes[$dp];
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    # We could check for CDATA here (and elsewhere) before doing this.
    #	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
    #	   &&($hpar_on == 1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    if($xhtmlstrict == 1){
	$os = $os . "<ol class=\"" . $class . "\">\n";
    }
    else{
	$os = $os . "<ol type=\"" . $type . "\">\n";
    };
    output($os);
});
sgml('</enumerate>', sub{
    my $os = "</ol>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
    $enumdepth--;
});

# Element: item
sgml('<item>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "";
    if(($pan eq "defnlist")||($pan eq "citations")){
	$os = "<dt> ";
    }
    elsif(($pan eq "menu")||($pan eq "Menu")){
#	$os = "<li> ";
	$os = "<dd> "; # Using DL without DT's for GELLMU menu
                       # This has the advantage over HTML MENU of
                       # providing multiple paragraphs in items and
                       # lists in items.
    }
    elsif($pan eq "parlist"){
	$os = "";
    }
    elsif(($pan eq "enumerate")||($pan eq "itemize")){
        # Only "itemize" and "enumerate" should have labels;
        # defer output until any label is detected
	$itemlabel = "";
	$labelinitem = "";
	$os = "";
    }
    else{
	$os = "<li><p> ";
	$hpar_on = 1;
        # was always: "<li>"
    }
    output($os);
});
sgml('</item>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan eq "parlist"){
	$os="&#xA0;&#xA0;&#xA0;";
    }
    elsif(($pan eq "defnlist")||($pan eq "citations")){
	;
    }
    elsif($pan eq "menu"){
	$os = "</dd>";
    }

    elsif($pan eq "Menu"){
	if($xhtmlstrict == 1){
	    $os = $os . "</dd>";
	}
	else{
	    $os = "<br" . $clemp . "<br\n" . $clemp . "</dd>";
	};
    }
    else{
	if($hpar_on==1){
	    $os = $os . "</p>\n";
	    $hpar_on = 0;
	};
	$os = $os . "</li>";
    };
    $os = $os . "\n";
    output($os);
});

# Element: aos -- @-end-of-sentence mark if we are NOT in math mode
#              -- this should not be used in math mode, but ...
sgml('<aos>', sub{
    if($gmath_on == 1){
	output(".");
    }
    else{
	output(". ");
    }; # extra space is not an issue in HTML
});
sgml('</aos>', "");

# Element: aoc -- @-comma
sgml('<aoc>', ",");
sgml('</aoc>', "");

# Element: eos -- unequivocal end-of-sentence mark
sgml('<eos>', sub{
    if($gmath_on == 1){
	if($mathml == 1){
	    output("<mtext>.</mtext\n>");
	}
	elsif($dmath_on == 1){
	    output("&#xA0;&#xA0;.");
	} # period goes in display
	else{
	    output(". ");
	}; # end-of-math will add another
    }
    elsif($verb_on > 0){
	output(".");
    }
    else{
	output(".  ");
    };
});
sgml('</eos>', "");

# Element: eoq -- end of question sentence mark
sgml('<eoq>', sub{
    if($verb_on > 0){
	output("?");
    }
    elsif(($gmath_on == 1) && ($mathml == 1)){
	my $os = "<mtext>?</mtext>";
	output($os);
    }
    else{
	output("? ");
    };
});
sgml('</eoq>', "");

# Element: eoe -- end of exclamation sentence mark
sgml('<eoe>', sub{
    if($verb_on > 0){
	output("!");
    }
    elsif(($gmath_on == 1) && ($mathml == 1)){
	my $os = "<mtext>!</mtext>";
	output($os);
    }
    else{
	output("! ");
    };
});
sgml('</eoe>', "");

# Element: bsl -- abstract char "\"
# sgml('<bsl>', "\\");
sgml('<bsl>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	if($_[0]->within("csep") ne ""){
	    $os = "\\";
	}
	elsif($stretchChallenged == 1){
	    $os = '<mo stretchy="true" lspace="1en" rspace="1en">\\</mo>';
	}
	else{
	    $os = "<mo stretchy=\"true\">\\</mo>";
	};
    }
    else{
	$os = "\\";
    };
    output($os);
});
sgml('</bsl>', "");

# Element: lbr -- abstract char "{"
sgml('<lbr>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '{';
	}
	else{
	    $os = '<mo stretchy="true">{</mo>';
	};
	output($os);
    }
    else{
	output("{");
    };
});
sgml('</lbr>', "");

# Element: rbr -- abstract char "}"
sgml('<rbr>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '}';
	}
	else{
	    $os = '<mo stretchy="true">}</mo>';
	};
	output($os);
    }
    else{
	output("}");
    };
});
sgml('</rbr>', "");

# Element: lsb -- abstract char "["
sgml('<lsb>', sub{
    my $os = "[";
    if(($gmath_on == 1)&&($mathml == 1)){
	if($_[0]->within("csep") ne ""){
	    $os = '[';
	}
	else{
	    $os = '<mo stretchy="true">[</mo>';
	};
    };
    output($os);
});
sgml('</lsb>', "");

# Element: rsb -- abstract char "]"
sgml('<rsb>', sub{
     my $os = "]";
     if(($gmath_on == 1)&&($mathml == 1)){
	if($_[0]->within("csep") ne ""){
	    $os = ']';
	}
	else{
	    $os = '<mo stretchy="true">]</mo>';
	};
     };
     output($os);
});
sgml('</rsb>', "");

# Element: quo -- abstract char "\""
sgml('<quo>', sub{
    if ($inanchopt ==1){
	output('"');
    }
    else{
	output "&#x0022;";
    };
});
sgml('</quo>', "");

# Element: sol -- abstract char "/"
sgml('<sol>', sub{
    if (($mathml == 1) && ($gmath_on == 1) && (inanchopt == 0)){
	my $elt = $_[0];
	if($elt->within("csep") ne ""){
	    output("/");
	}
	elsif($dmath_on == 1){
	    output("&#x2044;");
	}
	else{
	    output("&#x2215;");
	};
    }
    else{
	output("/");
    };
});
sgml('</sol>', "");

# Element: eqc -- abstract char "="
sgml('<eqc>', sub{
    if (($gmath_on == 1)&&($inanchopt == 0)){
	output(" = ");}
    else{output("=");}
});
sgml('</eqc>', "");

# Element ldots
sgml('<ldots>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)
       && !($_[0]->parent->name =~ /^(mbox|text)$/)){
	if($mathmlp == 1){
	    $os = "<mi>&#x2026;</mi>";
	}
	elsif($mathmlc == 1){
	    $os = "<ci>&#x2026;</ci>";
	};
    }
    else{
	$os =     "&#x2026;";
    };
    output($os);
});
sgml('</ldots>', "");

# Element cdots
sgml('<cdots>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)
       && !($_[0]->parent->name =~ /^(mbox|text)$/)){
	if($mathmlp == 1){
	    $os = "<mi>&#x22EF;</mi>";
	}
	elsif($mathmlc == 1){
	    $os = "<ci>&#x22EF;</ci>";
	};
    }
    else{
	$os =     "&#x22EF;";
    };
    output($os);
});
sgml('</cdots>', "");

# Element: nbs -- non-breaking space (like LaTeX's "~")
sgml('<nbs>', sub{
    my $os = "&#xA0;";
    if(($gmath_on) && ($mathml == 1)){
	$os = '<mspace width="0.6em"/>';
    }
    output($os);
});
sgml('</nbs>', "");

# Element: hsf -- stretchy horizontal fill; cannot do with HTML
sgml('<hsf>', "");
sgml('</hsf>', "");

# Element: dotfill
sgml('<dotfill>', "...");
sgml('</dotfill>', "");

# Element: hrulefill
sgml('<hrulefill>', "___");
sgml('</hrulefill>', "");

# Element: spc -- ordinary blank (like LaTeX's "\ ")
sgml('<spc>', sub{
    my $elt = $_[0];
    my $pan = $elt->parent->name;
    my $os = " ";
    if($pan =~ /^(verb|quostr|qquostr|nln|text)$/){
	$os = "&#xA0;";
    };
    # if( ($tabdepth > 0) && (($gmath_on == 1) || ($sv_gmath_on == 1)) ){
    #	$os = "&#xA0;";
    # };
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mspace width="0.6em"/>';
    }
    elsif($unirow[$tabdepth] == 1){
	$os = "&#xA0;";
    };
    output($os);
});
sgml('</spc>', "");

# Element: hsp -- small horizontal space (like LaTeX's "\,")
sgml('<hsp>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mspace width="0.3em"/>';
        output($os);
    }
    elsif(($mathml == 0) && (($gmath_on == 1) || ($sv_gmath_on == 1))){
	output("&#xA0;");
    };
});
sgml('</hsp>', "");

# Element: quad -- triple space in math
sgml('<quad>', sub{
    my $os = "";
    if($mathml == 1){
	$os = '<mspace width="1.8em"/>';
    }
    else{
	$os = "&#xA0;&#xA0;&#xA0";
    };
    output($os);
});
sgml('</quad>', "");

# Element: Hsp -- *mandatory* small horizontal space (like LaTeX's "\,")
sgml('<Hsp>', sub{
    my $os = " ";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mspace width="0.3em"/>';
    }
    elsif(($mathml == 0) && (($gmath_on == 1) || ($sv_gmath_on == 1))){
	$os = "&#xA0;";
    }
    elsif($unirow[$tabdepth] == 1){
	$os = "&#xA0;";
    };
    output($os);
});
sgml('</Hsp>', "");

# Element: abbr -- content is an abbreviation (maybe for smallcaps)
sgml('<abbr>', "");
sgml('</abbr>', "");

# Element: latex
sgml('<latex>', "<em>LaTeX</em>");
sgml('</latex>', );

# Element: tex
sgml('<tex>', "<em>TeX</em>");
sgml('</tex>', );

# Element: emph -- emphasized
sgml('<emph>', sub{
    $emphdepth++;
    push_output('string');
});
sgml('</emph>', sub{
    my $pos = pop_output;
    my $os = "";
    my $elt = $_[0];
    my $pan = $elt->parent->name;
    if(($mathml == 1) &&
       (($elt->within("mbox") ne "") || ($elt->within("regch") ne "")) &&
       (($gmath_on == 1) || ($sv_gmath_on == 1))){
	$os = $pos;
    }
    elsif(($mathml == 1) && ($sv_gmath_on == 1) && ($pan eq "text")){
	$os = $pos;
	my $parchld = $elt->parent->attribute("mchld")->value;
	my $nsybs = scalar(split(',', $parchld));
	if($nsybs > 1){
	    $os = '</mtext><mspace width="0.2em" />';
	    $os = $os . '<mtext mathvariant="italic" class="emphasized">';
	    $os = $os . $pos;
	    $os = $os . '</mtext><mspace width="0.2em" /><mtext>';
	};
    }
    else{
	if($emphdepth%2 == 1){
	    $os = "<em>" . $pos . "</em>";
	}
	else{
	    # If $emphdepth is even, it must be 2 or more.
	    $os = "</em>" . $pos . "<em>";
	};
	$os =~ s?(\s*)</em>?</em>\1?g;
	$os =~ s?<em>(\s*)?\1<em>?g;
    };
    output($os);
    $emphdepth--;
});
sgml('<emph0>', "<em>");
sgml('</emph0>', "</em>");

# Element: Emph -- alternate emphasis
sgml('<Emph>', '<em class="altemph">');
sgml('</Emph>', '</em>');

# Element: EMPH -- very strong emphasis
sgml('<EMPH>', '<em class="bold-italic">');
sgml('</EMPH>', '</em>');

# This next is a hack.
# A perl file should have a consistent text encoding.
# The 'e' in etale is U+00E9.  With Latin-1 encoding it should be
# simply 0xE9 but with UTF-8 encoding it should arrive as 0xC30xA9 .
#  With this code an encoding mixup with this element will result in
# this script finding it to be undefined.  In this special case
# the UTF-8 encoding for U+00E9 is legal as ISO-8859-1 text.

# Element: Etale -- a French name (UTF-8 encoding)
sgml('<étale>', "<em>");
sgml('</étale>', "</em>");

# This is provided for ISO-8859-1.  However, the name is not legal text if
# this file is understood to have UTF-8 encoding.  Perl 5.6 seems to tolerate
# its presence in this script in a "C" locale when utf8 is enabled.  Later
# versions of perl well may not.

# Element: tale -- a French name (ISO-8859-1 encoding)
sgml('<tale>', "<em>");
sgml('</tale>', "</em>");

# Element: emph* -- another alternate form of emphasized
sgml('<emph*>', "**");
sgml('</emph*>', "**");

# Element: invr -- abstract inverse video
sgml('<invr>', "<em>");
sgml('</invr>', "</em>");

# Element: rdash -- range dash as in 1998-99
sgml('<rdash>', "&#x2013;");
sgml('</rdash>', "");

# Element: pdash -- punctuation dash -- like this
sgml('<pdash>', "&#x2014;");
sgml('</pdash>', "");

# Element: anch -- anchor (a visibly marked location)
#    Note -- anchs cannot be nested under "gellmu.dtd" (or HTML)
sgml('<anch>', sub{
    $inanch = 1;
    push_output('string');
});
sgml('</anch>', sub{
    my $pos = pop_output;
    my $os = "";
    $inanch = 0;
    my $hrs = "";
    my $elt = $_[0];
    my $alabel = "";
    my $attsr = $elt->attributes;
    my %atts = %$attsr;
    my $par = $elt->parent;
    my $pan = $par->name;
    # With MathML stronger assumptions if this anch is in text inside math:
    #  Assume no href attribute and reference is either iref or href inside
    #  anchref
    if(($mathml == 1) && ($sv_gmath_on == 1) && ($xlinkflag == 1)
       && ($pan eq "text")){
	$os = $os . "</mtext><mtext";
	$os = $os . ' xmlns:xlink="http://www.w3.org/1999/xlink"';
	$os = $os . ' xlink:type="simple"';
	$thisref = $anchref;
	if($thisref =~ /href=/){
	    $thisref =~ s/\s*href=\"//;
	    $thisref =~ s/\"\s*//;
	}
	elsif($thisref =~ /iref=/){
	    $thisref =~ s/\s*iref=\"/\#/;
	    $thisref =~ s/\"\s*//;
	};
	$os = $os . ' xlink:href="' . $thisref . '">';
	$os = $os . $pos . "</mtext><mtext>";
	output($os);
	return;
    };
    # The href attribute for anch needs to go.  It is unsound because
    #   things like "_" can be in hrefs.
    if(exists $atts{"name"}){
	if($elt->attribute("name")->value ne ""){
	    $alabel = $elt->attribute("name")->value;
	};
    };
    if(exists $atts{"href"}){
	if($elt->attribute("href")->value ne ""){
	    $hrs = $hrs . ' href="' . $elt->attribute("href")->value . '" ';
	};
    };
    if($haveanchopt == 1){
	$hrs = $hrs . $anchopt;
        $haveanchopt = 0;
    }
    elsif($anchref ne ""){
	$hrs = $hrs . $anchref;
	$anchref = ""; # reset for next anchor
    }
    else{
	print STDERR $WhoAmI, " WARNING: \"anch\" has no reference.\n", 
                     "   Looking at: \"", $pos, "\"\n";
    };
    if($hrs =~ /^\s*fref\s*=/){
	$fncount++;
	my $frs = $hrs;
	$frs =~ s/\s*fref\s*=\s*\"//;
	$frs =~ s/\"\s*$//;
	$fnote[$fncount] = $frs;
	if($xhtmlstrict == 1){
	    $hrs = 'id="revfnote' . $fncount . '" href="#fnote'
		. $fncount . '"';
	}
	else{
	    $hrs = 'name="revfnote' . $fncount . '" id="revfnote'
		. $fncount . '" href="#fnote' . $fncount . '"';
	};
    };
    if($hrs =~ /^\s*iref\s*=/){
	my $irs = $hrs;
	$irs =~ s/\s*iref\s*=\s*\"//;
	$irs =~ s/\"\s*$//;
	$hrs = 'href="#' . $irs . '"';
    };
    if($hrs =~ /[Hh]ref\s*=\s*\"/){
	$hrs =~ s/[Hh]ref\s*=\s*\"/href=\"/;
    };
    $os = "<a " . $hrs . ">" . $pos . "</a>";
    output($os);
});

# Element: anchref
sgml('<anchref>', sub{
    push_output('string');
});
sgml('</anchref>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = $pos;
    # Could also provide some error checking when writing classical markup
    if($xhtmlstrict == 1){
	if($os =~ /name=/){
	    $os =~ s/name=/id=/;
	    if($os =~ /name=/){
		my $name = $elt->name;
		print STDERR $WhoAmI,': WARNING -- Multiple name specs in "',
		$name,'" at line ',$ev->line,' in file "',$ev->file,"\"\n";
	    };
	};
    };
    $anchref = $os;
});

# Element: anchv
sgml('<anchv>', sub{
    push_output('string');
});
sgml('</anchv>', sub{
    my $pos = pop_output;
    output($pos);
});

# Element: footnote -- LaTeX-like: can have paragraph content, not only plain.
sgml('<footnote>', sub{
    $fnsvhpar = $hpar_on;
    $hpar_on = 0;
    push_output('string');
});
sgml('</footnote>', sub{
    my $os = "";
    my $pos = pop_output;
    my $hrs = "";
    my $id = "";
    if($hpar_on == 1){
	$pos = $pos . "</p>\n";
	$hpar_on = 0;
    };
    $fncount++;
    $fnote[$fncount] = $pos;
    $id = "fnote" . $fncount;
    if($xhtmlstrict == 1){
	$os = '<sup><a id="rev' . $id . '" href="#' . $id . '">'
	    . $fncount . '</a></sup>';
    }
    else{
	$os = '<sup><a name="rev' . $id . '" id="rev' . $id . '" href="#'
	    . $id . '">' . $fncount . '</a></sup>';
    };
    output($os);
    $hpar_on = $fnsvhpar;
});

# Element: urlanch -- HTML-like anchor with visible = *absolute* URL
sgml('<urlanch>', sub{
    push_output('string');
});
sgml('</urlanch>', sub{
    my $os = "";
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if(length($pos) == 0){
	$os = "[Location of empty URL-anchor]";
    }
    else{
	my $url = $pos;
	$url =~ s/^\s*//;
	$url =~ s/\s*$//;
	if(($mathml == 1) && ($sv_gmath_on == 1) && ($xlinkflag == 1)
	   && ($pan eq "text")){
	    $os = $os . "</mtext><mtext";
	    $os = $os . ' xmlns:xlink="http://www.w3.org/1999/xlink"';
	    $os = $os . ' xlink:type="simple"';
	    $os = $os . ' xlink:href="' . $url;
	    $os = $os . '" mathvariant="monospace" class="stringtext">';
	    $os = $os . $url . "</mtext><mtext>";
	}
	else{
	    $os = "<a href=\"" . $url . "\"><kbd>" . $url . "</kbd></a>";
	};
    };
    output($os);
});

# Element: urnanch -- Not supported here

# Element: opt -- has this ever been used ???  Probably on the way out.
sgml('<opt>', sub{
    if($inanch == 1){
    $haveanchopt = 1;
    $inanchopt = 1;  # used to flag handling of <quo>
    push_output('string');
};});
sgml('</opt>', sub{
    if ($haveanchopt == 1){
        $anchopt = pop_output ;
        $inanchopt = 0;
    };
});

# This code should work with old docs formatted directly from article/SGML
# The new regime, however, dictates that everything now run through
# here must come from article/XML, and op0 does not exist in article/XML.
# Consequently, this code is no longer being maintained.
# Element: op0
sgml('<op0>', sub{
    push_output('string');
    if($inanch == 1){
	$haveanchopt = 1;
	$inanchopt = 1;  # used to flag handling of <quo>
    };
});
sgml('</op0>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if ($haveanchopt == 1){
	$inanchopt = 0;
    };
    if($pan eq "anch"){
	$anchopt = $pos;
	$haveanchopt = 1;
    }
    elsif($pan eq "sqrt"){
	$sqrtopt[$sqrtdepth] = $pos;
    }
    elsif($pan eq "table"){
	if($pos eq "t"){
	    $tabopt[$tabdepth] = " valign=\"top\"";
	}
	elsif($pos eq "b"){
	    $tabopt[$tabdepth] = " valign=\"bottom\"";
	}
	else{
	    $tabopt[$tabdepth] = "";
	};
    }
    else{
	$os = "{ELT " . $_[0]->name . " IN " . $pan . "***". $pos . "*}";
    };
    output($os);
});

# This code should work with old docs formatted directly from article/SGML
# The new regime, however, dictates that everything now run through
# here must come from article/XML, and ag0 does not exist in article/XML.
# Consequently, this code is no longer being maintained.
# Element: ag0 -- auto-generated command argument
sgml('<ag0>', sub{
    push_output('string');
    my $pan = $_[0]->parent->name;
    if(($pan eq "Section")||($pan eq "Subsection")||($pan eq "Subsubsection")){
	my $lvl = $sec_level;
        $sec_hdr_num = $lvl + 2;
	my $ssn = "";
	if(($lvl == 1)&&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial;
	}
	elsif(($lvl == 2)&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial . "." . $subsec_serial;
	}
	elsif(($lvl == 3)&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial . "." . $subsec_serial . ".";
	    $ssn = $ssn . $subsubsec_serial;
	}
	else{
	    $ssn = "";
	}
	$sech_os = "\n<h" . $sec_hdr_num . " align=\"left\">";
	if($ssn ne ""){
	    $sech_os = $sech_os . $ssn . ".  ";
	};
    }
    elsif($pan eq "anch"){
	;
    }
    elsif($pan =~ /^table/){
	;
    }
    elsif($pan =~ /^mtable/){
	;
    }
    elsif($pan eq "frac"){
	$frid[$fracdepth]++;
    }
    elsif($pan eq "binom"){
	$binargid++;
    }
    elsif($pan eq "sqrt"){
	;
    }
    else{
	output("{*ELT " . $_[0]->name . " IN " . $pan);
    };
});
sgml('</ag0>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if(($pan eq "section")||($pan eq "subsection")||($pan eq "subsubsection")){
	my $os = "*ELT " . $pan . " should not contain ag0.*";
	output($os);
    }
    elsif(
    ($pan eq "Section")||($pan eq "Subsection")||($pan eq "Subsubsection")){
	$new_sec = 0;
	my $ts = $pos;  #mandatory section header
	$sech_os = $sech_os . $ts . "</h" . $sec_hdr_num . ">\n";
	output($sech_os);
    }
    elsif($pan eq "anch"){
	my $os = $pos;
	output($os);
    }
    elsif($pan =~ /^table/){
    #  Was:  elsif(($pan eq "table")||($pan eq "tablec")){
	$tabarg[$tabdepth] = $pos;
    }
    elsif($pan =~ /^mtable/){
	$tabarg[$tabdepth] = $pos;
    }
    elsif($pan eq "frac"){
	if($frid[$fracdepth] == 1){
	    $numr[$fracdepth] = $pos;
	}
	elsif($frid[$fracdepth] == 2){
	    $denm[$fracdepth] = $pos;
	}
	else{
	    $os = "Fraction management error in codelets\n"
              . "fraction serial: " . $fracser           . "\n"
              . " fraction depth: " . $fracdepth         . "\n"
              . "    arg. number: " . $frid[$fracdepth]  . "\n"
              . "      numerator: " . $numr[$fracdepth]  . "\n"
              . "    denominator: " . $denm[$fracdepth]  . "\n";
	    die $os;
	}
    }
    elsif($pan eq "binom"){
	if($binargid == 1){
	    $binomu = $pos;
	}
	elsif($binargid == 2){
	    $binoml = $pos;
	}
	else{
	    print STDERR "Code Error for binom tag arg handling\n";
	    die;
	};
    }
    elsif($pan eq "sqrt"){
	$sqrtarg[$sqrtdepth] = $pos;
    }
    else{
	output("*}");
    };
});

# Element: sopt -- option for Section, Subsection, or Subsubsection
sgml('<sopt>', sub{
    push_output('string');
});
sgml('</sopt>', sub{
    $sopt = pop_output;
});

# Element: shead -- header for Section, Subsection, or Subsubsection
sgml('<shead>', sub{
    push_output('string');
    $sech_os = "";
    my $lvl = $sec_level;
    $sec_hdr_num = $lvl + 2;
    my $ssn = "";
    # Old code is kept here for backward compatibility
    if($sunitflag == 0){
	if(($lvl == 1)&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial;
	}
	elsif(($lvl == 2)&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial . "." . $subsec_serial;
	}
	elsif(($lvl == 3)&($lvl <= $secnumdepth)){
	    $ssn = $sec_serial . "." . $subsec_serial . ".";
	    $ssn = $ssn . $subsubsec_serial;
	}
	else{
	    $ssn = "";
	}
    }
    elsif($lvl <= $secnumdepth){
	$ssn = $sunit;
    };
    my $pan = $_[0]->parent->name;
    if($pan eq "Section"){
	$sech_os = $sech_os . "\n<div " . 'class="section">';
    }
    elsif($pan eq "Subsection"){
	$sech_os = $sech_os . "\n<div " . 'class="subsection">';
    }
    elsif($pan eq "Subsubsection"){
	$sech_os = $sech_os . "\n<div " . 'class="subsubsection">';
    }
    else{
	$sech_os = $sech_os . "\n<div>";
    };
    $sech_os = $sech_os . "\n<h" . $sec_hdr_num . ">";
    my $nonum = 0;
    if($_[0]->parent->attribute("nonum")->value eq "true"){
	$ssn = "";
    };
    if($sprefix ne ""){
	$sech_os = $sech_os . $sprefix;
	$sech_os =~ s/\s*$/\&#xA0;/;
    };
    if( !($ssn =~ /^\s*$/) ){
	$sech_os = $sech_os . $ssn . ".&#xA0;&#xA0;";
    }
    elsif($sprefix ne ""){
	$sech_os = $sech_os . "&#xA0;";
    };
});
sgml('</shead>', sub{
    $new_sec = 0;
    my $ts = pop_output;  #mandatory section header
    $sech_os = $sech_os . $ts . "</h" . $sec_hdr_num . ">\n";
    output($sech_os);
});

# Element: foox --
sgml('<foox>', "");
sgml('</foox>', "");

# Element: quostr -- like \texttt in LaTeX, surrounding quotes, if desired
#                 should be in the original markup as \quo; or use qquostr
sgml('<quostr>', "<kbd>");
sgml('</quostr>', "</kbd>");

# Element: qquostr
sgml('<qquostr>', '&#x201C;<kbd>');
sgml('</qquostr>', '</kbd>&#x201D;');

# Element: quochar --
sgml('<quochar>', '&#x2018;<kbd>');
sgml('</quochar>', "</kbd>&#x2019;");

# Element: quophrase --
sgml('<quophrase>',   '&#x201C;');
sgml('</quophrase>',  '&#x201D;');

# Element: squophrase --
sgml('<squophrase>',  '&#x2018;');
sgml('</squophrase>', '&#x2019;');

# Element: path -- a filesystem pathname
sgml('<path>', "<kbd>");
sgml('</path>', "</kbd>");

# Element: dummy -- replaceable part of code
sgml('<dummy>', "&lt;<em>");
sgml('</dummy>', "</em>&gt;");

# Element: hrule -- horizontal rule
sgml('<hrule>', sub{
    my $os = "<hr" . $clemp;
    output($os);
});
sgml('</hrule>', "");

# For experimentation
# Element: hruleT -- horizontal rule
sgml('<hruleT>', sub{
    my $os = "\n<hr class=\"test\"" . $clemp . "\n";
    output($os);
});
sgml('</hruleT>', "");

# Element: hyp -- abstract hyphen (deliberate, but could be "minus")
sgml('<hyp>', "-");
sgml('</hyp>', "");

# Generic handlers

sgml('start_element', sub{
    $unknown_elements++;
    print {STDERR} "Unknown element: ", $_[0]->name, "\n";
    output("*ELT " . $_[0]->name . "*");
    push_output('string');
});

sgml('end_element',sub{
    my $os = pop_output;
    output($os . "**");
});

sgml('cdata',sub{
    my $os = $_[0];
#     if(($gmath_on == 1) && ($tabdepth > 0)){
# 	$os =~ s/\s/&#xA0;/g;
#     };
    if($unirow[$tabdepth] == 1){
	$os =~ s/\s\s+/&#xA0;&#xA0;/g;
	$os =~ s/\s/&#xA0;/g;
    };
    output($os);
});

sgml('sdata',sub { die "Unknown SDATA: " . $_[0]; });

sgml('re',sub{
    my $os = "\n";
    if($isxml == 1){
	$os = "";
    }
    elsif($unirow[$tabdepth] == 1){
	$os = "&#xA0;";
    };
    output($os);
});

sgml('pi', sub{
    my $inst = $_[0];
    my $os = "";
    if($inst =~ /^xml/){
	if($isxml == 0){
	    $isxml = 1;
	};
    }
    elsif($inst =~ /centralStyled/){
	;
    }
    elsif($inst =~ /^gellmu/){
	;
    }
    else{
	print STDERR $WhoAmI, " *** Unknown processing instruction:\n",
	"     ", $inst . "\n";
    };
});

sgml('entity',sub { die "Unknown external entity: " . $_[0]->name; });

sgml('start_subdoc',sub { die "Unknown subdoc entity: " . $_[0]->name; });

# sgml('end_subdoc','');

# sgml('conforming','');

sub on_math{
    $math_on = 1;
    $gmath_on = 1;
    if($asstbodyflag == 1){
	# output("</em>");
    };
};

sub off_math{
    if($asstbodyflag == 1){
	# output("<em>");
    };
    $math_on = 0;
    $gmath_on = 0;
};

sub on_dmath{
# We've got to lie to HTML about paragraphs since a display will use
# a centered paragraph when it is already inside one.  Hmmm... maybe
# we should use html-blockquote.
    # $dmathpan is defined as local in the caller, sgml->'</displaymath>'
    $dmath_on = 1;
    $tabdepth++;
    $unirow[$tabdepth] = 1;
    # 20030718
    my $os = "";
    $eqinhpar = 0;
    if($asstbodyflag == 1){
	if($asstbodyhpar == 1){
	    # $os = $os . "</em></p>\n";
	    $os = $os . "</p>\n";
	    $eqinhpar = 1;
	    $asstbodyhpar = 0;
	}
	else{
	    # $os = $os . "</em>";
	    $os = $os;
	};
    }
    else{
	if($hpar_on == 1){
	    $os = $os . "</p>\n";
	    $eqinhpar =1;
	    $hpar_on = 0;
	}
	else{
	    ;
	};
    };
    output($os);
    push_output('string');
    $gmath_on = 1;
};

sub off_dmath{
    $gmath_on = 0;
    $dmath_on = 0;
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    #20030718
    my $os = "";
    $pos = pop_output;
    $os = $os . "$ctrbo<table cellspacing=\"0\" cellpadding=\"0\"><tr><td>\n"
	. $pos . "\n</td></tr></table>$ctrbc";
    if(($para_on == 1)&&($tabdepth==0)&&($eqinhpar == 1)){
	$eqinhpar = 0;
	if($asstbodyflag == 1){
	    # $os = $os . "\n<p><em>";
	    $os = $os . "\n<p>";
	    $asstbodyhpar = 1;
	}
	else{
	    $os = $os . "\n<p>";
	    $hpar_on = 1;
	};
    }
    elsif($eqinhpar == 1){
	# For example, para_on is off for Section>enumerate>item>displaymath
        # This code may not be fully adequate
	# print STDERR "off_dmath: (para_on, tabdepth) = (" . $para_on .
	#    ", " . $tabdepth . ")\n";
	$eqinhpar = 0;
	if($asstbodyflag == 1){
	    # $os = $os . "<p><em>";
	    $os = $os . "<p>";
	    $asstbodyhpar = 1;
	}
	else{
	    $os = $os . "<p>";
	    $hpar_on = 1;
	};
    }
    elsif($asstbodyflag == 1){
	# os = $os . "<em>";
    };
    output($os);
};

sub on_mathml{
    $math_on = 1;
    $gmath_on = 1;
    my $os = "";
    if($asstbodyflag == 1){
	# os = $os . "</em>";
    };
    $os = $os . '<math xmlns="' . $mathns . '" mode="inline"' . "\n>";
    $stolvl = 0;
    output($os);
};

sub off_mathml{
    my $os = "";
    $os = $os . "</math\n>";
    if($stolvl != 0){
	print STDERR $WhoAmI, " WARNING: Store unbalanced in \"math\"\n";
    };
    if($asstbodyflag == 1){
	# os = $os . "<em>";
    };
    output($os);
    $math_on = 0;
    $gmath_on = 0;
};

sub on_dmathml{
    # $dmathpan is defined as local in the caller, sgml->'</displaymath>'
    $dmath_on = 1;
    $gmath_on = 1 ;
    my $os = "";
    if($asstbodyflag == 1){
	# os = $os . "</em>";
    };
    $os = $os . "\n" . '<math xmlns="' . $mathns
	. '" display="block" mode="display"' . "\n>";
    $stolvl = 0;
    output($os);
};

sub off_dmathml{
    my $os = "";
    $os = $os . "</math>\n";
    if($stolvl != 0){
	print STDERR $WhoAmI,
	" WARNING: Store unbalanced in \"displaymath\"\n";
    };
    if($asstbodyflag == 1){
	# os = $os . "<em>";
    };
    output($os);
    $gmath_on = 0 ;
    $dmath_on = 0;
};

# Element: documentclass
sgml('<documentclass>', sub{
    push_output('nul');
});
sgml('</documentclass>', sub{
    pop_output;
});

# Element: dclass
sgml('<dclass>', "");
sgml('</dclass>', "");

# Element: dstyle
sgml('<dstyle>', "");
sgml('</dstyle>', "");

# Element: address
sgml('<address>', sub{
    push_output('string');
});
sgml('</address>', sub{
    my $pos = pop_output;
    if($authorseq == 0){
	print STDERR "WARNING: Address with no author?\n";
    }
    else{
	if($authoraddr[$authorseq] ne ""){
	    # Not the first address for this author
	    $authoraddr[$authorseq] = $authoraddr[$authorseq] . "<br\n" 
		. $clemp;
	};
	$authoraddr[$authorseq] = $authoraddr[$authorseq] . $pos;
    };
});

# Element: email
sgml('<email>', sub{
    push_output('string');
});
sgml('</email>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if($authorseq == 0){
	print STDERR "WARNING: 'email' container with no author\n",
                     "         Do you mean to use 'eaddr'?";
    }
    elsif($pan ne "preamble"){
	print STDERR "WARNING: 'email' container outside of 'preamble'?\n",
                     "         Do you mean to use 'eaddr'?";
    }
    else{
	$haveemail[$authorseq]++;
	if($haveemail[$authorseq] > 1){
	    # Not the first email address for this author
	    $authoremail[$authorseq] = $authoremail[$authorseq] . "<br\n" 
		. $clemp;
	};
	$authoremail[$authorseq] = $authoremail[$authorseq] . $pos;
    };
});

# Element: date
sgml('<date>', sub{
  push_output('string');
});
sgml('</date>', sub{
    $havedate = 1;
    my $s = pop_output;
    $datestr = $s;
});

# Element: copynotice
sgml('<copynotice>', sub{
  push_output('string');
});
sgml('</copynotice>', sub{
    my $s = pop_output;
    $copynotice = $s;
});

# Element: keywords
sgml('<keywords>', sub{
    push_output('nul');
});
sgml('</keywords>', sub{
    pop_output;
});

# Element: input
sgml('<input>', "");
sgml('</input>', "");

# Element: Section -- arising from "\begin{Section}...\end{Section}"
#                  section header (or "title") is shead or ag0 content
sgml('<Section>', sub{
    $new_sec = 1;
    $sec_serial++;
    $subsec_serial = 0;
    $sec_level = 1;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
});
sgml('</Section>', "</div>\n");

# Element: section -- LaTeX-like: elt. content is section "title"
sgml('<section>', sub{
    $new_sec = 1;
    $sec_serial++;
    $subsec_serial = 0;
    $sec_level = 1;
    $sopt = ""; # necessary ?
    push_output('string');
});
sgml('</section>', sub{
    my $pos = pop_output;
    my $lvl = $sec_level + 2;
    my $os = "\n<h" . $lvl . ">";
    if($sec_level <= $secnumdepth){
	$os = $os . $sec_serial . ".  ";
    }
    $os = $os .  $pos . "</h" . $lvl . ">\n";
    output($os);
});

# Element: Subsection
sgml('<Subsection>', sub{
    $new_sec = 1;
    $subsec_serial++;
    $subsubsec_serial = 0;
    $sec_level = 2;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
});
sgml('</Subsection>', "</div>\n");

# Element: subsection -- LaTeX-like: elt. content is section "title"
sgml('<subsection>', sub{
    $new_sec = 1;
    $subsec_serial++;
    $subsubsec_serial = 0;
    $sec_level = 2;
    $sopt = ""; # necessary ?
    push_output('string');
});
sgml('</subsection>', sub{
    my $pos = pop_output;
    my $lvl = $sec_level + 2;
    my $os = "\n<h" . $lvl . ">";
    if($sec_level <= $secnumdepth){
	$os = $os . $sec_serial . "." . $subsec_serial . ".  ";
    }
    $os = $os .  $pos . "</h" . $lvl . ">\n";
    output($os);
});

# Element: Subsubsection
sgml('<Subsubsection>', sub{
    $new_sec = 1;
    $subsubsec_serial++;
    $sec_level = 3;
    $sopt = "";
    $sprefix = "";
    $sunit = "";
    $sunitflag = 0;
});
sgml('</Subsubsection>', "</div>\n");

# Element: subsubsection -- LaTeX-like: elt. content is section "title"
sgml('<subsubsection>', sub{
    $new_sec = 1;
    $subsubsec_serial++;
    $sec_level = 3;
    $sopt = ""; # necessary ?
    push_output('string');
});
sgml('</subsubsection>', sub{
    my $pos = pop_output;
    my $lvl = $sec_level + 2;
    my $os = "\n<h" . $lvl . ">";
    if($sec_level <= $secnumdepth){
	$os = $os . $sec_serial . "." . $subsec_serial .
              "." . $subsubsec_serial . ".  ";
    }
    $os = $os .  $pos . "</h" . $lvl . ">\n";
    output($os);
});

# Element: verbatim
sgml('<verbatim>', sub{
    my $os = "";
    if($hpar_on == 1){
	$os = $os . "</p>\n";
    };
    $hpar_on = 0;
    $os = $os . "<pre>\n\n";
    output($os);
});
sgml('</verbatim>', sub{
    my $os = "\n</pre>\n";
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	$os = $os . "\n<p>";
	$hpar_on = 1;
    };
    output($os);
});

# Element: supsupsuphdr
sgml('<supsupsuphdr>', "\n<h1>");
sgml('</supsupsuphdr>', "</h1>");

# Element: supsuphdr
sgml('<supsuphdr>', "\n<h1>");
sgml('</supsuphdr>', "</h1>");

# Element: suphdr
sgml('<suphdr>', "\n<h2>");
sgml('</suphdr>', "</h2>");

# Element: hdr
sgml('<hdr>', "\n<h3>");
sgml('</hdr>', "</h3>");

# Element: subhdr
sgml('<subhdr>', "\n<h4>");
sgml('</subhdr>', "</h4>");

# Element: subsubhdr
sgml('<subsubhdr>', "\n<h5>");
sgml('</subsubhdr>', "</h5>");

# Element: supsupsuphdrc
sgml('<supsupsuphdrc>', "\n<h1 " . $ctratt . ">");
sgml('</supsupsuphdrc>', "</h1>");

# Element: supsuphdrc
sgml('<supsuphdrc>', "\n<h1 " . $ctratt . ">");
sgml('</supsuphdrc>', "</h1>");

# Element: suphdrc
sgml('<suphdrc>', "\n<h2 " . $ctratt . ">");
sgml('</suphdrc>', "</h2>");

# Element: hdrc
sgml('<hdrc>', "\n<h3 " . $ctratt . ">");
sgml('</hdrc>', "</h3>");

# Element: subhdrc
sgml('<subhdrc>', "\n<h4 " . $ctratt . ">");
sgml('</subhdrc>', "</h4>");

# Element: subsubhdrc
sgml('<subsubhdrc>', "\n<h5 " . $ctratt . ">");
sgml('</subsubhdrc>', "</h5>");

# Note: Lamport, edition 2, in a footnote labels "paragraph" and
#  "subparagraph" as unfortunate.  We'll not number it.
# Element: paragraph
sgml('<paragraph>', sub{
    $para_on = 1;
    $hpar_on = 1;
    output("\n<p>");
});
sgml('</paragraph>', sub{
    $para_on = 0;
    if($hpar_on == 1){
	output("</p>\n");
	$hpar_on = 0;
    }
});

# Element: subparagraph -- This needs work IF we support it.
#  Here, certainly, we do not need to think about $para_on .
sgml('<subparagraph>', "</p>\n<p>");
sgml('</subparagraph>', "</p>\n<p>");

# Element: mtable -- table in math mode
sgml('<mtable>', sub{
    my $os = "";
    if(($mathml == 0) && ($unirow[$tabdepth]==1)){
	$os = $os . "</td><td>";
    };
    $tabdepth++;;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    $tabopt[$tabdepth] = "";
    if($mathml == 1){
	$os = $os . "<mtable\n>";
    }
    else{
	$unirow[$tabdepth] = 1;
	$os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"\n>";
    };
    output($os);
});
sgml('<mtable0>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if(($pan =~ /$parasregexp/) && ($mathml == 0)){
	my $pan = $_[0]->parent->name;
	# These days mtable cannot occur outside of math
	if(($pan ne "td")&&($pan ne "th")&&($pan ne "item")
	   &&($pan ne "itembody")&&($pan ne "desc")&&($hpar_on==1)){
	    $hpar_on = 0;
	    $os = $os . "</p>\n";
	};
    };
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $tabdepth++;
    if($mathml == 1){
	$os = $os . "<mtable\n>";
    }
    else{
	$os = $os . "<table><tbody\n>";
    };
    output($os);
});
sgml('</mtable>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    if($mathml == 1){
	$os = $os . "</mtable\n>";
    }
    else{
	$os = $os . "</table>\n";
	$unirow[$tabdepth] = 0;
    };
    $tabdepth--;
    if(($mathml == 0) && ($unirow[$tabdepth]==1)){
	$os = $os . "</td><td>";
    };
    output($os);
});
sgml('</mtable0>',sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtable\n>";
    }
    else{
	$os = $os . "</tbody></table>\n";
    };
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    my $pan = $_[0]->parent->name;
    if(($pan =~ /$parasregexp/) && ($mathml == 0)){
	my $pan = $_[0]->parent->name;
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: tabarg
sgml('<tabarg>', sub{
    push_output('string');
});
sgml('</tabarg>', sub{
    $tabarg[$tabdepth] = pop_output;
    my @tbargv = split(//, $tabarg[$tabdepth]);
    my $len = scalar @tbargv;
    my $jj = 0;
    my $kk = 0;
    $tabasyn[$tabdepth][$kk] = "";
    while($jj < $len){
	if($tbargv[$jj] =~ /[clpr]/){
	    $kk++;
	    $tabasym[$tabdepth][$kk] = $tbargv[$jj];
	    $tabasyn[$tabdepth][$kk] = "";
	}
	else {
	    $tabasyn[$tabdepth][$kk] = $tabasyn[$tabdepth][$kk] . $tbargv[$jj];
	};
	$jj++;
    };
    $tabalen[$tabdepth] = $kk;  # Index to @tabasym[$tabdepth] starts at 1
});

# Element: tabopt
sgml('<tabopt>', sub{
    push_output('string');
});
sgml('</tabopt>', sub{
    my $pos = pop_output;
    if($pos eq "t"){
	$tabopt[$tabdepth] = " valign=\"top\"";
    }
    elsif($pos eq "b"){
	$tabopt[$tabdepth] = " valign=\"bottom\"";
    }
    else{
	$tabopt[$tabdepth] = "";
    };
});

# Element: table -- general
sgml('<table>', sub{
    my $os = "";
    $tabdepth++;;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    $tabopt[$tabdepth] = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")&&
    #	   !($pan =~ /^(td|tdc|tdp|tdr)$/) &&($pan ne "th")
    #	   &&($pan ne "desc")&&($hpar_on==1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    # tbody may help with CSS sanity
    $os = $os . "<table><tbody>\n";
    output($os);
});
sgml('</table>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    $os = $os . "</tbody></table>\n";
    $tabdepth--;
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")&&($tabdepth==0)){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element: tableb -- table, boxed and centered
sgml('<tableb>', sub{
    my $os = "";
    $tabdepth++;;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")
    #	   && !($pan =~ /^(td|tdc|tdp|tdr)$/) &&($pan ne "th")
    #	   &&($pan ne "desc")&&($hpar_on==1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    my $bordatt=" border='border'";
    if($xhtml == 1){
	$bordatt="";
    }
    $os = $os . $ctrbo . '<table class="boxed"' . $bordatt . "><tbody>\n";
    output($os);
});
sgml('</tableb>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    $os = $os . "</tbody></table>$ctrbc\n";
    $tabdepth--;
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")&&($tabdepth==0)){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element: tablec -- centered table
sgml('<tablec>', sub{
    my $os = "";
    $tabdepth++;;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")
	#   && !($pan =~ /^(td|tdc|tdp|tdr)$/) &&($pan ne "th")
	#   &&($pan ne "desc")&&($hpar_on==1)){
	#    $hpar_on = 0;
	#    $os = $os . "</p>\n";
	# };
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $os = $os . "$ctrbo<table><tbody>\n";
    output($os);
});
sgml('</tablec>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    $os = $os . "</tbody></table>$ctrbc\n";
    $tabdepth--;
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")&&($tabdepth==0)){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element: tablech -- left justified "chart", not boxed
sgml('<tablech>', sub{
    my $os = "";
    $tabdepth++;;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    $tabopt[$tabdepth] = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")
    #	   && !($pan =~ /^(td|tdc|tdp|tdr)$/)
    #	   &&($pan ne "th")&&($pan ne "desc")&&($hpar_on==1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    $os = $os . "<table class=\"chart\"><tbody>\n";  # For sanity with CSS
    output($os);
});
sgml('</tablech>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    $os = $os . "</tbody></table>\n";
    $tabdepth--;
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")&&($tabdepth==0)){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

sgml('<old-tablech>', sub{
    $tabdepth++;
    $tabrowseq[$tabdepth] = 0;
    $tabarg[$tabdepth] = "";
    output("<table class=\"chart\"><tbody>\n");
});
sgml('</old-tablech>',sub{
    my $os = "";
    my $tatts = "";
    # Deal with last row
    my $mseq = $tabrowseq[$tabdepth];  # the last row
    if($tabrowcurr[$tabdepth] ne ""){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = $os . "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
    };
    $os = $os . "</tbody></table>\n";
    $tabdepth--;
});

# Element: trule -- table wide horizontal rule (automatic with borders)
sgml('<trule>', sub{
    $tabrowseq[$tabdepth]++;
    my $rseq = $tabrowseq[$tabdepth];
    $tabrowtype[$tabdepth][$rseq] = "trule";
    # Deal with previous row
    my $mseq = $rseq - 1;
    if(($tabrowseq[$tabdepth] >= 2)&&($tabrowcurr[$tabdepth] ne "")){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="boxed"';
	}
	else{
	    $tatts = ' class="bruled"';
	};
	$os = "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
	output($os);
    };
});
sgml('</trule>',"");

# Element: emprow -- empty table row; browser rendering of this is
#                    somewhat unpredictable, especially with borders,
#                    but it *is* valid.  (The cell is formally non-empty.)
sgml('<emprow>', sub{
    $tabrowseq[$tabdepth]++;
    my $os = "";
    my $es = "";
    my $tatts = "";
    my $catts = "";
    my $ncols = $tabalen[$tabdepth];
    my $rseq = $tabrowseq[$tabdepth];
    $tabrowtype[$tabdepth][$rseq] = "emprow";
    # Deal with previous row
    my $mseq = $rseq - 1;
    if(($tabrowseq[$tabdepth] >= 2)&&($tabrowcurr[$tabdepth] ne "")){
	if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
	    $tatts = ' class="truled"';
	};
	$os = "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$tabrowcurr[$tabdepth] = "";
	output($os);
    };
    # Make the sole cell for this empty row
    $es = $es . '<td colspan="' . $ncols . '"';
    if($tabasyn[$tabdepth][0] =~ /\|$/){
	$catts = ' class="lruled"';
	if($tabasyn[$tabdepth][$ncols] =~ /\|$/){
	    $catts = ' class="boxed"';
	}
    }
    elsif($tabasyn[$tabdepth][$ncols] =~ /\|$/){
	$catts = ' class="rruled"';
    };
    $es = $es . $catts . "> </td>";
    $tabrowcurr[$tabdepth] = $es;
});
sgml('</emprow>',"");

# Element: tr  # stage outputting the rows of regular tables -- tr, trule
#    and emprow -- so that borders can be handled by row attributes (for CSS)
#    class = "boxed", "truled", or bruled"
#    More is needed to support separate cell borders
sgml('<tr>', sub{
    my $elt = $_[0];
    $tabaseq[$tabdepth] = 0;
    my $os = "";
    if(($gmath_on == 1)&&($mathml == 1)&&($elt->within("mtable") ne "")){
	$os = "<mtr>";
	output($os);
    }
    else{   # deal with previous row
	my $tatts = "";
	$tabrowseq[$tabdepth]++;
	my $rseq = $tabrowseq[$tabdepth];
	$tabrowtype[$tabdepth][$rseq] = "tr";
	my $mseq = $rseq - 1;
	if(($tabrowseq[$tabdepth] >= 2)&&($tabrowcurr[$tabdepth] ne "")){
	    if($tabrowtype[$tabdepth][$mseq-1] eq "trule"){
		$tatts = ' class="truled"';
	    };
	    $os = "<tr" . $tatts . ">" . $tabrowcurr[$tabdepth] . "</tr\n>";
	    $tabrowcurr[$tabdepth] = "";
	    output($os);
	};
	#  Now handle the current row
	push_output('string');
    };
});
sgml('</tr>', sub{
    my $elt = $_[0];
    my $os = "";
    my $pos = "";
    my $ncols = 0;
    my $acols = 0;
    my $dcols = 0; 
    my $catts = "";
    if(($gmath_on == 1)&&($mathml == 1)&&($elt->within("mtable") ne "")){
	$os = "</mtr\n>";
	output($os);
    }
    else{
	# Eventually  $os = "<tr>" . $tabrowcurr[$tabdepth] . "</tr\n>";
	$pos = pop_output;
	$os = $pos;
	$ncols = $tabalen[$tabdepth];
	$acols = $tabaseq[$tabdepth];
	if($acols < $ncols){
	    # Add an empty cell spanning the missing columns
	    $dcols = $ncols - $acols;
	    $os = $os . '<td colspan="' . $dcols . '"';
	    if($tabasyn[$tabdepth][$acols] =~ /\|$/){
		$catts = ' class="lruled"';
		if($tabasyn[$tabdepth][$ncols] =~ /\|$/){
		    $catts = ' class="boxed"';
		}
	    }
	    elsif($tabasyn[$tabdepth][$ncols] =~ /\|$/){
		$catts = ' class="rruled"';
	    }
	    $os = $os . $catts . "></td>";
	};
	# pass assembled cells through
	$tabrowcurr[$tabdepth] = $os;
    };
});

# Element: trb -- not used
sgml('<trb>', "<tr>");
sgml('</trb>',"</tr>\n");

# Element: trc -- not used
sgml('<trc>', "<tr>");
sgml('</trc>',"</tr>\n");

# Element: th
sgml('<th>', "<th>");
sgml('</th>',"</th>\n");

# Element: thc -- not used
sgml('<thc>', "<th>");
sgml('</thc>',"</th>\n");

# Table cell rendering: needs revision for alignment handling
#   based on the LaTeX-like argument.
# 19991216 -- When grandparent is "tablech", write valign="top".
# Element: td
sgml('<td>', sub{
    $tdtdbc = 0;
    $tabaseq[$tabdepth]++;
    push_output('string');
});
sgml('</td>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = "";
    my $atts = "";
    my $matts = "";
    my $nn = $tabaseq[$tabdepth];
    my $mm = $nn - 1;  # at least 0
    my $nnn = $nn;
    if($nn > $tabalen[$tabdepth]){
	$nnn = $tabalen[$tabdepth];
    }
    else{
	if(($tabasyn[$tabdepth][$mm] =~ /\|$/)&&($tabasyn[$tabdepth][$nn] =~ /\|$/)){
	    $atts = $atts . ' class="boxed"';
	}
	elsif($tabasyn[$tabdepth][$nn] =~ /\|$/){
	    $atts = $atts . ' class="rruled"';
	}
	elsif($tabasyn[$tabdepth][$mm] =~ /\|$/){
	    $atts = $atts . ' class="lruled"';
	}
    };
    my $cc = $tabasym[$tabdepth][$nnn];
    if($cc ne ""){
	$atts = $atts . $tabaval{$cc};
	$matts = $mtabaval{$cc};
    };
    if(($gmath_on == 1)&&($mathml == 1)&&($elt->within("mtable") ne "")){
	$os = "<mtd" . $matts . ">" . $pos . "</mtd>";
    }
    else{
	$os = "<td" . $atts;
	if(($tdtdbc == 1) && ($atts eq "")){  # Is this now obsolete?
	    $os = $os . ' align="center"';
	};
	if($elt->within("tablech") ne ""){
	    $os = $os . " valign=\"top\"";
	};
	$os = $os . ">" . $pos . "</td>";
    };
    output($os);
    $tdtdbc = 0;
});

# Element: tdp
sgml('<tdp>', sub{
    $tdtdbc = 0;
    $tabaseq[$tabdepth]++;
    push_output('string');
});
sgml('</tdp>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = "";
    my $atts = "";
    my $matts = "";
    my $nn = $tabaseq[$tabdepth];
    my $mm = $nn - 1;  # at least 0
    my $nnn = $nn;
    my $wspec = "";
    if($nn > $tabalen[$tabdepth]){
	$nnn = $tabalen[$tabdepth];
    }
    else{
	if( ($tabasyn[$tabdepth][$mm] =~ /\|$/)
	    && ($tabasyn[$tabdepth][$nn] =~ /\|$/) ){
	    $atts = $atts . ' class="boxed"';
	}
	elsif($tabasyn[$tabdepth][$nn] =~ /\|$/){
	    $atts = $atts . ' class="rruled"';
	}
	elsif($tabasyn[$tabdepth][$mm] =~ /\|$/){
	    $atts = $atts . ' class="lruled"';
	}
    };
    my $cc = $tabasym[$tabdepth][$nnn];
    if($cc ne ""){
	$atts = $atts . $tabaval{$cc};
	$matts = $mtabaval{$cc};
    };
    if(($gmath_on == 1)&&($mathml == 1)&&($elt->within("mtable") ne "")){
	$os = "<mtd" . $matts . ">" . $pos . "</mtd>";
    }
    else{
	$os = "<td" . $atts;
	if(($tdtdbc == 1) && ($atts eq "")){  # Is this now obsolete?
	    $os = $os . ' align="center"';
	};
	if($elt->within("tablech") ne ""){
	    $os = $os . " valign=\"top\"";
	};
	# A p-cell may have a width spec
	if(($nn <= $tabalen[$tabdepth]) && ($tabasyn[$tabdepth][$nn] =~ /\{/)){
	    $wspec = $tabasyn[$tabdepth][$nn];
	    $wspec =~ s/^.*\{//;
	    $wspec =~ s/\}.*$//;
	    if(!(($wspec >= 0) && ($wspec <=1))){
		$wspec = "";
	    }
	    else{
		$wspec = int(100*$wspec);
	    };
	    if($wspec ne ""){
		$os = $os . ' style="width: ' . $wspec . '%;"';
	    };
	};
	$os = $os . ">" . $pos . "</td>";
    };
    output($os);
    $tdtdbc = 0;
});

# Element: tdr
sgml('<tdr>', sub{
    $tdtdbc = 0;
    $tabaseq[$tabdepth]++;
    push_output('string');
});
sgml('</tdr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = "";
    my $atts = "";
    my $matts = "";
    my $nn = $tabaseq[$tabdepth];
    my $mm = $nn - 1;  # at least 0
    my $nnn = $nn;
    if($nn > $tabalen[$tabdepth]){
	$nnn = $tabalen[$tabdepth];
    }
    else{
	if(($tabasyn[$tabdepth][$mm] =~ /\|$/)&&($tabasyn[$tabdepth][$nn] =~ /\|$/)){
	    $atts = $atts . ' class="boxed"';
	}
	elsif($tabasyn[$tabdepth][$nn] =~ /\|$/){
	    $atts = $atts . ' class="rruled"';
	}
	elsif($tabasyn[$tabdepth][$mm] =~ /\|$/){
	    $atts = $atts . ' class="lruled"';
	}
    };
    my $cc = $tabasym[$tabdepth][$nnn];
    if($cc ne ""){
	$atts = $atts . $tabaval{$cc};
	$matts = $mtabaval{$cc};
    };
    if(($gmath_on == 1)&&($mathml == 1)&&($elt->within("mtable") ne "")){
	$os = "<mtd" . $matts . ">" . $pos . "</mtd>";
    }
    else{
	$os = "<td" . $atts;
	if(($tdtdbc == 1) && ($atts eq "")){  # Is this now obsolete?
	    $os = $os . ' align="center"';
	};
	if($elt->within("tablech") ne ""){
	    $os = $os . " valign=\"top\"";
	};
	$os = $os . ">" . $pos . "</td>";
    };
    output($os);
    $tdtdbc = 0;
});

sgml('</old-td>', sub{
    my $pos = pop_output;
    my $os = "";
    if($tdtdbc == 1){
	$os = "<td " . $ctratt . ">" . $pos . "</td>";
    }
    else{
	$os = "<td>" . $pos . "</td>";
    };
    output($os);
    $tdtdbc = 0;
});

# Element: tdbc
sgml('<tdbc>', sub{
    push_output('string');
});
sgml('</tdbc>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan =~ /^(td|tdc|tdp|tdr)$/){
	$tdtdbc = 1;
	$os = "<b>" . $pos . "</b>";
    }
    else{
	$os = "$ctrbo<b>" . $pos . "</b>$ctrbc";
    };
    output($os);
});

# Element: tdc -- not used
sgml('<tdc>', "<td valign=\"top\">");
sgml('</tdc>',"</td>");

# Element: Table
sgml('<Table>', sub{
    $tabdepth++;
    output("\n<table><tbody>\n");
});
sgml('</Table>',sub{
    output("\n</tbody></table>\n");
    $tabdepth--;
});

# Element: bigskip
sgml('<bigskip>', sub{
    my $os = "";
    if($xhtmlstrict == 0){
	$os = "<br" . $clemp . "<br" . $clemp . "<br\n" . $clemp;
    };
    output($os);
});
sgml('</bigskip>', "");

# Element: medskip
sgml('<medskip>', sub{
    my $os = "";
    if($xhtmlstrict == 0){
	$os = "<br" . $clemp . "<br\n" . $clemp;
    };
    output($os);
});
sgml('</medskip>', "");

# Element: smallskip
sgml('<smallskip>', "\n");
sgml('</smallskip>', "");

# Element: equation
sgml('<equation>', sub{
    $tabdepth++;
    if($mathml == 0){
	$unirow[$tabdepth] = 1;
	if ($hpar_on == 1){
	    $eqinhpar = 1;
	    $hpar_on = 0;
	}
	elsif($asstbodyhpar == 2){
	    $eqinhpar = 1;
	    $asstbodyhpar = 0;
	}
	else{  # both hpar's are 0
	    $eqinhpar = 0;
	};
    };
    push_output('string');
    $eqntag = "";
    $eqrtag = "";
    $equkey = "";
    $gmath_on = 1 ;
    $dmath_on = 1;
});
sgml('</equation>', sub{
    $dmath_on = 0;
    $gmath_on = 0 ;
    if($mathml == 0){
	$unirow[$tabdepth] = 0;
    };
    $tabdepth--;
    my $pos = pop_output;
    # Assemble label and content in $cos
    $equkey = $eqnkey;
    my $cos = "";
    my $tag = "";
    my $pan = $_[0]->parent->name;
    my $eqid = $_[0]->attribute("eqseq")->value;
    if($_[0]->attribute("nonum")->value ne "true"){
	if($eqntag ne ""){
	    $tag = $eqntag;
	}
	elsif($eqrtag ne ""){
	    $tag = $eqrtag;
	}
	elsif($labelserseqs{$equkey} > 0){
	    $tag = $labelserseqs{$equkey};
	}
	else{
	    $tag = "E-" . $eqid;
	    print STDERR $WhoAmI, " WARNING: Used eqseq for equation ",
	    $eqid, "\n", "eqnkey: ", $eqnkey, " equkey: ", $equkey, "\n";
	};
    };
    if(($mathml == 0) && ($tag ne "")){
	$cos = $cos . "(" . $tag . ")&#xA0;&#xA0;&#xA0;";
    };
    $cos = $cos . $pos;
    my $os = "";
    if($asstbodyflag == 1){
	# os = $os . "</em>";
    };
    if($mathml == 1){
	$os = $os . "\n" . '<math xmlns="' . $mathns
	    . '" display="block" mode="display"' . "\n>";
	# $os = $os . '<mtable><mlabeledtr';
	$os = $os . '<mtable><mtr class="labeled"';
	if($_[0]->attribute("nonum")->value ne "true"){
	    $os = $os . ' id="' . $eqnser . $eqnkey . '"';
	};
	$os = $os . '>';
	if($tag ne ""){
	    $os = $os . '<mtd><mtext>(' . $tag . ")</mtext></mtd\n>";
	}
	else{
	    $os = $os . "<mtd></mtd>";
	};
	# $os = $os . "<mtd><mrow>" . $cos
	#     . "</mrow></mtd></mlabeledtr></mtable></math\n>";
	$os = $os . "<mtd><mrow>" . $cos
	    . "</mrow></mtd></mtr></mtable></math\n>";
    }
    elsif(($pan =~ /$parasregexp/) && ($eqinhpar == 1) && ($tabdepth == 0)){
	$os = $os . "</p>\n$ctrbo<table cellspacing=\"0\" cellpadding=\"0\">"
	    . "<tr><td>\n" . $cos . "\n</td></tr></table>$ctrbc\n<p>";
    }
    elsif(($pan =~ /$parasregexp/) && ($tabdepth == 0)){
	$os = $os . "$ctrbo<table cellspacing=\"0\" cellpadding=\"0\">"
	    . "<tr><td>\n" . $cos . "\n</td></tr></table>$ctrbc\n<p>";
	$eqinhpar = 1;
    }
    else{
	$os = $os . "$ctrbo<table cellspacing=\"0\" cellpadding=\"0\">"
	    . "<tr><td>\n" . $cos . "\n</td></tr></table>$ctrbc\n";
	$eqinhpar = 0;
    };
    if($asstbodyflag == 1){
	# os = $os . "<em>";
    };
    output($os);
    if($mathml == 0){
	if ($eqinhpar == 1){
	    if($asstbodyflag == 1){
		$asstbodyhpar = 1;
	    }
	    else{
		$hpar_on = 1;
	    };
	    $eqinhpar = 0;
	}
	else{
	    $asstbodyhpar = 0;
	    $hpar_on = 0;
	};
    };
    $eqnkey = "";
});

# Element: pow
sgml('<pow>', sub{
    my $os = "";
    # math zone context implied for "pow"
    if($mathml == 1){
	push_output('string');
    }
    else{
	$os = "^{";
    };
    output($os);
});
sgml('</pow>', sub{
    my ($elt, $ev) = @_;
    my $os = "";
    my $pos = "";
    if($mathml == 1){
	$pos = pop_output;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $pos = "<mrow>" . $pos . "</mrow>";
	};
	if($store[$stolvl] ne ""){
	    $os = $os . "<msup>" . $store[$stolvl] . $pos . "</msup\n>";
	    $store[$stolvl] = "";
	    $stolvl--; # pow
	}
	else{
	    print STDERR "\n   WARNING: ",
	    'No stored base for element "pow" at line ', $ev->line,
	    "\n   Probably need added parentheses or other grouping\n";
	    $os = $pos;
	};
    }
    else{
	$os = "}";
    };
    output($os);
});

sgml('<pow0>', sub{
    my $os = "";
    # math zone context implied for "pow"
    if(($mathml == 1) && !($store[$stolvl] eq "")){
	push_output('string');
    }
    else{
	$os = "^{";
    };
    output($os);
});
sgml('</pow0>', sub{
    my $os = "";
    my $pos = "";
    my $elt= $_[0];
    if(($mathml == 1) && !($store[$stolvl] eq "")){
	$pos = pop_output;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $pos = "<mrow>" . $pos . "</mrow>";
	};
	$os = $os . "<msup>" . $store[$stolvl] . $pos . "</msup\n>";
	$store[$stolvl] = "";
	$stolvl--;  # pow
    }
    else{
	$os = "}";
    };
    output($os);
});

# Element: sarg
sgml('<sarg>', sub{
    my $os = "";
    # math zone context implied for "sarg"
    if($mathml == 1){
	push_output('string');
    }
    else{
	$os = "_{";
    };
    output($os);
});
sgml('</sarg>', sub{
    my ($elt, $ev) = @_;
    my $os = "";
    my $pos = "";
    if($mathml == 1){
	$pos = pop_output;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $pos = "<mrow>" . $pos . "</mrow>";
	};
	if($store[$stolvl] ne ""){
	    $os = $os . "<msub>" . $store[$stolvl] . $pos . "</msub\n>";
	    $store[$stolvl] = "";
	    $stolvl--; # sarg
	}
	else{
	    print STDERR "\n   WARNING: ",
	    'No stored base for element "sarg" at line ', $ev->line,
	    "\n   Probably need added parentheses or other grouping\n";
	    $os = $pos;
	};
    }
    else{
	$os = "}";
    };
    output($os);
});

sgml('<sarg0>', sub{
    my $os = "";
    # math zone context implied for "sarg"
    if(($mathml == 1) && !($store[$stolvl] eq "")){
	push_output('string');
    }
    else{
	$os = "_{";
    };
    output($os);
});
sgml('</sarg0>', sub{
    my $os = "";
    my $pos = "";
    my $elt= $_[0];
    if(($mathml == 1) && !($store[$stolvl] eq "")){
	$pos = pop_output;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $pos = "<mrow>" . $pos . "</mrow>";
	};
	$os = $os . "<msub>" . $store[$stolvl] . $pos . "</msub\n>";
	$store[$stolvl] = "";
	$stolvl--;  # sarg
    }
    else{
	$os = "}";
    };
    output($os);
});
sgml('<sarg00>', "_{");
sgml('</sarg00>', "}");

# Element: sum0
sgml('<sum0>', "SUM[");
sgml('</sum0>', "]");

# Element: sum
sgml('<sum>', sub{
    $sumdepth++;
    $sumsubseq[$sumdepth] = 0;
    $sumsupseq[$sumdepth] = 0;
    $sumsub[$sumdepth] = "";
    $sumsup[$sumdepth] = "";
    push_output('string');
});
sgml('</sum>', sub{
    my $cts = pop_output;
    #  So this code can easily be changed for other sum-like elements
    my $opc = "<mo>&#x2211;</mo>";
    my $eltname = $_[0]->name;
    my $os = uc($eltname);
    my $subarg = $sumsub[$sumdepth];
    my $suparg = $sumsup[$sumdepth];
    if($mathml == 1){
	# Re-initialize output string
	$os = "<mrow>";
	if(($subarg ne "") && ($suparg ne "")){
	    if($dmath_on == 1){
		$os = $os . "<munderover>" . $opc . $subarg . $suparg
		    . "</munderover>";
	    }
	    else{
		$os = $os . "<msubsup>" . $opc . $subarg . $suparg
		    . "</msubsup>";
	    };
	}
	elsif($suparg ne ""){
	    if($dmath_on == 1){
		$os = $os . '<mover accent="false">' . $opc . $suparg
		    . "</mover>";
	    }
	    else{
		$os = $os . "<msup>" . $opc . $suparg . "</msup>";
	    };
	}
	elsif($subarg ne ""){
	    if($dmath_on == 1){
		$os = $os . '<munder accentunder="false">' . $opc . $subarg
		    . "</munder>";
	    }
	    else{
		$os = $os . "<msub>" . $opc . $subarg . "</msub>";
	    };
	}
	else{
	    $os = $os . $opc;
	};
	$os = $os . $cts . "</mrow\n>";
    }
    else{
	if($subarg ne ""){
	    $os = $os . "_{" . $subarg . "}";
	};
	if($suparg ne ""){
	    $os = $os . "^{" . $suparg . "}";
	};
	$os = $os . "[" . $cts . "]";
    };
    output($os);
    $sumdepth--;
});

# Element: int0
sgml('<int0>', "INT[");
sgml('</int0>', "]");

# Element: int
sgml('<int>', sub{
    $sumdepth++;
    $sumsubseq[$sumdepth] = 0;
    $sumsupseq[$sumdepth] = 0;
    $sumsub[$sumdepth] = "";
    $sumsup[$sumdepth] = "";
    push_output('string');
});
sgml('</int>', sub{
    my $cts = pop_output;
    #  So this code can easily be changed for other sum-like elements
    my $opc = "<mo>&#x222B;</mo>";
    my $eltname = $_[0]->name;
    my $os = uc($eltname);
    my $subarg = $sumsub[$sumdepth];
    my $suparg = $sumsup[$sumdepth];
    if($mathml == 1){
	# Re-initialize output string
	$os = "<mrow>";
	if(($subarg ne "") && ($suparg ne "")){
	    $os = $os . "<msubsup>" . $opc . $subarg . $suparg . "</msubsup>";
	}
	elsif($suparg ne ""){
	    $os = $os . "<msup>" . $opc . $suparg . "</msup>";
	}
	elsif($subarg ne ""){
	    $os = $os . "<msub>" . $opc . $subarg . "</msub>";
	}
	else{
	    $os = $os . $opc;
	};
	$os = $os . $cts . "</mrow\n>";
    }
    else{
	if($subarg ne ""){
	    $os = $os . "_{" . $subarg . "}";
	};
	if($suparg ne ""){
	    $os = $os . "^{" . $suparg . "}";
	};
	$os = $os . "[" . $cts . "]";
    };
    output($os);
    $sumdepth--;
});

# Element: prod0
sgml('<prod0>', "PROD[");
sgml('</prod0>', "]");

# Element: prod
sgml('<prod>', sub{
    $sumdepth++;
    $sumsubseq[$sumdepth] = 0;
    $sumsupseq[$sumdepth] = 0;
    $sumsub[$sumdepth] = "";
    $sumsup[$sumdepth] = "";
    push_output('string');
});
sgml('</prod>', sub{
    my $cts = pop_output;
    #  So this code can easily be changed for other sum-like elements
    my $opc = "<mo>&#x220F;</mo>";
    my $eltname = $_[0]->name;
    my $os = uc($eltname);
    my $subarg = $sumsub[$sumdepth];
    my $suparg = $sumsup[$sumdepth];
    if($mathml == 1){
	# Re-initialize output string
	$os = "<mrow>";
	if(($subarg ne "") && ($suparg ne "")){
	    if($dmath_on == 1){
		$os = $os . "<munderover>" . $opc . $subarg . $suparg
		    . "</munderover>";
	    }
	    else{
		$os = $os . "<msubsup>" . $opc . $subarg . $suparg
		    . "</msubsup>";
	    };
	}
	elsif($suparg ne ""){
	    if($dmath_on == 1){
		$os = $os . '<mover accent="false">' . $opc . $suparg
		    . "</mover>";
	    }
	    else{
		$os = $os . "<msup>" . $opc . $suparg . "</msup>";
	    };
	}
	elsif($subarg ne ""){
	    if($dmath_on == 1){
		$os = $os . '<munder accentunder="false">' . $opc . $subarg
		    . "</munder>";
	    }
	    else{
		$os = $os . "<msub>" . $opc . $subarg . "</msub>";
	    };
	}
	else{
	    $os = $os . $opc;
	};
	$os = $os . $cts . "</mrow\n>";
    }
    else{
	if($subarg ne ""){
	    $os = $os . "_{" . $subarg . "}";
	};
	if($suparg ne ""){
	    $os = $os . "^{" . $suparg . "}";
	};
	$os = $os . "[" . $cts . "]";
    };
    output($os);
    $sumdepth--;
});

# Element: frac
sgml('<frac>', sub{
    push_output('string');
    $fracser++;
    $fracdepth++;
    $frid[$fracdepth] = 0;
    $numr[$fracdepth]="";
    $denm[$fracdepth]="";
});
sgml('</frac>', sub{
    my ($elt, $ev) = @_;
    my $pos=pop_output;
    my $os="";
    if($mathml == 1){
	my $wo = "<mfrac\n>";
	my $wc = "</mfrac\n>";
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',', $parchld);
	my $nsybs = scalar(@sybs);
	unless(($nsybs ==1) || ($pan =~ /$fracconregexp/)){
	    $wo = "<mrow><mfrac\n>";
	    $wc = "</mfrac></mrow\n>";
	};
	$os = $wo . $numr[$fracdepth] . $denm[$fracdepth] . $wc;
    }
    else{
	$os="{" . $numr[$fracdepth] . "}/{" . $denm[$fracdepth] . "}";
    };
    output($os);
    $fracdepth--;
});

# Element: numr
sgml('<numr>', sub{
    push_output('string');
});
sgml('</numr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    if($fracdepth > 0){
	if($mathml == 1){
	    my $chld = $elt->attribute("mchld")->value;
	    my $nchld = scalar(split(',', $chld));
	    if($nchld > 1){
		$numr[$fracdepth] = "<mrow>" . $pos . "</mrow\n>";
	    }
	    else{
		$numr[$fracdepth] = $pos;
	    };
	}
	else{
	    $numr[$fracdepth] = $pos;
	};
    }
    else{
	my $pan = $elt->parent->name;
	print STDERR $WhoAmI, ": numr with non-positive frac depth in ",
              $pan, "\n";
    };
});

# Element: denm
sgml('<denm>', sub{
    push_output('string');
});
sgml('</denm>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    if($fracdepth > 0){
	if($mathml == 1){
	    my $chld = $elt->attribute("mchld")->value;
	    my $nchld = scalar(split(',', $chld));
	    if($nchld > 1){
		$denm[$fracdepth] = "<mrow>" . $pos . "</mrow\n>";
	    }
	    else{
		$denm[$fracdepth] = $pos;
	    };
	}
	else{
	    $denm[$fracdepth] = $pos;
	};
    }
    else{
	my $pan = $elt->parent->name;
	print STDERR $WhoAmI, ": denm with non-positive frac depth in ",
              $pan, "\n";
    };
});

# Element: over
sgml('<over>', sub{
    if($mathml == 1){
	output('<mspace width="0.3em" /><mo>&#x2044;</mo><mspace width="0.3em" />');
    }
    else{
	output(" / ");
    };
});
sgml('</over>', "");

# Element: sqrt -- model (op0,ag0) OR (%vline)*  HTML symbol = &radic;
sgml('<sqrt>', sub{
    push_output('string');
    $sqrtdepth++;
    $sqrtopt[$sqrtdepth] = "";
    $sqrtarg[$sqrtdepth] = "";
    $radicand[$sqrtdepth] = "";
    $radx[$sqrtdepth] = "";
});
sgml('</sqrt>', sub{
    my $pos = pop_output;
    my $os = "";
    if(($sqrtopt[$sqrtdepth] eq "") && ($radicand[$sqrtdepth] eq "")){
    # the (%uline)* model
	if($mathml == 1){
	    $os = $os . "<msqrt><mrow\n>" . $pos . "</mrow></msqrt\n>";
	}
	else{
	    $os = $os . "SQRT{" . $pos . "}";
	};
    }
    elsif($radicand[$sqrtdepth] ne ""){
	if($mathml == 1){
	    if($haveUglyRadical == 1){  # Use exponent
		my $idx = "<mn>2</mn>"; # not really used but gains scope
		my $exp = "<mrow><mn>1</mn><mo>/</mo><mn>2</mn></mrow>";
		if($radx[$sqrtdepth] ne ""){
		    $idx = $radx[$sqrtdepth];
		    $exp = "<mfrac><mn>1</mn>" . $idx . "</mfrac>";
		    $os = "<msup><mfenced>" . $radicand[$sqrtdepth]
			. "</mfenced>" . $exp . "</msup\n>";
		}
		elsif($simpleradicand[$sqrtdepth] == 1){
		    $os = "<msup>" . $radicand[$sqrtdepth] . $exp
			. "</msup\n>";
		}
		else{
		    $os = "<msup><mfenced>" . $radicand[$sqrtdepth]
			. "</mfenced>" . $exp . "</msup\n>";
		};
	    }
	    else{
		if($radx[$sqrtdepth] ne ""){
		    $os = "<mroot>" . $radicand[$sqrtdepth]
			. $radx[$sqrtdepth] . "</mroot\n>";
		}
		else{
		    $os = "<msqrt>" . $radicand[$sqrtdepth] . "</msqrt\n>";
		};
	    };
	}
	else{
	    $os = $os . "SQRT";
	    if($radx[$sqrtdepth] ne ""){
		$os = $os . '[' . $radx[$sqrtdepth] . ']';
	    };
	    $os = $os . '{' . $radicand[$sqrtdepth] . '}';
	};
    }
    else{
    # one opt and one arg
	$os = $os . 'SQRT[' . $sqrtopt[$sqrtdepth]
            . ']{' . $sqrtarg[$sqrtdepth] . '}';
    };
    output($os);
    $sqrtdepth--;
});

# Element: pmod -- as in "\pmod{m}" for "(mod m)"
sgml('<pmod>', sub{
    push_output('string');
});
sgml('</pmod>', sub{
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	$os = '<mspace width="0.3em"/><mfenced><mrow><mo rspace="0.3em">'
	    . "mod</mo>" . $pos . "</mrow></mfenced>";
    }
    else{
	$os = "(mod " . $pos . ")";
    };
output($os);
});

# Element: bmod -- as in "a \mod m" for "a mod m"
sgml('<bmod>', sub{
    if($mathml == 1){
	# output('<mspace width="0.6em"/><mo>mod</mo><mspace width="0.3em"/>');
	output('<mo lspace="0.6em" rspace="0.3em">mod</mo>');
    }
    else{
	output(" mod ");
    };
});
sgml('</bmod>', "");


# Element: equiv -- LaTeX "equiv" symbol; an "equals sign" with 3 bars
sgml('<equiv>', sub{
    if($mathml == 1){
	output("<mo>&#x2261;</mo>");
    }
    else{
	output("<b>EQUIV</b>");
    };
});
sgml('</equiv>', "");

# Element: sim -- LaTeX "sim" symbol; like a tilde accent, but vert. centered
sgml('<sim>', sub{
    if($mathml == 1){
	output("<mo>&#x223C;</mo>");
    }
    else{
	output(" ~ ");
    };
});
sgml('</sim>', "");

# Element: simeq -- LaTeX "simeq" symbol; a "sim" above an "equals"
sgml('<simeq>', sub{
    if($mathml == 1){
	output("<mo>&#x2243;</mo>");
    }
    else{
	output(" \\simeq ");
    };
});
sgml('</simeq>', "");

# Element: cong -- LaTeX "cong" symbol; as with congruence of triangles,
#                  i.e., a tilde above an equals sign
sgml('<cong>', sub{
    if($mathml == 1){
	output("<mo>&#x2245;</mo>");
    }
    else{
	output(" ~= ");
    };
});
sgml('</cong>', "");

# Element: times -- multiplication symbol, something like upper case 'X'
sgml('<times>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo lspace="0.25em" rspace="0.25em">' . "&#x00D7;</mo>";
    }
    elsif($xhtml == 1){
	$os = "&#x00D7;";
    }
    else{
	$os = "\\times";
    };
    output($os);
});
sgml('</times>', "");

# Element: cdot -- a dot that is vertically centered
sgml('<cdot>', sub{
    my $os = "&#x00B7;";
    if($mathml == 1){
	$os = "<mo>" . $os . "</mo>";
    };
    output($os);
});
sgml('</cdot>', "");

# Element pm
sgml('<pm>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x00B1;</mo>";
    }
    else{
	$os = "&#x00B1;";
    };
    output($os);
});
sgml('</pm>', "");

# Element infty
sgml('<infty>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mi>&#x221E;</mi>";
    }
    else{
	$os = "INFTY";
    };
    output($os);
});
sgml('</infty>', "");

# Element: geq
sgml('<geq>', sub{
    if(($mathml == 1) && ($gmath_on == 1)){
	output("<mo>&#x2265;</mo>");
    }
    elsif($xhtmlstrict == 1){
	output("&#x2265;");
    }
    elsif($gmath_on == 1){
	if($unirow[$tabdepth] == 1){
	    output("&#xA0;&gt;=&#xA0;");
	}
	else{
	    output(" &gt;= ");
	};
    }
    else{
	output("&gt;=");
    };
});
sgml('</geq>', "");

# Element: leq
sgml('<leq>', sub{
    if(($mathml == 1) && ($gmath_on == 1)){
	output("<mo>&#x2264;</mo>");
    }
    elsif($xhtmlstrict == 1){
	output("&#x2264;");
    }
    elsif($gmath_on == 1){
	if($unirow[$tabdepth] == 1){
	    output("&#xA0;&lt;=&#xA0;");
	}
	else{
	    output(" &lt;= ");
	};
    }
    else{
	output("&lt;=");
    };
});
sgml('</leq>', "");

# Element: neq
sgml('<neq>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2260;</mo>");
    }
    else{
	output("&#x2260;");
    };
});
sgml('</neq>', "");

# Element: bold -- emboldened
sgml('<bold>', sub{
    push_output('string');
});
sgml('</bold>', sub{
    my $pos = pop_output;
    my $os = "";
    my $elt = $_[0];
    my $pan = $elt->parent->name;
    if(($mathml == 1) &&
       (($elt->within("mbox") ne "") || ($elt->within("regch") ne ""))
       && (($gmath_on == 1) || ($sv_gmath_on == 1))){
	$os = $pos;
    }
    elsif(($mathml == 1) && ($sv_gmath_on == 1) && ($pan eq "text")){
	$os = $pos;
	my $parchld = $elt->parent->attribute("mchld")->value;
	my $nsybs = scalar(split(',', $parchld));
	if($nsybs > 1){
	    $os = '</mtext><mspace width="0.2em" />';
	    $os = $os . '<mtext mathvariant="bold" class="strong">';
	    $os = $os . $pos;
	    $os = $os . '</mtext><mspace width="0.2em" /><mtext>';
	};
    }
    elsif(($gmath_on == 1) && ($mathml == 1)){
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld > 1){
	    $os = '<mrow fontweight="bold">' . $pos . "</mrow\n>";
	}
	else{
	    $os = '<mi fontweight="bold">' . $pos . "</mi\n>";
	};
    }
    else{
	$os = "<b>" . $pos . "</b>";
    };
    output($os);
});

# Element: eaddr -- content is an email address
sgml('<eaddr>', sub{
    push_output('string');
});
sgml('</eaddr>', sub{
    my $pos = pop_output;
    my $os = "<a href=\n\"mailto:" . $pos . "\"\n><kbd>" . $pos . "</kbd></a>";
    output($os);
});

# Element: today
sgml('<today>', sub{
    my @tv = localtime();
    my $yr = 1900+$tv[5];
    $todaystr = $GMonth[$tv[4]] . " " . $tv[3] . ", " . $yr;
    output($todaystr);
});
sgml('</today>', "");

sgml('<todayold>', sub{
    my $ts = `date '+%d %b %Y'`;
    my $sl = length($ts) - 1;
    $todaystr = substr($ts, 0, $sl);
    output($todaystr);
});

# Element: draftlabel
sgml('<draftlabel>', sub{
    $markdraft = 1;
});
sgml('</draftlabel>', "");

# Element: brk
sgml('<brk>', sub{
    my $os = "<br\n" . $clemp;
    output($os);
});
sgml('</brk>', "");

# Element: brs -- LaTeX-like suggested line break, strength 3; ignore for HTML
sgml('<brs>', "");
sgml('</brs>' , "");

# Element: ldq
sgml('<ldq>', sub{
    my $pan = $_[0]->parent->name;
    my $os = '``';
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x201C;</mo>";
    }
    elsif(($mathml == 1) && ($pan eq "text")){
	$os = '"';
    }
    elsif($xhtmlstrict == 1){
	$os = "&#x201C;";
    };
    output($os);
});
sgml('</ldq>', "");

# Element: rdq
sgml('<rdq>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "''";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x2033;</mo>";
    }
    elsif(($mathml == 1) && ($pan eq "text")){
	$os = '"';
    }
    elsif($xhtmlstrict == 1){
	$os = "&#x201D;";
    };
    output($os);
});
sgml('</rdq>', "");

# Element: exc
sgml('<exc>', sub{
    my $os = "!";
    if(($gmath_on > 0) && ($mathml == 1)){
	$os = "<mo>!</mo>";
    };
    output($os);
});
sgml('</exc>', "");

# Element: atc
# sgml('<atc>', "@");
sgml('<atc>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	if($_[0]->within("csep") ne ""){
	    $os = '@';
	}
	else{
	    $os = '<mo>@</mo>';
	};
    }
    else{
	$os = "@";
    };
    output($os);
});
sgml('</atc>', "");

# Element: hsh
# sgml('<hsh>', "#");
sgml('<hsh>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>#</mo>';
    }
    else{
	$os = "#";
    };
    output($os);
});
sgml('</hsh>', "");

# Element: dol
# sgml('<dol>', "\$");
sgml('<dol>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>\$</mo>';
    }
    else{
	$os = "\$";
    };
    output($os);
});
sgml('</dol>', "");

# Element: pct
# sgml('<pct>', "%");
sgml('<pct>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>%</mo>';
    }
    else{
	$os = "%";
    };
    output($os);
});
sgml('</pct>', "");

# Element: crt
# sgml('<crt>', "^");
sgml('<crt>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>^</mo>';
    }
    else{
	$os = "^";
    };
    output($os);
});
sgml('</crt>', "");

# Element: amp
# sgml('<amp>', "&amp;");
sgml('<amp>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>&amp;</mo>';
    }
    else{
	$os = "&amp;";
    };
    output($os);
});
sgml('</amp>', "");

# Element: ast
sgml('<ast>', sub{
    my ($elt, $ev) = @_;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	my $par = $elt->parent;
	my $pan = $par->name;
	if ($pan eq "Em0"){
	    $par = $par->parent;
	    $pan = $par->name;
	};
	my $parchld = $par->attribute("mchld")->value;
	my $nsybs = scalar(split(',', $parchld));
	if(($elt->within("text") ne "")||($elt->within("eqntag") ne "")
	      ||($elt->within("tag") ne "")){
	    $os = $os . "*";
	}
	elsif($nsybs == 1){
	    if($mathmlc == 1){
		$os = $os . "<ci>*</ci>";
	    }
	    elsif($mathmlp == 1){
		$os = $os . "<mi>*</mi>";
	    }
	}
	else{
	    $os = $os . "<mo>*</mo>";
	};
    }
    else{
	$os = $os . "*";
    };
    output($os);
});
sgml('</ast>', "");

# Element: und
# sgml('<und>', "_");
sgml('<und>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>_</mo>';
    }
    else{
	$os = "_";
    };
    output($os);
});
sgml('</und>', "");

# Element: tld
# sgml('<tld>', "~");
sgml('<tld>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mo>&#x223C;</mo>';
    }
    else{
	$os = "~";
    };
    output($os);
});
sgml('</tld>', "");

# In gellmu article <lsq/> and <rsq/> are for the ascii keyboard characters
# "left single quote" or "backquote" and "right single quote" or "apostrophe"
# (hex codes 60 and 27), while <apos/> is the apostrophe.  In ordinary text
# they should be promoted to &#x2018; and &#x2019; while in MathML
# to &#x2035; and &#x2032;.

# Element: lsq
sgml('<lsq>', sub{
    $os = '`';
    my ($elt, $ev) = @_;
    my $par = $elt->parent;
    my $pan = $par->name;
    if(($gmath_on == 1) && ($mathml == 1)){
	if($_[0]->within("msup") eq ""){
	    print STDERR "*** htmlgart.pl: WARNING backquote in math not in superscript\n";
	};
	$os = "<mo>&#x2035;</mo>";
    }
    elsif(($xhtmlstrict == 1) &&
	  !($pan =~ /^(nln|quostr|qquostr|verb|verbatim)$/)){
	$os = "&#x2018;";
    };
    output($os);
});
sgml('</lsq>', "");

# Element: rsq
sgml('<rsq>', sub{
    my $os = "'";
    my ($elt, $ev) = @_;
    my $par = $elt->parent;
    my $pan = $par->name;
    if(($gmath_on == 1) && ($mathml == 1)){
	# Font woes in some user agents
	my $elt=$_[0];
	$os = "<mo class=\"prime\">&#x2032;</mo>";
    }
    elsif(($xhtmlstrict == 1) &&
	  !($pan =~ /^(nln|quostr|qquostr|verb|verbatim)$/)){
	$os = "&#x2019;";
    };
    output($os);
});
sgml('</rsq>', "");

# Element: plu
sgml('<plu>', "+");
sgml('</plu>', "");

# Element: lpr
sgml('<lpr>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '(';
	}
	else{
	    $os = '<mo stretchy="true">(</mo>';
	};
	output($os);
    }
    else{
	output('(');
    };
});
sgml('</lpr>', "");

# Element: rpr
sgml('<rpr>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = ')';
	}
	else{
	    $os = '<mo stretchy="true">)</mo>';
	};
	output($os);
    }
    else{
	output(')');
    };
});
sgml('</rpr>', "");

# Element: ltc
sgml('<ltc>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '&lt;';
	}
	else{
	    $os = '<mo>&lt;</mo>';
	};
	output($os);
    }
    else{
	output('&lt;');
    };
});
sgml('</ltc>', "");

# Element: gtc
sgml('<gtc>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '&gt;';
	}
	else{
	    $os = '<mo>&gt;</mo>';
	};
	output($os);
    }
    else{
	output('&gt;');
    };
});
sgml('</gtc>', "");

# Element: vbr
sgml('<vbr>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '|';
	}
	else{
	    $os = '<mo>|</mo>';
	};
	output($os);
    }
    else{
	output("|");
    };
});
sgml('</vbr>', "");

# Element: mid
sgml('<mid>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	my $os = "";
	if($_[0]->within("csep") ne ""){
	    $os = '|';
	}
	else{
	    $os = '<mo>|</mo>';
	};
	output($os);
    }
    else{
	output("|");
    };
});
sgml('</mid>', "");

# Element: cln
sgml('<cln>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>:</mo>");
    }
    else{
	output(":");
    };
});
sgml('</cln>', "");

# Element: scl
sgml('<scl>', sub{
    my $os = ";";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mtext>;</mtext>";
    };
    output($os);
});
sgml('</scl>', "");

# Element: per
sgml('<per>', ".");
sgml('</per>', "");

# Element: cma
sgml('<cma>', sub{
    my $os = ",";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mtext>,</mtext>";
    };
    output($os);
});
sgml('</cma>', "");

# Element: qum
sgml('<qum>', "?");
sgml('</qum>', "");

# Element: nul -- place-holder for the location of whole-line comments in
#     the original .glm; on the one hand, we want to preserve line number
#     alignment between the .glm and the .sgml for author sanity.
#     So if we do and if we allow "\n" to bleed through from there, we
#     need to ** mark the location of former comments for target markups
#     that think blank lines are significant ** .
#        Now you ask why don't we keep the comments.  We could.  But if
#     we did they would have to go into each target in a way that was
#     safe for that target.  It's just not worth it.
#
#     (Don't even think about writing a nul char here!)
# Element: nul
sgml('<nul>', "");
sgml('</nul>', "");

# Element: cm0 -- place holder for end-of-line comments
sgml('<cm0>', "");
sgml('</cm0>', "");

# Element: cs0 -- place holder for end-of-line comments
sgml('<cs0>', "");
sgml('</cs0>', "");

# Element: cw0 -- place holder for end-of-line comments
sgml('<cw0>', "");
sgml('</cw0>', "");

# Element: alpha
sgml('<alpha>', &charWrite("alpha","03B1"));
sgml('</alpha>', "");

# Element: beta
sgml('<beta>', &charWrite("beta", "03B2"));
sgml('</beta>', "");

# Element: gamma
sgml('<gamma>', &charWrite("gamma","03B3"));
sgml('</gamma>', "");

# Element: Gamma
sgml('<Gamma>', &charWrite("Gamma", "0393"));
sgml('</Gamma>', "");

# Element: delta
sgml('<delta>', &charWrite("delta", "03B4"));
sgml('</delta>', "");

# Element: Delta
sgml('<Delta>', &charWrite("Delta", "0394"));
sgml('</Delta>', "");

# Element: epsilon
sgml('<epsilon>', &charWrite("epsilon", "03B5"));
sgml('</epsilon>', "");

# Element: varepsilon
sgml('<varepsilon>', &charWrite("varepsilon", "025B"));
sgml('</varepsilon>', "");

# Element: zeta
sgml('<zeta>', &charWrite("zeta", "03B6"));
sgml('</zeta>', "");

# Element: eta
sgml('<eta>', &charWrite("eta", "03B7"));
sgml('</eta>', "");

# Element: theta
sgml('<theta>', &charWrite("theta", "03B8"));
sgml('</theta>', "");

# Element: vartheta
sgml('<vartheta>', &charWrite("vartheta", "03D1"));
sgml('</vartheta>', "");

# Element: Theta
sgml('<Theta>', &charWrite("Theta", "398"));
sgml('</Theta>', "");

# Element: iota
sgml('<iota>', &charWrite("iota", "03B9"));
sgml('</iota>', "");

# Element: kappa
sgml('<kappa>', &charWrite("kappa", "03BA"));
sgml('</kappa>', "");

# Element: lambda
sgml('<lambda>', &charWrite("lambda", "03BB"));
sgml('</lambda>', "");

# Element: Lambda
sgml('<Lambda>', &charWrite("Lambda", "039B"));
sgml('</Lambda>', "");

# Element: mu
sgml('<mu>', &charWrite("mu", "03BC"));
sgml('</mu>', "");

# Element: nu
sgml('<nu>', &charWrite("nu", "03BD"));
sgml('</nu>', "");

# Element: xi
sgml('<xi>', &charWrite("xi", "03BE"));
sgml('</xi>', "");

# Element: Xi
sgml('<Xi>', &charWrite("Xi", "039E"));
sgml('</Xi>', "");

# Element: omicron
sgml('<omicron>', &charWrite("omicron", "03BF"));
sgml('</omicron>', "");

# Element: pi
sgml('<pi>', &charWrite("pi", "03C0"));
sgml('</pi>', "");

# Element: Pi
sgml('<Pi>', &charWrite("Pi", "03A0"));
sgml('</Pi>', "");

# Element: rho
sgml('<rho>', &charWrite("rho", "03C1"));
sgml('</rho>', "");

# Element: sigma
sgml('<sigma>', &charWrite("sigma","03C3"));
sgml('</sigma>', "");

# Element: Sigma
sgml('<Sigma>', &charWrite("Sigma", "03A3"));
sgml('</Sigma>', "");

# Element: tau
sgml('<tau>', &charWrite("tau", "03C4"));
sgml('</tau>', "");

# Element: upsilon
sgml('<upsilon>', &charWrite("upsilon", "03C5"));
sgml('</upsilon>', "");

# Element: Upsilon
sgml('<Upsilon>', &charWrite("Upsilon", "03A5"));
sgml('</Upsilon>', "");

# Element: phi
sgml('<phi>', &charWrite("phi", "03D5"));
sgml('</phi>', "");

# Element: Phi
sgml('<Phi>', &charWrite("Phi", "03A6"));
sgml('</Phi>', "");

# Element: varphi
sgml('<varphi>', &charWrite("varphi", "03C6"));
sgml('</varphi>', "");

# Element: chi
sgml('<chi>', &charWrite("chi", "03C7"));
sgml('</chi>', "");

# Element: psi
sgml('<psi>', &charWrite("psi", "03C8"));
sgml('</psi>', "");

# Element: Psi
sgml('<Psi>', &charWrite("Psi", "03A8"));
sgml('</Psi>', "");

# Element: omega
sgml('<omega>', &charWrite("omega", "03C9"));
sgml('</omega>', "");

# Element: Omega
sgml('<Omega>', &charWrite("Omega", "03A9"));
sgml('</Omega>', "");

# Element: i -- dotless `i' (and NOT "italic", as in HTML)
sgml('<i>', sub{
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "i";
    if(($pan eq "ovbar")||(($pan eq "Em0") && ($gpan eq "ovbar"))){
	$os = "&#x012B;";
    }
    elsif(($pan eq "acute") || (($pan eq "Em0") && ($gpan eq "acute"))){
	$os = "&#x00ED;";
    }
    else{
	$os = charWrite("\\i", "0131", $gmath_on);
    };
    output($os);
});
sgml('</i>', "");

# Element: j -- dotless `j'
sgml('<j>', sub{
    my $os = "";
    $os = $os . charWrite("\\j", "006A", $gmath_on); # EEF0, Moz private DTD ??
    output($os);
});
sgml('</j>', "");

# Element: ell -- cursive lower case L
#  should be: sgml('<ell>', &charWrite("ell", "2113"));
#  Mozilla has U-2113, but spaces it weirdly
sgml('<ell0>', sub{
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = $os . '<mi fontstyle="italic">l</mi>';
    }
    else{
	$os = $os . "<em>l</em>";
    };
    output($os);
});
sgml('</ell0>', "");
sgml('<ell>', &charWrite("ell", "2113"));
sgml('</ell>', "");

# Element: wp -- cursive lower case L
sgml('<wp>', &charWrite("wp", "2118"));
sgml('</wp>', "");

# Element: cslaa -- LaTeX's \aa, HTML's &aring;
sgml('<cslaa>', "&#x00E5;");
sgml('</cslaa>', "");

# Element: csll -- LaTeX's \l
sgml('<csll>', sub{
    my $os = "";
    $os = $os . charWrite("lstrok", "0142", $gmath_on);
    output($os);
});
sgml('</csll>', "");

# Element: csss -- LaTeX's \ss (lowercase German ss), HTML's &szlig;
sgml('<csss>', "&#x00DF;");
sgml('</csss>', "");

# Element: acute
sgml('<acute>', sub{push_output('string');});
sgml('</acute>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x00B4;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # acute
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\'{" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = '&#x00C1;';
	}
	elsif($pos eq "a"){
	    $os = '&#x00E1;';
	}
	elsif($pos eq "E"){
	    $os = '&#x00C9;';
	}
	elsif($pos eq "e"){
	    $os = '&#x00E9;';
	}
	elsif($pos eq "I"){
	    $os = '&#x00CD;';
	}
	elsif($pos eq "i"){
	    $os = '&#x00ED;';
	}
	elsif($pos eq "O"){
	    $os = '&#x00D3;';
	}
	elsif($pos eq "o"){
	    $os = '&#x00F3;';
	}
	elsif($pos eq "U"){
	    $os = '&#x00DA;';
	}
	elsif($pos eq "u"){
	    $os = '&#x00FA;';
	}
	elsif($pos eq "Y"){
	    $os = '&#x00DD;';
	}
	elsif($pos eq "y"){
	    $os = '&#x00FD;';
	};
	output($os);
    };
});

# Element: grave
sgml('<grave>', sub{push_output('string');});
sgml('</grave>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x0060;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # grave
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\\`{" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = '&#x00C0;';
	}
	elsif($pos eq "a"){
	    $os = '&#x00E0;';
	}
	elsif($pos eq "E"){
	    $os = '&#x00C8;';
	}
	elsif($pos eq "e"){
	    $os = '&#x00E8;';
	}
	elsif($pos eq "I"){
	    $os = '&#x00CC;';
	}
	elsif($pos eq "i"){
	    $os = '&#x00EC;';
	}
	elsif($pos eq "O"){
	    $os = '&#x00D2;';
	}
	elsif($pos eq "o"){
	    $os = '&#x00F2;';
	}
	elsif($pos eq "U"){
	    $os = '&#x00D9;';
	}
	elsif($pos eq "u"){
	    $os = '&#x00F9;';
	};
	output($os);
    };
});

# Element: ovhat0
sgml('<ovhat>', sub{push_output('string');});
sgml('</ovhat>', sub{
    my $en = pop_output;
    my $os = '&' . $en . 'circ;';
    output($os);
});

# Element: ovhat -- hat or circumflex, LaTeX \^
sgml('<ovhat>', sub{push_output('string');});
sgml('</ovhat>', sub{
    my $os = "";
    my $pos = pop_output;
    # $os = '&' . $pos . 'uml;';
    if($pos =~ /^&\#/){
	$os = $pos;
    }
    elsif($pos eq "a"){
	$os = '&#x00E2;';
    }
    elsif($pos eq "e"){
	$os = '&#x00EA;';
    }
    elsif($pos eq "i"){
	$os = '&#x00EE;';
    }
    elsif($pos eq "o"){
	$os = '&#x00F4;';
    }
    elsif($pos eq "u"){
	$os = '&#x00FB;';
    }
    elsif($pos eq "A"){
	$os = '&#x00C2;';
    }
    elsif($pos eq "E"){
	$os = '&#x00CA;';
    }
    elsif($pos eq "I"){
	$os = '&#x00CE;';
    }
    elsif($pos eq "O"){
	$os = '&#x00D4;';
    }
    elsif($pos eq "U"){
	$os = '&#x00DB;';
    }
    elsif($pos eq "c"){
	$os = '&#x0109;';
    }
    elsif($pos eq "g"){
	$os = '&#x011D;';
    }
    elsif($pos eq "h"){
	$os = '&#x0125;';
    }
    elsif($pos eq "j"){
	$os = '&#x0135;';
    }
    elsif($pos eq "s"){
	$os = '&#x015D;';
    }
    elsif($pos eq "w"){
	$os = '&#x0175;';
    }
    elsif($pos eq "y"){
	$os = '&#x0177;';
    }
    elsif($pos eq "C"){
	$os = '&#x0108;';
    }
    elsif($pos eq "G"){
	$os = '&#x011C;';
    }
    elsif($pos eq "H"){
	$os = '&#x0124;';
    }
    elsif($pos eq "J"){
	$os = '&#x0134;';
    }
    elsif($pos eq "S"){
	$os = '&#x015C;';
    }
    elsif($pos eq "W"){
	$os = '&#x0174;';
    }
    elsif($pos eq "Y"){
	$os = '&#x0176;';
    }
    else{
	print STDERR '*** WARNING: Cannot apply circumflex accent to "', $os ,
	             "\"\n";
	$os = "\\^{" . $pos . "}";
	print STDERR '    Writing pseudo-TeX "', $os , "\"\n";
    };
    output($os);
});

# Element: cedil0
sgml('<cedil>', sub{push_output('string');});
sgml('</cedil>', sub{
    my $en = pop_output;
    my $os = '&' . $en . 'cedil;';
    output($os);
});

# Element: cedil -- cedilla, LaTeX \c
sgml('<cedil>', sub{push_output('string');});
sgml('</cedil>', sub{
    my $os = "";
    my $pos = pop_output;
    # $os = '&' . $pos . 'uml;';
    if($pos =~ /^&\#/){
	$os = $pos;
    }
    elsif($pos eq "c"){
	$os = '&#x00E7;';
    }
    elsif($pos eq "k"){
	$os = '&#x0137;';
    }
    elsif($pos eq "l"){
	$os = '&#x013C;';
    }
    elsif($pos eq "n"){
	$os = '&#x0146;';
    }
    elsif($pos eq "r"){
	$os = '&#x0157;';
    }
    elsif($pos eq "s"){
	$os = '&#x015F;';
    }
    elsif($pos eq "t"){
	$os = '&#x0163;';
    }
    elsif($pos eq "C"){
	$os = '&#x00C7;';
    }
    elsif($pos eq "G"){
	$os = '&#x0122;';
    }
    elsif($pos eq "K"){
	$os = '&#x0136;';
    }
    elsif($pos eq "L"){
	$os = '&#x013B;';
    }
    elsif($pos eq "N"){
	$os = '&#x0145;';
    }
    elsif($pos eq "R"){
	$os = '&#x0156;';
    }
    elsif($pos eq "S"){
	$os = '&#x015E;';
    }
    elsif($pos eq "T"){
	$os = '&#x0162;';
    }
    else{
	print STDERR '*** WARNING: Cannot apply cedilla to "', $os , "\"\n";
	$os = "\\c{" . $pos . "}";
	print STDERR '    Writing pseudo-TeX "', $os , "\"\n";
    };
    output($os);
});

# Element: umlau0
sgml('<umlau>', sub{push_output('string');});
sgml('</umlau>', sub{
    my $en = pop_output;
    my $os = '&' . $en . 'uml;';
    output($os);
});

# Element: umlau -- umlaut, LaTeX \"
sgml('<umlau>', sub{push_output('string');});
sgml('</umlau>', sub{
    my $os = "";
    my $pos = pop_output;
    # $os = '&' . $pos . 'uml;';
    if($pos =~ /^&\#/){
	$os = $pos;
    }
    elsif($pos eq "a"){
	$os = '&#x00E4;';
    }
    elsif($pos eq "e"){
	$os = '&#x00EB;';
    }
    elsif($pos eq "i"){
	$os = '&#x00EF;';
    }
    elsif($pos eq "o"){
	$os = '&#x00F6;';
    }
    elsif($pos eq "u"){
	$os = '&#x00FC;';
    }
    elsif($pos eq "y"){
	$os = '&#x00FF;';
    }
    elsif($pos eq "A"){
	$os = '&#x00CB;';
    }
    elsif($pos eq "E"){
	$os = '&#x00CB;';
    }
    elsif($pos eq "I"){
	$os = '&#x00CF;';
    }
    elsif($pos eq "O"){
	$os = '&#x00D6;';
    }
    elsif($pos eq "U"){
	$os = '&#x00DC;';
    }
    elsif($pos eq "Y"){
	$os = '&#x0178;';
    }
    else{
	print STDERR '*** WARNING: Cannot apply umlaut to "', $os , "\"\n";
	$os = "\\\"{" . $pos . "}";
	print STDERR '    Writing pseudo-TeX "', $os , "\"\n";
    };
    output($os);
});

# Element: tilde
sgml('<tilde>', sub{push_output('string');});
sgml('</tilde>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x223C;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # tilde
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\~{" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = '&#x00C3;';
	}
	elsif($pos eq "a"){
	    $os = '&#x00E3;';
	}
	elsif($pos eq "N"){
	    $os = '&#x00D1;';
	}
	elsif($pos eq "n"){
	    $os = '&#x00F1;';
	}
	elsif($pos eq "I"){
	    $os = '&#x0128;';
	}
	elsif($pos eq "i"){
	    $os = '&#x0129;';
	}
	elsif($pos eq "U"){
	    $os = '&#x0168;';
	}
	elsif($pos eq "u"){
	    $os = '&#x0169;';
	};
	output($os);
    };
});

# Element: hat
sgml('<hat>', sub{push_output('string');});
sgml('</hat>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x005E;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # hat
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\^{" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = '&#x00C2;';
	}
	elsif($pos eq "a"){
	    $os = '&#x00E2;';
	}
	elsif($pos eq "E"){
	    $os = '&#x00CA;';
	}
	elsif($pos eq "e"){
	    $os = '&#x00EA;';
	}
	elsif($pos eq "I"){
	    $os = '&#x00CE;';
	}
	elsif($pos eq "i"){
	    $os = '&#x00EE;';
	}
	elsif($pos eq "O"){
	    $os = '&#x00D4;';
	}
	elsif($pos eq "o"){
	    $os = '&#x00F4;';
	}
	elsif($pos eq "U"){
	    $os = '&#x00DB;';
	}
	elsif($pos eq "u"){
	    $os = '&#x00FB;';
	};
	output($os);
    };
});

# Element: check -- (caron)
sgml('<check>', sub{push_output('string');});
sgml('</check>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x02C7;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # check
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\v{" . $pos . "}";
	output($os);
    };
});

# Element: bar -- (macron)
sgml('<bar>', sub{push_output('string');});
sgml('</bar>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x00AF;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # bar
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\={" . $pos . "}";
	output($os);
    };
});

# Element: vec
sgml('<vec>', sub{push_output('string');});
sgml('</vec>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	# not so clear what to use
	#    2192  RightArrow = ShortRightArrow
        #    21C0  RightVector
	#    21E5  RightArrowBar
	$os = '<mover accent="true">' . $pos . "<mo>&#x21C0;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # vec
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\vec{" . $pos . "}";
	output($os);
    };
});

# Element: dot
sgml('<dot>', sub{push_output('string');});
sgml('</dot>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x02D9;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # dot
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\dot{" . $pos . "}";
	output($os);
    };
});

# Element: ovdot
sgml('<ovdot>', sub{push_output('string');});
sgml('</ovdot>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x02D9;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # ovdot
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\.{" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = "&#x0226;";
	}
	elsif($pos eq "a"){
	    $os = "&#x0227;";
	}
	elsif($pos eq "B"){
	    $os = "&#x1E02;";
	}
	elsif($pos eq "b"){
	    $os = "&#x1E03;";
	}
	elsif($pos eq "C"){
	    $os = "&#x010A;";
	}
	elsif($pos eq "c"){
	    $os = "&#x010B;";
	}
	elsif($pos eq "E"){
	    $os = "&#x0116;";
	}
	elsif($pos eq "e"){
	    $os = "&#x0117;";
	}
	elsif($pos eq "G"){
	    $os = "&#x0120;";
	}
	elsif($pos eq "g"){
	    $os = "&#x0121;";
	}
	elsif($pos eq "I"){
	    $os = "&#x0130;";
	}
	elsif($pos eq "N"){
	    $os = "&#x1E44;";
	}
	elsif($pos eq "n"){
	    $os = "&#x1E45;";
	}
	elsif($pos eq "Z"){
	    $os = "&#x017B;";
	}
	elsif($pos eq "z"){
	    $os = "&#x017C;";
	}
	output($os);
    };
});

# Element: ddot
sgml('<ddot>', sub{push_output('string');});
sgml('</ddot>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x00A8;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # ddot
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\ddot{" . $pos . "}";
	output($os);
    };
});

# Element: breve
sgml('<breve>', sub{push_output('string');});
sgml('</breve>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x02D8;</mo></mover\n>";
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # breve
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\u{" . $pos . "}";
	output($os);
    };
});

# Element: boq -- inverted question mark, ">" in LaTeX text, HTML's &iquest;
sgml('<boq>', "&#x00BF;");
sgml('</boq>', "");

# Element: boe -- inverted exclamation mark, LaTeX text "<", HTML's &iexcl;
sgml('<boe>', "&#x00A1;");
sgml('</boe>', "");

# Element: spar
sgml('<spar>', sub{
    my ($elt, $ev) = @_;
    my $os = "";
    my $gmath = $gmath_on;
    if(($gmath == 1) && ($mathml == 1)){
	if($elt->within("text") ne ""){
	    $gmath = 2;
	};
    };
    $os = charWrite("para","00B6", $gmath);
    output($os);
});
sgml('</spar>', "");

# Element: ssec -- section mark, LaTeX \S, HTML's &sect;
sgml('<ssec>', "&#x00A7;");
sgml('</ssec>', "");

# Element: cslae -- ae ligature, LaTeX \ae, HTML's &aelig;
sgml('<cslae>', "&#x00E6;");
sgml('</cslae>', "");

# Element: csuae -- AE ligature, LaTeX \AE, HTML's &AElig;
sgml('<csuae>', "&#x00C6;");
sgml('</csuae>', "");

# Element: copyright
sgml('<copyright>', "&#x00A9;");
sgml('</copyright>', "");

# Element: pounds -- pound currency, LaTeX \pounds, HTML's &pound;
sgml('<pounds>', "&#x00A3;");
sgml('</pounds>', "");

# Element: aoq
sgml('<aoq>', "&#xA0;?");
sgml('</aoq>', "");

# Element: aoe
sgml('<aoe>', "&#xA0;!");
sgml('</aoe>', "");

# Element: lg0
sgml('<lg0>', "");
sgml('</lg0>', "");

# Element: bal
sgml('<bal>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</bal>', sub{
    my $pos = pop_output;
    my $os;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="(" close =")"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "bal")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"bal\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # bal
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "(" . $pos . ")";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"middle\" align=\"right\">(</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">" . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">)</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: balbr
sgml('<balbr>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</balbr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="{" close ="}"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "balbr")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"balbr\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # balbr
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "{" . $pos . "}";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"middle\" align=\"right\">{</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">" . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">}</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: lbalbr
sgml('<lbalbr>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</lbalbr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="{" close =""' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "lbalbr")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"lbalbr\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # lbalbr
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "{" . $pos . " ";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr>";
    $os = $os . "<td valign=\"middle\" align=\"right\">{</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">";
    $os = $os . $pos . "</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: rbalbr
sgml('<rbalbr>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</rbalbr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="" close ="}"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "rbalbr")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"rbalbr\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # rbalbr
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = " " . $pos . "}";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr>";
    $os = $os . "<td valign=\"middle\" align=\"right\">";
    $os = $os . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">}</td>";
    $os = $os . "</tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: balsb
sgml('<balsb>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</balsb>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="[" close ="]"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "balsb")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"balsb\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # balsb
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "[" . $pos . "]";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"middle\" align=\"right\">[</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">" . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">]</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: balab
sgml('<balab>', sub{
    if(($mathml == 0) && ($dmath_on ==1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</balab>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="&lt;" close ="&gt;"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "balab")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"balab\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # balab
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "&lt;" . $pos . "&gt;";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"middle\" align=\"right\">&lt;</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">" . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">&gt;</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: balvbr
sgml('<balvbr>', sub{
    if(($mathml == 0) && ($dmath_on == 1)){
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    push_output('string');
});
sgml('</balvbr>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $par = $elt->parent;
    my $pan = $par->name;
    my $os;
    if($mathml == 1){
	my $mfo = "<mrow>";
	my $mfc = "</mrow>";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld == 1){
	    $mfo = "";
	    $mfc = "";
	};
	$os = '<mfenced open="|" close ="|"' . "\n>" . $mfo . $pos . $mfc
	    . "</mfenced\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "balvbr")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for \"balvbr\" at l. ",
	    $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # balvbr
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
	return;
    };
    if($dmath_on == 0){
	$os = "|" . $pos . "|";
	output($os);
	return;
    };
    # Case remaining: $mathml == 0 and $dmath_on == 1
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $unirow[$tabdepth] = 0;
    $tabdepth--;
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td valign=\"middle\" align=\"right\">|</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">" . $pos . "</td>";
    $os = $os . "<td valign=\"middle\" align=\"left\">|</td></tr></table>\n";
    if($unirow[$tabdepth]==1){
	$os = $os . "</td><td>";
    };
    if($pan =~ /$parasregexp/){
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")&&
	   ($tabdepth==0)){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: func
sgml('<func>', sub{
    push_output('string');
});
sgml('</func>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $pan = $elt->parent->name;
    my $os = "";
    if($mathml == 1){
	if($pan =~ /^bal/){
	    $os = "<mi>" . $pos . "</mi>";
	}
	else{
	    $os = '<mrow><mspace width="0.2em"/><mi>' . $pos . "</mi></mrow>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # func
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "<b>" . $pos . "</b>";
	output($os);
    };
});

# Element: noanchorfootnote  -- for printed versions only
sgml('<noanchorfootnote>', "");
sgml('</noanchorfootnote>', "");

# Element: nobanner
sgml('<nobanner>', sub{$nobanner=1;});
sgml('</nobanner>', "");

# Element: banner
sgml('<banner>', sub{$nobanner=0;});
sgml('</banner>', "");

# Use of "nogratlinks" and "gratlinks" depends on the default setting
#   of the variable $nogratlinks at the top of this file
# Element: nogratlinks
sgml('<nogratlinks>', sub{$nogratlinks=1;});
sgml('</nogratlinks>', "");

# Element: gratlinks -- Create default gratutitous links
sgml('<gratlinks>', sub{$nogratlinks=0;});
sgml('</gratlinks>', "");

# Element: nobaseprint -- Don't show gratlinks in non-network outputs.
sgml('<nobaseprint>', "");
sgml('</nobaseprint>', "");

# Element: verse
sgml('<verse>', sub{
    $parqv_ser = 0;
    if($hpar_on == 1){
	$hpar_on = 0;
	output("</p>\n<blockquote>\n");
    }
    else{
	output("<blockquote>\n");
    }
});
sgml('</verse>', sub{
    my $pan = $_[0]->parent->name;
    if(($pan =~ /$parasregexp/)&&($hpar_on == 0)){
	$hpar_on = 1;
	output("</blockquote>\n<p>");
    }
    else{
	output("</blockquote>\n");
    }
});

# Element: bodymaketitle
sgml('<bodymaketitle>', sub{
    $bodymaketitle=1;
});
sgml('</bodymaketitle>',"");

# Element: maketitle
sgml('<maketitle>', sub{
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pan eq "preamble"){
	$maketitle=1;
    }
    elsif($pan eq "body"){
	if($bodymaketitle == 1){
	    $os = do_maketitle();
	    output($os);
	};
    };
});
sgml('</maketitle>',"");

# Element: doctop
sgml('<doctop>', "");
sgml('</doctop>', "");

# Element: notitle
sgml('<notitle>', sub{
    $notitle = 1;
});
sgml('</notitle>', "");

# Element: latexcommand
sgml('<latexcommand>', sub{
    push_output('nul');
});
sgml('</latexcommand>', sub{
    pop_output;
});

# Element: desc -- descriptive text for item in defnlist
sgml('<desc>', sub{
    $hpar_on = 0; # 20030715
    push_output('string');
});
sgml('</desc>', sub{
    my $pos = pop_output;
    my $os = "";
    if(length($pos) > 0){
	$os = $os . "<dd>" . $pos;
	if($hpar_on == 1){
	    $os = $os . "</p>\n";
	    $hpar_on = 0;
	};
	$os = $os . "</dd>\n";
    }
    else{
	$os = "<dd><br\n" . $clemp . "</dd>";
    }
    output($os);
});

# Element: defnlist -- definition list (like "dl" in HTML
# or the "description" environment in LaTeX)
sgml('<defnlist>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#    &&($hpar_on == 1)){
	#    $hpar_on = 0;
	#    $os = $os . "</p>\n";
	# };
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $os = $os . "<dl>\n";
    output($os);
});
sgml('</defnlist>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	#    $hpar_on = 1;
	#    $os = $os . "<p>";
	# };
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element: citations -- definition list (like "dl" in HTML
# or the "description" environment in LaTeX) -- variant: different "term"
sgml('<citations>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	my $pan = $_[0]->parent->name;
    #	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
    #	   &&($hpar_on == 1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $os = $os . "<dl><dd><dl>\n";  #Nesting for left margin effect.
    output($os);
});
sgml('</citations>', sub{
    my $os = "</dl></dd></dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	#    $hpar_on = 1;
	#    $os = $os . "<p>";
	#};
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element: term
sgml('<term>', "<dt><b>");
sgml('</term>', "</b></dt>\n");

# Element: abstract
sgml('<abstract>', "<h3 " . $ctratt . ">ABSTRACT</h3>\n<blockquote>\n");
sgml('</abstract>', "</blockquote>\n");

# Element: legalnotice
sgml('<legalnotice>', "<h3 " .$ctratt .">Permission</h3>\n<blockquote>\n");
sgml('</legalnotice>', "</blockquote>\n");

# Element: label -- location marker
sgml('<label>', sub{
    push_output('string');
});
sgml('</label>', sub{
    my $pos = pop_output;
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $lid = "";
    my $vis = "";
    my $tos = "";
    my $os = "";
    if($pos ne ""){
	$lid = $pos;
    }
    elsif($_[0]->attribute("lseq")->value ne ""){
	$lid = "label-" . $_[0]->attribute("lseq")->value;
    };
    if($lid ne ""){
	if($xhtmlstrict == 1){
	    $tos = '<a id="' . $lid . '">';
	}
	else{
	    $tos = '<a name="' . $lid . '" id="' . $lid . '">';
	};
    };
    if(($pan eq "thebibliography")&&($lid =~/^SU-TheBibLiog/)){
	$thebiblilabel = $tos . "</a>";
	return;
    }
    elsif($pan eq "eqnrow"){
	$eqlabelcount++;
	$eqrkey = $lid;
	if($eqlabelcount == 1){
	    # $os = "<td>" . $tos;
	    $os = "";
	}
	else{
	    # $os = $tos;
	    $os = "";
	};
	return;
    }
    else{
	$os = $tos;
    };
    $os = $os . "</a>";
    if($pan eq "itemlabel"){
	$labelinitem = $os;
    }
    else{
	output($os);
    };
});

# Element: ref -- internal reference
sgml('<ref>', sub{
    push_output('string');
});
sgml('</ref>', sub{
    my $key = pop_output; # the reference key
    my $vis = '?' . $key . '?';
    if($labelsers{$key} ne ""){
	$vis = $labelserseqs{$key};
    }
    elsif($labelsecunits{$key} ne ""){
	$vis = $labelsecunits{$key};
    }
    elsif($labelsids{$key} ne ""){
	$vis = $labelsids{$key};
    }
    else{
	print STDERR $WhoAmI, " -- ref key may not match label: \"$key\"\n";
    };
    my $os = $vis;
    output($os);
});

# Element: pageref -- internal reference; like "ref" for now
sgml('<pageref>', sub{
    push_output('string');
});
sgml('</pageref>', sub{
    my $pos = pop_output;
    # my $os = '<a href="#' . $pos . '">[' . $pos . ']</a>';
    my $os = "<a href=\"#" . $pos . "\">*</a>";
    output($os);
});

# Element: klabel
sgml('<klabel>', sub{
    push_output('string');
});
sgml('</klabel>', sub{
    my $pos = pop_output;
    if($xhtmlstrict == 1){
	my $os = '<a id="' . $pos . '">[' . $pos . ']</a>';
    }
    else{
	my $os = '<a name="' . $pos . '" id="' . $pos . '">[' . $pos . ']</a>';
    };
    output($os);
});

# Element: kref
sgml('<kref>', sub{
    push_output('string');
});
sgml('</kref>', sub{
    my $pos = pop_output;
    my $os = '<a href="#' . $pos . '">[' . $pos . ']</a>';
    output($os);
});

# Element: menu -- like the former HTML menu, compact version
sgml('<menu>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    if($pan =~ /$parasregexp/){
	my $pan = $_[0]->parent->name;
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	   &&($hpar_on == 1)){
	    $hpar_on = 0;
	    $os = $os . "</p>\n";
	};
    };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    if($xhtmlstrict == 0){
	$os = $os . "<dl compact=\"compact\">\n";
    }
    else{
	$os = $os . "<dl>\n";
    };
    output($os);
});
sgml('</menu>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	my $pan = $_[0]->parent->name;
	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	   &&($pan ne "tdp")){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    output($os);
});

# Element: Menu -- like the former HTML menu
sgml('<Menu>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
    #	   &&($hpar_on == 1)){
    #	    $hpar_on = 0;
    #	    $os = $os . "</p>\n";
    #	};
    # };
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    $os = $os . "<dl>\n";
    output($os);
});
sgml('</Menu>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element: parlist
sgml('<parlist>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
    #	   &&($hpar_on == 1)){
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    #	};
    };
    $os = $os . "\n<p>";
    $hpar_on = 1; # 20030717
    output($os);
});
sgml('</parlist>', sub{
    my $os = "</p>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($pan ne "tdp")){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

sub do_maketitle{
    my $os = "";   # Early GELLMU article required non-empty title
    if($arttitle ne ""){
	$os = $os . "<h1 " . $ctratt . ">" . $arttitle . "</h1>\n";
    };
    if($artsubtitle ne ""){
	$os = $os . "<h4 " . $ctratt . ">" . $artsubtitle . "</h4>\n";
    };
    if($authorseq > 0){
	my $jauth = 1;
	while($jauth <= $authorseq){
	    $os = $os . "<h2 " . $ctratt . ">" . $authorname[$jauth] 
		. "</h2>\n";
	    if($authoraddr[$jauth] ne ""){
		$os = $os . "<h4 " . $ctratt . ">\n"
                          . $authoraddr[$jauth] . "</h4>\n";
	    }
	    if($authoremail[$jauth] ne ""){
		if($haveemail[$jauth] > 1){
		    $os = $os . "<p " . $ctratt . ">Email addresses:<br\n" 
			. $clemp . "<kbd>";
		}
		elsif($haveemail[$authorseq] == 1){
		    $os = $os . "<p " . $ctratt . ">Email: <kbd>";
		}
		else{
		    print STDERR "WARNING: Logical error in perl code:\n",
                                 "'haveemail' not positive\n", "authorseq: ",
                                 $authorseq , "\n", "havemail: ",
                                 $haveemail[$authorseq], "\n";
		};
		$os = $os . $authoremail[$jauth] . "</kbd></p>\n";
	    };
	    $jauth++;
	};
    };
    if($havedate == 1){
	$os = $os . "<h4 " . $ctratt . ">" . $datestr . "</h4>\n";
    };
    if($copynotice ne ""){
	$os = $os . "<h5 " . $ctratt . ">" . $copynotice . "</h5>\n";
    };
    return $os;
};

# Element: partial -- partial differentiation "d" symbol
sgml('<partial>', &charWrite("partial", "2202"));
sgml('</partial>', "");

# Element: nabla -- gradient symbol
sgml('<nabla>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mi>&#x2207;</mi>");
    }
    else{
	output(" \\nabla ");
    };
});
sgml('</nabla>', "");

# Element: ovbar -- over bar accent, math or not
sgml('<ovbar>', sub{
    push_output('string');
});
sgml('</ovbar>', sub{
    my $elt = $_[0];
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = '<mover accent="true">' . $pos . "<mo>&#x00AF;</mo></mover\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # ovbar
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\={" . $pos . "}";
	if($pos =~ /^&\#/){
	    $os = $pos;
	}
	elsif($pos eq "A"){
	    $os = "&#x0100;";
	}
	elsif($pos eq "a"){
	    $os = "&#x0101;";
	}
	elsif($pos eq "E"){
	    $os = "&#x0112;";
	}
	elsif($pos eq "e"){
	    $os = "&#x0113;";
	}
	elsif($pos eq "I"){
	    $os = "&#x012A;";
	}
	elsif($pos eq "i"){
	    $os = "&#x012B;";
	}
	elsif($pos eq "O"){
	    $os = "&#x014C;";
	}
	elsif($pos eq "o"){
	    $os = "&#x014D;";
	}
	elsif($pos eq "U"){
	    $os = "&#x016A;";
	}
	elsif($pos eq "u"){
	    $os = "&#x016B;";
	}
	output($os);
    };
});

# Element: unbar
sgml('<unbar>', sub{
    push_output('string');
});
sgml('</unbar>', sub{
    my $pos = pop_output;
    my $os = $pos . "&#x0332;";
    if($pos =~/^&\#/){
	$os = $pos;
    }
    elsif($pos eq "B"){
	$os = "&#x1E06;";
    }
    elsif($pos eq "b"){
	$os = "&#x1E07;";
    }
    elsif($pos eq "D"){
	$os = "&#x1E0E;";
    }
    elsif($pos eq "d"){
	$os = "&#x1E0F;";
    }
    elsif($pos eq "K"){
	$os = "&#x1E34;";
    }
    elsif($pos eq "k"){
	$os = "&#x1E35;";
    }
    elsif($pos eq "L"){
	$os = "&#x1E3A;";
    }
    elsif($pos eq "l"){
	$os = "&#x1E3B;";
    }
    elsif($pos eq "N"){
	$os = "&#x1E48;";
    }
    elsif($pos eq "n"){
	$os = "&#x1E49;";
    }
    elsif($pos eq "R"){
	$os = "&#x1E5E;";
    }
    elsif($pos eq "r"){
	$os = "&#x1E5F;";
    }
    elsif($pos eq "T"){
	$os = "&#x1E6E;";
    }
    elsif($pos eq "t"){
	$os = "&#x1E6F;";
    }
    elsif($pos eq "Z"){
	$os = "&#x1E94;";
    }
    elsif($pos eq "z"){
	$os = "&#x1E95;";
    }
    elsif($pos eq "h"){
	$os = "&#x1E96;";
    };
    output($os);
});

# Element: secnumdepth -- depth of least significant sectional unit
#                        that is to be numbered.
#   part = 0, section = 1, subsection = 2, subsubsection = 3
sgml('<secnumdepth>', sub{
    push_output('string');
});
sgml('</secnumdepth>', sub{
    my $pos = pop_output;
    $secnumdepth = $pos;
});

# Element: circ -- LaTeX circ, as with composition of functions
sgml('<circ>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "<mo>&#x2218;</mo>";
    }
    elsif($xhtmlstrict == 1){
	$os = $os . "&#x2218;";
    }
    else{
	$os = $os . "\\circ ";
    }
    output($os);
});
sgml('</circ>', "");

# Element: rightarrow -- LaTeX rightarrow
sgml('<rightarrow>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2192;</mo>");
    }
    else{
	output(" --&gt; ");
    };
});
sgml('</rightarrow>', "");

# Element: longrightarrow -- LaTeX longrightarrow
sgml('<longrightarrow>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	if($lackMathGlyphs == 1){
	    output("<mo>&#x2192;</mo>");
	}
	else{
	    output("<mo>&#x27F6;</mo>");
	};
    }
    else{
	output(" ----&gt; ");
    };
});
sgml('</longrightarrow>', "");

# Element: leftarrow -- LaTeX leftarrow
sgml('<leftarrow>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2190;</mo>");
    }
    else{
	output(" &lt;-- ");
    };
});
sgml('</leftarrow>', "");

# Element: longleftarrow -- LaTeX longleftarrow
sgml('<longleftarrow>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x27F5;</mo>");
    }
    else{
	output(" &lt;---- ");
    };
});
sgml('</longleftarrow>', "");

# Element: leftrightarrow -- LaTeX leftrightarrow
sgml('<leftrightarrow>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2194;</mo>");
    }
    else{
	output(" &lt;--&gt; ");
    };
});
sgml('</leftrightarrow>', "");

# Element: wedge -- LaTeX wedge (math symbol)
sgml('<wedge>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2227;</mo>");
    }
    else{
	output(" ^ ");
    };
});
sgml('</wedge>', "");

# Element: oplus -- LaTeX oplus (dir sum math symbol)
sgml('<oplus>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2295;</mo>");
    }
    else{
	output("\\oplus");
    };
});
sgml('</oplus>', "");

# Element: ominus -- LaTeX ominus (circled minus math symbol)
sgml('<ominus>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2296;</mo>");
    }
    else{
	output("\\ominus");
    };
});
sgml('</ominus>', "");

# Element: otimes -- LaTeX otimes (tensor product math symbol)
sgml('<otimes>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2297;</mo>");
    }
    else{
	output("\\otimes");
    };
});
sgml('</otimes>', "");

# Element: in -- LaTeX in (math set membership symbol)
sgml('<in>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2208;</mo>");
    }
    else{
	output("\\in");
    };
});
sgml('</in>', "");

# Element: not -- LaTeX not (math set not a member symbol)
sgml('<not>', "");
sgml('</not>', "");

sgml('<not0>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x2209;</mo>");
    }
    else{
	output("\\not");
    };
});
sgml('</not0>', "");

# Element: compacttitle
sgml('<compacttitle>', "");
sgml('</compacttitle>', "");

# Element: norm -- math norm (i.e., "||x||")
sgml('<norm>', sub{
    push_output('string');
});
sgml('</norm>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	$os = $pos;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $os = '<mfenced open="||" close="||"><mrow>' . $os
		. "</mrow></mfenced\n>";
	}
	else{
	    $os = '<mfenced open="||" close="||">' . $os . "</mfenced>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # norm
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = " ||" . $pos . "|| ";
	output($os);
    };
});
sgml('<norm0>', " ||");
sgml('</norm0>', "|| ");

# Element: absval -- math absolute value (i.e., "|x|")
sgml('<absval>', sub{
    push_output('string');
});
sgml('</absval>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	$os = $pos;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $os = '<mfenced open="|" close="|"><mrow>' . $os
		. "</mrow></mfenced\n>";
	}
	else{
	    $os = '<mfenced open="|" close="|">' . $os . "</mfenced>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # absval
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = " |" . $pos . "| ";
	output($os);
    };
});
sgml('<absval0>', " |");
sgml('</absval0>', "| ");

# Element: transp -- matrix transpose
sgml('<transp>', sub{
    if($mathml == 1){
	push_output('string');
    }
    else{
	output(" <b>transp</b>(");
    };
});
sgml('</transp>', sub{
    if($mathml == 1){
	my $pos = pop_output;
	my $os = "";
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	my $wo = "";
	my $wc = "";
	if($nchld > 1){
	    $wo = "<mrow>";
	    $wc = "</mrow>";
	};
	$os = "<mmultiscripts>" . $wo . $pos . $wc;
	$os = $os . "<mprescripts/><none/><mo rspace=\"-.5em\">t</mo></mmultiscripts\n>";
	output($os);
    }
    else{
	output(") ");
    };
});

# Element: vdots -- math vertical dots
sgml('<vdots>', sub{
    if($mathml == 1){
	output("<mo>&#x22EE;</mo>");
    }
    else{
	output(":");
    };
});
sgml('</vdots>', "");

# Element: ddots -- math down right diagonal dots
sgml('<ddots>', sub{
    if($mathml == 1){
	output("<mo>&#x22F1;</mo>");
    }
    else{
	output(":");
    };
});
sgml('</ddots>', "");

# Element: mapsto -- LaTeX name
sgml('<mapsto>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x21A6;</mo>");
    }
    else{
	output(" :--&gt; ");
    };
});
sgml('</mapsto>', "");

# Element: longmapsto -- LaTeX name
sgml('<longmapsto>', sub{
    if(($gmath_on == 1) && ($mathml == 1)){
	output("<mo>&#x21A6;</mo>");  # should be &#x27FC;
    }
    else{
	output(" :---&gt; ");
    };
});
sgml('</longmapsto>', "");

# Element: angle -- LaTeX name
sgml('<angle>', &charWrite("angle", "2220"));
sgml('</angle>', "");

# Element: perp -- LaTeX name
sgml('<perp>', &charWrite("perp", "22A5"));
sgml('</perp>', "");

# Element: nocustomlengths:
sgml('<nocustomlengths>', "");
sgml('</nocustomlengths>', "");

# Element: feed
sgml('<feed>', sub{
    my $os = "\n<hr" . $clemp . "\n";
    output($os);
});
sgml('</feed>', "");

# Element: bref
sgml('<bref>', sub{
    push_output('string');
});
sgml('</bref>', sub{
    my $pos = pop_output;
    my $os = "<a href=\"#" . $pos . "\">*</a>";
    output($os);
});

# Element: subset
sgml('<subset>', &charWrite("&lt;=", "2282"));
sgml('</subset>', "");

# Element: supset
sgml('<supset>', &charWrite("&gt;=", "2283"));
sgml('</supset>', "");

# Element: subseteq
sgml('<subseteq>', &charWrite("&lt;=", "2286"));
sgml('</subseteq>', "");

# Element: supseteq
sgml('<supseteq>', &charWrite("&gt;=", "2287"));
sgml('</supseteq>', "");

# Element: parallel
sgml('<parallel>', &charWrite("||", "2225"));
sgml('</parallel>', "");

# Element: cap -- e.g., the symbol for intersection of sets
sgml('<cap>', &charWrite("cap","2229") );
sgml('</cap>', "");

# Element: cup -- e.g., the symbol for union of sets
sgml('<cup>', &charWrite("cup","222A") );
sgml('</cup>', "");

# Element: nwarrow
sgml('<nwarrow>', &charWrite("nwarrow","2196") );
sgml('</nwarrow>', "");

# Element: nearrow
sgml('<nearrow>', &charWrite("nearrow","2197") );
sgml('</nearrow>', "");

# Element: searrow
sgml('<searrow>', &charWrite("searrow","2198") );
sgml('</searrow>', "");

# Element: swarrow
sgml('<swarrow>', &charWrite("swarrow","2199") );
sgml('</swarrow>', "");

# Element: backslash
sgml('<backslash>', &charWrite("\\", "2216") );
sgml('</backslash>', "");

# Element: lessdot
sgml('<lessdot>', &charWrite("lessdot","22D6") );
sgml('</lessdot>', "");

# Element: gtrdot
sgml('<gtrdot>', &charWrite("gtrdot","22D7") );
sgml('</gtrdot>', "");

# Element: emptyset
sgml('<emptyset>', &charWrite("&#x00D8;","2205") );
sgml('</emptyset>', "");

# Element: bullet -- bullet math symbol
sgml('<bullet>', sub{
    my ($elt, $ev) = @_;
    my $os = "";
    my $gmath = $gmath_on;
    if(($gmath == 1) && ($mathml == 1)){
	if($elt->within("text") ne ""){
	    $gmath = 2;
	};
    };
    # $os = charWrite("bullet","2022", $gmath);
    $os = charWrite("&#x2022;", "2022", $gmath);
    output($os);
});
sgml('</bullet>', "");

# Element: langle -- math symbol something like "<"
sgml('<langle>', sub{
    my $os = "";
    if($mathml == 1){
	$os = '<mo stretchy="true">&#x2329;</mo>';
    }
    else{
	$os = "&lt;";
    };
    output($os);
});
sgml('</langle>', "");

# Element: rangle -- math symbol something like "<"
sgml('<rangle>', sub{
    my $os = "";
    if($mathml == 1){
	$os = '<mo stretchy="true">&#x232A;</mo>';
    }
    else{
	$os = "&gt;";
    };
    output($os);
});
sgml('</rangle>', "");

# Element: iseq -- item label for inline list
sgml('<iseq>', sub{
    push_output('string');
});
sgml('</iseq>', sub{
    my $pos = pop_output;
    my $os = " " . $pos . " ";
    output($os);
});

# Element: softw -- name of software
sgml('<softw>', "<em>");
sgml('</softw>', "</em>");

sgml('<citekey0>', sub{
    push_output('string');
});
sgml('</citekey0>', sub{
    my $key = pop_output;
    my $id = $bibprefix . $key;
    my $cnote = $thiscitenote;
    my $ref = $labelserseqs{$id};
    if($ref eq ""){
	$ref = "*";
    };
    my $vis = "\[" . $ref;
    if($cnote ne ""){
	$vis = $vis . ", " . $cnote;
    };
    $vis = $vis . "\]";
    my $os = "<a href=\"#" . $id . "\">$vis</a>";
    output($os);
});

# Element: kcite -- citation with key = visible label
sgml('<kcite>', sub{
    push_output('string');
});
sgml('</kcite>', sub{
    my $key = pop_output;
    my $id = $bibprefix . $key;
    my $os = "<a href=\"#" . $id . "\">[$key]</a>";
    output($os);
});

# Element: citekey -- citation with key = visible label
sgml('<citekey>', sub{
    push_output('string');
});
sgml('</citekey>', sub{
    $thiscitekey = pop_output;
});

# Element: citenote
sgml('<citenote>', sub{
    push_output('string');
});
sgml('</citenote>', sub{
    $thiscitenote = pop_output;
});

# Element: citetext
sgml('<citetext>', sub{
    push_output('string');
});
sgml('</citetext>', sub{
    $thiscitetext = pop_output;
});

# Element: cite
sgml('<cite>', sub{
    $thiscitekey = "";
    $thiscitenote = "";
    $thiscitetext = "";
    push_output('string');
});
sgml('</cite>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    my $os = "";
    if($pos ne ""){
	print STDERR "Loose content in <cite>\n";
    };
    my $id = $bibprefix . $thiscitekey;
    my $vis = "\[" . $thiscitetext;
    if($thiscitenote ne ""){
	$vis = $vis . ", " . $thiscitenote;
    };
    $vis = $vis . "\]";
    if(($mathml == 1) && ($sv_gmath_on == 1) && ($xlinkflag == 1)
       && ($pan eq "text")){
	$os = $os . "</mtext><mtext";
	$os = $os . ' xmlns:xlink="http://www.w3.org/1999/xlink"';
	$os = $os . ' xlink:type="simple"';
	$os = $os . ' xlink:href="#' . $id . '">';
	$os = $os . $vis . "</mtext><mtext>";
    }
    else{
	$os = "<a href=\"#" . $id . "\">" . $vis . "</a>";
    };
    output($os);
});

# Element: bibentry
sgml('<bibentry>', sub{
    $bibliseq++;
    $thisbibkey = "";
    $thisbiblabel = "";
    output("<dd>");
});
sgml('</bibentry>', sub{
    my $os = "</dd \n>";
    output($os);
});

# Element: bibhead
sgml('<bibhead>', sub{
    push_output('string');
});
sgml('</bibhead>', sub{
    my $pos = pop_output;
    my $os = "";
    if($pos ne ""){
	print STDERR $WhoAmI, " WARNING: Loose content in bibhead, ",
	"  bibentry $bibliseq -- $pos --\n";
    };
$os = "\[" . $thisbiblabel . "\]&#xA0;&#xA0; ";
    output($os);
});

# Element: biblabel
sgml('<biblabel>', sub{
    push_output('string');
});
sgml('</biblabel>', sub{
    my $pos = pop_output;
    if($pos ne ""){
	$thisbiblabel = $pos;
    }
    else{
	$thisbiblabel = $bibliseq;
    };
});

# Element: bibkey
sgml('<bibkey>', sub{
    push_output('string');
});
sgml('</bibkey>', sub{
    my $pos = pop_output;
    if ($pos eq ""){
	$pos = "NoKey-" . $bibliseq;
	# This should have been handled in xmlgart.pl
	print STDERR $WhoAmI, " WARNING: No key for bibentry $bibliseq\n";
    };
    $thisbibkey = $pos;
});

# Element: bibbody
sgml('<bibbody>', "\n");
sgml('</bibbody>', "");

# Element: slnt -- slanted style
sgml('<slnt>', sub{
    push_output('string');
});
sgml('</slnt>', sub{
    my $pos = pop_output;
    my $os = "";
    my $elt = $_[0];
    my $pan = $elt->parent->name;
    if(($mathml == 1) &&
       (($elt->within("mbox") ne "") || ($elt->within("regch") ne ""))
       && (($gmath_on == 1) || ($sv_gmath_on == 1))){
	$os = $pos;
    }
    elsif(($mathml == 1) && ($sv_gmath_on == 1) && ($pan eq "text")){
	$os = $pos;
    }
    elsif(($gmath_on == 1) && ($mathml == 1)){
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',',$chld));
	if($nchld > 1){
	    $os = '<mrow fontstyle="italic">' . $pos . "</mrow\n>";
	}
	else{
	    $os = '<mi fontstyle="italic">' . $pos . "</mi\n>";
	};
    }
    else{
	$os = "<em>" . $pos . "</em>";
    };
    output($os);
});

# Element: slnt -- slanted style
sgml('<slnt0>', "<em>");
sgml('</slnt0>', "</em>");

# Element: ovvee -- "check" accent, i.e., "\v" in LaTeX; render plain for now
sgml('<ovvee>', "");
sgml('</ovvee>', "");

# Element: thebibliography -- hand-rolled bibliography
sgml('<thebibliography>', sub{
    # To wait for $thebiblilabel
    push_output('string');
});
sgml('</thebibliography>', sub{
    my $pos = pop_output;
    my $os = "\n<hr" . $clemp . "\n<h3 " . $ctratt . ">" . $thebiblilabel;
    $os = $os . "REFERENCES</h3>\n<dl>\n";
    $os = $os . $pos;
    $os = $os . "</dl>\n";
    output($os);
});
###
sgml('<thebibliography0>',
  "\n<hr />\n<h3 " . $ctratt . ">REFERENCES</h3>\n<dl>\n");
sgml('</thebibliography0>', "</dl>\n");
###

# Element: vbibitem -- bilio item with key = visible label
sgml('<vbibitem>', sub{
    push_output('string');
});
sgml('</vbibitem>', sub{
    my $key = pop_output;
    my $id = $bibprefix . $key;
    if($xhtmlstrict == 1){
	my $os = "<a id=\"" . $id . "\"><b>[" . $key
	    . "]</b></a>&#xA0;&#xA0; ";
    }
    else{
	my $os = "<a name=\"". $id . "\" id=\"" . $id . "\"><b>["
	    . $key . "]</b></a>&#xA0;&#xA0; ";
    };
    output($os);
});

# Element: hy0 -- hyphenation hint
sgml('<hy0>', "");
sgml('</hy0>', "");

# Element: binom
sgml('<binom>', sub{
    $binargid = 0;
    $binoml = 0;
    $binomu = 0;
    push_output('string');
});
sgml('</binom>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	my $wo = '<mfrac linethickness="0">';
	my $wc = "</mfrac\n>";
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',', $parchld);
	my $nsybs = scalar(@sybs);
	unless(($nsybs ==1) || ($pan =~ /$fracconregexp/)){
	    $wo = '<mrow><mfrac linethickness="0">';
	    $wc = "</mfrac></mrow\n>";
	};
	$os = "<mfenced>" . $wo . $binomu . $binoml . $wc . "</mfenced>";
    }
    else{
	$os = " <b>binom</b>($binomu, $binoml) ";
    };
    output($os);
});

# Element binl
sgml('<binl>', sub{
    push_output('string');
});
sgml('</binl>', sub{
    my $elt = $_[0];
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $chld = $elt->attribute("mchld")->value;
	my $nchlds = scalar(split(',', $chld));
	if($nchlds > 1){
	    $binoml = "<mrow>" . $pos . "</mrow>";
	}
	else{
	    $binoml = $pos;
	};
    }
    else{
	$binoml = $pos;
    };
});

# Element binu
sgml('<binu>', sub{
    push_output('string');
});
sgml('</binu>', sub{
    my $elt = $_[0];
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $chld = $elt->attribute("mchld")->value;
	my $nchlds = scalar(split(',', $chld));
	if($nchlds > 1){
	    $binomu = "<mrow>" . $pos . "</mrow>";
	}
	else{
	    $binomu = $pos;
	};
    }
    else{
	$binomu = $pos;
    };
});
sgml('<binu0>', sub{
    push_output('string');
});
sgml('</binu0>', sub{
    $binomu = pop_output;
});

# Element equals
sgml('<equals>', sub{
    if($mathml == 1){
	output("<mo>=</mo>");
    }
    elsif (($gmath_on == 1)&&($inanchopt == 0)){
	if($unirow[$tabdepth] == 1){
	    output("&#xA0;=&#xA0;");
	}
	else{
	    output(" = ");
	};
    }
    else{
	output("=");
    };
});
sgml('</equals>', "");

# Element plus
sgml('<plus>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>+</mo>";
    }
    else{
	$os = "+";
    };
    output($os);
});
sgml('</plus>', "");

# Element minus
sgml('<minus>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2212;</mo>";
    }
    else{
	$os = "-";
    };
    output($os);
});
sgml('</minus>', "");

# Element quotient
sgml('<quotient>', sub{
    my $os = "";
    if($mathml == 1){
	if($stretchChallenged == 1){
	    $os = '<mo stretchy="true" lspace="0.3em" rspace="0.3em">&#x2044;</mo>';
	}
	else{
	    $os = "<mo stretchy=\"true\">&#x2044;</mo>";   # or &#x2044; ?
	};
    }
    else{
	$os = "/";
    };
    output($os);
});
sgml('</quotient>', "");

# Element neg -- unary negation (math)
sgml('<neg>', sub{
    push_output('string');
});
sgml('</neg>', sub{
    my $pos = pop_output;
    my $os = "-{" . $pos . "}";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mrow><mo>&#x2212;</mo>" . $pos . "</mrow>";
    };
    output($os);
});

# Element: radicand
sgml('<radicand>', sub{
    $simpleradicand[$sqrtdepth] = 0;
    push_output('string');
});
sgml('</radicand>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if ($sqrtdepth > 0){
	if($mathml == 1){
	    my $chld = $_[0]->attribute("mchld")->value;
	    my $nchld = scalar(split(',', $chld));
	    if($nchld > 1){
		$radicand[$sqrtdepth] = "<mrow>" . $pos . "</mrow>";
	    }
	    else{
		$radicand[$sqrtdepth] = $pos;
		if($chld eq "Cd0"){
		    $simpleradicand[$sqrtdepth] = 1;
		};
	    };
	}
	else{
	    $radicand[$sqrtdepth] = $pos;
	};
    }
    else{
	print STDERR $WhoAmI,
	": ERROR (radicand) sqrtdepth not positive in", $pan, "\n";
    };
});

# Element: radx
sgml('<radx>', sub{
    push_output('string');
});
sgml('</radx>', sub{
    my $pos = pop_output;
    my $pan = $_[0]->parent->name;
    if ($sqrtdepth > 0){
	if($mathml == 1){
	    my $chld = $_[0]->attribute("mchld")->value;
	    my $nchld = scalar(split(',', $chld));
	    if($nchld > 1){
		$radx[$sqrtdepth] = "<mrow>" . $pos . "</mrow>";
	    }
	    else{
		$radx[$sqrtdepth] = $pos;
	    };
	}
	else{
	    $radx[$sqrtdepth] = $pos;
	};
    }
    else{
	print STDERR $WhoAmI,
	": ERROR (radx) sqrtdepth not positive in", $pan, "\n";
    };
});

# Element: lgg
sgml('<lgg>', sub{
    push_output('string');
});
sgml('</lgg>', sub{
    my $pos = pop_output;
    my $os = $pos;
    output($os);
});

# Element: mlg
sgml('<mlg>', sub{
    push_output('string');
});
sgml('</mlg>', sub{
    my $os = "";
    my $pos = pop_output;
    # mathematical context implied
    if($mathml == 1){
	my $seq = $_[0]->attribute("mseq")->value;
	my $par = $_[0]->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "mlg")){
	    print STDERR $WhoAmI, ": WARNING -- Seq. no. mismatch for mlg at l. "
		, $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: "
		, $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: "
		, $sybs[$seq-1], "\n";
	};
	# An mlg "forces" an mrow
	my $chld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	}
	else{
	    $os = $pos;
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mlg
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	}
    }
    else{
	$os = "{" . $pos . "}";
	output($os);
    };
});

# Element: citetitle -- an external title citation
sgml('<citetitle>', "<em>");
sgml('</citetitle>', "</em>");

# Element: mathsym -- markup for declaring math symbol
sgml('<mathsym>', sub{
    push_output('nul');
});
sgml('</mathsym>', sub{
    pop_output;
});

# Element: TableOfContents
sgml('<TableOfContents>', sub{
    my $os = '<div class="tableofcontents">' . "\n";
    $os = $os . "<h3>Table of Contents</h3>\n<dl class=\"tableofcontents\">\n";
    output($os);
});
sgml('</TableOfContents>', sub{
    my $os = "";
    my $depth = 0;
    while($currtocdepth > $depth){
	$os = $os . "</dd></dl>";
	$currtocdepth --;
    };
    $os = $os . "\n</div>\n";
    output($os);
});

# Element: tocitem
sgml('<tocitem>', sub{
    my $depth = $_[0]->attribute("depth")->value;
    my $diff = $currtocdepth - $depth;
    my $os = "";
    if($currtocdepth == 0){  # Just starting
	if($depth != 1){
	    print STDERR
		$WhoAmI, " WARNING: Cannot descend more than one section",
		"\n  level at a time -- elt. ", $_[0]->name, "seq. $eltser \n";
	}
	else{
	    $currtocdepth = 1;
	    $os = "<dd>";
	};
    }
    elsif($depth == $currtocdepth){
	$os = "</dd><dd>\n";
    }
    elsif(($diff == 1) && ($depth > 0)){
        # Returning one level toward the top
	$os = "</dd></dl></dd><dd>\n";
	$currtocdepth = $depth;
    }
    elsif(($diff == 2) && ($depth > 0)){
        # Returning two levels toward the top
	$os = "</dd></dl></dd></dl></dd><dd>\n";
	$currtocdepth = $depth;
    }
    elsif(($diff == 3) && ($depth > 0)){
        # Returning three levels toward the top
	$os = "</dd></dl></dd></dl></dd></dl></dd><dd>\n";
	$currtocdepth = $depth;
    }
    elsif(($diff == -1) && ($depth > 0)){
        # Descending one level
	$os = "<dl><dd>\n";
	$currtocdepth = $depth;
    }
    elsif(($diff < -1) && ($depth > 0)){
        # Trying to descend two or more levels ?
	print STDERR 
	    $WhoAmI, " WARNING: Cannot descend more than one section",
	    "\n  level at a time -- elt. ", $_[0]->name, "seq. $eltser \n";
    }
    else{
	print STDERR $WhoAmI, " WARNING: toc depth change not supported\n",
	"  Elt. \"", $_[0]->name, "\" in \"", $_[0]->parent->name, "\"\n";
    };
    output($os);
});
sgml('</tocitem>', "\n");

# Element: tocunitlength
sgml('<tocunitlength>', sub{
    push_output('string');
});
sgml('</tocunitlength>', sub{
    my $os = pop_output;
    output($os);
});

# Element: tocunit
sgml('<tocunit>', sub{
    push_output('string');
});
sgml('</tocunit>', sub{
    my $pos = pop_output;
    my @tunitarray = split(/\./, $pos);
    my $len = scalar @tunitarray;
    my $os = $pos;
    if(($tocunitlength > 0) && ($len > $tocunitlength)){
	while($len > $tocunitlength){
	    shift @tunitarray;
	    $len--;
	};
	$os = join(".", @tunitarray);
    };
    $os = $os . "&#xA0;&#xA0;";
    output($os);
});

# Element: tocentry
sgml('<tocentry>', "");
sgml('</tocentry>', "");

# Element: tocdepth
sgml('<tocdepth>', sub{
    push_output('nul');
});
sgml('</tocdepth>', sub{
    pop_output;
});

# Element: sprefix
sgml('<sprefix>', sub{
    push_output('string');
});
sgml('</sprefix>', sub{
    $sprefix = pop_output;
});

# Element: sunit
sgml('<sunit>', sub{
    push_output('string');
});
sgml('</sunit>', sub{
    $sunit = pop_output;
    $sunitflag = 1;
});

# Element series
sgml('<series>', sub{
    push_output('string');
});
sgml('</series>', sub{
    my $pos = pop_output;
    my $os = "";
    my $typeatt = $_[0]->attribute("type")->value;
    if(($pos =~ /[1-9][0-9]?/) && ($pos < 30)){
	if($typeatt eq "A"){
	    $os = $Alphabetic[$pos];
	}
	elsif($typeatt eq "a"){
	    $os = $alphabetic[$pos];
	}
	elsif($typeatt eq "I"){
	    $os = $Roman[$pos];
	}
	elsif($typeatt eq "i"){
	    $os = $roman[$pos];
	}
	else{
	    $os = $pos;
	};
    }
    else{
	print STDERR $WhoAmI, ": Cannot perform series conversion on \"",
	$pos, "\"\n";
	$os = $pos;
    };
    output($os);
});

# Element logo
sgml('<logo>', sub{
    push_output('string');
});
sgml('</logo>', sub{
    my $pos = pop_output;
    my $os = $pos;
    if($pos eq "AllTeX"){
	$os = "(La)TeX";
    }
    elsif($pos eq "LaTeXe"){
	$os = "LaTeX2e";
    }
    elsif($pos eq "LaTeXo"){
	$os = "LaTeX 2.09";
    };
    output($os);
});

# Element insas
sgml('<insas>', "");
sgml('</insas>', "");

# Element booklist
sgml('<booklist>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($hpar_on == 1)){
	#    $hpar_on = 0;
	#    $os = $os . "</p>\n";
	# };
    # };
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    $os = $os . "<dl>\n";
    output($os);
});
sgml('</booklist>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")){
	#    $hpar_on = 1;
	#    $os = $os . "<p>";
	# };
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element description
sgml('<description>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($hpar_on == 1)){
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    # };
    $os = $os . "<dl>\n";
    output($os);
});
sgml('</description>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")){
	#    $hpar_on = 1;
	#    $os = $os . "<p>";
	# };
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element ditem
sgml('<ditem>', "");
sgml('</ditem>', "");

# Element itemlabel
sgml('<itemlabel>', sub{
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "";
    if($pan eq "ditem"){
	$os = $os . "<dt>";
    };
    if($gpan eq "description"){
	$os = $os . "<b>";
    };
    if($gpan eq "booklist"){
	$os = $os . "<em>";
    };
    if($pan eq "ditem"){
	$os = $os . "\n";
    };
    if(($pan eq "item")&&(($gpan eq "itemize")||($gpan eq "enumerate"))){
        output($os);
        push_output('string');
    }
    else{
        output($os);
    };
});
sgml('</itemlabel>', sub{
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "";
    my $pos = "";
    if($gpan eq "description"){
	$os = $os . "</b>";
    };
    if($gpan eq "booklist"){
	$os = $os . "</em>";
    };
    if(($pan eq "item")&&(($gpan eq "itemize")||($gpan eq "enumerate"))){
        $itemlabel = pop_output;
    }
    elsif($pan eq "ditem"){
        $os = $os . "</dt>\n";
    }
    else{
        $os = $os . " ";
    };
    output($os);
});

# Element itembody
sgml('<itembody>', sub{
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "";
    $hpar_on = 0;
    if($pan eq "ditem"){
	$os = $os . "<dd>";
    };
    if(($pan eq "item")&&(($gpan eq "itemize")||($gpan eq "enumerate"))){
	$hpar_on = 1;
        if(($itemlabel ne "")&&($gpan eq "enumerate")){
            $os = $os . '<li value="' . $itemlabel . '"><p> ';
        }
        elsif(($itemlabel ne "")&&($gpan eq "itemize")){
            $os = $os . '<li><p>' . $itemlabel . ' ';
        }
        else{
            $os = $os . '<li><p> ';
        };
    };
    if($labelinitem ne ""){
	$os = $os . $labelinitem;
	$labelinitem = "";
    };
    output($os);
});
sgml('</itembody>', sub{
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    my $os = "";
    if($hpar_on == 1){
	$os = $os . "</p>\n";
	$hpar_on = 0;
    };
    if($pan eq "ditem"){
	$os = $os . "</dd>";
    };
    output($os);
});

# Element: addr
sgml('<addr>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
	#   &&($hpar_on == 1)){
	#    $hpar_on = 0;
	#    $os = $os . "</p>\n";
	# };
    # };
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    $os = $os . "<address>\n";
    output($os);
});
sgml('</addr>', sub{
    my $os = "</address>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# my $pan = $_[0]->parent->name;
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")){
	#    $hpar_on = 1;
	#    $os = $os . "<p>";
	# };
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element aln
sgml('<aln>', " ");
sgml('</aln>', sub{
    my $os = "<br\n" . $clemp;
    output($os);
});

# Element: verblist
sgml('<verblist>', sub{
    my $os = "";
#    if($pan =~ /$parasregexp/){
#	my $pan = $_[0]->parent->name;
#	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
#	   &&($hpar_on == 1)){
#	    $hpar_on = 0;
#	    $os = $os . "</p>\n";
#	};
#	if($hpar_on == 1){
#	    $hpar_on = 0;
#	    $os = $os . "</p>\n";
#	};
#    };
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    if($xhtmlstrict == 0){
	$os = $os . "<dl class=\"verblist\" compact=\"compact\">\n";
    }
    else{
	$os = $os . "<dl class=\"verblist\">\n";
    };
    output($os);
});
sgml('</verblist>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
#	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")){
#	    $hpar_on = 1;
#	    $os = $os . "<p>";
#	};
	$hpar_on = 1;
	$os = $os . "<p>";
    };
    output($os);
});

# Element nln
sgml('<nln>', sub{
    push_output('string');
});
sgml('</nln>', sub{
    my $pos = pop_output;
    my $os = "<dd><kbd>\n";
    if($pos =~ /^\s*$/){
	$os = $os . "&#xA0;";
    }
    else{
	$os = $os . $pos;
    };
    $os = $os . "</kbd></dd>\n";
    output($os);
});

# Element empty
sgml('<empty>', "");
sgml('</empty>', "");

# Element overline
sgml('<overline>', sub{push_output('string');});
sgml('</overline>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = '<mover><mrow>' . $pos
		. "</mrow><mo>&#x00AF;</mo></mover\n>";
	}
	else{
	    $os = '<mover>' . $pos . "<mo>&#x00AF;</mo></mover\n>";
	};
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # overline
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\overline{" . $pos . "}";
	output($os);
    };
});

# Element underline
sgml('<underline>', sub{push_output('string');});
sgml('</underline>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = '<munder><mrow>' . $pos
		. "</mrow><mo>&#x00AF;</mo></munder\n>";
	}
	else{
	    $os = '<munder>' . $pos . "<mo>&#x00AF;</mo></munder\n>";
	};
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # underline
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\underline{" . $pos . "}";
	output($os);
    };
});

# Element overbrace
sgml('<overbrace>', sub{push_output('string');});
sgml('</overbrace>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = '<mover><mrow>' . $pos
		. "</mrow><mo>&#xFE37;</mo></mover\n>";
	}
	else{
	    # $os = '<mover>' . $pos . "<mo>&#x00AF;</mo></mover\n>";
	    $os = '<mover>' . $pos . "<mo>&#xFE37;</mo></mover\n>";
	};
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # overbrace
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\overbrace{" . $pos . "}";
	output($os);
    };
});


# Element underbrace
sgml('<underbrace>', sub{push_output('string');});
sgml('</underbrace>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if(($gmath_on == 1) && ($mathml == 1)){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = '<munder><mrow>' . $pos
		. "</mrow><mo>&#xFE38;</mo></munder\n>";
	}
	else{
	    # $os = '<munder>' . $pos . "<mo>&#x00AF;</mo></munder\n>";
	    $os = '<munder>' . $pos . "<mo>&#xFE38;</mo></munder\n>";
	};
	my $name = $elt->name;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # underbrace
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\underbrace{" . $pos . "}";
	output($os);
    };
});

# Element assertion
sgml('<assertion>', sub{
    my $os = "";
    my $pan = $_[0]->parent->name;
    # if($pan =~ /$parasregexp/){
    #	if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")
    #	   &&($hpar_on == 1)){
    if($hpar_on == 1){
	$hpar_on = 0;
	$os = $os . "</p>\n";
    };
    # };
    my $astyle = $_[0]->attribute("style")->value;
    if($astyle eq "definition"){
	$os = $os . "<dl class=\"definition\">\n";
    }
    else{
	$os = $os . "<dl class=\"assertion\">\n";
    };
    output($os);
});
sgml('</assertion>', sub{
    my $os = "</dl>\n";
    my $pan = $_[0]->parent->name;
    if ($pan =~ /$parasregexp/){
	# my $pan = $_[0]->parent->name;
	# if(($pan ne "item")&&($pan ne "itembody")&&($pan ne "desc")){
	$hpar_on = 1;
	$os = $os . "<p>";
	# };
    };
    output($os);
});

# Element assthead
sgml('<assthead0>', "<dd>\n<b>");
sgml('</assthead0>', "</b>\n ");

sgml('<assthead>', sub{
    push_output('string');
});
sgml('</assthead>', sub{
    my $pos = pop_output;
    my $os = "<dd>\n";
    if(!($asstname =~ /^\s*$/)){
	if($asstid =~ /^\s*$/){
	    $os = $os . "<b>" . $asstname . ".</b>\n&#xA0; ";
	}
	else{
	    $os = $os . "<b>" . $asstname . "&#xA0;" . $asstid
		. ".</b>\n&#xA0; ";
	};
    };
    output($os);
});

# Element asstbody
sgml('<asstbody>', sub{
    $asstbodyflag = 1;
    $asstbodyhpar = 0;
    # output(" <em>");
});
sgml('</asstbody>', sub{
    my $os = "";
    if($asstbodyhpar == 1){
	# $os = "</em></p>\n</dd>";
	$os = "</p>\n</dd>";
    }
    elsif($hpar_on == 1){
	# $os = "</em></p>\n</dd>";
	$os = "</p>\n</dd>";
	$hpar_on = 1;
    }
    else{
	# $os = "</em></dd>";
	$os = "</dd>";
    };
    output($os);
    $asstbodyhpar = 0;
    $asstbodyflag = 0;
});

# Element asstkey
sgml('<asstkey>', sub{
    push_output('nul');
});
sgml('</asstkey>', sub{
    pop_output;
});

# Element asstser
sgml('<asstser>', sub{
    push_output('nul');
});
sgml('</asstser>', sub{
    pop_output;
});

# Element asstname
sgml('<asstname>', sub{
    push_output('string');
});
sgml('</asstname>', sub{
    $asstname = pop_output;
});

# Element asstid
sgml('<asstid>', sub{
    push_output('string');
});
sgml('</asstid>', sub{
    $asstid = pop_output;
});

# Element eqnline -- content of equation after eqnkey, eqnser
sgml('<eqnline>', sub{
    $eqatag = "";
    $eqrtag = "";
});
sgml('</eqnline>', "");

# Element eqnarray
sgml('<eqnarray>', sub{
    my $os = "";
    $eqnkey = "";
    $eqntag = "";
    $eqakey = "";
    $eqatag = 0;
    $eqatagstring = "";
    $eqnamode = $_[0]->attribute("mode")->value;
    if($asstbodyflag == 1){
	# os = $os . "</em>";
    };
    if($mathml == 0){
	if($asstbodyhpar == 1){
	    $os = $os . "</p>\n";
	    $eqinhpar = 1;
	    $asstbodyhpar = 0;
	}
	elsif($hpar_on == 1){
	    $os = $os . "</p>\n";
	    $eqinhpar = 1;
	    $hpar_on = 0;
	}
	else{  #  both hpar's are 0
	    $eqinhpar = 0;
	};
    };
    $gmath_on = 1;
    $dmath_on = 1;
    output($os);
});
sgml('</eqnarray>', sub{
    $dmath_on = 0;
    $gmath_on = 0;
    my $os = "";
    $tabdepth--;
    if($mathml == 1){
	$os = $os . "\n</mtable></math>\n";
	if($asstbodyflag == 1){
	    # os = $os . "<em\n>";
	};
    }
    else{
	$unirow[$tabdepth] = 0;
	$os = "</table>\n";
	my $pan = $_[0]->parent->name;
	if(($pan =~ /$parasregexp/) && ($eqinhpar == 1)){
	    if($asstbodyflag == 1){
		# $os = $os . "$ctrbc\n<p><em>";
		$os = $os . "$ctrbc\n<p>";
		$asstbodyhpar = 1;
	    }
	    else{
		$os = $os . "$ctrbc\n<p>";
		$hpar_on = 1;
	    };
	}
	elsif($eqinhpar == 1){
	    if($asstbodyflag == 1){
		# $os = $os . "\n$ctrbc<p><em>";
		$os = $os . "\n$ctrbc<p>";
		$asstbodyhpar = 1;
	    }
	    else{
		$os = $os . "\n$ctrbc<p>";
		$hpar_on = 1;
	    };
	}
	else{
	    if($asstbodyflag == 1){
		# $os = $os . "\n$ctrbc\n<em>";
		$os = $os . "\n$ctrbc\n";
		$asstbodyhpar = 0;
	    }
	    else{
		$os = $os . "\n$ctrbc\n";
		$hpar_on = 0;
	    };
	};
	$eqinhpar = 0;
    };
    output($os);
});

# Element eqnkey
sgml('<eqnkey>', sub{
    push_output('string');
});
sgml('</eqnkey>', sub{
    $eqnkey = pop_output;
});

# Element eqnser -- only used for making label in XML?
sgml('<eqnser>', sub{
    push_output('string');
});
sgml('</eqnser>', sub{
    $eqnser = pop_output;
});

# Element eqnabody -- content of eqnarray after eqnkey, eqnser
sgml('<eqnabody>', sub{
    my $os = "";
    if(($eqnamode%2 == 0) && ($eqnamode > 0)){  # write tag for array
	if($eqnkey ne ""){
	    $eqakey = $eqnkey;
	    if($labelserseqs{$eqakey} > 0){
		$eqatag = $labelserseqs{$eqakey};
		if($mathml == 1){
		    $eqatagstring = "(" . $eqatag . ")";
		}
		else{
		    $eqatagstring = "(" . $eqatag . ")&#xA0;&#xA0;";
		};
	    }
	    else{
		print STDERR $WhoAmI, " WARNING: No series for key ",
		"$eqakey\n   of eqnarray with mode $eqnamode\n";
	    };
	}
	else{
	    print STDERR $WhoAmI, " WARNING: Code logic: Cannot find key for ",
	    "eqnarray\n", "   with mode $eqnamode, eqseq=",
	    $_[0]->parent->attribute("eqseq")->value, "\n";
	};
    };
    $eqnarowseq = 0;
    $tabdepth++;
    if($mathml == 1){
	$os = $os . "\n" . '<math xmlns="' . $mathns
	    . '" display="block" mode="display"' . "\n>";
	$os = $os . "<mtable\n>";
    }
    else{
	$os = $os . "$ctrbo\n";
	$os = $os . "<table cellspacing=\"0\" cellpadding=\"0\">\n";
	$unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</eqnabody>', "");

# Element eqnrow -- content of eqnabody
sgml('<eqnrow>', sub{
    $eqnarowseq++;
    $eqrkey = "";
    $eqrtag = "";
    $eqlabelcount = 0;
    $eqnrow = "";
    push_output('string');
});
sgml('</eqnrow>', sub{
    my $os = "";
    my $pos = pop_output;
#   Handle the tag cell
    my $tag = "";
    if($mathml == 1){
	# $os = $os . "<mlabeledtr\n>";
	$os = $os . "<mtr class=\"labeled\"\n>";
    }
    else{
	$os = $os . "<tr\n>";
    };
    my $tag = "";
    my $emptytagcell = "";
    if($mathml == 1){
	$emptytagcell = "<mtd><mtext>&#xA0;</mtext></mtd\n>";
    }
    else{
	$emptytagcell = "<td></td>";
    };
    if(($eqnamode == 0) || ($eqrtag ne "")){  #  Tag the rows
	if($eqrtag ne ""){
	    $tag = $eqrtag;
	}
	elsif($labelserseqs{$eqrkey} > 0){
	    $tag = $labelserseqs{$eqrkey};
	}
	else{
	    $tag = "EA-" . 
		$_[0]->parent->parent->parent->attribute("eqseq")->value
		    . "/" . $eqnarowseq;
	};
	if($eqrkey ne ""){
	    if($mathml == 1){
		$os = $os . '<mtd id="' . $eqrkey . '"><mtext>(' . $tag
		    . ")</mtext></mtd\n>";
	    }
	    elsif($xhtmlstrict == 1){
		$os = $os . '<td><a id="' . $eqrkey . '">(' . $tag
		    . ")</a>&#xA0;&#xA0;" . "</td>\n";
	    }
	    else{
		$os = $os . '<td><a name="' . $eqrkey . '" id="' . $eqrkey
		    . '">(' . $tag . ")</a>&#xA0;&#xA0;" . "</td>\n";
	    };
	}
	else{
	    if($mathml == 1){
		$os = $os . '<mtd><mtext>(' . $tag . ")</mtext></mtd\n>";
	    }
	    else{
		$os = $os . '<td>(' . $tag . ")&#xA0;&#xA0;" . "</td>\n";
	    };
	};
    }
    elsif($eqnamode%2 == 0){  #  Tag only first row
	if($eqnarowseq == 1){
	    if($eqntag ne ""){
		if($mathml == 1){
		    $os = $os . "<mtd><mtext>(" . $eqntag .
			")</mtext></mtd\n>";
		}
		else{
		    $os = $os . "<td>(" . $eqntag . ")&#xA0;&#xA0;</td>\n";
		};
	    }
	    elsif($eqatag > 0){
		if($mathml == 1){
		    $os = $os . "<mtd><mtext>" . $eqatagstring
			. "</mtext></mtd\n>";
		}
		else{
		    $os = $os . "<td>" . $eqatagstring . "</td\n>";
		};
	    }
	    else{
		$os = $os . $emptytagcell;
	    };
	}
	else{
	    $os = $os . $emptytagcell;
	};
    }
    else{
	if(($mathml == 1) && ($eqatag == 0)){
	    $os = $os . $emptytagcell;
	};
    };
# end of tag cell handling
    $os = $os . $pos;
    if ($mathml == 1){
	# $os = $os . "</mlabeledtr\n>";
	$os = $os . "</mtr\n>";
    }
    else{
	$os = $os . "</tr\n>";
    };
    output($os);
});

# Element eqnleft -- content of eqnrow
sgml('<eqnleft>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . '<mtd columnalign="right">';
    }
    else{
	$os = $os . '<td align="right"><table><tr><td>';
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</eqnleft>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	$unirow[$tabdepth] = 0;
	$tabdepth--;
	$os = $os . "</td></tr></table></td>\n";
    };
    output($os);
});

# Element eqncenter -- content of eqnrow
sgml('<eqncenter>', sub{ 
    my $os = "";
    if($mathml == 1){
	$os = $os . '<mtd columnalign="center">';
    }
    else{
	$os = $os . '<td align="center"><table><tr><td>';
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</eqncenter>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	$unirow[$tabdepth] = 0;
	$tabdepth--;
	$os = $os . "</td></tr></table></td>\n";
    };
    output($os);
});

# Element eqnright -- content of eqnrow
sgml('<eqnright>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . '<mtd columnalign="left">';
    }
    else{
	$os = $os . '<td align="left"><table><tr><td>';
	$tabdepth++;
	$unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</eqnright>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	$unirow[$tabdepth] = 0;
	$tabdepth--;
	$os = $os . "</td></tr></table></td>\n";
    };
    output($os);
});

# Element mathbb
sgml('<mathbb>', sub{
    $passcdata = 1;
    push_output('string');
});
sgml('</mathbb>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    $passcdata = 0;
    my $os = "";
    if($mathml == 1){
	if($noMathStyle == 1){
	    $os = '<mi mathvariant="double-struck" mathcolor="#b00">'
		. $pos . "</mi\n>";
	}
	else{
	    $os = '<mi mathvariant="double-struck">' . $pos . "</mi\n>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mathbb
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "<b>" . $pos . "</b>";
	output($os);
    };
});

# Element mathcal
sgml('<mathcal>', sub{
    $passcdata = 1;
    push_output('string');
});
sgml('</mathcal>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    $passcdata = 0;
    my $os = "";
    if($mathml == 1){
	if($noMathStyle == 1){
	    $os = '<mi mathvariant="script" mathcolor="#00e">'
		. $pos . "</mi\n>";
	}
	else{
	    $os = '<mi mathvariant="script">' . $pos . "</mi\n>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mathcal
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\cal{" . $pos . "}";
	output($os);
    };
});
sgml('</mathcal0>', sub{
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	$os = "<mi mathvariant=\"script\">" . $pos . "</mi\n>";
    }
    else{
	$os = "\\cal{" . $pos . "}";
    };
    $passcdata = 0;
    output($os);
});

# Element mathfrak
sgml('<mathfrak>', sub{
    $passcdata = 1;
    push_output('string');
});
sgml('</mathfrak>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    $passcdata = 0;
    my $os = "";
    if($mathml == 1){
	if($noMathStyle == 1){
	    $os = '<mi mathvariant="fraktur" mathcolor="#0b0">'
		. $pos . "</mi\n>";
	}
	else{
	    $os = '<mi mathvariant="fraktur">' . $pos . "</mi\n>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mathfrak
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\fraktur{" . $pos . "}";
	output($os);
    };
});

# Element mathbf
sgml('<mathbf>', sub{
    $passcdata = 1;
    push_output('string');
});
sgml('</mathbf>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    $passcdata = 0;
    my $os = "";
    if($mathml == 1){
        my $tpos = $pos;
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $chld = $elt->attribute("mchld")->value;
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    print STDERR $WhoAmI, ":\n      ******\n",
	    "      WARNING -- Multiple children in mathbf\n      ******\n";
	};
	if($tpos =~ /<mi>/){
	    $tpos =~ s|<mi>||g ;
	};
	if($tpos =~ /<\/mi>/){
	    $tpos =~ s|</mi>||g ;
	};
	$os = '<mi mathvariant="bold-italic" fontweight="bold">' . $tpos .
	    "</mi\n>";
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "',
	    $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mathbf
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "<b>" . $pos . "</b>";
	output($os);
    };
});

# Element apos -- apostrophe
sgml('<apos>', sub{
    my $os = "'";
    my ($elt, $ev) = @_;
    my $par = $elt->parent;
    my $pan = $par->name;
    if(($gmath_on == 1) && ($mathml == 1)){
	# Font woes in some user agents
	my $elt=$_[0];
	$os = "<mo class=\"prime\">&#x2032;</mo>";
    }
    output($os);
});
sgml('</apos>', "");

# Element array
sgml('<array>', sub{
    my $os = "";
    if(($mathml == 0) && ($unirow[$tabdepth]==1)){
	$os = $os . "</td><td>";
    };
    $tabdepth++;
    $arrtabflag[$tabdepth] = 0;
    $tabaseq[$tabdepth] = 0;
    $tabalen[$tabdepth] = 0;
    my $par = $_[0]->parent;
    my $pan = $par->name;
    my $gpan = $par->parent->name;
    if($mathml == 1){
	if(($pan =~ /^(msub|lower)$/) && ($gpan =~ /(sum|int|prod)/)){
	    $os = $os . "<mtable class=\"substack\"\n>";
	}
	else{
	    $os = $os . "<mtable\n>";
	};
    }
    else{
	$unirow[$tabdepth] = 1;
	if($hpar_on == 1){
	    $hpar_on = 0;
	    $os = $os . "</p>\n";
	    $arrtabflag[$tabdepth] = 1;
	};
	$os = $os . "<table>\n";
    };
    output($os);
});
sgml('</array>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtable\n>";
    }
    else{
	$os = $os . "</table>";
	$unirow[$tabdepth] = 0;
	my $par = $_[0]->parent;
	my $pan = $par->name;
	if($arrtabflag[$tabdepth] == 1){
	    $hpar_on = 1;
	    $os = $os . "<p>";
	};
    };
    $arrtabflag[$tabdepth] = 0;
    $tabdepth--;
    if(($mathml == 0) && ($unirow[$tabdepth]==1)){
	$os = $os . "</td><td>";
    };
    output($os);
});

# Element arrhead
sgml('<arrhead>', sub{
    $tabopt[$tabdepth] = "";
    $tabarg[$tabdepth] = "";
    push_output('string');
});
sgml('</arrhead>', sub{
    pop_output;
    my @tbargv = split(//, $tabarg[$tabdepth]);
    my $len = scalar @tbargv;
    my $jj = 0;
    my $kk = 0;
    while($jj < $len){
	if($tbargv[$jj] =~ /[clpr]/){
	    $kk++;
	    $tabasym[$tabdepth][$kk] = $tbargv[$jj];
	};
	$jj++;
    };
    $tabalen[$tabdepth] = $kk;  # Index to @tabasym[$tabdepth] starts at 1
});

# Element arrpos
sgml('<arrpos>', sub{
    push_output('string');
});
sgml('</arrpos>', sub{
    $tabopt[$tabdepth] = pop_output;
});

# Element arrcols
sgml('<arrcols>', sub{
    push_output('string');
});
sgml('</arrcols>', sub{
    $tabarg[$tabdepth] = pop_output;
});

# Element arrbody
sgml('<arrbody>', "");
sgml('</arrbody>', "");

# Element arrayrow
sgml('<arrayrow>', sub{
    my $os = "";
    $tabaseq[$tabdepth] = 0;
    if($mathml == 1){
	$os = $os . "<mtr>";
    }
    else{
	$os = $os . "<tr>";
    };
    output($os);
});
sgml('</arrayrow>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtr>";
    }
    else{
	$os = $os . "</tr>";
    };
    output($os);
});

# Element firstacell
sgml('<firstacell>', sub{
    my $os = "";
    $tabaseq[$tabdepth]++;
    my $nn = $tabaseq[$tabdepth];
    if($nn > $tabalen[$tabdepth]){
	$nn = $tabalen[$tabdepth];
    };
    my $cc = $tabasym[$tabdepth][$nn];
    if($mathml == 1){
	$os = "<mtd>";
	if($cc ne ""){
	    $os = "<mtd" . $mtabaval{$cc} . ">";
	};
    }
    else{
	# $tabdepth++;
	$os = "<td>";
	if($cc ne ""){
	    $os = "<td" . $tabaval{$cc} . ">";
	};
	# $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td>";
	# $unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</firstacell>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	# $unirow[$tabdepth] = 0;
	# $os = "</td></tr></table></td>\n";
	$os = "</td>\n";
	# $tabdepth--;
    };
    output($os);
});

# Element arraycell -- same as code for firstacell but for name
sgml('<arraycell>', sub{
    my $os = "";
    $tabaseq[$tabdepth]++;
    my $nn = $tabaseq[$tabdepth];
    if($nn > $tabalen[$tabdepth]){
	$nn = $tabalen[$tabdepth];
    };
    my $cc = $tabasym[$tabdepth][$nn];
    if($mathml == 1){
	$os = "<mtd>";
	if($cc ne ""){
	    $os = "<mtd" . $mtabaval{$cc} . ">";
	};
    }
    else{
	# $tabdepth++;
	$os = "<td>";
	if($cc ne ""){
	    $os = "<td" . $tabaval{$cc} . ">";
	};
	# $os = $os . "<table cellspacing=\"0\" cellpadding=\"0\"><tr><td>";
	# $unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</arraycell>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	# $unirow[$tabdepth] = 0;
	# $os = "</td></tr></table></td>\n";
	$os = "</td>\n";
	# $tabdepth--;
    };
    output($os);
});

sgml('<arraycell02>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "<mtd>";
    }
    else{
	$tabdepth++;
	$os = $os . "<td><table cellspacing=\"0\" cellpadding=\"0\"><tr><td>";
	$unirow[$tabdepth] = 1;
    };
    output($os);
});
sgml('</arraycell02>', sub{
    my $os = "";
    if($mathml == 1){
	$os = $os . "</mtd\n>";
    }
    else{
	$unirow[$tabdepth] = 0;
	$os = "</td></tr></table></td>\n";
	$tabdepth--;
    };
    output($os);
});

# Element includegraphics
sgml('<includegraphics>', sub{
    push_output('string');
});
sgml('</includegraphics>', sub{
    my $os = "";
    my $stem = pop_output;
    my $suf=".png";
    my $fname = $stem . $suf;
    if(open(IMGFH, $fname)){
	close(IMGFH);
    }
    else{
	$suf=".jpg";
	$fname = $stem . $suf;
	if(open(IMGFH, $fname)){
	    close(IMGFH);
	}
	else{
	    $suf=".gif";
	    $fname = $stem . $suf;
	    if(open(IMGFH, $fname)){
		close(IMGFH);
	    }
	    else{
		$suf=".png";
		$fname = $stem . $suf;
		print STDERR "  *** WARNING: Graphic image for stem name ",
		$stem, " missing\n";
	    };
	};
    };
    my $alt=$_[0]->attribute("description")->value;
    if($alt eq ""){
	$alt="Image file: " . $fname;
    };
    $os = '<img src="' . $fname . '" alt="' . $alt . '"' . $clemp . "\n";
    output($os);
});

# Element Cd0
sgml('<Cd0>', sub{
    push_output('string');
});
sgml('</Cd0>', sub{
    my ($elt, $event) = @_;
    my $pos = pop_output;
    my $os = "";
    my $type = "";
    my @sar = ();
    my $sarl = 0;
    my @tar = ();
    my $tys = "";
    my $jj = 0;
    if($passcdata == 1){
	output($pos);
	return;
    };
    $type=$elt->attribute("type")->value;
    if($type eq "number"){
	if($mathmlc == 1){
	    $os = "<cn>" . $pos . "</cn>";
	}
	else{
	    $os = "<mn>" . $pos . "</mn>";
	};
    }
    elsif($type eq "letter"){
	if($_[0]->within("regch") ne ""){
	    $os = $pos;
	}
	elsif($_[0]->parent->name =~ /^(bold|emph)$/){
	    $os = $pos;
	}
	else{
	    if($mathmlc == 1){
		$os = "<ci>" . $pos . "</ci>";
	    }
	    else{
		$os = "<mi>" . $pos . "</mi>";
	    };
	};
    }
    elsif($type eq "character"){
	if($_[0]->within("csep") ne ""){
	    $os = $pos;
	}
	else{
	    if($pos eq "'"){
		# font woes
		my $elt=$_[0];
		$os = '<mo class="prime">&#x2032;</mo>';
	    }
	    else{
		$os = '<mo>' . $pos . '</mo>';
	    };
	};
    }
    elsif($type eq "text"){
	$os = $pos;
    }
    elsif($type =~ /^word:/){
	@sar = split(' ', $pos);
	$sarl=scalar(@sar);
	$jj = 0;
	while($jj < $sarl){
	    $os = $os . "<mi>" . $sar[$jj] . "</mi>";
	    $jj++;
	};
    }
    elsif($type =~ /^mixed:/){
	@sar = split(' ', $pos);
	$sarl=scalar(@sar);
	$tys=$elt->attribute("tys")->value;
	if(length($tys) != $sarl){
	    print STDERR $WhoAmI, ": *** Logic -- length of tys != sarl\n";
	}
	@tar = split('', $tys);
	$jj = 0;
	while($jj < $sarl){
	    if($tar[$jj] eq "n"){
		$os = $os . "<mn>" . $sar[$jj] . "</mn>";
	    }
	    elsif($tar[$jj] eq "l"){
		$os = $os . "<mi>" . $sar[$jj] . "</mi>";
	    }
	    elsif($tar[$jj] eq "c"){
		$os = $os . "<mo>" . $sar[$jj] . "</mo>";
	    }
	    else{
		print STDERR $WhoAmI, ': *** Misparsed math char -- "',
		$sar[$jj] , "\"\n";
	    };
	    $jj++;
	}
    }
    else{
	print STDERR $WhoAmI, ': *** Misparsed math CDATA -- "', $pos, "\"\n";
	print STDERR "      in " . $elt->parent->name . "\n";
	print STDERR "   mlvl: " . $elt->attribute("mlvl")->value .
	    "  mseq: " . $elt->attribute("mseq")->value . "\n";
	$os = $os . '[' . $pos . ']';
    };
    if($mathml == 1){
	my $par = $elt->parent;
	my $pan = $par->name;
	if($pan =~ /^(mbox|text)$/){
	    output($os);
	    return;
	}
	my $seq = $elt->attribute("mseq")->value;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "Cd0")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for Cd0 at l. ", $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	    output($os);
	    return;
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # Cd0
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};

    }
    else{
	output($os);
    };
});

# Element Em0
sgml('<Em0>', sub{
    push_output('string');
});
sgml('</Em0>', sub{
    my ($elt, $event) = @_;
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "Em0")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for Em0 at l. ", $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($pan eq "not"){
	    my $notname = $elt->attribute("mchld")->value;
	    if($notname eq "in"){
		$os = "<mo>&#x2209;</mo>";
	    }
	    elsif(($notname eq "mid") || ($notname eq "vbr")){
		$os = "<mo>&#x2224;</mo>";
	    }
	    elsif($notname eq "sim"){
		$os = "<mo>&#x2241;</mo>";
	    }
	    elsif($notname eq "simeq"){
		$os = "<mo>&#x2244;</mo>";
	    }
	    elsif($notname eq "cong"){
		$os = "<mo>&#x2247;</mo>";
	    }
	    elsif($notname eq "parallel"){
		$os = "<mo>&#x2226;</mo>";
	    }
	    elsif($notname eq "equiv"){
		$os = "<mo>&#x2262;</mo>";
	    }
	    elsif($notname eq "equals"){
		$os = "<mo>&#x2260;</mo>";
	    }
	    elsif($notname eq "subset"){
		$os = "<mo>&#x2284;</mo>";
	    }
	    elsif($notname eq "supset"){
		$os = "<mo>&#x2285;</mo>";
	    }
	    elsif($notname eq "subseteq"){
		$os = "<mo>&#x2288;</mo>";
	    }
	    elsif($notname eq "supseteq"){
		$os = "<mo>&#x2289;</mo>";
	    }
	    elsif($notname eq "ltc"){
		$os = "<mo>&#x226E;</mo>";
	    }
	    elsif($notname eq "gtc"){
		$os = "<mo>&#x226F;</mo>";
	    }
	    elsif($notname eq "leq"){
		$os = "<mo>&#x2270;</mo>";
	    }
	    elsif($notname eq "geq"){
		$os = "<mo>&#x2271;</mo>";
	    }
	    elsif(($notname eq "hsp") || ($notname eq "spc")){
		return;
	    }
	    else{
		$os =~ s/>/>&\#x0338\;/;
	    };
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # Em0
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	output($os);
    };
});

# Element Sym
sgml('<Sym>', sub{
    push_output('string');
});
sgml('</Sym>', sub{
    my ($elt, $event) = @_;
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow\n>";
	};
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "Sym")){
	    print STDERR $WhoAmI,
	    ": WARNING -- Seq. no. mismatch for Sym at l. ", $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: ",
	    $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: ",
	    $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # Sym
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	output($os);
    };
});

# Element: Sym0
sgml('<Sym0>', "");
sgml('</Sym0>', "");

sgml('<Bc0>', sub{
    my ($element, $event) = @_;
    my $name = $element->attribute("aname")->value;
    push_output('string');
});
sgml('</Bc0>', sub{
    my ($element, $event) = @_;
    my $name = $element->attribute("aname")->value;
    my $pos = pop_output;
    my $os = "<mrow>" . $pos . "</mrow\n>";
    output($os);
});

# Element lgcdata
sgml('<lgcdata>', "");
sgml('</lgcdata>', "");

# Element overset -- as in amsmath
sgml('<overset>', sub{
    $ousetdepth++;
    push_output('string');
});
sgml('</overset>', sub{
    pop_output;
    my ($elt, $ev) = @_;
    my $os = "";
    if($mathml == 1){
	$os = "<mover>" . $expr[$ousetdepth] . $deco[$ousetdepth]
	    . "</mover\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: "
		, $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: "
		, $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # overset
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\overset{" . $deco[$ousetdepth] . "}{"
	    . $expr[$ousetdepth] . "}\n";
	output($os);
    };
    $ousetdepth--;
});

# Element underset -- as in amsmath
sgml('<underset>', sub{
    $ousetdepth++;
    push_output('string');
});
sgml('</underset>', sub{
    pop_output;
    my ($elt, $ev) = @_;
    my $os = "";
    if($mathml == 1){
	$os = "<munder>" . $expr[$ousetdepth] . $deco[$ousetdepth]
	    . "</munder\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: "
		, $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: "
		, $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # underset
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{
	$os = "\\underset{" . $deco[$ousetdepth] . "}{"
	    . $expr[$ousetdepth] . "}\n";
	output($os);
    };
    $ousetdepth--;
});

# Element deco -- first arg in overset or underset
sgml('<deco>', sub{
    push_output('string');
});
sgml('</deco>', sub{
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow>";
	};
    };
    $deco[$ousetdepth] = $os;
});

# Element expr -- second arg i overset or underset or first arg in mscript
sgml('<expr>', sub{
    push_output('string');
});
sgml('</expr>', sub{
    my $pos = pop_output;
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $_[0]->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow>";
	};
    };
    $expr[$ousetdepth] = $os;
});

# Element vect -- vector with coord args (<coord>) and
#                 separator string (<csep>)
#    separator string is space-delimited
#    fields: open, close, between [...]
#    default: open="(", close=")", between=","
#    empty csep means open, close, between are all ""
# Begin rendering with csep
sgml('<vect>', sub{
    $vectdepth++;
    $coordseq[$vectdepth] = 0;
    $csep[$vectdepth][0] = "";
    $csepn[$vectdepth] = -1;   # means no <csep> found
    push_output('string');
});
sgml('</vect>', sub{
    my $os = "";
    my $pos = pop_output;
    my $vd = $vectdepth;
    my $ns = $csepn[$vd];
    my $ss = "";
    if($mathml == 1){
	$os = $os . "<mfenced";
	if($ns == -1){
	    $os = $os . ">";
	}
	elsif($ns == 0){
	    $os = $os . ' open="" close="" separators="">';
	}
	elsif($ns == 1){
	    $os = $os . ' open="' . $csep[$vd][1] . '">';
	}
	elsif($ns == 2){
	    $os = $os . ' open="' . $csep[$vd][1] . '" close="'
		. $csep[$vd][2] . '">';
	}
	elsif($ns > 2){
	    $os = $os . ' open="' . $csep[$vd][1] . '" close="'
		. $csep[$vd][2] . '"';
	    my $jj = 2;
	    while($jj < $ns){
		$jj++;
		$ss = $ss . $csep[$vd][$jj];
	    };
	    $os = $os . ' separators="' . $ss . '">';
	}
	else{
	    $os = $os . " >";
	};
	$os = $os . $pos;
	$os = $os . "</mfenced\n>";
    }
    else{  # mathml is not being used
	if($ns == -1){
	    $os = $os . "(" . $pos . ")";
	}
	elsif($ns == 0){
	    $os = $os . $pos;
	}
	elsif($ns == 1){
	    $os = $os . $csep[$vd][1] . $pos . ")";
	}
	elsif($ns > 1){
	    $os = $csep[$vd][1] . $pos . $csep[$vd][2];
	}
	else{
	    print STDERR $WhoAmI, ": WARNING: cannot format <vect>\n";
	};
    };
    output($os);
    $vectdepth--;
});

# Element csep -- coordinate separation string for <vect>
sgml('<csep>', sub{
    $csepq++;
    push_output('string');
});
sgml('</csep>', sub{
    my $pos = pop_output;
    # print STDERR "<csep> no. ", $csepq, " found ", $pos, "\n";
    my $os = "";
    my @seps = split('', $pos);
    my $sepn = scalar(@seps);
    $csepn[$vectdepth] = 0;
    if($sepn > 0){
	my $jj = 0;
	my $kk = 0;
	my $glean = "";
	my @tout = ();
	my $tc = "";
	while($jj < $sepn){
	    $glean = "";
	    $kk++;
	    $tc = $seps[$jj];
	    $jj++;
	    $glean = $glean . $tc;
	    if($tc eq "&"){
		# print STDERR "<csep> no. ", $csepq, " found entity in pos. "
		#    , $kk, "\n";
		until($tc eq ";"){
		    $tc = $seps[$jj];
		    $jj++;
		    $glean = $glean. $tc;
		};
	    };
	    $csep[$vectdepth][$kk] = $glean;
	    $tout[$kk] = $glean;
	};
	# $csep[$vectdepth][$kk] begins with $kk = 1
	$csepn[$vectdepth] = $kk;
	# print STDERR "<csep> no. ",$csepq," writing ",join("+", @tout),"\n";
    };
});

# Element coord -- coordinate argument in <vect>
sgml('<coord>', sub{
    $coordseq[$vectdepth]++;
    push_output('string');
});
sgml('</coord>', sub{
    my $elt = $_[0];
    my $pos = pop_output;
    my $os = "";
    my $ns = $csepn[$vectdepth];
    my $k = $coordseq[$vectdepth];
    # If mathml is being used, separators is an <mfenced> attribute.
    if($mathml == 0){
	if(($k > 1) && ($ns > 2)){
	    if($k + 1 < $ns){
		$os = $os . $csep[$vectdepth][$k + 1] . " ";
	    }
	    else{
		$os = $os . $csep[$vectdepth][$ns] . " ";
	    };
	}
	elsif(($k > 1) && ($ns != 0)){
	    $os = $os . ", ";
	};
	$os = $os . $pos;
    }
    else{
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = $os . "<mrow>" . $pos . "</mrow>";
	}
	else{
	    $os = $os . $pos;
	};
    };
    output($os);
});

# Element: aF -- "applyFunction"
#   I do not use this in source except when it's not obvious in context
#   from explicit or implicit expression types
sgml('<aF>', sub{
    if($mathml == 1){
	$os = '<mo class="invisible">&#x2061;</mo>';
	output($os);
    };
});
sgml('</aF>', "");

# Element: icomma -- invisible comma
#   I generally use \vect[]{x}{y}{z} instead of x\icomma{}y\icomma{}z
sgml('<icomma>', sub{
    if($mathml == 1){
	$os = '<mo class="invisible">&#x2063;</mo>';
	output($os);
    };
});
sgml('</icomma>', "");

# Element: itimes -- invisible times
#   I do not use this in source except when it's not obvious in context
#   from explicit or implicit expression types
sgml('<itimes>', sub{
    if($mathml == 1){
	$os = '<mo class="invisible">&#x2062;</mo>';
	output($os);
    };
});
sgml('</itimes>', "");

# Element mscript -- 4 corner super- and subscripts
sgml('<mscript>', sub{
    $ousetdepth++;
    my $d = $ousetdepth;
    $uleft[$d] = "";
    $lleft[$d] = "";
    $lright[$d] = "";
    $uright[$d] = "";
    push_output('string');
});
sgml('</mscript>', sub{
    pop_output;  # there should be nothing loose
    my ($elt, $ev) = @_;
    my $os = "";
    my $d = $ousetdepth;
    if($mathml == 1){
	$os = $os . "<mmultiscripts>" . $expr[$d];
	if(($lright[$d] ne "") || ($uright[$d] ne "")){
	    if($lright[$d] eq ""){
		$os = $os . "<none/>";
	    }
	    else{
		$os = $os . $lright[$d];
	    };
	    if($uright[$d] eq ""){
		$os = $os . "<none/>";
	    }
	    else{
		$os = $os . $uright[$d];
	    };
	};
	if(($lleft[$d] ne "") || ($uleft[$d] ne "")){
	    $os = $os . "<mprescripts/>";
	    if($lleft[$d] eq ""){
		$os = $os . "<none/>";
	    }
	    else{
		$os = $os . $lleft[$d];
	    };
	    if($uleft[$d] eq ""){
		$os = $os . "<none/>";
	    }
	    else{
		$os = $os . $uleft[$d];
	    };
	};
	$os = $os . "</mmultiscripts\n>";
	my $seq = $elt->attribute("mseq")->value;
	my $name = $elt->name;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq $name)){
	    print STDERR $WhoAmI, ': WARNING -- Seq. no. mismatch for "'
		, $name, '" at l. ', $ev->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: "
		, $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: "
		, $sybs[$seq-1], "\n";
	};
	if($sybs[$seq] =~ /(msub|msup|pow|sarg)/){
	    $stolvl++;  # mscript
	    $store[$stolvl] = $os;
	}
	else{
	    output($os);
	};
    }
    else{  # not using MathML
	if(($lleft[$d] ne "") || ($uleft[$d] ne "")){
	    $os = $os . "\\pre[";
	    if($lleft[$d] ne ""){
		$os = $os . "_{" . $lleft[$d] . "}";
	    };
	    if($uleft[$d] ne ""){
		$os = $os . "^{" . $uleft[$d] . "}";
	    };
	    $os = $os . "]";
	};
	$os = $os . "<b>{</b>" . $expr[$d] . "<b>}</b>";
	if(($lright[$d] ne "") || ($uright[$d] ne "")){
	    if($lright[$d] ne ""){
		$os = $os . "_{" . $lright[$d] . "}";
	    };
	    if($uright[$d] ne ""){
		$os = $os . "^{" . $uright[$d] . "}";
	    };
	};
	output($os);
    }
    $ousetdepth--;
});

# Element uleft
sgml('<uleft>', sub{
    push_output('string');
});
sgml('</uleft>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	};
    };
    $uleft[$ousetdepth] = $os;
});

# Element lleft
sgml('<lleft>', sub{
    push_output('string');
});
sgml('</lleft>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	};
    };
    $lleft[$ousetdepth] = $os;
});

# Element lright
sgml('<lright>', sub{
    push_output('string');
});
sgml('</lright>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	};
    };
    $lright[$ousetdepth] = $os;
});

# Element uright
sgml('<uright>', sub{
    push_output('string');
});
sgml('</uright>', sub{
    my $pos = pop_output;
    my $elt = $_[0];
    my $os = $pos;
    if($mathml == 1){
	my $mchld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $mchld));
	if($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	};
    };
    $uright[$ousetdepth] = $os;
});

# Element aTs -- LaTeX's "\@" space adjustment
sgml('<aTs>', "");
sgml('</aTs>', "");

# Element iTc -- LaTeX's "\/" italic correction
sgml('<iTc>', "");
sgml('</iTc>', "");

# Element setOf -- setbuilder notation
sgml('<setOf>', sub{
    $ousetdepth++;
    $parm[$ousetdepth] = "";
    $cond[$ousetdepth] = "";
    push_output('string');
});
sgml('</setOf>', sub{
    my $pos = pop_output;
    my $os = "";
    if($pos ne ""){
	print STDERR $WhoAmI, ": WARNING -- Loose content found in <setOf>\n";
    };
    my $prm = $parm[$ousetdepth];
    my $cnd = $cond[$ousetdepth];
    if($mathml == 1){
	$os = $os . '<mfenced open="{" close = "}" separators="|">';
	$os = $os . $prm;
	if($cnd ne ""){
	    $os = $os . $cnd;
	};
	$os = $os . "</mfenced\n>";
    }
    else{
	$os = $os . "<b>{</b>";
	$os = $os . $prm;
	if($cnd ne ""){
	    $os = $os . " <b>|</b> " . $cnd;
	};
	$os = $os . "<b>}</b>";
    };
    output($os);
    $ousetdepth--;
});

# Element parm -- setbuilder notation: parameter expression
sgml('<parm>', sub{
    push_output('string');
});
sgml('</parm>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	my $par = $elt->parent;
	my $parchld = $par->attribute("mchld")->value;
	my $nsybs = scalar(split(',', $parchld));
	my $chld = $elt->attribute("mchld")->value;
	my $nchld = scalar(split(',', $chld));
	if($nsybs > 1){  # <cond> is present
	    $os = "<mrow>" . $pos . '<mspace width="0.4em"/></mrow>';
	}
	elsif($nchld > 1){
	    $os = "<mrow>" . $pos . "</mrow>";
	}
	else{
	    $os = $pos;
	};
    }
    else{
	$os = $pos;
    };
    $parm[$ousetdepth] = $os;
});

# Element cond -- setbuilder notation: condition expression
sgml('<cond>', sub{
    push_output('string');
});
sgml('</cond>', sub{
    my ($elt, $ev) = @_;
    my $pos = pop_output;
    my $os = "";
    if($mathml == 1){
	$os = '<mrow><mspace width="0.4em"/>' . $pos . "</mrow>";
    }
    else{
	$os = $pos;
    };
    $cond[$ousetdepth] = $os;
});

# Element: vee --
sgml('<vee>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2228;</mo>";
    }
    else{
	$os = "&#x2228;";
    };
    output($os);
});
sgml('</vee>', "");

# Element: setminus --
sgml('<setminus>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2216;</mo>";
    }
    else{
	$os = "&#x2216;";
    };
    output($os);
});
sgml('</setminus>', "");

# Element: triangle --
sgml('<triangle>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x25B5;</mo>";
    }
    else{
	$os = "&#x25B5;";
    };
    output($os);
});
sgml('</triangle>', "");

# Element: ll --
sgml('<ll>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x226A;</mo>";
    }
    else{
	$os = "&#x226A;";
    };
    output($os);
});
sgml('</ll>', "");

# Element: gg --
sgml('<gg>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x226B;</mo>";
    }
    else{
	$os = "&#x226B;";
    };
    output($os);
});
sgml('</gg>', "");

# Element: asymp --
sgml('<asymp>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2248;</mo>";
    }
    else{
	$os = "&#x2248;";
    };
    output($os);
});
sgml('</asymp>', "");

# Element: approx --
sgml('<approx>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x224A;</mo>";
    }
    else{
	$os = "&#x224A;";
    };
    output($os);
});
sgml('</approx>', "");

# Element: implies --
sgml('<implies>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x21D2;</mo>";
    }
    else{
	$os = "&#x21D2;";
    };
    output($os);
});
sgml('</implies>', "");

# Element: revimplies --
sgml('<revimplies>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x21D0;</mo>";
    }
    else{
	$os = "&#x21D0;";
    };
    output($os);
});
sgml('</revimplies>', "");

# Element: iff --
sgml('<iff>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x21D4;</mo>";
    }
    else{
	$os = "&#x21D4;";
    };
    output($os);
});
sgml('</iff>', "");

# Element: uparrow --
sgml('<uparrow>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2191;</mo>";
    }
    else{
	$os = "&#x2191;";
    };
    output($os);
});
sgml('</uparrow>', "");

# Element: downarrow --
sgml('<downarrow>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2193;</mo>";
    }
    else{
	$os = "&#x2193;";
    };
    output($os);
});
sgml('</downarrow>', "");

# Element: abuts --
sgml('<abuts>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x21D2;</mo>";
    }
    else{
	$os = "&#x21D2;";
    };
    output($os);
});
sgml('</abuts>', "");

# Element: ltimes --
sgml('<ltimes>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x22C9;</mo>";
    }
    else{
	$os = "&#x22C9;";
    };
    output($os);
});
sgml('</ltimes>', "");

# Element: rtimes --
sgml('<rtimes>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x22CA;</mo>";
    }
    else{
	$os = "&#x22CA;";
    };
    output($os);
});
sgml('</rtimes>', "");

# Element mp
sgml('<mp>', sub{
    my $os = "";
    if($mathml == 1){
	$os = "<mo>&#x2213;</mo>";
    }
    else{
	$os = "&#x2213;";
    };
    output($os);
});
sgml('</mp>', "");

# Element: eqntag
sgml('<eqntag>', sub{
    push_output('string');
});
sgml('</eqntag>', sub{
    $eqntag = pop_output;
});

# Element: tag
sgml('<tag>', sub{
    push_output('string');
});
sgml('</tag>', sub{
    $eqrtag = pop_output;
});

# Element: prime -- emulates \prime in LaTeX; author-level use in a script
sgml('<prime>', sub{
    my $os = "&#x2032;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>" . $os . "</mo>";
    };
    output($os);
});
sgml('</prime>', "");

# Element: backprime -- emulates \backprime in LaTeX; author-level use
#                       in a script
sgml('<backprime>', sub{
    my $os = "&#x2035;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>" . $os . "</mo>";
    };
    output($os);
});
sgml('</backprime>', "");

# Element: sprime -- should flow to normal single prime accent: U-2032
#   for now this should already be wrapped in a superscript
sgml('<sprime>', sub{
    my $os = "&#x2032;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x2032;</mo>";
    };
    output($os);
});
sgml('</sprime>', "");

# Element: dprime -- should flow to normal double prime accent: U-2033
sgml('<dprime>', sub{
    my $os = "&#x2033;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x2032;&#x2032;</mo>";
    };
    output($os);
});
sgml('</dprime>', "");

# Element: tprime -- should flow to normal triple prime accent: U-2034
sgml('<tprime>', sub{
    my $os = "&#x2034;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x2032;&#x2032;&#x2032;</mo>";
    };
    output($os);
});
sgml('</tprime>', "");

# Element: qprime -- should flow to normal quadruple prime accent: U-2057
sgml('<qprime>', sub{
    my $os = "&#x2057;";
    if(($gmath_on == 1) && ($mathml == 1)){
	$os = "<mo>&#x2032;&#x2032;&#x2032;&#x2032;</mo>";
    };
    output($os);
});
sgml('</qprime>', "");

# Element: bprime -- should flow to normal reversed prime accent: U-2035
#   for now this should already be wrapped in a superscript
sgml('<bprime>', "<mo>&#x2035;</mo>");
sgml('</bprime>', "");

# Element: rqq
sgml('<rqq>', "&#x2057;");
sgml('</rqq>', "");

# Element: rtq
sgml('<rtq>', "&#x2034;");
sgml('</rtq>', "");

# Element: dag
sgml('<dag>', "&#x2020;");
sgml('</dag>', "");

# Element: ddag
sgml('<ddag>', "&#x2021;");
sgml('</ddag>', "");

# Element: reg
sgml('<reg>', "&#x00AE;");
sgml('</reg>', "");

# Element: trade
sgml('<trade>', "&#x2122;");
sgml('</trade>', "");

# Element: nobr
sgml('<nobr>', sub{
    push_output('string');
});
sgml('</nobr>', sub{
    my $pos = pop_output;
    my $os = '<span style="white-space: nowrap">' . $pos . '</span>';
    output($os);
});

# Element sipbody -- body of sum, int, or prod
sgml('<sipbody>', sub{
    push_output('string');
});
sgml('</sipbody>', sub{
    my $os = "";
    my $pos = pop_output;
    my $elt = $_[0];
    # mathematical context implied
    if($mathml == 1){
	$os = $pos;
	my $seq = $elt->attribute("mseq")->value;
	my $par = $elt->parent;
	my $pan = $par->name;
	my $parchld = $par->attribute("mchld")->value;
	my @sybs = split(',',$parchld);
	if(!($sybs[$seq-1] eq "sipbody")){
	    print STDERR $WhoAmI, ": WARNING -- Seq. no. mismatch for",
	     "sipbody at l. " , $_[1]->line, "\n";
	    print STDERR "     Parent elt. ", $pan, " with child list: "
		, $parchld, "\n";
	    print STDERR "     Elt att mseq: ", $seq, "; parent lookup: "
		, $sybs[$seq-1], "\n";
	};
	# Need an mrow ?
	my $chld = $elt->attribute("mchld")->value;
	my @chlds = split(',', $chld);
	my $nchld = scalar(@chlds);
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow>";
	};
    }
    else{
	$os = $pos;
    };
    output($os);
});

# Element lower -- lower limit for sum, int, prod
sgml('<lower>', sub{
    push_output('string');
});
sgml('</lower>', sub{
    my $pos = pop_output;
    my $os = $pos;
    my $elt = $_[0];
    if($mathml == 1){
	my $chld = $elt->attribute("mchld")->value;
	my @chlds = split(',', $chld);
	my $nchld = scalar(@chlds);
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow>";
	};
    };
    $sumsub[$sumdepth] = $os;
});

# Element upper -- upper limit for sum, int, prod
sgml('<upper>', sub{
    push_output('string');
});
sgml('</upper>', sub{
    my $pos = pop_output;
    my $os = $pos;
    my $elt = $_[0];
    if($mathml == 1){
	my $chld = $elt->attribute("mchld")->value;
	my @chlds = split(',', $chld);
	my $nchld = scalar(@chlds);
	if($nchld > 1){
	    $os = "<mrow>" . $os . "</mrow>";
	};
    };
    $sumsup[$sumdepth] = $os;
});

# General table processing routines -- under construction, still needing work
# Not currently used
sub on_table{
    $tabser++;
    $tabdepth++;
    $tabid[$tabdepth] = $tabser;
    $tabhlen[$tabdepth] = 0;
    $tabvlen[$tabdepth] = 0;
    $tabopt[$tabdepth] = "";
    $tabarg[$tabdepth] = "";
    push_output('string');
};

# Not currently used
sub off_table{
    my ($elt, $evt) = @_;
    my $name = $elt->name;
    my $pos = pop_output;
    my $es = "";
    my $rs = "";
    if($tabhlen[$tabdepth] == 0){
	$es = $es . "Error: cannot find table argument for element \"";
	$es = $es . $name . "\"\n with (general) table serial number ";
	$es = $es . $tabid[$tabdepth] . " at table depth " . $tabdepth;
	die $es;
    };
# Ummm... This is HTML?  No.  LaTeX Sketch
    $rs = $rs . "\\begin{" . $name . "}" . $tabarg[$tabdepth] . "\n";
    $rs = $rs . $pos;
    $rs = $rs. "\\end{" . $name . "}\n";
    $tabdepth--;
    return $rs;
};

# Not currently used
sub diag_table{
    my ($pos, $elt, $evt) = @_;
    my $name = $elt->name;
    my $fn = $event->file;
    my $es = "";
    my $rs = "";
    $rs = "REPORT on " . $name . " in file " . $name . "\n\n";
    $rs = "\\begin{" . $name . "}" . $tabarg[$tabdepth] . "\n";
    $rs = $rs . $pos;
    $rs = $rs. "\\end{" . $name . "}\n\n";
    print {STDERR} $rs;
};

sub plain_string{
    my $os = $_[0];
    $os =~ s/\s/ /g;
    $os =~ s/<[^<>]*>//g;
$os;
};

sub uni_write{
    my ($code) = @_;
    my $os = "";
    if($mathmlc == 1){
	$os = '<ci>&#x' . $code . ';</ci>';
    }
    elsif($mathmlp == 1){
	$os = '<mi>&#x' . $code . ';</mi>';
    }
    else{
	$os = '&#x' . $code . ';';
    };
    return $os;
};

sub charWrite0{
    my ($name, $code) = @_;
    my $os = "";
    if($mathmlc == 1){
	$os = '<ci>&#x' . $code . ';</ci>';
    }
    elsif($mathmlp == 1){
	$os = '<mi>&#x' . $code . ';</mi>';
    }
    elsif($xhtmlstrict == 1){
	$os = '&#x' . $code . ';';
    }
    else{
	$os = '<b>' . $name . '</b>';
    };
    return $os;
};

sub charWrite{
    my ($name, $code, $gmath) = @_;
	# my $show = " <mtext> (charWrite args: " . $name . ", " . $code
	# . ", " . $gmath . ") </mtext>\n";
    my $os = "";
    if($gmath eq ""){
	$gmath = 1;
    };
    if($gmath == 2){
	$os = '&#x' . $code . ';';
    }
    elsif($gmath == 1){
	if($mathmlc == 1){
	    $os = '<ci>&#x' . $code . ';</ci>';
	}
	elsif($mathmlp == 1){
	    $os = '<mi>&#x' . $code . ';</mi>';
	}
	else{
	    $os = '<b>' . $name . '</b>';
	};
    }
    elsif($xhtmlstrict == 1){
	$os = '&#x' . $code . ';';
    }
    else{
	$os = '<b>' . $name . '</b>';
    };
	# $os = $os . $show;
    return $os;
};
1;
