/*
 * $Id: funct2.c,v 1.2 1994/06/21 08:14:11 ralf Exp $
 * History:
 * $Log: funct2.c,v $
 * Revision 1.2  1994/06/21  08:14:11  ralf
 * Corrected Bug in keyword search
 *
 * Revision 1.1  1994/06/17  11:26:29  ralf
 * Initial revision
 *
 */
/***************************************************************************
   name : funct2.c
 author : DORNER Fernando, GRANZER Andreas
purpose : includes besides funct1.c all functions which are called from the programm commands.c;
 ****************************************************************************/

/********************************* includes *********************************/
#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <malloc.h>
#include "main.h"
#include "funct1.h"
#include "commands.h"
#include "funct2.h"
#include "stack.h"
/******************************************************************************/

/********************************   extern variables   *************************/
extern int tabcounter;
extern FILE *fRtf;
extern FILE *fTex;
extern int bPard;
extern BOOL bInDocument;
extern int BracketLevel;
extern int RecursLevel;
extern BOOL twocolumn;
extern BOOL TABBING_ON;
extern BOOL TABBING_ON_itself;
extern BOOL TABBING_RETURN;
extern BOOL article;
extern BOOL report;
extern BOOL book;
extern BOOL titlepage;
extern int fontsize;
extern char *progname;
extern char *latexname;
extern BOOL MathMode[MAXENVIRONS];
extern char alignment[MAXENVIRONS];
extern int environ_type[MAXENVIRONS];
extern int environ_mode[MAXENVIRONS];  /* DT */
extern long linenumber;
extern int iEnvCount;
extern fpos_t pos_begin_kill;
extern BOOL ParDone;          /* DT */   /* is the RTF /par already done before */
extern BOOL IgnoreSpaces;
extern int TabularColumn;
extern char CellJustif[MAXCELLS];
extern int curr_fontsize[MAXENVIRONS];
extern BOOL Debug;
extern int NumberColumns;

/*****************************************************************************/

/***************************** global variables ********************************/
int tabstoparray[100];
int number_of_tabstops=0;
BOOL FirstHline=TRUE;
char RowModel[1000]="";
char HlineTop[1000]="";
char HlineBot[1000]="";
int ncell=0;
/*****************************************************************************/

void Rowstrcat(char *addstring)
{
  strcat(RowModel, addstring);
  strcat(HlineTop, addstring);
  strcat(HlineBot, addstring);
}

/*----------------------------Tabbing Environment ------------------------*/
/******************************************************************************/
void Tabbing(int code)
/******************************************************************************
  purpose: pushes all tabbing-commands on a stack
parameter: code : on/off at begin/end-environment
  globals: TABBING_ON: true if tabbing-mode is on (only in this environment)
	   TABBING_RETURN, TABBING_ITSELF: true if environmend ends
 ******************************************************************************/
{
  if (code & ON)  /* on switch */
  {
    code &= ~(ON);  /* mask MSB */
    if (code == TABBING)
    {
      TABBING_ON = TRUE;
      /*TABBING_ON_itself = FALSE; */

      PushEnvironment(code);

      fprintf(fRtf,"\\par\\line ");
      fgetpos(fRtf,&pos_begin_kill);
      /* Test ConvertTabbing(); */
    }
  }
  else /* off switch */
  {
    /* TABBING_RETURN = TRUE;
    TABBING_ON_itself = TRUE; */
    TABBING_ON = FALSE;
    PopEnvironment(code);

    fprintf(fRtf,"\\par\\pard\\line\\q%c ",alignment[iEnvCount]);
  }
}

/******************************************************************************/
void CmdTabset(int code)
/******************************************************************************
 purpose: sets an tabstop
globals:  tabcounter: specifies the tabstop-position
 ******************************************************************************/
{int tabstop;
    tabstop = (tabcounter/6)*567;
    tabstoparray[number_of_tabstops] = tabstop;
    number_of_tabstops++;
    fprintf(fRtf,"\\tx%d ",tabstop); /* Tab at tabstop/567 centimeters */
}

/******************************************************************************/
void CmdTabjump(int code)
/******************************************************************************
 purpose: jumps to an tabstop
 ******************************************************************************/
{
    fprintf(fRtf,"\\tab ");
}

/******************************************************************************/
void CmdTabkill(int code)
/******************************************************************************
 purpose: a line in the TABBING-Environment which ends with an kill-command won't be
	 written to the rtf-FILE
 ******************************************************************************/
{int i;

  fsetpos(fRtf,&pos_begin_kill);

  for(i=0;i<number_of_tabstops;i++)
    {
    fprintf(fRtf,"\\tx%d ",tabstoparray[i]); /* Tab at tabstop/567 centimeters */
    }

  number_of_tabstops = 0;
}
/*-------------------- End of Tabbing Environment -------------------------*/



/******************************************************************************/
void CmdIgnoreFigure(int code)
/******************************************************************************
  purpose: function, which overreads the Figure,Picture,Bibliopgraphy and Minipage
	   Environment
parameter: code: which environment to ignore
 ******************************************************************************/
{
 char endfigure[20];
 char zeichen;
 BOOL found = FALSE;
 int i, endstring=0;

    switch (code & ~(ON))  /* mask MSB */
    {
	 case FIGURE : {
			   strcpy(endfigure,"end{figure}");
			   endstring = strlen(endfigure) -1;
			   break;
		       }
	 case FIGURE_1 : {
			   strcpy(endfigure,"end{figure*}");
			   endstring = strlen(endfigure) -1;
			   break;
		       }
	 case PICTURE : {
			   strcpy(endfigure,"end{picture}");
			   endstring = strlen(endfigure) -1;
			   break;
			}
	 case MINIPAGE : {
			   strcpy(endfigure,"end{minipage}");
			   endstring = strlen(endfigure) -1;
			   break;
			}
	 case THEBIBLIOGRAPHY : {
			   strcpy(endfigure,"end{thebibliography}");
			   endstring = strlen(endfigure) -1;
			   break;
			}

    } /* end switch */

    while (fread(&zeichen,1,1,fTex) >=1)
    {
       if (zeichen == '\\')
       {
	  int found_space = FALSE;
	  for (i=0; i<=endstring; i++)
	    {
	    int nl = FALSE;
	    if (fread(&zeichen,1,1,fTex) < 1)
		numerror(ERR_EOF_INPUT);
	    if (zeichen == '\\')
		linenumber++;                   /* \\-in figure is a line !!! */
	    while(zeichen == ' ' || zeichen == '\t' || zeichen == '\n' && !nl)
	    {
		if(zeichen == '\n')
		    nl = TRUE;
		if(fread(&zeichen,1,1,fTex) !=1)
		    numerror(ERR_EOF_INPUT);
		found_space = TRUE;
	    }
	    if(found_space && zeichen != '{') /* for vi } */
		break;
	    found_space = FALSE;
	    if (zeichen != endfigure[i])
		break;
	    if (i == endstring)                 /* end-figure-found */
		found = TRUE;
	    } /* for */
       } /* if */
       if (zeichen == '%')
	  IgnoreTo('\n');
       if (zeichen == '\n')
	  linenumber++;                         /* count lines */
       if (found)
	   return;
    } /* while */
    numerror(ERR_EOF_INPUT);
}
/*------------------------------------------------------------------------*/


/******************************************************************************/
void CmdIgnoreParameter(int code)
/******************************************************************************
  purpose: function, which ignores both: optional and normal parameters
parameter: code: number of optional/normal parameters to ignore
 ******************************************************************************/
{ char optparam[1024];
  switch (code)
       {
	  case Two_Opt_One_NormParam : GetOptParam(optparam,1023);
	  case One_Opt_One_NormParam : GetOptParam(optparam,1023);
	  case No_Opt_One_NormParam  : GetParam(optparam,1023);
    				       return;
				       break;
	  case Two_Opt_Two_NormParam : GetOptParam(optparam,1023);
	  case One_Opt_Two_NormParam : GetOptParam(optparam,1023);
	  case No_Opt_Two_NormParam  : GetParam(optparam,1023);
				       GetParam(optparam,1023);
				       return;
				       break;
	  case Two_Opt_Three_NormParam: GetOptParam(optparam,1023);
	  case One_Opt_Three_NormParam: GetOptParam(optparam,1023);
	  case No_Opt_Three_NormParam: GetParam(optparam,1023);
				       GetParam(optparam,1023);
				       GetParam(optparam,1023);
				       return;
				       break;
	  case Two_Opt_No_NormParam  : GetOptParam(optparam,1023);
	  case One_Opt_No_NormParam  : GetOptParam(optparam,1023);
				      break;
       } /* switch */
}
/*------------------------------------------------------------------------*/


/******************************************************************************/
void Ignore_Environment(char *searchstring)
/******************************************************************************
  purpose: function, which ignores an unconvertable environment in LaTex
parameter: searchstring : includes the string to search for
	   example: \begin{unknown} ... \end{unknown}
		    searchstring="end{unknown}"
 ******************************************************************************/
{
 char zeichen;
 BOOL found = FALSE;
 int i, endstring;
    endstring = strlen(searchstring) - 1;
    while (fread(&zeichen,1,1,fTex) >=1)
    {
       if (zeichen == '\\')
       {
	  for (i=0; i<=endstring; i++)
	    {
	    if (fread(&zeichen,1,1,fTex) < 1)
		numerror(ERR_EOF_INPUT);
	    if (zeichen != searchstring[i])
		break;
	    if (i == endstring)                 /* end-environment-found */
		found = TRUE;
	    } /* for */
	} /* if */
       if (zeichen == '%')
	   IgnoreTo('\n');
       if (zeichen == '\n')
	   linenumber++;
       if (found)
	   return;
    } /* while */
    numerror(ERR_EOF_INPUT);
}
/*------------------------------------------------------------------------*/


/******************************************************************************/
void GetOptParam(char *string, int size)
/******************************************************************************
  purpose: function to get an optional parameter
parameter: string: returnvalue of optional parameter
	   size: max. size of returnvalue
 ******************************************************************************/
{
  char cThis; 
  int i,PopLevel,PopBrack;

  if ( (fread(&cThis,1,1,fTex) < 1))
    numerror(ERR_EOF_INPUT);

  if ( cThis != '[' )
  {
    fseek(fTex,-1L,SEEK_CUR); /* reread last character */
    string = "";
    return;
  }
  else
  {
    ++BracketLevel;
    Push(RecursLevel,BracketLevel);
  }
  for (i = 0; ;i++)   /* get param from input stream */
  {
    if (fread(&cThis,1,1,fTex) < 1)
       numerror(ERR_EOF_INPUT);
    if (cThis == ']')
    {
      --BracketLevel;
      Pop(&PopLevel,&PopBrack);
      break;
    }
    if (cThis == '%')
      {
       IgnoreTo('\n');
       continue;
      }
    if (size-- > 0)
      string[i] = cThis;
  }
  string[i] = '\0';
}
/*------------------------------------------------------------------------*/

/******************************************************************************/
void CmdIgnoreEnvironment(int code)
/******************************************************************************
  purpose: overreads an ignoreable environment
parameter: code: type of environment & ON/OFF
 ******************************************************************************/
{
     switch (code & ~(ON))   /* ON/OFF-parameter exclude */
     {
	case BIBLIOGRAPHY :
			  Ignore_Environment("end{thebibliography}");
			  break;                
	case LETTER : Ignore_Environment("end{letter}");
			  break;
	case TABLE : Ignore_Environment("end{table}");
			  break;
	case TABLE_1 : Ignore_Environment("end{table*}");
			  break;
	default : numerror(ERR_WRONG_COMMAND);
     } /* switch */
}

/******************************************************************************/
void CmdColumn (int code)
/******************************************************************************
  purpose: chooses beetween one/two-columns
parameter: number of columns
 globals: twocolumn: true if twocolumn-mode is set
 ******************************************************************************/
{
   switch (code)
   {
       case One_Column : fprintf(fRtf,"\\page \\colsx709\\endnhere "); /* new page & one column */
			 twocolumn = FALSE;
			 break;
       case Two_Column : fprintf(fRtf,"\\page \\cols2\\colsx709\\endnhere "); /* new page & two columns */
			 twocolumn = TRUE;
			 break;
   } /* switch */
}

/******************************************************************************/
char *GetSubString(char *s, char terminatesymbol)
/******************************************************************************
purpose:
-----------------------------------------------------------------------------
 GetString is a function which returns the substrings of the string s
   seperated by the terminatesymbol 
 after calling this funtion the first substring to the terminatesymbol
   is cut off the string s 
-----------------------------------------------------------------------------*/
{char *substring;
 char *hilfstring;
 int i=0;

      substring =(char*) malloc((strlen(s)+1) * sizeof(char)); /* get heap-memory */
      if (substring == NULL)
	  error(" malloc error -> out of memory!\n");
      strcpy(substring,"");

      for(i=0; (int)i<=(int)strlen(s); i++)  /* if *s == "" -> for won't be executed */
      {                            /* <= is used for recognising the endmark of the string */
	if (s[i] == '\0')
	{
	   strcpy(s,"");
	   break;
	}
	if (s[i] == terminatesymbol)
	{
	   hilfstring = &s[i+1];
	   strcpy(s,hilfstring);    /* is also replaced in the calling-function */
	   break;
	}
	substring[i] = s[i];
      }  /* for */

      substring[i] = '\0'; /* end-mark */
      return substring;
}
/*-----------------------------------------------------------------------------*/

/******************************************************************************/
void CmdNewPage(int code)
/******************************************************************************
  purpose: starts a new page
parameter: code: newpage or newcolumn-option
 globals: twocolumn: true if twocolumn-mode is set
 ******************************************************************************/
{
   switch (code)
   {
      case NewPage :  fprintf(fRtf,"\\page "); /* causes new page */
		      break;
      case NewColumn : if (twocolumn == TRUE)
			  fprintf(fRtf,"\\column "); /* new column */
		       else
			  fprintf(fRtf,"\\page ");  /* causes new page */
		       break;
   } /* switch */
}

/******************************************************************************/
void Cmd_OptParam_Without_braces(int code)
/******************************************************************************
 purpose: gets an optional parameter which isn't surrounded by braces but by spaces
 ******************************************************************************/
{char cNext=' ';
 char cLast=' ';

    do
    {
       cLast = cNext;
       if (fread(&cNext,1,1,fTex) < 1)
	   numerror(ERR_EOF_INPUT);

    } while ((cNext != ' ') &&
	     (cNext != '\\') &&
	     (cNext != '{') &&
	     (cNext != '\n') &&
	     (cNext != ',') &&
	     ((cNext != '.')  || (isdigit(cLast))) && /* . doesn't mean the end of an command inside an number of the type real */
	     (cNext != '}') &&
	     (cNext != '\"') &&
	     (cNext != '[') &&
	     (cNext != '$'));

    fseek(fTex,-1L,SEEK_CUR);
}


/******************************************************************************/
void GetInputParam(char *string, int size)
/******************************************************************************
  purpose: gets the parameter followed the \include or \input -command
parameter: string: returnvalue of the input/include-parameter
	   size: max. size of the returnvalue
		 must be determined by the calling-function
 ******************************************************************************/
{
  char cThis;
  int i,PopLevel,PopBrack;
  BOOL readuntilnewline = FALSE;

  if ( (fread(&cThis,1,1,fTex) < 1))
    numerror(ERR_EOF_INPUT);
  if ( cThis == '{' )
  {
    ++BracketLevel;
    Push(RecursLevel,BracketLevel);

  }
  else
  {
    readuntilnewline = TRUE;
    fseek(fTex,-1L,SEEK_CUR); /* reread last character */
  }
  for (i = 0; ;i++)   /* get param from input stream */
  {
    if (fread(&cThis,1,1,fTex) < 1)
       numerror(ERR_EOF_INPUT);
    if (cThis == '}')
    {
      --BracketLevel;
      Pop(&PopLevel,&PopBrack);
      break;
    }

    if ((readuntilnewline == TRUE) &&
	((cThis == ' ') || (cThis == '\n')))
	{
	if (cThis == '\n')
	    linenumber++;
	break;
	}

    if (size-- > 0)
      string[i] = cThis;
  }
  string[i] = '\0';
}

/******************************************************************************/
void ConvertTabbing(void)
/******************************************************************************
 purpose: routine which converts the tabbing-commands from LaTex to Rtf
 ******************************************************************************/
{ int read_end = 1024;
  char cCommand[MAXCOMMANDLEN];
  int i;
  long j=0;
  char cThis; 
  BOOL getcommand;
  BOOL command_end_line_found;
  BOOL command_kill_found;

while (TABBING_ON)
{
command_end_line_found = FALSE;
command_kill_found = FALSE;

while (command_end_line_found == FALSE)
  {
  for (;;) /* do forever */
  {
    getcommand=FALSE;
    if (fread(&cThis,1,1,fTex) < 1)
       numerror(ERR_EOF_INPUT);
    j++;

    if (cThis == '\\')
       {
       getcommand=TRUE;
       strcpy(cCommand,"");

       for (i = 0; ;i++)   /* get command from input stream */
	   {
	   if (fread(&cThis,1,1,fTex) < 1)
	      numerror(ERR_EOF_INPUT);
	   j++;

	   if (i == 0) /* test for special characters */
	      {
	      switch(cThis)
		  {
		  case '\\':    command_end_line_found=TRUE;
				break;
		    } /* switch */
	      }  /* if */

	   if (!isalpha(cThis))
	       {
	       while (cThis == ' ')   /* all spaces after commands are ignored */
	       {
	       if (fread(&cThis,1,1,fTex) < 1)
		   numerror(ERR_EOF_INPUT);
	       j++;
	       }

	       fseek(fTex,-1L,SEEK_CUR); /* position of next character after command
					    except space */
	       j--;
	       break; /* for */
	       }
	   cCommand[i] = cThis;
	   }  /* for */

	   cCommand[i] = '\0';  /* mark end of string with zero */
    }  /* if \\ */

    if ((getcommand) &&
	((command_end_line_found) ||
	 (strcmp(cCommand,"kill") == 0) ||
	 (strcmp(cCommand,"end") == 0)))
	{
	command_end_line_found = TRUE;
	if (strcmp(cCommand,"kill") == 0)
	    command_kill_found = TRUE;
	break;
	}

    if (j >= read_end)
	{
	command_end_line_found = TRUE;
	break;
	}
  } /* for */
  } /* while command_end_line_found */

  fseek(fTex,-j,SEEK_CUR); /* re_read line */
  if (command_kill_found)
    Convert_Tabbing_with_kill();
  else
    Convert();
} /* while Tabbing_ON */

TABBING_ON = FALSE;
} /* ConvertTabbing */


/******************************************************************************/
void Convert_Tabbing_with_kill(void)
/******************************************************************************
 purpose: routine which converts the tabbing-kill-option from LaTex to Rtf
 globals: tabcounter:
 ******************************************************************************/
{ int i=0;
  BOOL command_kill_found=FALSE;
  char cThis; 
  char cCommand[MAXCOMMANDLEN];

tabcounter=0;

while (command_kill_found == FALSE)
   {
    if (fread(&cThis,1,1,fTex) < 1)
       numerror(ERR_EOF_INPUT);

    strcpy(cCommand,"");

    if (cThis == '\\')
       {

       for (i = 0; ;i++)   /* get command from input stream */
	   {
	   if (fread(&cThis,1,1,fTex) < 1)
	      numerror(ERR_EOF_INPUT);

	   if (i == 0) /* test for special characters */
	      {
	      switch(cThis)
		  {
		  case '=': CmdTabset(0);
			    break;
		  default : if(!isalpha(cThis))
				 numerror(ERR_WRONG_COMMAND_IN_TABBING);
		    } /* switch */
	      }  /* if */

	   if (!isalpha(cThis))
	       {
	       while (cThis == ' ')   /* all spaces after commands are ignored */
	       {
	       if (fread(&cThis,1,1,fTex) < 1)
		   numerror(ERR_EOF_INPUT);
	       }

	       fseek(fTex,-1L,SEEK_CUR); /* position of next character after command
					    except space */
	       break; /* for */
	       }
	   cCommand[i] = cThis;
	   }  /* for */

	   cCommand[i] = '\0';  /* mark end of string with zero */
    }  /* if \\ */
    else
      tabcounter++;

      if (strcmp(cCommand,"kill") == 0)
	{
	command_kill_found = TRUE;
	tabcounter = 0;
	break;
	}
  } /* while command_kill_found */
} /* Convert_Tabbing_with_kill */


/******************************************************************************/
void CmdBottom(int code)
/******************************************************************************/
{
  /* it's conventional for the height of the text to be the same on all full pages */
}

/******************************************************************************/
void CmdAbstract(int code)
/******************************************************************************
  purpose: converts the LaTex-abstract-command to an similar Rtf-style
parameter: code: on/off-option
 globals : article and titlepage from the documentstyle
 ******************************************************************************/
{ static char oldalignment = JUSTIFIED;


  switch (code)
     {
     case  ON:
	 if ((article) && (titlepage))
	    {
	    fprintf(fRtf,"\n\r\\par\n\\par\\pard ");
	    fprintf(fRtf,"\\pard\\qj ");  /* blocked */
	    fprintf(fRtf,"{\\b\\fs%d Abstract}",fontsize);
	    }
	 else
	    {
	    fprintf(fRtf,"\n\r\\par\n\\par\\pard \\page ");
	    fprintf(fRtf,"\\pard\\qj ");   /* blocked */
	    fprintf(fRtf,"{\\b\\fs%d Abstract:}\\par ",fontsize);
	    }
	  oldalignment = alignment[iEnvCount];
	  alignment[iEnvCount] = JUSTIFIED;
	  break;
    case  OFF:
	  fprintf(fRtf,"\\pard ");
	  alignment[iEnvCount] = oldalignment;
	  fprintf(fRtf,"\n\r\\par\\q%c ",alignment[iEnvCount]);
	  break;
     } /* switch */
}



/******************************************************************************/
void CmdTitlepage(int code)
/******************************************************************************
  purpose: converts the LaTex-Titlepage-command to an similar Rtf-style
parameter: on/off option
 globals : alignment: is used for the default-alignment-setting after this environment
 ******************************************************************************/
{
  switch (code)
     {
     case  ON:
	    fprintf(fRtf,"\n\r\\par\\pard \\page ");  /* new page */
	    fprintf(fRtf,"\n\r\\par\\q%c ",alignment[iEnvCount]);
	    break;
    case  OFF:
	  fprintf(fRtf,"\\pard ");
	  fprintf(fRtf,"\n\r\\par\\q%c \\page ",alignment[iEnvCount]);
	 break;
     } /* switch */
}

/******************************************************************************/
void CmdHyphenation(int code)
/******************************************************************************
 purpose: the parameter surrrounded by braces after the hyphenation-command
	  won't be seperated at a line-end.
 ******************************************************************************/
{ char hyphenparameter[10240];
  unsigned int i;

    GetParam(hyphenparameter,10239);

/* In a future version we may correctly hyphenate all occurencies of
 * hyphenation-words
 */
# ifdef notdef
    for (i=0; i<(strlen(hyphenparameter)-1); i++)
	{
	if (hyphenparameter[i] != '-')
	    fprintf(fRtf,"%c",hyphenparameter[i]);
	else
	    fprintf(fRtf,"\\-");
	} /* for */
# endif /* notdef */
}

/******************************************************************************/
void CmdFormula2(int code)
/******************************************************************************
 purpose: the same as the function CmdFormula: see above!
 ******************************************************************************/
{ char errormessage[128];

  if(Debug) fprintf(OUTPUTF,"\n  CmdFormula2: code %8X ", code);

  switch(code)
  {
    case (BEGIN_DISPLAY | ON):
     if (MathMode[iEnvCount] == TRUE)
     {  sprintf(errormessage,"\\begin{<displaymath>} in math mode in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
     }
     CmdFormula(BEGIN_DISPLAY);
     break;
    case (BEGIN_DISPLAY | OFF):
     if (MathMode[iEnvCount] == FALSE)
     {  sprintf(errormessage,"\\end{<displaymath>} not in math mode in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
     }
     CmdFormula(BEGIN_DISPLAY);
     break;
    case (BEGIN_MATH | ON):
     if (MathMode[iEnvCount] == TRUE)
     {  sprintf(errormessage,"\\begin{<math>} in math mode in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
     }
     CmdFormula(BEGIN_MATH);
     break;
    case (BEGIN_MATH | OFF):
     if (MathMode[iEnvCount] == FALSE)
     {  sprintf(errormessage,"\\end{<math>} not in math mode in File: %s at linenumber: %ld",latexname,linenumber);
        error(errormessage);
     }
     CmdFormula(BEGIN_MATH);
     break;
  };
}

/******************************************************************************/
void CmdLetter(int code)
/******************************************************************************
  purpose: pushes all necessary letter-commands on a stack
parameter: code: on/off-option for environment
 ******************************************************************************/
{
  if (code & ON)  /* on switch */
  {
    code &= ~(ON);  /* mask MSB */
    if (code == LETTER)
    {
      PushEnvironment(code);
    }
  }
  else /* off switch */
  {
    PopEnvironment(code);
  }
}

/******************************************************************************/
void CmdAddress(int code)
/******************************************************************************
 purpose: prints the address in a letter
 globals: alignment
 ******************************************************************************/
{ static char oldalignment = JUSTIFIED;

     oldalignment = alignment[iEnvCount];
     alignment[iEnvCount] = RIGHT;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);   /* address will be printed on the right top */

     Convert(); /* convert routine is called again for evaluating the contens
		 hold in braces after the \address-command */

     alignment[iEnvCount] = oldalignment;
     fprintf(fRtf,"\\par\\chdate "); /* additional to the address the actual date is printed */

     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);
}


/******************************************************************************/
void CmdSignature(int code)
/******************************************************************************
 purpose: prints the signature in a letter
 globals: alignment
 ******************************************************************************/
{ static char oldalignment = JUSTIFIED;

     oldalignment = alignment[iEnvCount];
     alignment[iEnvCount] = RIGHT;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);   /* signature will be printed on the right top */

     Convert(); /* convert routine is called again for evaluating the contens
		 hold in braces after the \signature-command */

     alignment[iEnvCount] = oldalignment;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);
}

/******************************************************************************/
void CmdOpening(int code)
/******************************************************************************
 purpose: special command in the LaTex-letter-environment will be converted to a
	  similar Rtf-style
 globals: alignment
 ******************************************************************************/
{ static char oldalignment;

     oldalignment = alignment[iEnvCount];
     alignment[iEnvCount] = LEFT;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);   /* opening will be printed on the right top */

     Convert(); /* convert routine is called again for evaluating the contens
		 hold in braces after the \opening-command */

     alignment[iEnvCount] = oldalignment;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);
}

/******************************************************************************/
void CmdClosing(int code)
/******************************************************************************
 purpose: special command in the LaTex-letter-environment will be converted to a
	  similar Rtf-style
 globals: alignment
 ******************************************************************************/
{ static char oldalignment;

     oldalignment = alignment[iEnvCount];
     alignment[iEnvCount] = LEFT;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);   /* closing will be printed on the right top */

     Convert(); /* convert routine is called again for evaluating the contens
		 hold in braces after the \closing-command */

     alignment[iEnvCount] = oldalignment;
     fprintf(fRtf,"\n\r\\par\\pard\\q%c ",alignment[iEnvCount]);
}

void CmdPs(int code)
{
    /* additional text to the \ps-command will be converted by the basic convert-routine */
    /* but you'll have to type the 'P.S.:'-text yourself */
}

/******************************************************************************/
void CmdArray(int code)
/******************************************************************************
 purpose: converts the LaTex-Array/eqnarray to a similar Rtf-style
	  this converting is only partially
	  so the user has to convert some part of the array/eqnarray-environment by hand
parameter: type of array-environment
 ******************************************************************************/
{
  if (code & ON)  /* on switch */
  {
    code &= ~(ON);  /* mask MSB */
    fprintf(OUTPUTF,"\n%s: WARNING: Following environment cannot be converted completely!",progname);
    fprintf(OUTPUTF,"\nSome parts of this environment have to be converted and corrected by hand");

    if (code == ARRAY)
      {
      fprintf(OUTPUTF,"Begin of environment: ARRAY\n");
      fprintf(fRtf,"\\par ***begin of environment: ARRAY ***\\par");
      }
    if (code == EQNARRAY)
      {
      fprintf(OUTPUTF,"Begin of environment: EQNARRAY\n");
      fprintf(fRtf,"\\par ***begin of environment: EQNARRAY ***\\par");
      }
    if (code == EQNARRAY_1)
      {
      fprintf(OUTPUTF,"Begin of environment: EQNARRAY* \n");
      fprintf(fRtf,"\\par ***begin of environment: EQNARRAY*    ***\\par");
      }
  }
  else /* off switch */
  {
    code &= ~(OFF);  /* mask MSB */
    if (code == ARRAY)
      {
      fprintf(OUTPUTF,"End of environment: ARRAY\n");
      fprintf(fRtf,"\\par ***end of environment: ARRAY ***\\par");
      }
    if (code == EQNARRAY)
      {
      fprintf(OUTPUTF,"End of environment: EQNARRAY\n");
      fprintf(fRtf,"\\par ***end of environment: EQNARRAY ***\\par");
      }
    if (code == EQNARRAY_1)
      {
      fprintf(OUTPUTF,"End of environment: EQNARRAY* \n");
      fprintf(fRtf,"\\par ***end of environment: EQNARRAY*    ***\\par");
      }
  }
}

/******************************************************************************/
void CmdHline(int code)
/******************************************************************************
 purpose: performs \\hline in tabular environment
 ******************************************************************************/
{
  int icell;
	
  if (FirstHline)
  {  fprintf(fRtf,"%s",HlineTop);}
  else
  {  fprintf(fRtf,"%s",HlineBot);}
  ;
  for (icell = 1; icell <= ncell; icell++)
   {
     fprintf(fRtf,"\\sl-1\\cell");
   };
   fprintf(fRtf,"\\row\n%s",RowModel);
   IgnoreSpaces = TRUE;
   TabularColumn = 1;
}

/******************************************************************************/
void TabularDbleSlash()
/******************************************************************************
 purpose: performs double backslash in tabular environment
 ******************************************************************************/
{
  switch (environ_type[iEnvCount])
  {
    case TABULAR :
      fprintf(fRtf,"\\cell\\row%s",RowModel);
      IgnoreSpaces = TRUE;
      TabularColumn = 1;
      break;
    default :
      warning(" \\\\ not in tabular environment, ignored");
  }
}

/******************************************************************************/
void TabulationChar()
/******************************************************************************
 purpose: performs & tabular environment
 ******************************************************************************/
{
  switch (environ_type[iEnvCount])
  {
    case TABULAR :
      fprintf(fRtf,"\\cell\\pard \\intbl ");	
      IgnoreSpaces = TRUE;
      TabularColumn += 1;
      if(CellJustif[TabularColumn] == 'c')
      {
      	fprintf(fRtf,"\\qc ");
      }
      else if(CellJustif[TabularColumn] == 'l')
      {
      	fprintf(fRtf,"\\li%d\\ri%d\\ql ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      else if(CellJustif[TabularColumn] == 'p')
      {
      	fprintf(fRtf,"\\li%d\\ri%d\\ql ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      else if(CellJustif[TabularColumn] == 'r')
      {
      	fprintf(fRtf,"\\li%d\\ri%d\\qr ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      ;
      break;
    default :
      warning(" & not in tabular environment, ignored");
  }
}


/******************************************************************************/
void CmdTabular(int code)
/******************************************************************************
 purpose: converts the LaTex-Tabular to a similar Rtf-style
	  this converting is only partially
	  so the user has to convert some part of the Tabular-environment by hand
parameter: type of array-environment
 ******************************************************************************/
{
  char TabularParam[128];
  int icell;
  int cellx[MAXCELLS]={0};
  BOOL CellBorderLeft[MAXCELLS]={FALSE};
  BOOL CellBorderRight[MAXCELLS]={FALSE};
  int CellSize[MAXCELLS]={2000};
  int DefaultCellSize = 2000;
  char CellSizeChar[128]="";
  char workstring[1024]="";
  char errormessage[256]="";
  int ichar;
  int pchar=0;
  BOOL pcell=FALSE;
  float DimenNumber=0.0;
  char CellUnit[3]="";

  switch (code)
  {
    case (TABULAR | ON):
      GetParam(TabularParam,127);
      PushEnvironment(TABULAR);

      /* compiling the tabular description */
      ncell = 0;
      pcell = FALSE;
      if (Debug) fprintf(OUTPUTF,"\nTabular params=%s",TabularParam);
      for (ichar = 0; TabularParam[ichar] != '\0'; ichar++)
      { if (Debug) fprintf(OUTPUTF,"<%c>",TabularParam[ichar]);
        if ((TabularParam[ichar] == '{') && (TabularParam[ichar-1] == 'p'))
        {pcell = TRUE; pchar = 0; if(Debug) Message("pcell = TRUE!");}
        else if (pcell && (TabularParam[ichar] == '}'))
        { pcell = FALSE; CellSizeChar[pchar++]='\0';
          if (Debug) fprintf(OUTPUTF,"\nTabular-p=%s",CellSizeChar);
          sscanf(CellSizeChar,"%f%c%c",&DimenNumber,&CellUnit[0],&CellUnit[1]);
          CellUnit[2]='\0';
          CellSize[ncell] = DimenToTwips(DimenNumber,CellUnit);
          if (Debug) fprintf(OUTPUTF,"\nCell Size (twips)=%d",CellSize[ncell]);
        }
        else if (pcell)
        { if (pchar > 120) error("Tabular paragraph size > 120 chars");
          if (Debug) fprintf(OUTPUTF," '%c'",TabularParam[ichar]);
          CellSizeChar[pchar++] = TabularParam[ichar];
          CellSizeChar[pchar+1] = '\0';
        }
        else if (TabularParam[ichar] == '|')
        { CellBorderLeft[ncell+1] = TRUE;}
        else if (TabularParam[ichar] == 'c')
        {ncell++; CellJustif[ncell] = TabularParam[ichar]; pcell=FALSE; CellSize[ncell]=2000;}
        else if (TabularParam[ichar] == 'l')
        {ncell++; CellJustif[ncell] = TabularParam[ichar]; pcell=FALSE; CellSize[ncell]=2000;}
        else if (TabularParam[ichar] == 'r')
        {ncell++; CellJustif[ncell] = TabularParam[ichar]; pcell=FALSE; CellSize[ncell]=2000;}
        else if (TabularParam[ichar] == 'p')
        {ncell++; CellJustif[ncell] = TabularParam[ichar]; pcell=FALSE; CellSize[ncell]=2000;}
/*        else if (TabularParam[ichar] == ' '){ } */
/*        else if (TabularParam[ichar] == '\n'){ } */
        else
        { sprintf(errormessage,"Abnormal character '%c'[x%2x] in tabular p{}(%s)",
          TabularParam[ichar],TabularParam[ichar],TabularParam); error(errormessage);
        }        	
        ;          
      };
      CellBorderRight[ncell] = CellBorderLeft[ncell+1];

      sprintf(RowModel,"\n");
      sprintf(HlineTop,"\n");
      sprintf(HlineBot,"\n");

/*      Rowstrcat("\\trowd \\trgaph80 "); */
      Rowstrcat("\\trowd "); 

      if (!ParDone)
      {sprintf(errormessage,
      "\\begin{tabular} within a paragraph at line %d, \\par inserted",linenumber);
      warning(errormessage);
      CmdPar(0);
      };

      if (environ_mode[iEnvCount-1] == PAR_CENTER) Rowstrcat("\\trqc");
      if (environ_mode[iEnvCount-1] == PAR_RIGHT) Rowstrcat("\\trqr");
      if (environ_mode[iEnvCount-1] == PAR_LEFT) Rowstrcat("\\trql");

      DefaultCellSize =
        DimenToTwips((17.0-(NumberColumns-1.0))/(NumberColumns*ncell+1.0),"cm");

      for (icell = 1; icell <= ncell; icell++)
      {
      	strcat(HlineTop,"\\clbrdrt\\brdrs");
      	strcat(HlineBot,"\\clbrdrb\\brdrs");
        if (CellBorderLeft[icell]) Rowstrcat("\\clbrdrl\\brdrs ");
        if (CellBorderRight[icell]) Rowstrcat("\\clbrdrr\\brdrs ");
        if (CellJustif[icell] != 'p'){ CellSize[icell] = DefaultCellSize; }
        cellx[icell] = cellx[icell-1] + CellSize[icell];
        sprintf(workstring,"\\cellx%d ",cellx[icell]);
        Rowstrcat(workstring);
        ;          
      };
      Rowstrcat("\n\\pard\\intbl ");

      workstring[0] = '\0';
      TabularColumn = 1;
      if(CellJustif[TabularColumn] == 'c')
      {
      	sprintf(workstring,"\\qc ");
      }
      else if(CellJustif[TabularColumn] == 'l')
      {
      	sprintf(workstring,"\\li%d\\ri%d\\ql ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      else if(CellJustif[TabularColumn] == 'p')
      {
      	sprintf(workstring,"\\li%d\\ri%d\\ql ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      else if(CellJustif[TabularColumn] == 'r')
      {
      	sprintf(workstring,"\\li%d\\ri%d\\qr ",5*curr_fontsize[iEnvCount],
                                         5*curr_fontsize[iEnvCount]);
      }
      ;
      Rowstrcat(workstring);
    
      IgnoreSpaces = TRUE;

      fprintf(fRtf,"%s",RowModel);
      FirstHline = TRUE;
      break;

    case (TABULAR_1 | ON):
      fprintf(OUTPUTF,"Begin of environment: TABULAR*  \n");
      fprintf(fRtf,"{\\v\\par ***begin of environment: TABULAR*   ***\\par}");
      break;
    case (TABULAR | OFF):
      FirstHline = TRUE;
      PopEnvironment(code);
      break;
    case (TABULAR_1 | OFF):
      fprintf(OUTPUTF,"End of environment: TABULAR*  \n");
      fprintf(fRtf,"{\\v\\par ***end of environment: TABULAR*  ***\\par}");
      break;
  }
}

/******************************************************************************/
void CmdTable(int code)
/******************************************************************************
 purpose: converts the LaTex-Table to a similar Rtf-style
	  this converting is only partially
	  so the user has to convert some part of the Table-environment by hand
parameter: type of array-environment
 ******************************************************************************/
{
  if (code & ON)  /* on switch */
  {
    code &= ~(ON);  /* mask MSB */
    fprintf(OUTPUTF,"\n%s: WARNING: Following environment cannot be converted completely!",progname);
    fprintf(OUTPUTF,"\nSome parts of this environment have to be converted and corrected by hand");

    if (code == TABLE)
      {
      fprintf(OUTPUTF,"Begin of environment: TABLE\n");
      fprintf(fRtf,"{\\v\\par ***begin of environment: TABLE ***\\par}");
      }
    if (code == TABLE_1)
      {
      fprintf(OUTPUTF,"Begin of environment: TABLE*  \n");
      fprintf(fRtf,"{\\v\\par ***begin of environment: TABLE*   ***\\par}");
      }
  }
  else /* off switch */
  {
    code &= ~(OFF);  /* mask MSB */
    if (code == TABLE)
      {
      fprintf(OUTPUTF,"End of environment: TABLE\n");
      fprintf(fRtf,"{\\v\\par ***end of environment: TABLE ***\\par}");
      }
    if (code == TABLE_1)
      {
      fprintf(OUTPUTF,"End of environment: TABLE*  \n");
      fprintf(fRtf,"{\\v\\par ***end of environment: TABLE*  ***\\par}");
      }
  }
};

/******************************************************************************/
void CmdExponent(int code)
/******************************************************************************
 purpose: converts the exponent field after the '^' and the subscript after '_'
parameter: type of operand
 ******************************************************************************/
{
  char exponent[1000]="";
  char errormessage[1100]="";
  float FloatFsize=20.0;
  
  GetParam(exponent,999);

  switch(code)
  {
    case EXPONENT:  sprintf(errormessage,"Exponent:|%s|",exponent);
                    if (Debug) Message(errormessage);

                    PushEnvironment(EXPONENT);
                    fprintf(fRtf,"\\up6 ");
                    CmdSetFont(F_ROMAN);
                    if(curr_fontsize[iEnvCount] > 14)
                    { FloatFsize = 0.75*curr_fontsize[iEnvCount];
                      curr_fontsize[iEnvCount] = FloatFsize;
                    };
                      fprintf(fRtf,"\\fs%d ",curr_fontsize[iEnvCount]);
                    ConvertString(exponent);
                    PopEnvironment(EXPONENT);
                    break;
    case SUBSCRIPT:  sprintf(errormessage,"Subscript:|%s|",exponent);
                    if (Debug) Message(errormessage);

                    PushEnvironment(SUBSCRIPT);
                    fprintf(fRtf,"\\dn6 ");
                    CmdSetFont(F_ROMAN);
                    if(curr_fontsize[iEnvCount] > 14)
                    { FloatFsize = 0.75*curr_fontsize[iEnvCount];
                      curr_fontsize[iEnvCount] = FloatFsize;
                    }
                      fprintf(fRtf,"\\fs%d ",curr_fontsize[iEnvCount]);
                    ConvertString(exponent);
                    PopEnvironment(SUBSCRIPT);
                    break;
     default: sprintf(errormessage,"Abnormal CmdExponent %d",code);
              error(errormessage);
  }
}  
