procedure CheckLig(var FLig  : ptrLigRecord;
                   var UChar : CharUsedArr);
var pLig, pTrace : ptrLigRecord;
    i, j, jj : integer;
    fl : boolean;
begin

     if FLig <> nil then
     if not (FLig^.TTLig in [TLabel, TLabelBoundary]) then
     begin
         ErrorLog('*** Error : LIGTABLE is not started with LABEL record');
         FlagError:=true;
     end;

     pLig:=FLig; jj:=0;
     while pLig <> nil do
     with pLig^ do
     begin
           jj:=jj+1;

           if TTLig in [TLabel, TLabelBoundary] then
           begin

              if TTLig = TLabel then
              begin
                    if UChar[LigChar] and (marked <> LigDiscard) then
                    begin
                      ErrorLog('*** Error : Character '+ConvChar(LigChar)+' is in LABEL field');
                      ErrorLog('              (record '+ConvInt(jj)+' of the LIGTABLE) more than once');
                      marked:=LigDiscard;
                    end;
                    UChar[LigChar]:=true;
              end
              else begin
                    if UChar[256] and (marked <> LigDiscard) then
                    begin
                      ErrorLog('*** Error : LABEL BOUNDARYCHAR is found more than once');
                      ErrorLog('              (record '+ConvInt(jj)+' of the LIGTABLE) more than once');
                      marked:=LigDiscard;
                    end;
                    UChar[256]:=true;
              end;

              {---- Trace LIG ----}
              pTrace:=pLig; fl:=true; i:=1; j:=0;
              while (pTrace <> nil) and fl do
              begin
                    if i <= j then
                    begin
                        if pTrace^.TTLig in [TKern, TLig, TSLig, TSLigH,
                                          TLigS, TLigSH, TSLigS, TSLigSH,
                                          TSLigSHH]
                              then i:=i+1;
                    end
                    else if pTrace^.TTLig = TStop then
                    begin
                         fl:=false;
                    end
                    else if pTrace^.TTLig = TSkip then
                    begin
                        i:=0; j:=pTrace^.SkipNum;
                    end;
                   if fl then pTrace:=pTrace^.ptrNext;
              end; {while}
              {---- end Trace ----}

              if fl and (marked <> LigDiscard) then
              begin
                   ErrorLog('*** Error : LIG Program for character '+ConvChar(LigChar)+' has no STOP');
                   ErrorLog('              (record '+ConvInt(jj)+' of the LIGTABLE)');
                   marked:=LigDiscard;
              end;

           end; {if}

          pLig:=pLig^.ptrNext;

     end; {while}

end; {CheckLig}



procedure CheckFontLig(var FParam : FontParamRec;
                       var FChar  : CharDataType;
                       var FLig   : ptrLigRecord);
var UChar    : CharUsedArr;
var i, j, jj : integer;
    pLig     : ptrLigRecord;
    TTLigOld : TLigType;
    res      : float;
begin

     res:=FParam.FontDesignUnits/FParam.FontDesignSize;

     if FLig <> nil then
     if not (FLig^.TTLig in [TLabel, TLabelBoundary]) then
     begin
         ErrorLog('*** Error : LIGTABLE is not started with LABEL record');
         FlagError:=true;
     end;

     for j:=0 to 256 do UChar[j]:=false;
     CheckLig(FLig,UChar);

     pLig:=FLig; jj:=0; TTLigOld:=TLabel;
     while pLig <> nil do
     with pLig^ do
     begin
           jj:=jj+1;
           case TTLig of
           TLabel : begin
                    if (not FChar[LigChar].defined) then
                    begin
                      ErrorLog('*** Error : Character '+ConvChar(LigChar)+' from the record '+ConvInt(jj));
                      ErrorLog('               of the LIGTABLE [LABEL] is not defined.');
                      FlagError:=true;
                    end;
           end;
           TLabelBoundary : begin
           end;
           TKern : begin
                    if not ((FParam.FlBoundChar and (KernChar = FParam.BoundChar))
                             or (FChar[KernChar].defined))
                    then begin
                      ErrorLog('*** Error : Character '+ConvChar(KernChar)+' from the record '+ConvInt(jj));
                      ErrorLog('               of the LIGTABLE [KRN] is not defined.');
                      FlagError:=true;
                    end;
                    if abs(KernValue/res) > 2048.0 then
                    begin
                      ErrorLog('*** Error : Normalized KRN size (record '+ConvInt(jj));
                      ErrorLog('               of the LIGTABLE) is greater than 2048.0');
                    end;
           end;
           TStop : begin
                 if TTLigOld in [TSkip, TStop, TLabel, TLabelBoundary] then
                 begin
                      ErrorLog('*** Error : STOP follows SKIP or STOP or LABEL instruction');
                      ErrorLog('               (record '+ConvInt(jj)+' from LIGTABLE)');
                 end;
           end;
           TSkip : begin
                      if TTLigOld in [TSkip, TStop, TLabel, TLabelBoundary] then
                      begin
                         ErrorLog('*** Error : SKIP follows SKIP or STOP or LABEL instruction');
                         ErrorLog('               (record '+ConvInt(jj)+' from LIGTABLE)');
                      end;
                   end;
           TLig, TSLig, TSLigH, TLigS, TLigSH,
           TSLigS, TSLigSH, TSLigSHH : begin
                    if not ( (Fparam.FlBoundChar and (NextChar = FParam.BoundChar))
                              or (FChar[NextChar].defined))
                    then begin
                      ErrorLog('*** Error : 1st character '+ConvChar(NextChar)+' from the record '+ConvInt(jj));
                      ErrorLog('               of the LIGTABLE [LIG] is not defined.');
                      FlagError:=true;
                    end;
                    if not FChar[InsChar].defined then
                    begin
                      ErrorLog('*** Error : 2nd character '+ConvChar(InsChar)+' from the record '+ConvInt(jj));
                      ErrorLog('               of the LIGTABLE [LIG] is not defined.');
                      FlagError:=true;
                    end;
           end;
           end; {case}
           TTLigOld:=TTLig;
           pLig:=pLig^.ptrNext;
     end; {while}

end; {CheckFontLig}


procedure CheckFont(var FParam : FontParamRec;
                    var FDim   : FontDimenRec;
                    var FChar  : CharDataType;
                    var FLig   : ptrLigRecord);
var i, j, jj : integer;
    res : float;
    fl : boolean;
begin

     if FParam.FontDesignSize <= 0.0 then
     begin
          ErrorLog('*** Error : FONTDESIGNSIZE < 0 : '
                      +ConvReal(FParam.FontDesignSize));
          ErrorLog('            FONTDESIGNSIZE is set to 10.0');
          FParam.FontDesignSize:=10.0; FlagError:=true;
     end;
     if FParam.FontDesignUnits <= 0.0 then
     begin
          ErrorLog('*** Error : FONTDESIGNUNIT < 0 : '
                     +ConvReal(FParam.FontDesignUnits));
          ErrorLog('            FONTDESIGNUNITS is set to 1.0');
          FParam.FontDesignUnits:=1.0; FlagError:=true;
     end;

     res:=FParam.FontDesignUnits/FParam.FontDesignSize;

     {---- Check sizes -----}
     with FDim do
     begin
        if abs(Space/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SPACE size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Stretch/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized STRETCH size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Shrink/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SHRINK size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(XHeight/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized XHEIGHT size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Quad/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized QUAD size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(ExtraSpace/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized EXTRASPACE size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Num1/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized NUM1 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Num2/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized NUM2 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Num3/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized NUM3 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Denom1/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized DENOM1 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Denom2/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized DENOM2 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Sup1/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUP1 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Sup2/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUP2 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Sup3/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUP3 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Sub1/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUB1 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Sub2/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUB2 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(SupDrop/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUPDROP size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(SubDrop/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized SUBDROP size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Delim1/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized DELIM1 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(Delim2/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized DELIM2 size in FONTDIMEN is greater than 2048.0');
        end;
        if abs(AxisHeight/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized AXISHEIGHT size in FONTDIMEN is greater than 2048.0');
        end;
     end; {with}
     {---- end Check sizes -----}

     {----- Trace LIGTABLE records -----}
     CheckFontLig(FParam, FChar, FLig);
     {----- end Trace LIGTABLE records -----}

     {-------- Check NEXTLARGER/VARCHAR cycles ----------}
     for i:=0 to 255 do
     with FChar[i] do
     if defined then
     begin

        if abs(CharWD/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized CHARWD size (character '+ConvChar(i)+') is greater than 2048.0');
        end;
        if abs(CharHT/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized CHARHT size (character '+ConvChar(i)+') is greater than 2048.0');
        end;
        if abs(CharDP/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized CHARDP size (character '+ConvChar(i)+') is greater than 2048.0');
        end;
        if abs(CharIC/res) > 2048.0 then
        begin
            ErrorLog('*** Error : Normalized CHARIC size (character '+ConvChar(i)+') is greater than 2048.0');
        end;

        if FlAddParm = 1 then {NextLarger}
        begin
           for j:=0 to 255 do FChar[j].traced:=false;
           fl:=true; j:=i;
           while fl do
           begin
               fl:=false;
               if FChar[j].traced then
               begin
                  ErrorLog('*** Error : Cycle NEXTLARGER is infinite :');
                  ErrorLog('               start character '+ConvChar(i)+' , cycle character '+ConvChar(j)+' .');
                  ErrorLog('            Attribute NEXTLARGER for character '+ConvChar(j)+' is ignored.');
                  FChar[j].FlAddParm:=0;
               end;
               FChar[j].traced:=true;
               if FChar[j].FlAddParm = 1 then
               begin
                  jj:=FChar[j].NextLarger;
                  if not FChar[jj].defined then
                  begin
                      ErrorLog('*** Error : In character '+ConvChar(j)+' the referenced [NEXTLARGER]');
                      ErrorLog('               character '+ConvChar(jj)+' is not defined.');
                      ErrorLog('            Attribute NEXTLARGER is ignored.');
                      FChar[j].FlAddParm:=0;
                  end
                  else begin
                      j:=jj; fl:=true;
                  end;
               end;
           end; {while}
           for j:=0 to 255 do FChar[j].traced:=false;
        end; {NextLarger}

        if FlAddParm in [2,3] then {VarChar}
        begin
           if (Top <> 0) and (not FChar[Top].defined) then
           begin
              ErrorLog('*** Error : In character '+ConvChar(i)+' the referenced [TOP]');
              ErrorLog('               character '+ConvChar(Top)+' is not defined.');
              ErrorLog('            Attribute VARCHAR is ignored.');
              FlAddParm:=0;
           end;
           if (Mid <> 0) and (not FChar[Mid].defined) then
           begin
              ErrorLog('*** Error : In character '+ConvChar(i)+' the referenced [MID]');
              ErrorLog('               character '+ConvChar(Mid)+' is not defined.');
              ErrorLog('            Attribute VARCHAR is ignored.');
              FlAddParm:=0;
           end;
           if (Bot <> 0) and (not FChar[Bot].defined) then
           begin
              ErrorLog('*** Error : In character '+ConvChar(i)+' the referenced [BOT]');
              ErrorLog('               character '+ConvChar(Bot)+' is not defined.');
              ErrorLog('            Attribute VARCHAR is ignored.');
              FlAddParm:=0;
           end;
        end;

        if FlAddParm = 3 then {VarChar + REP}
        begin
           if not FChar[Rep].defined then
           begin
              ErrorLog('*** Error : In character '+ConvChar(i)+' the referenced [REP]');
              ErrorLog('               character '+ConvChar(Rep)+' is not defined.');
              ErrorLog('            Attribute VARCHAR is ignored.');
              FlAddParm:=0;
           end;
        end;

     end; {for i}
     {-------- end Check NEXTLARGER/VARCHAR cycles ----------}


end; {CheckFont}



