/*
 * Clutter.
 *
 * An OpenGL based 'interactive canvas' library.
 *
 * Copyright (C) 2010 Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *   Damien Lespiau <damien.lespiau@intel.com>
 */

/**
 * SECTION:clutter-cex100
 * @short_description: Intel CE3100, CE4100 Specific API
 *
 * The CEX100 backend for Clutter provides some Intel CE3100/CE4100
 * specific API
 *
 * You need to include `clutter/cex100/clutter-cex100.h`
 * to have access to the functions documented here.
 */

#ifndef __CLUTTER_CEX100_H__
#define __CLUTTER_CEX100_H__

#include <glib.h>

#include <libgdl.h>

G_BEGIN_DECLS

/**
 * ClutterCex100BufferingMode:
 * @CLUTTER_CEX100_DOUBLE_BUFFERING: The GDL plane will be double buffered
 * @CLUTTER_CEX100_TRIPLE_BUFFERING: The GDL plane will be triple buffered
 *
 * Enum passed to clutter_cex100_set_buffering_mode().
 *
 * Since: 1.6
 */
typedef enum /*< prefix=CLUTTER_CEX100 >*/
{
  CLUTTER_CEX100_DOUBLE_BUFFERING = 2,
  CLUTTER_CEX100_TRIPLE_BUFFERING = 3
} ClutterCex100BufferingMode;

void            clutter_cex100_set_plane                (gdl_plane_id_t             plane);
void            clutter_cex100_set_buffering_mode       (ClutterCex100BufferingMode mode);

EGLDisplay      clutter_cex100_get_egl_display          (void);

G_END_DECLS

#endif /* __CLUTTER_CEX100_H__ */
