/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.internal.MppImplKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import java.util.Collection;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\n\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\b\u0010\b\u001a\u00020\u0004H\u0002J\u0014\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\nH\u0002J\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nJ=\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0006H\u0002J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0002J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0002J\b\u0010\u0019\u001a\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u0004H\u0002J\b\u0010\u001b\u001a\u00020\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0004H\u0002J\b\u0010\u001d\u001a\u00020\u0004H\u0002J\b\u0010\u001e\u001a\u00020\u0004H\u0002\u00a8\u0006\u001f"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalDetection;", "", "()V", "ansiHyperLinks", "", "ansiLevel", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "interactive", "ciSupportsColor", "detectInitialSize", "Lkotlin/Pair;", "", "detectSize", "detectTerminal", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "width", "height", "hyperlinks", "(Lcom/github/ajalt/mordant/rendering/AnsiLevel;Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/Boolean;Ljava/lang/Boolean;)Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "forcedColor", "getColorTerm", "", "getTerm", "getTermProgram", "isCI", "isDomTerm", "isIntellijRunActionConsole", "isJediTerm", "isRecentITerm", "isVsCodeTerminal", "isWindowsTerminal", "mordant"})
@SourceDebugExtension(value={"SMAP\nTerminalDetection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalDetection.kt\ncom/github/ajalt/mordant/terminal/TerminalDetection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1#2:173\n1747#3,3:174\n*S KotlinDebug\n*F\n+ 1 TerminalDetection.kt\ncom/github/ajalt/mordant/terminal/TerminalDetection\n*L\n163#1:174,3\n*E\n"})
public final class TerminalDetection {
    @NotNull
    public static final TerminalDetection INSTANCE = new TerminalDetection();

    private TerminalDetection() {
    }

    @NotNull
    public final TerminalInfo detectTerminal(@Nullable AnsiLevel ansiLevel, @Nullable Integer width, @Nullable Integer height, @Nullable Boolean hyperlinks, @Nullable Boolean interactive) {
        boolean outputInteractive;
        boolean ij = this.isIntellijRunActionConsole();
        Boolean bl = interactive;
        boolean inputInteractive = bl != null ? bl : ij || MppImplKt.stdinInteractive();
        Boolean bl2 = interactive;
        boolean bl3 = outputInteractive = bl2 != null ? bl2 : ij || MppImplKt.stdoutInteractive();
        AnsiLevel ansiLevel2 = ansiLevel;
        if (ansiLevel2 == null) {
            ansiLevel2 = this.ansiLevel(outputInteractive);
        }
        AnsiLevel level = ansiLevel2;
        Boolean bl4 = hyperlinks;
        boolean ansiHyperLinks = bl4 != null ? bl4 : outputInteractive && level != AnsiLevel.NONE && this.ansiHyperLinks();
        Pair<Integer, Integer> pair2 = this.detectInitialSize();
        int w = ((Number)pair2.component1()).intValue();
        int h = ((Number)pair2.component2()).intValue();
        Integer n = width;
        Integer n2 = height;
        return new TerminalInfo(n != null ? n : w, n2 != null ? n2 : h, level, ansiHyperLinks, outputInteractive, inputInteractive, ij);
    }

    @Nullable
    public final Pair<Integer, Integer> detectSize() {
        return MppImplKt.getTerminalSize();
    }

    private final Pair<Integer, Integer> detectInitialSize() {
        Pair<Integer, Integer> pair2 = MppImplKt.getTerminalSize();
        if (pair2 == null) {
            Object object;
            Object object2 = MppImplKt.getEnv("COLUMNS");
            pair2 = new Pair<Integer, Integer>(object2 != null && (object2 = StringsKt.toIntOrNull((String)object2)) != null ? (Integer)object2 : 79, (object = MppImplKt.getEnv("LINES")) != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : 24);
        }
        return pair2;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean ansiHyperLinks() {
        block9: {
            block8: {
                if (this.forcedColor() == AnsiLevel.NONE) ** GOTO lbl-1000
                if (this.isWindowsTerminal()) ** GOTO lbl-1000
                var1_1 = this.getTermProgram();
                if (var1_1 == null) break block8;
                switch (var1_1.hashCode()) {
                    case 1246525912: {
                        if (!var1_1.equals("wezterm")) {
                            ** break;
                        }
                        ** GOTO lbl15
                    }
                    case -1987176184: {
                        if (var1_1.equals("iterm.app")) break;
                        ** break;
                    }
                    case 99761772: {
                        if (!var1_1.equals("hyper")) ** break;
lbl15:
                        // 2 sources

                        v0 = true;
                        break block9;
                    }
                }
                v0 = this.isRecentITerm();
                break block9;
            }
            v0 = (Intrinsics.areEqual(var2_2 = this.getTerm(), "xterm-kitty") != false ? true : Intrinsics.areEqual(var2_2, "alacritty")) != false;
        }
        if (v0) lbl-1000:
        // 2 sources

        {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final AnsiLevel ansiLevel(boolean interactive) {
        block78: {
            block75: {
                block76: {
                    block77: {
                        block74: {
                            var2_2 /* !! */  = this.forcedColor();
                            if (var2_2 /* !! */  != null) {
                                it = var2_2 /* !! */ ;
                                $i$a$-let-TerminalDetection$ansiLevel$1 = false;
                                return it;
                            }
                            if (this.isIntellijRunActionConsole() || this.isVsCodeTerminal()) {
                                return AnsiLevel.TRUECOLOR;
                            }
                            if (!interactive) {
                                return AnsiLevel.NONE;
                            }
                            if (this.isWindowsTerminal() || this.isDomTerm()) {
                                return AnsiLevel.TRUECOLOR;
                            }
                            if (this.isJediTerm()) {
                                return AnsiLevel.TRUECOLOR;
                            }
                            var2_2 /* !! */  = this.getColorTerm();
                            if (var2_2 /* !! */  == null) break block74;
                            switch (var2_2 /* !! */ .hashCode()) {
                                case 47822731: {
                                    if (!var2_2 /* !! */ .equals("24bit")) {
                                        break;
                                    }
                                    ** GOTO lbl27
                                }
                                case 1482504776: {
                                    if (!var2_2 /* !! */ .equals("24bits")) {
                                        break;
                                    }
                                    ** GOTO lbl27
                                }
                                case 1350697621: {
                                    if (!var2_2 /* !! */ .equals("truecolor")) break;
lbl27:
                                    // 3 sources

                                    return AnsiLevel.TRUECOLOR;
                                }
                            }
                        }
                        if (this.isCI()) {
                            return this.ciSupportsColor() != false ? AnsiLevel.ANSI256 : AnsiLevel.NONE;
                        }
                        var2_2 /* !! */  = this.getTermProgram();
                        if (var2_2 /* !! */  == null) break block75;
                        switch (var2_2 /* !! */ .hashCode()) {
                            case 1246525912: {
                                if (!var2_2 /* !! */ .equals("wezterm")) {
                                    ** break;
                                }
                                break block76;
                            }
                            case -1987176184: {
                                if (!var2_2 /* !! */ .equals("iterm.app")) {
                                    ** break;
                                }
                                break block77;
                            }
                            case 1015440833: {
                                if (var2_2 /* !! */ .equals("apple_terminal")) break;
                                ** break;
                            }
                            case 99761772: {
                                if (!var2_2 /* !! */ .equals("hyper")) ** break;
                                return AnsiLevel.TRUECOLOR;
                            }
                        }
                        return AnsiLevel.ANSI256;
                    }
                    return this.isRecentITerm() != false ? AnsiLevel.TRUECOLOR : AnsiLevel.ANSI256;
                }
                return AnsiLevel.TRUECOLOR;
            }
            if ((var3_7 = this.getTerm()) == null || (it = StringsKt.split$default((CharSequence)var3_7, (String[])(var5_6 = new String[]{"-"}), false, 0, 6, null)) == null) ** GOTO lbl-1000
            it = it;
            $i$a$-let-TerminalDetection$ansiLevel$2 = false;
            var5_6 = TuplesKt.to(CollectionsKt.firstOrNull(it), CollectionsKt.lastOrNull(it));
            if (var5_6 != null) {
                v0 = var5_6;
            } else lbl-1000:
            // 2 sources

            {
                v0 = TuplesKt.to(null, null);
            }
            var2_2 /* !! */  = v0;
            term = (String)var2_2 /* !! */ .component1();
            level = (String)var2_2 /* !! */ .component2();
            var5_6 = level;
            if (var5_6 == null) break block78;
            tmp = -1;
            switch (var5_6.hashCode()) {
                case -1619924752: {
                    if (var5_6.equals("256color")) {
                        tmp = 1;
                    }
                    break;
                }
                case 47822731: {
                    if (var5_6.equals("24bit")) {
                        tmp = 2;
                    }
                    break;
                }
                case 49747: {
                    if (var5_6.equals("256")) {
                        tmp = 1;
                    }
                    break;
                }
                case 1482504776: {
                    if (var5_6.equals("24bits")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1350697621: {
                    if (var5_6.equals("truecolor")) {
                        tmp = 2;
                    }
                    break;
                }
                case 1321940355: {
                    if (var5_6.equals("256colors")) {
                        tmp = 1;
                    }
                    break;
                }
                case -1331586071: {
                    if (var5_6.equals("direct")) {
                        tmp = 2;
                    }
                    break;
                }
            }
            switch (tmp) {
                case 1: {
                    return AnsiLevel.ANSI256;
                }
                case 2: {
                    return AnsiLevel.TRUECOLOR;
                }
            }
        }
        if ((var5_6 = term) == null) ** GOTO lbl-1000
        tmp = -1;
        switch (var5_6.hashCode()) {
            case 3515268: {
                if (var5_6.equals("rxvt")) {
                    tmp = 1;
                }
                break;
            }
            case -1345749109: {
                if (var5_6.equals("cygwin")) {
                    tmp = 2;
                }
                break;
            }
            case 94842723: {
                if (var5_6.equals("color")) {
                    tmp = 1;
                }
                break;
            }
            case 114378980: {
                if (var5_6.equals("xterm")) {
                    tmp = 1;
                }
                break;
            }
            case 112480882: {
                if (var5_6.equals("vt220")) {
                    tmp = 1;
                }
                break;
            }
            case 112479859: {
                if (var5_6.equals("vt100")) {
                    tmp = 1;
                }
                break;
            }
            case 102977780: {
                if (var5_6.equals("linux")) {
                    tmp = 1;
                }
                break;
            }
            case -538394785: {
                if (var5_6.equals("konsole")) {
                    tmp = 1;
                }
                break;
            }
            case -907689876: {
                if (var5_6.equals("screen")) {
                    tmp = 1;
                }
                break;
            }
            case 3095014: {
                if (var5_6.equals("dumb")) {
                    tmp = 3;
                }
                break;
            }
            case 3564252: {
                if (var5_6.equals("tmux")) {
                    tmp = 1;
                }
                break;
            }
            case 2999107: {
                if (var5_6.equals("ansi")) {
                    tmp = 1;
                }
                break;
            }
        }
        switch (tmp) {
            case 2: {
                v1 = AnsiLevel.TRUECOLOR;
                break;
            }
            case 1: {
                v1 = AnsiLevel.ANSI16;
                break;
            }
            case 3: {
                v1 = AnsiLevel.NONE;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v1 = AnsiLevel.NONE;
            }
        }
        return v1;
    }

    private final String getTerm() {
        String string;
        String string2 = MppImplKt.getEnv("TERM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string = null;
        }
        return string;
    }

    private final String getColorTerm() {
        String string;
        String string2 = MppImplKt.getEnv("COLORTERM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private final AnsiLevel forcedColor() {
        block22: {
            block24: {
                block26: {
                    block25: {
                        block23: {
                            block21: {
                                if (!Intrinsics.areEqual(this.getTerm(), "dumb")) break block21;
                                v0 = AnsiLevel.NONE;
                                break block22;
                            }
                            if (MppImplKt.getEnv("NO_COLOR") == null) break block23;
                            v0 = AnsiLevel.NONE;
                            break block22;
                        }
                        v1 = MppImplKt.getEnv("FORCE_COLOR");
                        if (v1 != null) {
                            v2 = v1.toLowerCase(Locale.ROOT);
                            v3 = v2;
                            Intrinsics.checkNotNullExpressionValue(v2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                        } else {
                            v3 = var1_1 = null;
                        }
                        if (var1_1 == null) break block24;
                        switch (var1_1.hashCode()) {
                            case 48: {
                                if (!var1_1.equals("0")) {
                                    ** break;
                                }
                                ** GOTO lbl57
                            }
                            case 0: {
                                if (var1_1.equals("")) break;
                                ** break;
                            }
                            case -2116143010: {
                                if (var1_1.equals("16color")) break;
                                ** break;
                            }
                            case 49: {
                                if (var1_1.equals("1")) break;
                                ** break;
                            }
                            case -1619924752: {
                                if (!var1_1.equals("256color")) {
                                    ** break;
                                }
                                break block25;
                            }
                            case 50: {
                                if (!var1_1.equals("2")) {
                                    ** break;
                                }
                                break block25;
                            }
                            case 51: {
                                if (!var1_1.equals("3")) {
                                    ** break;
                                }
                                break block26;
                            }
                            case 1350697621: {
                                if (!var1_1.equals("truecolor")) {
                                    ** break;
                                }
                                break block26;
                            }
                            case 97196323: {
                                if (!var1_1.equals("false")) {
                                    ** break;
                                }
                                ** GOTO lbl57
                            }
                            case 3569038: {
                                if (var1_1.equals("true")) break;
                                ** break;
                            }
                            case 3387192: {
                                if (!var1_1.equals("none")) ** break;
lbl57:
                                // 3 sources

                                v0 = AnsiLevel.NONE;
                                break block22;
                            }
                        }
                        v0 = AnsiLevel.ANSI16;
                        break block22;
                    }
                    v0 = AnsiLevel.ANSI256;
                    break block22;
                }
                v0 = AnsiLevel.TRUECOLOR;
                break block22;
            }
            v0 = null;
        }
        return v0;
    }

    private final String getTermProgram() {
        String string;
        String string2 = MppImplKt.getEnv("TERM_PROGRAM");
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        } else {
            string = null;
        }
        return string;
    }

    private final boolean isVsCodeTerminal() {
        return Intrinsics.areEqual(this.getTermProgram(), "vscode");
    }

    private final boolean isWindowsTerminal() {
        CharSequence charSequence = MppImplKt.getEnv("WT_SESSION");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isDomTerm() {
        CharSequence charSequence = MppImplKt.getEnv("DOMTERM");
        return !(charSequence == null || charSequence.length() == 0);
    }

    private final boolean isJediTerm() {
        return Intrinsics.areEqual(MppImplKt.getEnv("TERMINAL_EMULATOR"), "JetBrains-JediTerm");
    }

    private final boolean isRecentITerm() {
        String[] stringArray;
        Object object = MppImplKt.getEnv("TERM_PROGRAM_VERSION");
        Integer ver = object != null && (object = StringsKt.split$default((CharSequence)object, stringArray = new String[]{"."}, false, 0, 6, null)) != null && (object = (String)CollectionsKt.firstOrNull(object)) != null ? StringsKt.toIntOrNull((String)object) : null;
        return ver != null && ver >= 3;
    }

    private final boolean isCI() {
        return MppImplKt.getEnv("CI") != null;
    }

    private final boolean ciSupportsColor() {
        boolean bl;
        block3: {
            String[] stringArray = new String[]{"APPVEYOR", "BUILDKITE", "CIRCLECI", "DRONE", "GITHUB_ACTIONS", "GITLAB_CI", "TRAVIS"};
            Iterable $this$any$iv = CollectionsKt.listOf(stringArray);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!(MppImplKt.getEnv(it) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isIntellijRunActionConsole() {
        return !this.isJediTerm() && MppImplKt.runningInIdeaJavaAgent();
    }
}

