/* Copyright (C) 2019-2025 Greenbone AG
 *
 * SPDX-License-Identifier: AGPL-3.0-or-later
 */

#ifndef _GVMD_MANAGE_SQL_ALERTS_H
#define _GVMD_MANAGE_SQL_ALERTS_H

#include "manage_alerts.h"

/**
 * @brief Filter columns for alert iterator.
 */
#define ALERT_ITERATOR_FILTER_COLUMNS                                         \
 { GET_ITERATOR_FILTER_COLUMNS, "event", "condition", "method",               \
   "filter",  NULL }

/**
 * @brief Alert iterator columns.
 */
#define ALERT_ITERATOR_COLUMNS                                                \
 {                                                                            \
   GET_ITERATOR_COLUMNS (alerts),                                             \
   { "event", NULL, KEYWORD_TYPE_INTEGER },                                   \
   { "condition", NULL, KEYWORD_TYPE_INTEGER },                               \
   { "method", NULL, KEYWORD_TYPE_INTEGER },                                  \
   { "filter", NULL, KEYWORD_TYPE_INTEGER },                                  \
   { G_STRINGIFY (LOCATION_TABLE), NULL, KEYWORD_TYPE_INTEGER },              \
   { "active", NULL, KEYWORD_TYPE_INTEGER },                                  \
   { NULL, NULL, KEYWORD_TYPE_UNKNOWN }                                       \
 }

/**
 * @brief Alert iterator columns for trash case.
 */
#define ALERT_ITERATOR_TRASH_COLUMNS                                          \
 {                                                                            \
   GET_ITERATOR_COLUMNS (alerts_trash),                                       \
   { "event", NULL, KEYWORD_TYPE_INTEGER },                                   \
   { "condition", NULL, KEYWORD_TYPE_INTEGER },                               \
   { "method", NULL, KEYWORD_TYPE_INTEGER },                                  \
   { "filter", NULL, KEYWORD_TYPE_STRING },                                   \
   { "filter_location", NULL, KEYWORD_TYPE_INTEGER},                          \
   { "active", NULL, KEYWORD_TYPE_INTEGER },                                  \
   { NULL, NULL, KEYWORD_TYPE_UNKNOWN }                                       \
 }

user_t
alert_owner (alert_t);

char *
alert_owner_uuid (alert_t);

char*
alert_owner_name (alert_t);

char *
alert_name (alert_t);

char *
alert_filter_id (alert_t);

event_t
alert_event (alert_t);

char *
alert_data (alert_t, const char *, const char *);

int
alert_applies_to_task (alert_t, task_t);

gchar *
alert_smb_file_path (alert_t, task_t);

void
init_alert_vfire_call_iterator (iterator_t *, alert_t);

const char*
alert_vfire_call_iterator_name (iterator_t *);

const char*
alert_vfire_call_iterator_value (iterator_t *);

gchar *
new_secinfo_list (event_t, const void *, alert_t, int *);

gchar *
new_secinfo_message (event_t, const void *, alert_t);

#endif /* not _GVMD_MANAGE_SQL_ALERTS_H */
