#pragma once
/*
 *  $Id: value-format.h 28507 2025-09-04 17:07:29Z yeti-dn $
 *  Copyright (C) 2016-2025 David Necas (Yeti).
 *  E-mail: yeti@gwyddion.net.
 *
 *  This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any
 *  later version.
 *
 *  This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 *  details.
 *
 *  You should have received a copy of the GNU General Public License along with this program; if not, write to the
 *  Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __GWY_VALUE_FORMAT_H__
#define __GWY_VALUE_FORMAT_H__

#include <glib-object.h>
#include <libgwyddion/macros.h>

G_BEGIN_DECLS

#define GWY_TYPE_VALUE_FORMAT (gwy_value_format_get_type())

typedef struct {
    /*<public>*/
    gdouble magnitude;
    gint precision;
    gchar *units;
    /*<private>*/
    GString *units_gstring;
} GwyValueFormat;

GType           gwy_value_format_get_type (void)                    G_GNUC_CONST;
GwyValueFormat* gwy_value_format_new      (gdouble magnitude,
                                           gint precision,
                                           const gchar *units)      G_GNUC_MALLOC;
GwyValueFormat* gwy_value_format_copy     (GwyValueFormat *format)  G_GNUC_MALLOC;
void            gwy_value_format_free     (GwyValueFormat *format);
void            gwy_value_format_assign   (GwyValueFormat *format,
                                           GwyValueFormat *source);
void            gwy_value_format_set_units(GwyValueFormat *format,
                                           const gchar *units);

G_END_DECLS

#endif

/* vim: set cin columns=120 tw=118 et ts=4 sw=4 cino=>1s,e0,n0,f0,{0,}0,^0,\:1s,=0,g1s,h0,t0,+1s,c3,(0,u0 : */
