---
title: Affinity Team Captains
---

**This guide is for affinity team captains.** These special people are **team maintainers** of one of our [affinity teams][] and help triage and evaluate the issues and contributions of others. You may find what is written here interesting, but it’s definitely not for everyone.
{: .note .info}

## Affinity teams & their captains

The Jekyll project uses [affinity teams][] to help break up the work of incoming issues and pull requests from community members. We receive a sizeable number of issues and pull requests each week; the use of affinity teams helps distribute this load across a number of specialized groups instead of pushing it all onto @jekyll/core.

## Responsibilities of Team Captains

Each affinity team has a few captains who manage the issues and pull requests for that team. When an issue or PR is opened with a `/cc` for a given affinity team, @jekyllbot automatically assigns a random affinity team captain to the issue to triage it. They have access to add labels, reassign the issue, give LGTM's, and so forth. While they do not merge PR's today, they are still asked to review PR's for parts of the codebase under their purview.

## How do I become a team captain?

Just ask! Feel free to open an issue on `jekyll/jekyll` and add `/cc @jekyll/core`. We can add you. :smile:

Alternatively, you can email or otherwise reach out to [@oe](https://github.com/oe) directly if you prefer the more private route.

## Ugh, I'm tired and don't have time to be a captain anymore. What now?

No sweat at all! Email [@oe](https://github.com/oe) and ask to be removed. Alternatively, you should be able to go to your team's page on GitHub.com (go to https://github.com/jekyll, click "Teams", click the link to your team) and change your status to either "member" or leave the team.

We realize that being a captain is no easy feat so we want to make it a great experience. As always, communicate as much as you can with us about what is working, and what isn't. Thanks for dedicating some time to Jekyll! :sparkles:

[affinity teams]: https://teams.jekyllrb.com/
