/* SPDX-License-Identifier: GPL-2.0-or-later */
/* This file was generated by: ./scripts/crypto/gen-hash-testvecs.py blake2b */

static const struct {
	size_t data_len;
	u8 digest[BLAKE2B_HASH_SIZE];
} hash_testvecs[] = {
	{
		.data_len = 0,
		.digest = {
			0x78, 0x6a, 0x02, 0xf7, 0x42, 0x01, 0x59, 0x03,
			0xc6, 0xc6, 0xfd, 0x85, 0x25, 0x52, 0xd2, 0x72,
			0x91, 0x2f, 0x47, 0x40, 0xe1, 0x58, 0x47, 0x61,
			0x8a, 0x86, 0xe2, 0x17, 0xf7, 0x1f, 0x54, 0x19,
			0xd2, 0x5e, 0x10, 0x31, 0xaf, 0xee, 0x58, 0x53,
			0x13, 0x89, 0x64, 0x44, 0x93, 0x4e, 0xb0, 0x4b,
			0x90, 0x3a, 0x68, 0x5b, 0x14, 0x48, 0xb7, 0x55,
			0xd5, 0x6f, 0x70, 0x1a, 0xfe, 0x9b, 0xe2, 0xce,
		},
	},
	{
		.data_len = 1,
		.digest = {
			0x6f, 0x2e, 0xcc, 0x83, 0x53, 0xa3, 0x20, 0x16,
			0x5b, 0xda, 0xd0, 0x04, 0xd3, 0xcb, 0xe4, 0x37,
			0x5b, 0xf0, 0x84, 0x36, 0xe1, 0xad, 0x45, 0xcc,
			0x4d, 0x7f, 0x09, 0x68, 0xb2, 0x62, 0x93, 0x7f,
			0x72, 0x32, 0xe8, 0xa7, 0x2f, 0x1f, 0x6f, 0xc6,
			0x14, 0xd6, 0x70, 0xae, 0x0c, 0xf0, 0xf3, 0xce,
			0x64, 0x4d, 0x22, 0xdf, 0xc7, 0xa7, 0xf8, 0xa8,
			0x18, 0x23, 0xd8, 0x6c, 0xaf, 0x65, 0xa2, 0x54,
		},
	},
	{
		.data_len = 2,
		.digest = {
			0x04, 0x13, 0xe2, 0x10, 0xbe, 0x65, 0xde, 0xce,
			0x61, 0xa8, 0xe0, 0xd6, 0x35, 0xb1, 0xb8, 0x88,
			0xd2, 0xea, 0x45, 0x3a, 0xe1, 0x8d, 0x94, 0xb5,
			0x66, 0x06, 0x98, 0x96, 0x39, 0xf8, 0x0e, 0xcb,
			0x34, 0xa6, 0xa8, 0x17, 0xfe, 0x56, 0xbc, 0xa9,
			0x5e, 0x1b, 0xb1, 0xde, 0x3c, 0xc7, 0x78, 0x4f,
			0x39, 0xc6, 0xfc, 0xa8, 0xb3, 0x27, 0x66, 0x3e,
			0x4e, 0xb5, 0x5d, 0x08, 0x89, 0xee, 0xd1, 0xe0,
		},
	},
	{
		.data_len = 3,
		.digest = {
			0x2b, 0x4a, 0xa3, 0x4e, 0x2b, 0x7a, 0x47, 0x20,
			0x30, 0x5b, 0x09, 0x17, 0x3a, 0xf4, 0xcc, 0xf0,
			0xf7, 0x7b, 0x97, 0x68, 0x98, 0x9f, 0x4f, 0x09,
			0x46, 0x25, 0xe7, 0xd6, 0x53, 0x6b, 0xf9, 0x68,
			0x48, 0x12, 0x44, 0x8c, 0x9a, 0xc8, 0xd4, 0x42,
			0xeb, 0x2c, 0x5f, 0x41, 0xba, 0x17, 0xd0, 0xc3,
			0xad, 0xfd, 0xfb, 0x42, 0x33, 0xcb, 0x08, 0x5d,
			0xd2, 0x5c, 0x3d, 0xde, 0x87, 0x4d, 0xd6, 0xe4,
		},
	},
	{
		.data_len = 16,
		.digest = {
			0xbf, 0x40, 0xf2, 0x38, 0x44, 0x8e, 0x24, 0x5e,
			0xbc, 0x67, 0xbb, 0xf0, 0x10, 0x9a, 0x79, 0xbb,
			0x36, 0x55, 0xce, 0xd2, 0xba, 0x04, 0x0d, 0xe8,
			0x30, 0x29, 0x5c, 0x2a, 0xa6, 0x3a, 0x4f, 0x37,
			0xac, 0x5f, 0xd4, 0x13, 0xa2, 0xf4, 0xfe, 0x80,
			0x61, 0xd7, 0x58, 0x66, 0x0c, 0x7f, 0xa2, 0x56,
			0x6b, 0x52, 0x7c, 0x22, 0x73, 0x7f, 0x17, 0xaa,
			0x91, 0x5a, 0x22, 0x06, 0xd9, 0x00, 0x48, 0x12,
		},
	},
	{
		.data_len = 32,
		.digest = {
			0x41, 0x04, 0x65, 0x93, 0x81, 0x9a, 0x20, 0x0a,
			0x00, 0x60, 0x00, 0x64, 0x4c, 0x04, 0x3d, 0xe0,
			0x6b, 0x17, 0x0c, 0xe1, 0x0e, 0x28, 0x8b, 0xa0,
			0x76, 0xd2, 0x79, 0xb0, 0x33, 0x60, 0x61, 0x27,
			0xf2, 0x64, 0xf1, 0x8a, 0xe5, 0x3e, 0xaa, 0x37,
			0x60, 0xad, 0x2d, 0x75, 0x13, 0xae, 0xd8, 0x9e,
			0xec, 0xe0, 0xe4, 0x40, 0x2f, 0x59, 0x44, 0xb0,
			0x66, 0x7a, 0x68, 0x38, 0xce, 0x21, 0x99, 0x2a,
		},
	},
	{
		.data_len = 48,
		.digest = {
			0x19, 0x6f, 0x9d, 0xc7, 0x87, 0x12, 0x5c, 0xa3,
			0xe2, 0xd3, 0xf1, 0x82, 0xec, 0xf3, 0x55, 0x9c,
			0x86, 0xd1, 0x6d, 0xde, 0xcf, 0x5b, 0xec, 0x4c,
			0x43, 0x25, 0x85, 0x90, 0xef, 0xe8, 0xe3, 0x5f,
			0x2c, 0x3a, 0x84, 0x07, 0xb8, 0x55, 0xfd, 0x5e,
			0xa4, 0x45, 0xf2, 0xac, 0xe4, 0xbd, 0xc7, 0x96,
			0x80, 0x59, 0x3e, 0xc9, 0xb1, 0x60, 0xb1, 0x2b,
			0x17, 0x49, 0x7d, 0x3e, 0x7d, 0x4d, 0x70, 0x24,
		},
	},
	{
		.data_len = 49,
		.digest = {
			0x73, 0x72, 0xd5, 0x0a, 0x97, 0xb4, 0x7d, 0xdb,
			0x05, 0x14, 0x8e, 0x40, 0xc2, 0x9a, 0x8a, 0x74,
			0x4b, 0xda, 0x7e, 0xfc, 0x97, 0x57, 0x23, 0x39,
			0xdc, 0x57, 0x09, 0x13, 0x24, 0xfc, 0xf3, 0x23,
			0x55, 0x48, 0xdd, 0xe5, 0x07, 0x9a, 0x6f, 0x7b,
			0x62, 0xea, 0x4d, 0x79, 0xb4, 0xb9, 0xc5, 0x86,
			0xc0, 0x34, 0xd6, 0xd2, 0x6c, 0xc3, 0x94, 0xfb,
			0x34, 0xd6, 0x62, 0xae, 0xb8, 0x99, 0xf1, 0x38,
		},
	},
	{
		.data_len = 63,
		.digest = {
			0x42, 0x3a, 0xe3, 0xa2, 0xae, 0x5a, 0x28, 0xce,
			0xf1, 0x3c, 0x97, 0xc2, 0x34, 0xf6, 0xb5, 0x1e,
			0xfc, 0x31, 0xb4, 0x04, 0x61, 0xb7, 0x54, 0x0b,
			0x0d, 0x1a, 0x22, 0x9c, 0x04, 0x67, 0x5c, 0x4c,
			0x75, 0x1b, 0x10, 0x0b, 0x99, 0xe2, 0xb1, 0x5e,
			0x5d, 0x4b, 0x7a, 0xe6, 0xf6, 0xb5, 0x62, 0xee,
			0x2d, 0x44, 0x57, 0xb2, 0x96, 0x73, 0x5e, 0xb9,
			0x6a, 0xb2, 0xb3, 0x16, 0xa3, 0xd9, 0x6a, 0x60,
		},
	},
	{
		.data_len = 64,
		.digest = {
			0x50, 0xb9, 0xbe, 0xb2, 0x69, 0x07, 0x45, 0x5b,
			0x59, 0xde, 0x8d, 0xbf, 0x08, 0xdc, 0x2e, 0x7f,
			0x93, 0x29, 0xc1, 0x91, 0xe8, 0x74, 0x03, 0x89,
			0x20, 0xfb, 0xb2, 0x4b, 0xe8, 0x68, 0x6f, 0xe1,
			0xb4, 0x30, 0xbe, 0x11, 0x3c, 0x43, 0x19, 0x66,
			0x72, 0x78, 0xb7, 0xf4, 0xe9, 0x09, 0x18, 0x4e,
			0xae, 0x4a, 0x24, 0xe0, 0x6f, 0x44, 0x02, 0xe3,
			0xfd, 0xda, 0xb3, 0x3e, 0x3c, 0x6d, 0x54, 0x2e,
		},
	},
	{
		.data_len = 65,
		.digest = {
			0xd6, 0xf2, 0xa9, 0x61, 0x3f, 0xce, 0x2a, 0x68,
			0x19, 0x86, 0xff, 0xd1, 0xee, 0x89, 0x3b, 0xa4,
			0x10, 0x9a, 0x91, 0x50, 0x35, 0x48, 0x9e, 0xf5,
			0x9c, 0x95, 0xe0, 0xfb, 0x92, 0x0f, 0xa8, 0xf7,
			0x6c, 0x43, 0x85, 0xf1, 0x6e, 0x11, 0x4e, 0x67,
			0x78, 0xd7, 0x53, 0x25, 0x0c, 0xf8, 0xce, 0x38,
			0x74, 0x08, 0xb0, 0x3c, 0x53, 0x20, 0x4d, 0xc4,
			0x9a, 0xf5, 0x78, 0xe8, 0x41, 0x8f, 0xed, 0x1f,
		},
	},
	{
		.data_len = 127,
		.digest = {
			0xe8, 0xb2, 0xc5, 0xa7, 0xf5, 0xfa, 0xee, 0xa0,
			0x57, 0xba, 0x58, 0xf9, 0x0a, 0xf2, 0x64, 0x16,
			0xa8, 0xa6, 0x03, 0x85, 0x3b, 0xb8, 0x6f, 0xca,
			0x76, 0xc3, 0xa1, 0x2b, 0xec, 0xef, 0xc4, 0x66,
			0x11, 0xdf, 0x03, 0x85, 0x9d, 0x0c, 0x37, 0x7b,
			0xa9, 0x7b, 0x44, 0xfb, 0x11, 0x8f, 0x3f, 0x71,
			0xcd, 0x81, 0x43, 0x2e, 0x71, 0x5c, 0x54, 0x9f,
			0xca, 0x0f, 0x01, 0x91, 0xca, 0xaa, 0x93, 0xe9,
		},
	},
	{
		.data_len = 128,
		.digest = {
			0x05, 0x8e, 0x9d, 0xdc, 0xe9, 0x36, 0x3e, 0x73,
			0x63, 0x59, 0x69, 0x81, 0x0b, 0x8c, 0xc7, 0x9e,
			0xcc, 0xe7, 0x9c, 0x19, 0x54, 0xa7, 0x2f, 0x86,
			0xb5, 0xea, 0xae, 0x6d, 0xfe, 0x4e, 0x6e, 0x83,
			0x8d, 0x1a, 0x1c, 0x70, 0x3f, 0x34, 0xa1, 0x04,
			0x59, 0xd1, 0xbb, 0xaa, 0x58, 0xf7, 0xce, 0xfb,
			0x86, 0x66, 0x22, 0xfc, 0x78, 0x74, 0x6e, 0x85,
			0xf1, 0x59, 0x7d, 0x9e, 0x1c, 0x3b, 0xc6, 0x65,
		},
	},
	{
		.data_len = 129,
		.digest = {
			0x6b, 0x1f, 0x7c, 0x9a, 0x65, 0x7f, 0x09, 0x61,
			0xe5, 0x04, 0x9a, 0xf1, 0x4b, 0x36, 0x8e, 0x41,
			0x86, 0xcf, 0x86, 0x19, 0xd8, 0xc9, 0x34, 0x70,
			0x67, 0xd1, 0x03, 0x72, 0x12, 0xf7, 0x27, 0x92,
			0x2e, 0x3d, 0x2b, 0x54, 0x9a, 0x48, 0xa4, 0xc2,
			0x61, 0xea, 0x6a, 0xe8, 0xdd, 0x07, 0x41, 0x85,
			0x58, 0x6d, 0xcd, 0x12, 0x0d, 0xbc, 0xb1, 0x23,
			0xb2, 0xdb, 0x24, 0x1f, 0xc4, 0xa7, 0xae, 0xda,
		},
	},
	{
		.data_len = 256,
		.digest = {
			0x50, 0xd8, 0xdc, 0xb2, 0x50, 0x24, 0x7a, 0x49,
			0xb1, 0x00, 0x73, 0x16, 0x1f, 0xce, 0xf9, 0xe8,
			0x77, 0x0a, 0x27, 0x74, 0xc7, 0xeb, 0xf0, 0x62,
			0xb9, 0xf3, 0x24, 0xa6, 0x03, 0x18, 0x40, 0xde,
			0x9b, 0x1d, 0xa8, 0xd0, 0xbf, 0x66, 0xa3, 0xc1,
			0x31, 0x04, 0x95, 0xc7, 0xc3, 0xb7, 0x11, 0xe2,
			0x1e, 0x31, 0x49, 0x98, 0x06, 0xab, 0xf0, 0xe6,
			0x5c, 0xac, 0x88, 0x28, 0x0b, 0x3d, 0xb2, 0xc2,
		},
	},
	{
		.data_len = 511,
		.digest = {
			0xd4, 0x2b, 0x6b, 0x9e, 0xfc, 0x44, 0xc0, 0x90,
			0x64, 0x77, 0x5d, 0xf3, 0x44, 0xb6, 0x92, 0x8f,
			0x80, 0xe2, 0xe4, 0x9b, 0xaf, 0x49, 0x04, 0xea,
			0x29, 0xf7, 0x4a, 0x33, 0x3f, 0xc7, 0x3b, 0xab,
			0xa1, 0x71, 0x7f, 0xa2, 0x8e, 0x03, 0xa0, 0xd6,
			0xa7, 0xcd, 0xe0, 0xf8, 0xd7, 0x3b, 0xa4, 0x0d,
			0x84, 0x79, 0x12, 0x72, 0x3f, 0x8e, 0x48, 0x35,
			0x76, 0x4f, 0x56, 0xe9, 0x21, 0x40, 0x19, 0xbe,
		},
	},
	{
		.data_len = 513,
		.digest = {
			0x84, 0xd4, 0xd8, 0x6c, 0x60, 0x3d, 0x6e, 0xfd,
			0x84, 0xb7, 0xdf, 0xba, 0x13, 0x5e, 0x07, 0x94,
			0x5b, 0x6b, 0x62, 0x1d, 0x82, 0x02, 0xa7, 0xb3,
			0x21, 0xdf, 0x42, 0x20, 0x85, 0xa8, 0x6f, 0x30,
			0xf7, 0x03, 0xba, 0x66, 0x0e, 0xa6, 0x42, 0x21,
			0x37, 0xe8, 0xed, 0x5b, 0x22, 0xf5, 0x4e, 0xa5,
			0xe5, 0x80, 0x1b, 0x47, 0xf0, 0x49, 0xb3, 0xe5,
			0x6e, 0xd9, 0xd9, 0x95, 0x3d, 0x2e, 0x42, 0x13,
		},
	},
	{
		.data_len = 1000,
		.digest = {
			0x71, 0x17, 0xab, 0x93, 0xfe, 0x3b, 0xa4, 0xe6,
			0xcb, 0xb0, 0xea, 0x95, 0xe7, 0x1a, 0x01, 0xc0,
			0x12, 0x33, 0xfe, 0xcc, 0x79, 0x15, 0xae, 0x56,
			0xd2, 0x70, 0x44, 0x60, 0x54, 0x42, 0xa8, 0x69,
			0x7e, 0xc3, 0x90, 0xa0, 0x0c, 0x63, 0x39, 0xff,
			0x55, 0x53, 0xb8, 0x46, 0xef, 0x06, 0xcb, 0xba,
			0x73, 0xf4, 0x76, 0x22, 0xf1, 0x60, 0x98, 0xbc,
			0xbf, 0x76, 0x95, 0x85, 0x13, 0x1d, 0x11, 0x3b,
		},
	},
	{
		.data_len = 3333,
		.digest = {
			0x3a, 0xaa, 0x85, 0xa0, 0x8c, 0x8e, 0xe1, 0x9c,
			0x9b, 0x43, 0x72, 0x7f, 0x40, 0x88, 0x3b, 0xd1,
			0xc4, 0xd8, 0x2b, 0x69, 0xa6, 0x74, 0x47, 0x69,
			0x5f, 0x7d, 0xab, 0x75, 0xa9, 0xf9, 0x88, 0x54,
			0xce, 0x57, 0xcc, 0x9d, 0xac, 0x13, 0x91, 0xdb,
			0x6d, 0x5c, 0xd8, 0xf4, 0x35, 0xc9, 0x30, 0xf0,
			0x4b, 0x91, 0x25, 0xab, 0x92, 0xa8, 0xc8, 0x6f,
			0xa0, 0xeb, 0x71, 0x56, 0x95, 0xab, 0xfd, 0xd7,
		},
	},
	{
		.data_len = 4096,
		.digest = {
			0xe1, 0xe9, 0xbe, 0x6c, 0x96, 0xe2, 0xe8, 0xa6,
			0x53, 0xcd, 0x79, 0x77, 0x57, 0x51, 0x2f, 0xb2,
			0x9f, 0xfc, 0x09, 0xaa, 0x2c, 0xbc, 0x6c, 0x5f,
			0xb0, 0xf2, 0x12, 0x39, 0x54, 0xd7, 0x27, 0xf8,
			0x33, 0x5d, 0xd4, 0x8a, 0xca, 0xd8, 0x2e, 0xbb,
			0x02, 0x82, 0xca, 0x1b, 0x54, 0xfa, 0xd6, 0xf4,
			0x49, 0x63, 0xfc, 0xc8, 0x73, 0xd4, 0x26, 0x8d,
			0x4f, 0x1c, 0x56, 0xa7, 0xf4, 0x58, 0x6f, 0x51,
		},
	},
	{
		.data_len = 4128,
		.digest = {
			0xf2, 0xf6, 0xe1, 0x16, 0x98, 0x69, 0x74, 0x5f,
			0x6c, 0xc4, 0x9d, 0x34, 0xa2, 0x84, 0x5d, 0x47,
			0xac, 0x39, 0xe0, 0x14, 0x2d, 0x78, 0xfa, 0x27,
			0xd5, 0x18, 0xaf, 0x26, 0x89, 0xa4, 0x69, 0xd3,
			0x56, 0xde, 0xfe, 0x4b, 0x9f, 0x0c, 0x9d, 0x5a,
			0x9a, 0x73, 0x3e, 0x3c, 0x76, 0x4b, 0x96, 0xca,
			0x49, 0xda, 0x05, 0x8c, 0x53, 0xbb, 0x85, 0x89,
			0x60, 0xc7, 0xe0, 0xb3, 0x51, 0x18, 0xd2, 0xd2,
		},
	},
	{
		.data_len = 4160,
		.digest = {
			0xfc, 0x5c, 0xcf, 0xbf, 0x29, 0xe3, 0x01, 0xef,
			0x4b, 0x40, 0x70, 0x01, 0xca, 0x4d, 0x46, 0xce,
			0xa9, 0x95, 0x5d, 0xb4, 0xf1, 0x79, 0x29, 0xdb,
			0xac, 0x32, 0x3d, 0xd9, 0x60, 0x9e, 0x6b, 0xb8,
			0x28, 0x62, 0xb7, 0x4a, 0xbb, 0x33, 0xb9, 0xd0,
			0x83, 0xe0, 0xd7, 0x5a, 0x2d, 0x01, 0x4c, 0x61,
			0x9e, 0x7d, 0x2d, 0x2d, 0x60, 0x29, 0x5e, 0x60,
			0x10, 0xb7, 0x41, 0x00, 0x3f, 0xe5, 0xf7, 0x52,
		},
	},
	{
		.data_len = 4224,
		.digest = {
			0xf8, 0xe5, 0x4b, 0xe5, 0x89, 0xf9, 0x1b, 0x43,
			0xbb, 0x65, 0x3d, 0xa0, 0xb4, 0xdc, 0x04, 0x26,
			0x68, 0x15, 0xae, 0x4d, 0xd6, 0x03, 0xb7, 0x27,
			0x06, 0x8c, 0x2a, 0x82, 0x51, 0x96, 0xbf, 0x83,
			0x38, 0x96, 0x21, 0x8a, 0xd9, 0xf9, 0x4e, 0x38,
			0xc6, 0xb3, 0xbd, 0xfe, 0xd3, 0x49, 0x90, 0xbc,
			0xa1, 0x77, 0xd0, 0xa0, 0x3c, 0x2b, 0x4e, 0x10,
			0x34, 0xc3, 0x17, 0x85, 0x3d, 0xec, 0xa8, 0x05,
		},
	},
	{
		.data_len = 16384,
		.digest = {
			0x38, 0x56, 0xaf, 0x83, 0x68, 0x9c, 0xba, 0xe3,
			0xec, 0x51, 0xf5, 0xf4, 0x93, 0x48, 0x1d, 0xe6,
			0xad, 0xa8, 0x8c, 0x70, 0x2a, 0xd9, 0xaa, 0x43,
			0x04, 0x40, 0x95, 0xc1, 0xe6, 0x8a, 0xf5, 0x01,
			0x6b, 0x79, 0xd9, 0xb4, 0xd0, 0x1d, 0x93, 0x26,
			0xfe, 0xf5, 0x07, 0x57, 0xda, 0x08, 0x0a, 0x82,
			0xc9, 0x17, 0x13, 0x5b, 0x9e, 0x11, 0x96, 0xa5,
			0xd0, 0x92, 0xcd, 0xf1, 0xa3, 0x5b, 0x43, 0x21,
		},
	},
};

static const u8 hash_testvec_consolidated[BLAKE2B_HASH_SIZE] = {
	0xa4, 0xf8, 0xf6, 0xa1, 0x36, 0x89, 0xc0, 0x2a,
	0xc3, 0x42, 0x32, 0x71, 0xe5, 0xea, 0x14, 0x77,
	0xf3, 0x99, 0x91, 0x87, 0x49, 0xc2, 0x8d, 0xa5,
	0x2f, 0xed, 0x01, 0x35, 0x39, 0x64, 0x09, 0x25,
	0xe3, 0xa8, 0x50, 0x97, 0x35, 0x8b, 0xf5, 0x19,
	0x1e, 0xd5, 0x9f, 0x03, 0x0b, 0x65, 0x55, 0x0e,
	0xa0, 0xb7, 0xda, 0x18, 0x7b, 0x7f, 0x88, 0x55,
	0x1f, 0xdb, 0x82, 0x6b, 0x98, 0x90, 0x1c, 0xdd,
};

static const u8 blake2b_keyed_testvec_consolidated[BLAKE2B_HASH_SIZE] = {
	0x2b, 0x89, 0x36, 0x3a, 0x36, 0xe4, 0x18, 0x38,
	0xc4, 0x5b, 0x5c, 0xa5, 0x9a, 0xed, 0xf2, 0xee,
	0x5a, 0xb6, 0x82, 0x6c, 0x63, 0xf2, 0x29, 0x57,
	0xc7, 0xd5, 0x32, 0x27, 0xba, 0x88, 0xb1, 0xab,
	0xf2, 0x2a, 0xc1, 0xea, 0xf3, 0x91, 0x89, 0x66,
	0x47, 0x1e, 0x5b, 0xc6, 0x98, 0x12, 0xe9, 0x25,
	0xbf, 0x72, 0xd2, 0x3f, 0x88, 0x97, 0x17, 0x51,
	0xed, 0x96, 0xfb, 0xe9, 0xca, 0x52, 0x42, 0xc9,
};
