# File sys/Formula.cpp.praat
# Generated by test/createPraatTests.praat

#
# result = x + y
#
x = 5
y = 6
result = x + y
assert result = 11

#
# result# = x + owned y#
#
result# = 5 + { 11, 13, 31 }   ; numeric vector literals are owned
assert result# = { 16, 18, 36 }

#
# result# = x + unowned y#
#
y# = { 17, -11, 29 }
result# = 30 + y#   ; numeric vector variables are not owned
assert result# = { 47, 19, 59 }

#
# Error: unequal sizes.
#
x# = { 11, 13, 17 }
y# = { 8, 90 }
asserterror When adding vectors, their numbers of elements should be equal, instead of 3 and 2.
result# = x# + y#

#
# result# = owned x# + y#
#
result# = { 11, 13, 17 } + { 44, 56, 67 }   ; owned + owned
assert result# = { 55, 69, 84 }
y# = { 3, 2, 89.5 }
result# = { 11, 13, 17 } + y#   ; owned + unowned
assert result# = { 14, 15, 106.5 }

#
# result# = unowned x# + owned y#
#
x# = { 14, -3, 6.25 }
result# = x# + { 55, 1, -89 }
assert result# = { 69, -2, -82.75 }

#
# result# = unowned x# + unowned y#
#
x# = { 14, -33, 6.25 }
y# = { -33, 17, 9 }
result# = x# + y#
assert result# = { -19, -16, 15.25 }

assert { 1, 2, 3 } + { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 2, 3 }, { 5, 6 }, { 8, 9 } }

a# = { 1, 2, 3 }
assert a# + { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 2, 3 }, { 5, 6 }, { 8, 9 } }

#
# result## = owned x## + y#
#
y# = { -5, 6, -19 }
result## = { { 14, -33, 6.25 }, { -33, 17, 9 } } + y#
assert result## = { { 9, -27, -12.75 }, { -38, 23, -10 } }

#
# result## = unowned x## + y#
#
x## = { { 14, -33, 6.25 }, { -33, 17, 9 } }
y# = { -5, 6, -19 }
result## = x## + y#
assert result## = { { 9, -27, -12.75 }, { -38, 23, -10 } }

#
# result = x - y
#
x = 5
y = 6
result = x - y
assert result = -1

#
# result# = x - owned y#
#
result# = 5 - { 11, 13, 31 }   ; numeric vector literals are owned
assert result# = { -6, -8, -26 }

#
# result# = x - unowned y#
#
y# = { 17, -11, 29 }
result# = 30 - y#   ; numeric vector variables are not owned
assert result# = { 13, 41, 1 }

#
# Error: unequal sizes.
#
x# = { 11, 13, 17 }
y# = { 8, 90 }
asserterror When subtracting vectors, their numbers of elements should be equal, instead of 3 and 2.
result# = x# - y#

#
# result# = owned x# - y#
#
result# = { 11, 13, 17 } - { 44, 56, 67 }   ; owned + owned
assert result# = { -33, -43, -50 }
y# = { 3, 2, 89.5 }
result# = { 11, 13, 17 } - y#   ; owned + unowned
assert result# = { 8, 11, -72.5 }

#
# result# = unowned x# + owned y#
#
x# = { 14, -3, 6.25 }
result# = x# + { 55, 1, -89 }
assert result# = { 69, -2, -82.75 }

#
# result# = unowned x# + unowned y#
#
x# = { 14, -33, 6.25 }
y# = { -33, 17, 9 }
result# = x# - y#
assert result# = { 47, -50, -2.75 }

assert { 1, 2, 3 } - { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 0, -1 }, { -1, -2 }, { -2, -3 } }

a# = { 1, 2, 3 }
assert a# - { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 0, -1 }, { -1, -2 }, { -2, -3 } }

#
# result## = owned x## - y#
#
y# = { -5, 6, -19 }
result## = { { 14, -33, 6.25 }, { -33, 17, 9 } } - y#
assert result## = { { 19, -39, 25.25 }, { -28, 11, 28 } }

#
# result## = unowned x## - y#
#
x## = { { 14, -33, 6.25 }, { -33, 17, 9 } }
y# = { -5, 6, -19 }
result## = x## - y#
assert result## = { { 19, -39, 25.25 }, { -28, 11, 28 } }

#
# result = x * y
#
x = 5
y = 6
result = x * y
assert result = 30

#
# result# = x * owned y#
#
result# = 5 * { 11, 13, 31 }   ; numeric vector literals are owned
assert result# = { 55, 65, 155 }

#
# result# = x * unowned y#
#
y# = { 17, -11, 29 }
result# = 30 * y#   ; numeric vector variables are not owned
assert result# = { 510, -330, 870 }

#
# Error: unequal sizes.
#
x# = { 11, 13, 17 }
y# = { 8, 90 }
asserterror When multiplying vectors, their numbers of elements should be equal, instead of 3 and 2.
result# = x# * y#

#
# result# = owned x# * y#
#
result# = { 11, 13, 17 } * { 44, 56, 67 }   ; owned * owned
assert result# = { 484, 728, 1139 }
y# = { 3, 2, 89.5 }
result# = { 11, 13, 17 } * y#   ; owned * unowned
assert result# = { 33, 26, 1521.5 }

#
# result# = unowned x# * owned y#
#
x# = { 14, -3, 6.25 }
result# = x# * { 55, 1, -89 }
assert result# = { 770, -3, -556.25 }

#
# result# = unowned x# * unowned y#
#
x# = { 14, -33, 6.25 }
y# = { -33, 17, 9 }
result# = x# * y#
assert result# = { -462, -561, 56.25 }

assert { 1, 2, 3 } * { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 1, 2 }, { 6, 8 }, { 15, 18 } }

a# = { 1, 2, 3 }
assert a# * { { 1, 2 }, { 3, 4 }, { 5, 6 } } = { { 1, 2 }, { 6, 8 }, { 15, 18 } }

assert { 3, 4 } ^ 3 = { 27, 64 }
assert { 3, -4 } ^ 3 = { 27, -64 }
assert { -4 } ^ 2.3 = { undefined }

a# = zero# (10)
a# ~ sum ({ 3, 4 } ^ 2)
assert sum (a#) = 250
a# ~ sum ({ col } ^ 2)
assert sum (a#) = 385

assert rectify (-1.0) = 0.0
assert rectify (0.0) = 0.0
assert rectify (1.0) = 1.0
assert rectify (undefined) = undefined
assert rectify# ({ 1.2, -2.3, 4.5, 0, undefined, -44 }) = { 1.2, 0, 4.5, 0, undefined, 0 }

assert sqrt (-1.0) = undefined
assert sqrt (0.0) = 0.0
assert sqrt (1.0) = 1.0
assert sqrt (4.0) = 2.0
assert sqrt (undefined) = undefined
assert sqrt# ({ -1.0, 0.0, 1.0, 4.0, undefined }) = { undefined, 0.0, 1.0, 2.0, undefined }

assert arcsin (-1.1) = undefined
assert abs (arcsin (-1.0) - -pi/2) < 1e-17
assert arcsin (0.0) = 0
assert abs (arcsin (1.0) - pi/2) < 1e-17
assert arcsin (1.1) = undefined
assert arcsin (undefined) = undefined

assert arccos (-1.1) = undefined
assert abs (arccos (-1.0) - pi) < 1e-17
assert abs (arccos (0.0) - pi/2) < 1e-17
assert arccos (1.0) = 0
assert arccos (1.1) = undefined
assert arccos (undefined) = undefined

assert arcsinh (-1.0) < 0
assert arcsinh (0.0) = 0
assert arcsinh (1.0) > 0
assert arcsinh (undefined) = undefined

assert arccosh (1.0) = 0
assert arccosh (0.9) = undefined
assert arccosh (0.0) = undefined
assert arccosh (-10.0) = undefined
assert arccosh (undefined) = undefined

assert arctanh (-1.0) = undefined
assert arctanh (0.0) = 0
assert arctanh (1.0) = undefined
assert arctanh (undefined) = undefined

assert log2 (-1.0) = undefined
assert log2 (0.0) = undefined
assert log2 (1.0) = 0.0
assert log2 (2.0) = 1.0
assert log2 (10.0) > 3.0
assert log2 (undefined) = undefined

assert ln (-1.0) = undefined
assert ln (0.0) = undefined
assert ln (1.0) = 0.0
assert abs (ln (2.0) - 0.693) < 0.001
assert ln (3.0) > 1.0
assert ln (undefined) = undefined

assert log10 (-1.0) = undefined
assert log10 (0.0) = undefined
assert log10 (1.0) = 0.0
assert abs (log10 (2.0) - 0.301) < 0.001
assert log10 (10.0) = 1.0
assert log10 (11.0) > 1.0
assert log10 (undefined) = undefined

assert sigmoid (0.0) = 0.5
assert sigmoid (-1000) = 0
assert arctanh (1000) = undefined

assert invSigmoid (0.5) = 0.0
assert invSigmoid (-1.0) = undefined   ; not a number
assert invSigmoid (0.0) = undefined   ; minus infinity
assert invSigmoid (1.0) = undefined   ; plus infinity
assert invSigmoid (2.0) = undefined   ; not a number

assert min (5, 6, 1, 7) = 1
assert min (undefined, 6, 1, 7) = undefined
assert min (5, undefined, 1, 7) = undefined
assert min (5, 6, undefined, 7) = undefined
assert min (5, 6, 1, undefined) = undefined
assert min (undefined, undefined) = undefined
assert min (undefined) = undefined
assert min (5) = 5

assert min ({ 5, 6, 1, 7 }) = 1
assert min ({ undefined, 6, 1, 7 }) = undefined
assert min ({ 5, undefined, 1, 7 }) = undefined
assert min ({ 5, 6, undefined, 7 }) = undefined
assert min ({ 5, 6, 1, undefined }) = undefined
assert min ({ undefined, undefined }) = undefined
assert min ({ undefined }) = undefined
assert min (zero# (0)) = undefined
assert min ({ }) = undefined

assert min_e (5, 6, 1, 7) = 1
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e (undefined, 6, 1, 7)
asserterror cannot determine the minimum of a vector: element 2 is undefined.
pos = min_e (5, undefined, 1, 7)
asserterror cannot determine the minimum of a vector: element 3 is undefined.
pos = min_e (5, 6, undefined, 7)
asserterror cannot determine the minimum of a vector: element 4 is undefined.
pos = min_e (5, 6, 1, undefined)
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e (undefined, undefined)
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e (undefined)
assert min_e (5) = 5

assert min_e ({ 5, 6, 1, 7 }) = 1
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e ({ undefined, 6, 1, 7 })
asserterror cannot determine the minimum of a vector: element 2 is undefined.
pos = min_e ({ 5, undefined, 1, 7 })
asserterror cannot determine the minimum of a vector: element 3 is undefined.
pos = min_e ({ 5, 6, undefined, 7 })
asserterror cannot determine the minimum of a vector: element 4 is undefined.
pos = min_e ({ 5, 6, 1, undefined })
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e ({ undefined, undefined })
asserterror cannot determine the minimum of a vector: element 1 is undefined.
pos = min_e ({ undefined })
asserterror cannot determine the minimum of an empty vector.
pos = min_e (zero# (0))
asserterror cannot determine the minimum of an empty vector.
pos = min_e ({})

assert min_removeUndefined (5, 6, 1, 7) = 1
assert min_removeUndefined (undefined, 6, 1, 7) = 1
assert min_removeUndefined (5, undefined, 1, 7) = 1
assert min_removeUndefined (5, 6, undefined, 7) = 5
assert min_removeUndefined (5, 6, 1, undefined) = 1
assert min_removeUndefined (undefined, undefined) = undefined
assert min_removeUndefined (undefined) = undefined
assert min_removeUndefined (5) = 5

assert min_removeUndefined ({ 5, 6, 1, 7 }) = 1
assert min_removeUndefined ({ undefined, 6, 1, 7 }) = 1
assert min_removeUndefined ({ 5, undefined, 1, 7 }) = 1
assert min_removeUndefined ({ 5, 6, undefined, 7 }) = 5
assert min_removeUndefined ({ 5, 6, 1, undefined }) = 1
assert min_removeUndefined ({ undefined, undefined }) = undefined
assert min_removeUndefined ({ undefined }) = undefined
assert min_removeUndefined (zero# (0)) = undefined
assert min_removeUndefined ({ }) = undefined

#
# A published test: the 10,000th element of the default 64-bit Mersenne Twister random sequence
# should be 9'981'545'732'273'789'042.
#
random_initializeWithSeedUnsafelyButPredictably (5489)
for i to 10000
	a = randomUniform (0, 1)
endfor
random_initializeSafelyAndUnpredictably ()
a *= 2 ^ 64
roundingError = a - 9981545732273789042
writeInfoLine: fixed$ (a, 0), " ", roundingError
assert roundingError <= 2048   ; actually usually zero

a# = zero# (0)   ; edge case
a## = { a#, a# }
assert numberOfRows (a##) = 2
assert numberOfColumns (a##) = 0

assert transpose## ({ { 1, 2, 3 }, { 4, 5, 6 }, { 7, 8, 9 } }) = { { 1, 4, 7 }, { 2, 5, 8 }, { 3, 6, 9 } }

assert transpose## ({ { 1, 2, 3 }, { 4, 5, 6 } }) = { { 1, 4 }, { 2, 5 }, { 3, 6 } }

a## = { { 1, 2, 3 }, { 4, 5, 6 } }
assert transpose## (a##) = { { 1, 4 }, { 2, 5 }, { 3, 6 } }
assert transpose## (transpose## (a##)) = a##

a## = { { 4, 7, -10 }, { 16, 0, 88 } }
result# = columnSums# (a##)
assert result# = { 20, 7, 78 }

appendInfoLine: "sys/Formula.cpp.praat", " OK"
