% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runMOFA.R
\name{runMOFA}
\alias{runMOFA}
\title{train a MOFA model}
\usage{
runMOFA(object, outfile = NULL)
}
\arguments{
\item{object}{an untrained \code{\link{MOFAmodel}} object}

\item{outfile}{output .hdf5 file}
}
\value{
a trained \code{\link{MOFAmodel}} object
}
\description{
Function to train an untrained \code{\link{MOFAmodel}} object.
}
\details{
In this step the R package is calling the \code{mofapy} Python package,
 where the the training is performed. \cr
The interface with Python is done with the \code{\link{reticulate}} package. 
If you have several versions of Python installed and Rstudio is not detecting
 the correct one, you can change it using \code{reticulate::use_python}.
}
\examples{
data <- makeExampleData()
# create and prepare the MOFAmodel
MOFAobject <- createMOFAobject(data)
MOFAobject <- prepareMOFA(MOFAobject)
# fit the model (takes some time)
\dontrun{
# MOFAobject <- runMOFA(MOFAobject)
# MOFAobject
}
}
