# topnfiles: Find youngest/oldest or smallest/largest files

In a directory structure, identify those files which
 - were least/most recently been used, or
 - are smallest/largest

"Used" by default means "modified", but this can be adjusted with the --attribute argument.

Run with the --help argument for usage instructions.


## Motivation

As mentioned at https://troelsarvin.blogspot.com/2024/09/find-recently-updated-files.html a chain of linux tools may obtain the same, but it will be slower and potentially rather memory-intensive with very large file systems.

Indeed, on a file system with 3 million files, topnfiles is 40% faster than the find+sort method (when comparing user+system time), and consumes 10% of the memory that find+sort consumes.

## Examples

    troels@host:/usr/share/doc$ topnfiles .
    2025-09-01T02:00:00+02:00 ./vim-common/README.txt
    2025-09-01T02:00:00+02:00 ./vim-common/README_amibin.txt
    2025-09-01T02:00:00+02:00 ./vim-common/README_ole.txt
    2025-09-01T02:00:00+02:00 ./vim-common/README_os390.txt
    2025-09-01T02:00:00+02:00 ./vim-common/README_ami.txt
    2025-09-02T02:00:00+02:00 ./python3-botocore/README.rst
    2025-09-02T02:00:00+02:00 ./python3-boto3/CHANGELOG.rst
    2025-09-02T02:00:00+02:00 ./python3-boto3/README.rst
    2025-09-04T02:00:00+02:00 ./topnfiles/README.md
    2025-09-04T02:00:00+02:00 ./topnfiles/CHANGELOG.md

    troels@host:/usr/share/doc$ topnfiles --return oldest .
    1997-09-16T17:36:28+02:00 ./fcgi-devel/doc/fastcgi-whitepaper/img00001.gif
    1997-09-16T17:36:28+02:00 ./fcgi-devel/doc/fastcgi-whitepaper/img00003.gif
    1997-09-16T17:36:28+02:00 ./fcgi-devel/doc/fastcgi-whitepaper/img00002.gif
    1997-09-16T17:36:27+02:00 ./fcgi-devel/doc/fastcgi-prog-guide/ch1inta1.gif
    1997-09-16T17:36:27+02:00 ./fcgi-devel/doc/fastcgi-prog-guide/ch1intra.gif
    1997-09-16T17:36:27+02:00 ./fcgi-devel/doc/fastcgi-prog-guide/covera.gif
    1997-09-16T17:36:26+02:00 ./fcgi-devel/doc/omi-logo.gif
    1997-09-16T17:36:24+02:00 ./fcgi/LICENSE.TERMS
    1996-12-14T00:25:34+01:00 ./zip/algorith.txt
    1970-01-02T01:00:00+01:00 ./postgresql-jdbc/README.md

## How to rank

The "--return <...>" argument determines how topnfiles pick resulting directory entries.
Possible values for "--return" are:
 - youngest
 - oldest
 - smallest
 - largest

The result set is printed like this:
If using "-r youngest", youngest qualifying files are printed last.
If using "-r oldest", oldest qualifying files are printed last.
If using "-r smallest ", smallest qualifying files are printed last.
If using "-r largest", largest qualifying files are printed last.

## Output

Output format is governed by the "-o"/"--output" parameter, defaulting to human readable output.

### Human readable output

For this output mode, for each directory entry found, a line is printed to stdout, in a way which is human readable: Problematic characters are replaced by Unicode control pictures, or are caret escaped, depending on the capabilities of the environment. One implication of this is that the one-line-per-path rule is upheld.

The exact format of human readable output may change between versions.

File metadata elements are separated by a space. Element order is as follows (to the extent the elements are requested in the --output argument):
 - Size (in bytes)
 - ISO timestamp
 - Unix timestamp
 - File path

### Machine readable output

The "j" output option (which may not be combined with other output modifiers) results in JSON output.

If using the "0" output option (which may also not be combined with other output modifiers), each resulting path is suffixed with a NULL (ASCII 0) character, instaed of a newline, similar to the *find* tool's -print0 option. In this situation, "odd" characters are not replace with the U+FFFD unicode character.

## See also

Source code is available at https://gitlab.com/troelsarvin/topnfiles

Compiled packages may be available at https://troels.arvin.dk/topnfiles/
