/*
 Copyright (C) 2024 Fredrik Öhrström (gpl-3.0-or-later)

 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

// Generated 2025-12-08_00:02

BuiltinDriver builtins_[] =
{
    { "aquastream", "", "driver{name=aquastream meter_type=WaterMeter default_fields=name,id,total_m3,timestamp detect{mvt=IMT,01,07}library{use=total_m3,meter_datetime,target_m3,target_date}fields{field{name=status quantity=Text info=status_and_error_flags attributes=INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=LOW_BATTERY info='Low Battery – 18 months before end of life'value=0x04 test=Set}map{name=TEMPORARY_ALARM info='Temporary alarm - Manipulation/module removed'value=0x10 test=Set}map{name=LEAKAGE info=Leakage value=0x20 test=Set}map{name=BURST info=Burst value=0x30 test=Set}}}field{name=total_tariff1 quantity=Volume match{measurement_type=Instantaneous vif_range=Volume tariff_nr=1}}field{name=battery quantity=Time display_unit=y force_scale=0.0027397260273972603 match{measurement_type=Instantaneous difvifkey=02FD74}}}}", false },
    { "elf2", "", "driver{name=elf2 meter_type=HeatMeter default_fields=name,id,status,total_energy_kwh,timestamp detect{mvt=APA,42,04 mvt=APA,42,0d}library{use=fabrication_no use=on_time_h use=on_time_at_error_h}fields{field{name=meter quantity=PointInTime info='Meter date when telegram was sent.'display_unit=date match{measurement_type=Instantaneous vif_range=Date}}field{name=meter quantity=PointInTime info='Meter date when telegram was sent.'display_unit=datetime match{measurement_type=Instantaneous vif_range=DateTime}}field{name=t2_temperature quantity=Temperature info='Temperature of returned water.'match{measurement_type=Instantaneous vif_range=ReturnTemperature}}field{name=t1_temperature quantity=Temperature info='Temperature of incoming water.'match{measurement_type=Instantaneous vif_range=FlowTemperature}}field{name=current_power quantity=Power info='Instantaneous power consumed.'match{measurement_type=Instantaneous vif_range=AnyPowerVIF}}field{name=current_volume_flow quantity=Flow info='Instantaneous water flow.'match{measurement_type=Instantaneous vif_range=VolumeFlow}}field{name=total_volume quantity=Volume info='Total volume of water used for heating.'match{measurement_type=Instantaneous vif_range=AnyVolumeVIF}}field{name=total_volume_cooling quantity=Volume info='Total volume of water used for cooling.'match{measurement_type=Instantaneous vif_range=AnyVolumeVIF subunit_nr=1 tariff_nr=0 storage_nr=0}}field{name=input1_volume quantity=Volume info='Total volume of water used in input1.'match{measurement_type=Instantaneous vif_range=AnyVolumeVIF subunit_nr=0 tariff_nr=1 storage_nr=0}}field{name=input2_volume quantity=Volume info='Total volume of water used in input2.'match{measurement_type=Instantaneous vif_range=AnyVolumeVIF subunit_nr=0 tariff_nr=2 storage_nr=0}}field{name=total_energy quantity=Energy info='The total heat energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name=total_energy_cooling quantity=Energy info='The total cooling energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF subunit_nr=1 tariff_nr=0 storage_nr=0}}field{name=total_energy_period quantity=Energy info='The total cooling energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1}}field{name=total_energy_cooling_period quantity=Energy info='The total cooling energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF subunit_nr=1 tariff_nr=0 storage_nr=1}}field{name=status quantity=Text info='Status and error flags.'attributes=INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=MINIMUM_FLOW info='Average minute flow is below the minimum flow and higher than the starting flow.'value=0x01 test=Set}map{name=FLOW_METER_FAILURE info='No flow detected and temperature diff is higher than threshold.'value=0x02 test=Set}map{name=RETURN_TEMPERATURE_ERROR info='Temperature is out of measurement range or the sensor is broken.'value=0x04 test=Set}map{name=SUPPLY_TEMPERATURE_ERROR info='Temperature is out of measurement range or the sensor is broken.'value=0x08 test=Set}map{name=DIFFERENTIAL_TEMPERATURE_ERROR info='The temperature differences (eg supply-return) exceeds a threshold.'value=0x10 test=Set}map{name=MAXIMUM_FLOW info='Average minute flow Qs is higher than Qp and equal to or lower than 2Qp (Qp < Qs ≤ 2 * Qp).'value=0x20 test=Set}map{name=MEMORY_FAILURE info='Critical internal error.'value=0x40 test=Set}map{name=LOW_BATTERY_VOLTAGE info='Low battery voltage.'value=0x80 test=Set}map{name=DAILY_ABNORMAL_NOMINAL_FLOW info=('Nominal flow is detected at Q > Qp for 1 h per day (24 h)'&#10;'where one day is measured from the moment the overrun is detected.')value=0x100 test=Set}map{name=ANNUAL_ABNORMAL_NOMINAL_FLOW info=('Nominal flow is detected at Q > Qp for 200 h in 1 year'&#10;'where one year is calculated from the start of billing period n to'&#10;'the start of billing period n+1 (which is when the annual data is saved to the archive).')value=0x200 test=Set}map{name=DIFFERENTIAL_TEMPERATURE_TOO_LOW info=('The volume count is incremented in 3 consecutive integration cycles while'&#10;'the differential temperature is below the configured differential temperature'&#10;'insensitivity threshold.')value=0x400 test=Set}map{name=CRC_ERROR info='Critical internal error in firmware vs saved model.'value=0x800 test=Set}map{name=FLASH_ERROR info='Critical internal error when reading non-volatile flash memory.'value=0x1000 test=Set}map{name=CRITICAL_BATTERY_VOLTAGE info='Critical low battery voltage.'value=0x2000 test=Set}map{name=CPU_OVERTEMPERATURE info='CPU is overheating.'value=0x4000 test=Set}map{name=UART_LIMIT_OVERRUN info='Sent and received bytes exceeds the byte count limit.'value=0x8000 test=Set}}}}}", false },
    { "elster", "", "driver{name=elster meter_type=GasMeter default_fields=name,id,total_m3,timestamp detect{mvt=ELS,81,03}library{use=actuality_duration_s}fields{field{name=total quantity=Volume info='The total water consumption.'match{measurement_type=Instantaneous vif_range=Volume}}}}", false },
    { "eltako", "", "driver{name=eltako default_fields=name,id,total_kwh,timestamp meter_type=ElectricityMeter detect{mvt=ELT,01,02}fields{field{name=status quantity=Text info=status_and_error_flags match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xff default_message=OK map{name=BUSY info='System is busy'value=0x01 test=Set}map{name=GENERIC_APP_ERROR info='Generic application error'value=0x02 test=Set}map{name=CURRENT_LOW info='Current too low'value=0x04 test=Set}map{name=PERMANENT_ERROR info='permanent error'value=0x08 test=Set}map{name=TEMPORARY_ERROR info='temporary error'value=0x10 test=Set}}}field{name=total_tariff_1 quantity=Energy info='Total cumulative active energy per tariff.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyEnergyVIF tariff_nr=1}}field{name=total_tariff_2 quantity=Energy info='Total cumulative active energy per tariff.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyEnergyVIF tariff_nr=2}}field{name='total_reactive_tariff_{tariff_counter}'quantity=Energy info='Total cumulative reactive energy per tariff.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyEnergyVIF storage_nr=2 tariff_nr=1,10}}field{name=voltage_l1_n quantity=Voltage info='Instantaneous voltage between L1 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage add_combinable=Mfct01}}field{name=current_l1 quantity=Amperage info='Instantaneous current in the L1 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage add_combinable=Mfct01}}field{name=power_l1 quantity=Power info='active Power in L1 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF add_combinable=Mfct01}}field{name=reactive_power_l1 quantity=Power info='reactive Power in L1 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF subunit_nr=1 add_combinable=Mfct01}}field{name=voltage_l2_n quantity=Voltage info='Instantaneous voltage between L2 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage add_combinable=Mfct02}}field{name=current_l2 quantity=Amperage info='Instantaneous current in the L2 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage add_combinable=Mfct02}}field{name=power_l2 quantity=Power info='active Power in L2 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF add_combinable=Mfct02}}field{name=reactive_power_l2 quantity=Power info='reactive Power in L2 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF subunit_nr=1 add_combinable=Mfct02}}field{name=voltage_l3_n quantity=Voltage info='Instantaneous voltage between L3 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage add_combinable=Mfct03}}field{name=current_l3 quantity=Amperage info='Instantaneous current in the L3 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage add_combinable=Mfct03}}field{name=power_l3 quantity=Power info='active Power in L3 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF add_combinable=Mfct03}}field{name=reactive_power_l3 quantity=Power info='reactive Power in L3 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF subunit_nr=1 add_combinable=Mfct03}}field{name=ct_numerator info='Current transformer ratio (numerator)'quantity=Dimensionless vif_scaling=None match{difvifkey=02FF68}}field{name=active_power_overall quantity=Power info='active Power overall'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF add_combinable=Mfct00}}field{name=reactive_power_overall quantity=Power info='reactive Power overall'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF subunit_nr=1 add_combinable=Mfct00}}field{name=active_tariff info='active tariff'quantity=Dimensionless vif_scaling=None match{difvifkey=01FF13}}field{name=total quantity=Energy info='Total active energy over all tariffs.'calculate=total_tariff_1_kwh+total_tariff_2_kwh}}}", false },
    { "elvsense", "", "driver{name=elvsense default_fields=name,id,temperature_c,humidity_rh,co2_ppm,battery_v,status,timestamp meter_type=TempHygroMeter detect{mvt=ELV,50,1b mvt=ELV,51,1b mvt=ELV,52,1b mvt=ELV,53,1b mvt=ELV,54,1b}fields{field{name=temperature quantity=Temperature info='Instantaneous room temperature.'match{measurement_type=Instantaneous vif_range=ExternalTemperature}}field{name=battery quantity=Voltage info='Battery voltage.'match{measurement_type=Instantaneous vif_range=Voltage}}field{name=humidity quantity=RelativeHumidity info='Relative humidity for 200W and 300W meters'match{measurement_type=Instantaneous vif_range=RelativeHumidity}}field{name=co2 quantity=Dimensionless info='CO2 concentration ppm for 300W meters'vif_scaling=None display_unit=ppm match{difvifkey=027C03324F43}}field{name=status quantity=Text info='Sensor status and error flags.'attributes=STATUS,INCLUDE_TPL_STATUS}}}", false },
    { "fiowater", "", "driver{name=fiowater meter_type=WaterMeter default_fields=name,id,status,total_m3,timestamp detect{mvt=FIO,01,07}library{use=status-tpl-only use=total_m3 use=meter_datetime}}", false },
    { "hydrocalm4", "", "driver{name=hydrocalm4 default_fields=name,id,status,total_heating_kwh,total_cooling_kwh,timestamp meter_type=HeatCoolingMeter detect{mvt=BMT,1a,0d}fields{field{name=status quantity=Text info=status_and_error_flags attributes=INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=SABOTAGE info=SABOTAGE_ENCLOSURE value=0x80 test=Set}}}field{name=total_heating quantity=Energy info='The total heating energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF index_nr=1}}field{name=device quantity=PointInTime info='The date time when the recording was made.'match{measurement_type=Instantaneous vif_range=DateTime}}field{name=total_cooling quantity=Energy info='The total cooling energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF subunit_nr=0 tariff_nr=1 storage_nr=0}}field{name=total_heating info='Total heating volume of media.'quantity=Volume match{measurement_type=Instantaneous vif_range=Volume}}field{name=total_cooling info='Total cooling volume of media.'quantity=Volume match{measurement_type=Instantaneous vif_range=Volume subunit_nr=0 tariff_nr=1 storage_nr=0}}field{name=c1_volume info='Supply c1 volume.'quantity=Volume match{measurement_type=Instantaneous vif_range=Volume subunit_nr=1 tariff_nr=0 storage_nr=0}}field{name=c2_volume info='Supply c2 volume.'quantity=Volume match{measurement_type=Instantaneous vif_range=Volume subunit_nr=2 tariff_nr=0 storage_nr=0}}field{name=supply_temperature info='The supply t1 pipe temperature.'quantity=Temperature match{measurement_type=Instantaneous vif_range=FlowTemperature index_nr=1}}field{name=return_temperature info='The supply t2 pipe temperature.'quantity=Temperature match{measurement_type=Instantaneous vif_range=ReturnTemperature}}field{name=volume_flow quantity=Flow info='The current heat media volume flow.'match{measurement_type=Instantaneous vif_range=VolumeFlow}}field{name=power quantity=Power info='The current power consumption.'match{measurement_type=Instantaneous vif_range=AnyPowerVIF}}}}", false },
    { "ime", "", "driver{name=ime info='This meter uses a seriously bonkers violation of the wmbus protocol. Avoid at all cost!'default_fields=name,id,positive_total_active_energy_kwh,timestamp meter_type=ElectricityMeter detect{mvt=IME,66,02}fields{field{name=status quantity=Text info='Meter status from tpl field.'attributes=INCLUDE_TPL_STATUS}field{name=positive_total_active_energy quantity=Energy info='Positive Three-phase Active Energy (Total).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=849010FF80843B}}field{name=negative_total_active_energy quantity=Energy info='Negative Three-phase Active Energy (Total).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=849010FF80843C}}field{name=positive_total_reactive_energy quantity=Energy info='Positive Three-phase Reactive Energy (Total).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=849010FF81843B}}field{name=negative_total_reactive_energy quantity=Energy info='Negative Three-phase Reactive Energy (Total).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=849010FF81843C}}field{name=positive_tariff1_active_energy quantity=Energy info='Positive Three-phase Active Energy (Tariff 1).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=8410FF80843B}}field{name=positive_tariff2_active_energy quantity=Energy info='Positive Three-phase Active Energy (Tariff 2).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=8420FF80843B}}field{name=negative_tariff1_active_energy quantity=Energy info='Negative Three-phase Active Energy (Tariff 1).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=8410FF80843C}}field{name=negative_tariff2_active_energy quantity=Energy info='Negative Three-phase Active Energy (Tariff 2).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=8420FF80843C}}field{name=positive_tariff1_reactive_energy quantity=Energy info='Positive Three-phase Reactive Energy (Tariff 1).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=8410FF81843B}}field{name=positive_tariff2_reactive_energy quantity=Energy info='Positive Three-phase Reactive Energy (Tariff 2).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=8420FF81843B}}field{name=negative_tariff1_reactive_energy quantity=Energy info='Negative Three-phase Reactive Energy (Tariff 1).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=8410FF81843C}}field{name=negative_tariff2_reactive_energy quantity=Energy info='Negative Three-phase Reactive Energy (Tariff 2).'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=8420FF81843C}}field{name=partial_positive_active_energy quantity=Energy info='Partial Positive Three-phase Active Energy.'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=84A010FF80843B}}field{name=partial_negative_active_energy quantity=Energy info='Partial Negative Three-phase Active Energy.'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kwh match{difvifkey=84A010FF80843C}}field{name=partial_positive_reactive_energy quantity=Energy info='Partial Positive Three-phase Reactive Energy.'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=84A010FF81843B}}field{name=partial_negative_reactive_energy quantity=Energy info='Partial Negative Three-phase Reactive Energy.'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=kvarh match{difvifkey=84A010FF81843C}}field{name=pulse_input quantity=Dimensionless info='Pulse Input.'vif_scaling=None dif_signedness=Signed force_scale=0.01 display_unit=counter match{difvifkey=04FF9029}}field{name=pulse_unit quantity=Text info='Pulse Unit.'match{difvifkey=02FF912B}lookup{name=UNIT map_type=IndexToString mask_bits=0xffff map{name=WH info=Wh value=0 test=Set}map{name=KWH info=kWh value=1 test=Set}map{name=MWH info=MWh value=2 test=Set}map{name=VARH info=varh value=3 test=Set}map{name=KVARH info=kvarh value=4 test=Set}map{name=MVARH info=mvarh value=5 test=Set}map{name=VAH info=VAh value=6 test=Set}map{name=KVAH info=kVAh value=7 test=Set}map{name=MVAH info=mVAh value=8 test=Set}map{name=M3 info=m³ value=9 test=Set}map{name=KM3 info=km³ value=10 test=Set}map{name=WOOT info='woot not in manual'value=11 test=Set}map{name=NM3 info=Nm³ value=12 test=Set}map{name=KNM3 info=kNm³ value=13 test=Set}map{name=MNM3 info=MNm³ value=14 test=Set}map{name=J info=J value=15 test=Set}map{name=KJ info=kJ value=16 test=Set}map{name=MJ info=MJ value=17 test=Set}map{name=cal info=cal value=18 test=Set}map{name=KCAL info=kcal value=19 test=Set}map{name=G info=g value=20 test=Set}map{name=KG info=kg value=21 test=Set}map{name=T info=T value=21 test=Set}}}field{name=kta quantity=Text info='Current Transformer Ratio (KTA).'vif_scaling=None dif_signedness=Unsigned display_unit=txt match{difvifkey=02FF922B}}field{name=ktv quantity=Text info='Voltage Transformer Ratio (KTV).'vif_scaling=None dif_signedness=Unsigned display_unit=txt match{difvifkey=02FF9329}}field{name=three_phase_total_active_power quantity=Power info='Three-phase Total Active Power.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=84B010FF842B}}field{name=active_power_l1 quantity=Power info='Active Power L1.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=848020FF842B}}field{name=active_power_l2 quantity=Power info='Active Power L2.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=849020FF842B}}field{name=active_power_l3 quantity=Power info='Active Power L3.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=84A020FF842B}}field{name=three_phase_total_reactive_power quantity=Power info='Three-phase Total Reactive Power.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kvar match{difvifkey=84B010FF852B}}field{name=reactive_power_l1 quantity=Power info='Reactive Power L1.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kvar match{difvifkey=848020FF852B}}field{name=reactive_power_l2 quantity=Power info='Reactive Power L2.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kvar match{difvifkey=849020FF852B}}field{name=reactive_power_l3 quantity=Power info='Reactive Power L3.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kvar match{difvifkey=84A020FF852B}}field{name=three_phase_total_apparent_power quantity=Power info='Three-phase Total Apparent Power.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kva match{difvifkey=84B010FF862B}}field{name=apparent_power_l1 quantity=Power info='Apparent Power L1.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kva match{difvifkey=848020FF862B}}field{name=apparent_power_l2 quantity=Power info='Apparent Power L2.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kva match{difvifkey=849020FF862B}}field{name=apparent_power_l3 quantity=Power info='Apparent Power L3.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kva match{difvifkey=84A020FF862B}}field{name=voltage_1_n quantity=Voltage info='1-N Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=848020FF8748}}field{name=voltage_2_n quantity=Voltage info='2-N Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=849020FF8748}}field{name=voltage_3_n quantity=Voltage info='3-N Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=84A020FF8748}}field{name=voltage_1_2 quantity=Voltage info='1-2 Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=848020FF8848}}field{name=voltage_2_3 quantity=Voltage info='2-3 Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=849020FF8848}}field{name=voltage_3_1 quantity=Voltage info='3-1 Voltage.'vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=v match{difvifkey=84A020FF8848}}field{name=current_l1 quantity=Amperage info='Phase 1 Current Value.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=a match{difvifkey=848020FF8959}}field{name=current_l2 quantity=Amperage info='Phase 2 Current Value.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=a match{difvifkey=849020FF8959}}field{name=current_l3 quantity=Amperage info='Phase 3 Current Value.'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=a match{difvifkey=84A020FF8959}}field{name=frequency quantity=Frequency info=Frequency. vif_scaling=None dif_signedness=Signed force_scale=0.1 display_unit=hz match{difvifkey=02FF8A48}}field{name=three_phase_power quantity=Dimensionless info='Three-phase Power Factor (PF).'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=factor match{difvifkey=82B010FF8B28}}field{name=power_factor_sector quantity=Text info='Power Factor (PF) sector.'match{difvifkey=82B010FF8C2B}lookup{name=SECTOR_NR map_type=IndexToString mask_bits=0xffff map{name=RESISTIVE info=Resistive value=0 test=Set}map{name=INDUCTIVE info=Inductive value=1 test=Set}map{name=CAPACITIVE info=Capacitive value=2 test=Set}}}field{name=total_active_power_requirement quantity=Power info='Total Active Power Requirement (MD).'vif_scaling=None dif_signedness=Unsigned force_scale=0.001 display_unit=kw match{difvifkey=8410FF8D2B}}field{name=max_total_active_power_tariff1 quantity=Power info='Maximum Total Active Power Requirement Tariff 1 (PMD T1).'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=8410FF8E2B}}field{name=max_total_active_power_tariff2 quantity=Power info='Maximum Total Active Power Requirement Tariff 2 (PMD T2).'vif_scaling=None dif_signedness=Signed force_scale=0.001 display_unit=kw match{difvifkey=8420FF8E2B}}field{name=run_meter_total quantity=Time info='Run hour meter (TOT).'vif_scaling=None dif_signedness=Signed force_scale=1/60 display_unit=h match{difvifkey=84B010FF8F21}}field{name=run_meter_tariff1 quantity=Time info='Run hour meter (Tariff 1).'vif_scaling=None dif_signedness=Signed force_scale=1/60 display_unit=h match{difvifkey=8410FF8F21}}field{name=run_meter_tariff2 quantity=Time info='Run hour meter (Tariff 2).'vif_scaling=None dif_signedness=Signed force_scale=1/60 display_unit=h match{difvifkey=8420FF8F21}}}}", false },
    { "iperl", "", "driver{name=iperl meter_type=WaterMeter default_fields=name,id,total_m3,max_flow_m3h,timestamp manufacturer=Sensus model=iperl detect{mvt=SEN,68,06 mvt=SEN,68,07 mvt=SEN,7c,07}fields{field{name=total quantity=Volume info='The total water consumption.'match{measurement_type=Instantaneous vif_range=Volume}}field{name=max_flow quantity=Flow info='The maximum water flow recorded during previous period.'match{measurement_type=Instantaneous vif_range=VolumeFlow}}}}", false },
    { "istaheat", "", "driver{name=istaheat meter_type=HeatMeter default_fields=name,id,status,total_kwh,target_kwh,timestamp detect{mvt=IST,a9,04}fields{field{name=status quantity=Text info='Meter status from tpl field.'attributes=INCLUDE_TPL_STATUS}field{name=total quantity=Energy info='The total heat energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name=target quantity=PointInTime info='Last day of previous billing month.'display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=2}}field{name=target quantity=Energy info='The total heat energy for the previous month period.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=2}}field{name=target quantity=Volume info='The total heating media volume recorded by this meter at the end of last month.'match{measurement_type=Instantaneous vif_range=Volume storage_nr=2}}field{name=last_year quantity=PointInTime info='Last day of previous billing year.'display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=1}}field{name=last_year quantity=Energy info='The total heat energy for the previous year period.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1}}}}", false },
    { "itronheat", "", "driver{name=itronheat meter_type=HeatMeter default_fields=name,id,status,total_kwh,timestamp detect{mvt=ITW,00,04}library{use=meter_datetime}fields{field{name=status quantity=Text info='Meter status from tpl field.'attributes=INCLUDE_TPL_STATUS}field{name=total quantity=Energy info='The total heat energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name=total quantity=Volume info='The total volume of heating media recorded by this meter.'match{measurement_type=Instantaneous vif_range=Volume}}field{name=last_year quantity=PointInTime info='Last day of previous billing year.'display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=1}}field{name=last_year quantity=Energy info='The total heat energy for the previous year period.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1}}}}", false },
    { "kamheat", "multical302,multical303,multical403,multical602,multical603,multical803", "driver{name=kamheat aliases=multical302,multical303,multical403,multical602,multical603,multical803 default_fields=name,id,total_energy_consumption_kwh,total_volume_m3,status,timestamp meter_type=HeatMeter detect{mvt=KAM,30,04 mvt=KAM,30,0d mvt=KAM,30,0c mvt=KAM,40,04 mvt=KAM,40,0c mvt=KAM,19,04 mvt=KAM,34,04 mvt=KAM,34,0a mvt=KAM,34,0b mvt=KAM,34,0c mvt=KAM,34,0d mvt=KAM,1c,04 mvt=KAM,35,04 mvt=KAM,35,0c mvt=KAM,39,04}library{use=fabrication_no use='meter_date|(10/348/Date and time)'use='meter_datetime|(10/348/Date and time)'use=on_time_h use=on_time_at_error_h use=flow_return_temperature_difference_c use='target_date|(14/348/Date and Time logged)'}fields{field{name=status quantity=Text info='Status and error flags'attributes=STATUS,INCLUDE_TPL_STATUS match{difvifkey=04FF22}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffffffff default_message=OK map{name=VOLTAGE_INTERRUPTED value=0x00000001 test=Set}map{name=LOW_BATTERY_LEVEL value=0x00000002 test=Set}map{name=SENSOR_ERROR value=0x00000004 test=Set}map{name=SENSOR_T1_ABOVE_MEASURING_RANGE value=0x00000008 test=Set}map{name=SENSOR_T2_ABOVE_MEASURING_RANGE value=0x00000010 test=Set}map{name=SENSOR_T1_BELOW_MEASURING_RANGE value=0x00000020 test=Set}map{name=SENSOR_T2_BELOW_MEASURING_RANGE value=0x00000040 test=Set}map{name=TEMP_DIFF_WRONG_POLARITY value=0x00000080 test=Set}map{name=FLOW_SENSOR_WEAK_OR_AIR value=0x00000100 test=Set}map{name=WRONG_FLOW_DIRECTION value=0x00000200 test=Set}map{name=RESERVED_BIT_10 value=0x00000400 test=Set}map{name=FLOW_INCREASED value=0x00000800 test=Set}map{name=IN_A1_LEAKAGE_IN_THE_SYSTEM value=0x00001000 test=Set}map{name=IN_B1_LEAKAGE_IN_THE_SYSTEM value=0x00002000 test=Set}map{name=IN_A1_A2_EXTERNAL_ALARM value=0x00004000 test=Set}map{name=IN_B1_B2_EXTERNAL_ALARM value=0x00008000 test=Set}map{name=V1_COMMUNICATION_ERROR value=0x00010000 test=Set}map{name=V1_WRONG_PULSE_FIGURE value=0x00020000 test=Set}map{name=IN_A2_LEAKAGE_IN_THE_SYSTEM value=0x00040000 test=Set}map{name=IN_B2_LEAKAGE_IN_THE_SYSTEM value=0x00080000 test=Set}map{name=T3_ABOVE_MEASURING_RANGE_OR_SWITCHED_OFF value=0x00100000 test=Set}map{name=T3_BELOW_MEASURING_RANGE_OR_SWITCHED_OFF value=0x00200000 test=Set}map{name=V2_COMMUNICATION_ERROR value=0x00400000 test=Set}map{name=V2_WRONG_PULSE_FIGURE value=0x00800000 test=Set}map{name=V2_AIR value=0x01000000 test=Set}map{name=V2_WRONG_FLOW_DIRECTION value=0x02000000 test=Set}map{name=RESERVED_BIT_26 value=0x04000000 test=Set}map{name=V2_INCREASED_FLOW value=0x08000000 test=Set}map{name=V1_V2_BURST_WATER_LOSS value=0x10000000 test=Set}map{name=V1_V2_BURST_WATER_PENETRATION value=0x20000000 test=Set}map{name=V1_V2_LEAKAGE_WATER_LOSS value=0x40000000 test=Set}map{name=V1_V2_LEAKAGE_WATER_PENETRATION value=0x80000000 test=Set}}}field{name=status16 quantity=Text info='Status and error flags'attributes=INJECT_INTO_STATUS,HIDE match{difvifkey=02FF22}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=VOLTAGE_INTERRUPTED value=0x0001 test=Set}map{name=LOW_BATTERY_LEVEL value=0x0002 test=Set}map{name=RESERVED_BIT_2 value=0x0004 test=Set}map{name=SENSOR_T1_ABOVE_MEASURING_RANGE value=0x0008 test=Set}map{name=SENSOR_T2_ABOVE_MEASURING_RANGE value=0x0010 test=Set}map{name=SENSOR_T1_BELOW_MEASURING_RANGE value=0x0020 test=Set}map{name=SENSOR_T2_BELOW_MEASURING_RANGE value=0x0040 test=Set}map{name=TEMP_DIFF_WRONG_POLARITY value=0x0080 test=Set}map{name=FLOW_SENSOR_WEAK_OR_AIR value=0x0100 test=Set}map{name=WRONG_FLOW_DIRECTION value=0x0200 test=Set}map{name=RESERVED_BIT_10 value=0x0400 test=Set}map{name=FLOW_INCREASED value=0x0800 test=Set}map{name=RESERVED_BIT_12 value=0x1000 test=Set}map{name=RESERVED_BIT_13 value=0x2000 test=Set}map{name=RESERVED_BIT_14 value=0x4000 test=Set}map{name=RESERVED_BIT_15 value=0x8000 test=Set}}}field{name=status_narrow quantity=Text info='Status and error flags'attributes=INJECT_INTO_STATUS,HIDE match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=NARROW_ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=VOLTAGE_INTERRUPTED value=0x0001 test=Set}map{name=SENSOR_T1_OUTSIDE_MEASURING_RANGE value=0x0008 test=Set}map{name=SENSOR_T2_OUTSIDE_MEASURING_RANGE value=0x0004 test=Set}map{name=SENSOR_T3_OUTSIDE_MEASURING_RANGE value=0x0020 test=Set}map{name=LEAKAGE_COLD_WATER value=0x0040 test=Set}map{name=LEAKAGE_HOT_WATER value=0x0100 test=Set}map{name=BURST_WATER_LOSS value=0x0200 test=Set}map{name=V1_COMMUNICATION_ERROR value=0x0010 test=Set}map{name=V2_COMMUNICATION_ERROR value=0x0400 test=Set}map{name=V1_WRONG_PULSE_FIGURE value=0x0800 test=Set}map{name=V2_WRONG_PULSE_FIGURE value=0x0080 test=Set}map{name=V1_AIR value=0x1000 test=Set}map{name=V2_AIR value=0x2000 test=Set}map{name=V1_WRONG_FLOW_DIRECTION value=0x4000 test=Set}map{name=V2_WRONG_FLOW_DIRECTION value=0x8000 test=Set}}}field{name=total_energy_consumption quantity=Energy info='The total energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name=total_energy_backward quantity=Energy info='The total backwards energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF add_combinable=BackwardFlow}}field{name=total_volume quantity=Volume info='The volume of water (3/68/Volume V1).'match{measurement_type=Instantaneous vif_range=Volume}}field{name='total_volume_subunit{subunit_counter}'quantity=Volume info='The volume of water for a subunit.'match{measurement_type=Instantaneous vif_range=Volume subunit_nr=1,4}}field{name=volume_flow quantity=Flow info='The actual amount of water that pass through this meter (8/74/Flow V1 actual).'match{measurement_type=Instantaneous vif_range=VolumeFlow}}field{name=power quantity=Power info='The current power flowing.'match{measurement_type=Instantaneous vif_range=AnyPowerVIF}}field{name=max_power quantity=Power info='The maximum power supplied.'match{measurement_type=Maximum vif_range=AnyPowerVIF}}field{name=t1_temperature quantity=Temperature info='The forward temperature of the water (6/86/t2 actual 2 decimals).'match{measurement_type=Instantaneous vif_range=FlowTemperature}}field{name=t2_temperature quantity=Temperature info='The return temperature of the water (7/87/t2 actual 2 decimals).'match{measurement_type=Instantaneous vif_range=ReturnTemperature}}field{name=max_flow quantity=Flow info='The maximum flow of water that passed through this meter.'match{measurement_type=Maximum vif_range=VolumeFlow}}field{name=forward_energy quantity=Energy info='The forward energy of the water (4/97/Energy E8).'vif_scaling=None display_unit=m3c match{difvifkey=04FF07}}field{name=return_energy quantity=Energy info='The return energy of the water (5/110/Energy E9).'vif_scaling=None display_unit=m3c match{difvifkey=04FF08}}field{name=target_energy quantity=Energy info='The energy consumption recorded by this meter at the set date (11/60/Heat energy E1/026C).'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1}}field{name=target_volume quantity=Volume info='The amount of water that had passed through this meter at the set date (13/68/Volume V1).'match{measurement_type=Instantaneous vif_range=Volume storage_nr=1}}field{name='target_volume_subunit{subunit_counter}'quantity=Volume info='The amount of water that had passed through a subunit of the meter at the set date.'match{measurement_type=Instantaneous vif_range=Volume storage_nr=1 subunit_nr=1,4}}field{name=operating_time quantity=Time info='How long the meter has been collecting data.'match{measurement_type=Instantaneous vif_range=OperatingTime add_combinable=Mfct21}}field{name=enhanced_id quantity=Text match{difvifkey=02F9FF15}}field{name=va quantity=Dimensionless vif_scaling=None display_unit=counter match{difvifkey=04EEFF07}}field{name=vb quantity=Dimensionless vif_scaling=None display_unit=counter match{difvifkey=04EEFF08}}}test{args='303_wrong_flow kamheat 83076912 NOKEY'telegram=52442d2c1269078340048d2067e08d1620d2ca7804060000000004140000000004ff070000000004ff080000000002592618025d2816023B000002ff220002026c393B440600000000441400000000426c213B json=('{\"_\":\"telegram\",\"media\":\"heat\",\"meter\":\"kamheat\",\"name\":\"303_wrong_flow\",\"id\":\"83076912\",\"forward_energy_m3c\":0,\"return_energy_m3c\":0,\"t1_temperature_c\":61.82,\"t2_temperature_c\":56.72,\"target_date\":\"2025-11-01\",\"target_energy_kwh\":0,\"target_volume_m3\":0,\"total_energy_consumption_kwh\":0,\"total_volume_m3\":0,\"volume_flow_m3h\":0,\"meter_date\":\"2025-11-25\",\"status\":\"WRONG_FLOW_DIRECTION\",\"timestamp\":\"1111-11-11T11:11:11Z\"'&#10;'}')}}", false },
    { "kampress", "", "driver{name=kampress default_fields=name,id,status,pressure_bar,max_pressure_bar,min_pressure_bar,timestamp meter_type=PressureSensor detect{mvt=KAM,01,18}fields{field{name=status quantity=Text info=status_and_error_flags match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK map{name=DROP info='Unexpected drop in pressure in relation to average pressure.'value=0x01 test=Set}map{name=SURGE info='Unexpected increase in pressure in relation to average pressure.'value=0x02 test=Set}map{name=HIGH info='Average pressure has reached configurable limit. Default 15 bar.'value=0x04 test=Set}map{name=LOW info='Average pressure has reached configurable limit. Default 1.5 bar.'value=0x08 test=Set}map{name=TRANSIENT info='Pressure changes quickly over short timeperiods. Average is fluctuating.'value=0x10 test=Set}map{name=COMM_ERROR info='Cannot measure properly or bad internal communication.'value=0x20 test=Set}}}field{name=pressure quantity=Pressure info='The measured pressure.'match{measurement_type=Instantaneous vif_range=Pressure}}field{name=max_pressure quantity=Pressure info='The maximum pressure measured during ?'match{measurement_type=Maximum vif_range=Pressure}}field{name=min_pressure quantity=Pressure info='The minimum pressure measured during ?'match{measurement_type=Minimum vif_range=Pressure}}field{name=alfa info='We do not know what this is.'quantity=Dimensionless vif_scaling=None match{difvifkey=05FF09}}field{name=beta info='We do not know what this is.'quantity=Dimensionless vif_scaling=None match{difvifkey=05FF0A}}}}", false },
    { "maddalena", "", "driver{name=maddalena meter_type=WaterMeter default_fields=name,id,status,total_m3,timestamp detect{mvt=MAD,01,07 mvt=MAD,01,06}library{use=fabrication_no,meter_datetime,target_m3,target_date,total_m3}fields{field{name=status quantity=Text info='Status and error flags.'attributes=INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xffff default_message=OK}}}}", false },
    { "nzr", "", "driver{name=nzr default_fields=name,id,status,total_energy_consumption_kwh,timestamp meter_type=ElectricityMeter detect{mvt=NZR,00,02 mvt=EMH,00,02}fields{field{name=status quantity=Text info=status_and_error_flags attributes=STATUS,INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xff default_message=OK map{name=BUSY info='System is busy'value=0x01 test=Set}map{name=GENERIC_APP_ERROR info='Generic application error'value=0x02 test=Set}map{name=CURRENT_LOW info='Current too low'value=0x04 test=Set}map{name=PERMANENT_ERROR info='permanent error'value=0x08 test=Set}map{name=TEMPORARY_ERROR info='temporary error'value=0x10 test=Set}}}field{name=total_energy_consumption quantity=Energy info='The total energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyEnergyVIF tariff_nr=1}}field{name=current_power_consumption quantity=Power info='active Power overall'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF}}field{name=current_power_consumption_1 quantity=Power info='active Power in L1 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF storage_nr=2}}field{name=voltage_at_phase_1 quantity=Voltage info='Instantaneous voltage between L1 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage storage_nr=2}}field{name=current_at_phase_1 quantity=Amperage info='Instantaneous current in the L1 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage storage_nr=2}}field{name=current_power_consumption_2 quantity=Power info='active Power in L2 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF storage_nr=4}}field{name=voltage_at_phase_2 quantity=Voltage info='Instantaneous voltage between L2 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage storage_nr=4}}field{name=current_at_phase_2 quantity=Amperage info='Instantaneous current in the L2 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage storage_nr=4}}field{name=current_power_consumption_3 quantity=Power info='active Power in L3 phase'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=AnyPowerVIF storage_nr=6}}field{name=voltage_at_phase_3 quantity=Voltage info='Instantaneous voltage between L3 and neutral.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Voltage storage_nr=6}}field{name=current_at_phase_3 quantity=Amperage info='Instantaneous current in the L3 phase.'match{measurement_type=Instantaneous vif_scaling=Auto vif_range=Amperage storage_nr=6}}}}", false },
    { "relhca", "", "driver{name=relhca meter_type=HeatCostAllocationMeter default_fields=name,id,consumption_hca,timestamp detect{mvt=REL,41,00}library{use=consumption_hca use=target_hca use=meter_datetime use=target_date}fields{field{name=next_target quantity=PointInTime display_unit=date match{measurement_type=Instantaneous vif_range=Date add_combinable=FutureValue storage_nr=1}}}}", false },
    { "sensostar", "", "driver{name=sensostar meter_type=HeatMeter default_fields=name,id,status,total_kwh,total_water_m3,target_date,target_kwh,timestamp detect{mvt=EFE,00,04}library{use=meter_datetime,fabrication_no,model_version,on_time_h,parameter_set}fields{field{name=status quantity=Text info='Meter status from tpl field.'attributes=INCLUDE_TPL_STATUS match{measurement_type=Instantaneous vif_range=ErrorFlags}lookup{name=ERROR_FLAGS map_type=BitToString mask_bits=0xff default_message=OK map{name=ERROR_TEMP_SENSOR_1_CABLE_BREAK value=0x01 test=Set}map{name=ERROR_TEMP_SENSOR_1_SHORT_CIRCUIT value=0x02 test=Set}map{name=ERROR_TEMP_SENSOR_2_CABLE_BREAK value=0x04 test=Set}map{name=ERROR_TEMP_SENSOR_2_SHORT_CIRCUIT value=0x08 test=Set}map{name=ERROR_FLOW_MEASUREMENT_SYSTEM_ERROR value=0x10 test=Set}map{name=ERROR_ELECTRONICS_DEFECT value=0x20 test=Set}map{name=OK_INSTRUMENT_RESET value=0x40 test=Set}map{name=OK_BATTERY_LOW value=0x80 test=Set}}}field{name=total quantity=Energy info='The total heat energy consumption recorded by this meter.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name='total_tariff{tariff_counter}'quantity=Energy info='The total heat energy consumption recorded by this meter on tariff 2-3.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF tariff_nr=2,3}}field{name='total_subunit{subunit_counter}'quantity=Volume info='The total volume consumption recorded by this meter on subunit 1-3.'match{measurement_type=Instantaneous vif_range=Volume subunit_nr=1,3}}field{name=total_water quantity=Volume info='The total volume of heating media recorded by this meter.'match{measurement_type=Instantaneous vif_range=Volume}}field{name=total_water_tariff2 quantity=Volume info='The total volume of heating media recorded by this meter on tariff2.'match{measurement_type=Instantaneous vif_range=Volume tariff_nr=2}}field{name=target_water quantity=Volume info='The total volume of heating media as recorded at the end of the billing period.'match{measurement_type=Instantaneous vif_range=Volume storage_nr=1}}field{name=power quantity=Power info='Power consumption.'match{measurement_type=Instantaneous vif_range=AnyPowerVIF}}field{name=power_max quantity=Power info='Power consumption.'match{measurement_type=Maximum vif_range=AnyPowerVIF}}field{name=flow_water quantity=Flow info='Flow of water.'match{measurement_type=Instantaneous vif_range=VolumeFlow}}field{name=flow_water_max quantity=Flow info='Flow of water maximum.'match{measurement_type=Maximum vif_range=VolumeFlow}}field{name=forward quantity=Temperature info='Forward temperature of water.'match{measurement_type=Instantaneous vif_range=FlowTemperature}}field{name=return quantity=Temperature info='Return temperature of water.'match{measurement_type=Instantaneous vif_range=ReturnTemperature}}field{name=difference quantity=Temperature info='Difference forward - return temperature.'match{measurement_type=Instantaneous vif_range=TemperatureDifference}}field{name=target quantity=PointInTime info='The reporting date of the last billing period.'display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=1}}field{name=target quantity=Energy info='The energy consumption at the last billing period date.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1}}field{name='target_tariff{tariff_counter}'quantity=Energy info='The energy consumption at the last billing period date on tariff 2-3.'match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=1 tariff_nr=2,3}}field{name='target_subunit{subunit_counter}'quantity=Volume info='The volume consumption at the last billing period date on subunit 1-3.'match{measurement_type=Instantaneous vif_range=Volume storage_nr=1 subunit_nr=1,3}}field{name='target_{storage_counter}'quantity=Energy match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=2,32}}}}", false },
    { "supercal", "", "driver{name=supercal default_fields=name,id,total_kwh,timestamp meter_type=HeatMeter detect{mvt=SON,1b,04}library{use=meter_datetime,flow_temperature_c,return_temperature_c,volume_flow_m3h}fields{field{name=total quantity=Energy match{measurement_type=Instantaneous vif_range=AnyEnergyVIF}}field{name=total quantity=Volume match{measurement_type=Instantaneous vif_range=Volume}}field{name=target quantity=Energy match{measurement_type=Instantaneous vif_range=AnyEnergyVIF storage_nr=20}}field{name=target quantity=Volume match{measurement_type=Instantaneous vif_range=Volume storage_nr=20}}field{name=target quantity=PointInTime display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=20}}field{name=power quantity=Power match{measurement_type=Instantaneous vif_range=AnyPowerVIF}}}}", false },
    { "werhlemodwm", "", "driver{name=werhlemodwm meter_type=WaterMeter default_fields=name,id,total_m3,timestamp detect{mvt=WZG,03,16}library{use=meter_datetime use=total_m3 use=fabrication_no use=target_date use=target_m3}fields{field{name=next_target quantity=PointInTime display_unit=date match{measurement_type=Instantaneous vif_range=Date add_combinable=FutureValue storage_nr=1}}field{name='target_{storage_counter}'quantity=Volume match{measurement_type=Instantaneous vif_range=Volume storage_nr=1,13}}field{name='target_{storage_counter}'quantity=PointInTime display_unit=date match{measurement_type=Instantaneous vif_range=Date storage_nr=1,13}}}}", false },
};

MapToDriver builtins_mvts_[] =
{
    { { MANUFACTURER_IMT,0x01,0x07 }, "aquastream" },
    { { MANUFACTURER_APA,0x42,0x04 }, "elf2" },
    { { MANUFACTURER_APA,0x42,0x0d }, "elf2" },
    { { MANUFACTURER_ELS,0x81,0x03 }, "elster" },
    { { MANUFACTURER_ELT,0x01,0x02 }, "eltako" },
    { { MANUFACTURER_ELV,0x50,0x1b }, "elvsense" },
    { { MANUFACTURER_ELV,0x51,0x1b }, "elvsense" },
    { { MANUFACTURER_ELV,0x52,0x1b }, "elvsense" },
    { { MANUFACTURER_ELV,0x53,0x1b }, "elvsense" },
    { { MANUFACTURER_ELV,0x54,0x1b }, "elvsense" },
    { { MANUFACTURER_FIO,0x01,0x07 }, "fiowater" },
    { { MANUFACTURER_BMT,0x1a,0x0d }, "hydrocalm4" },
    { { MANUFACTURER_IME,0x66,0x02 }, "ime" },
    { { MANUFACTURER_SEN,0x68,0x06 }, "iperl" },
    { { MANUFACTURER_SEN,0x68,0x07 }, "iperl" },
    { { MANUFACTURER_SEN,0x7c,0x07 }, "iperl" },
    { { MANUFACTURER_IST,0xa9,0x04 }, "istaheat" },
    { { MANUFACTURER_ITW,0x00,0x04 }, "itronheat" },
    { { MANUFACTURER_KAM,0x30,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x30,0x0d }, "kamheat" },
    { { MANUFACTURER_KAM,0x30,0x0c }, "kamheat" },
    { { MANUFACTURER_KAM,0x40,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x40,0x0c }, "kamheat" },
    { { MANUFACTURER_KAM,0x19,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x34,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x34,0x0a }, "kamheat" },
    { { MANUFACTURER_KAM,0x34,0x0b }, "kamheat" },
    { { MANUFACTURER_KAM,0x34,0x0c }, "kamheat" },
    { { MANUFACTURER_KAM,0x34,0x0d }, "kamheat" },
    { { MANUFACTURER_KAM,0x1c,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x35,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x35,0x0c }, "kamheat" },
    { { MANUFACTURER_KAM,0x39,0x04 }, "kamheat" },
    { { MANUFACTURER_KAM,0x01,0x18 }, "kampress" },
    { { MANUFACTURER_MAD,0x01,0x07 }, "maddalena" },
    { { MANUFACTURER_MAD,0x01,0x06 }, "maddalena" },
    { { MANUFACTURER_NZR,0x00,0x02 }, "nzr" },
    { { MANUFACTURER_EMH,0x00,0x02 }, "nzr" },
    { { MANUFACTURER_REL,0x41,0x00 }, "relhca" },
    { { MANUFACTURER_EFE,0x00,0x04 }, "sensostar" },
    { { MANUFACTURER_SON,0x1b,0x04 }, "supercal" },
    { { MANUFACTURER_WZG,0x03,0x16 }, "werhlemodwm" },
};
