# D.4 What is the relationship between capitalism and the ecological crisis?

Environmental damage has reached alarming proportions. Almost daily there are
new upwardly revised estimates of the severity of global warming, ozone
destruction, topsoil loss, oxygen depletion from the clearing of rain forests,
acid rain, toxic wastes and pesticide residues in food and water, the
accelerating extinction rate of natural species, etc., etc. Almost all
scientists now recognise that global warming may soon become irreversible,
with devastating results for humanity. Those few who reject this consensus are
usually paid by corporations with a vested interest in denying the reality of
what their companies are doing to the planet (such as oil companies). That
sections of the ruling class have become aware of the damage inflicted on the
planet's eco-systems suggests that we have only a few decades before they
irreparably damaged.

Most anarchists see the ecological crisis as rooted in the psychology of
domination, which emerged with the rise of hierarchy (including patriarchy,
classes, and the first primitive states) during the Late Neolithic. Murray
Bookchin, one of the pioneers of eco-anarchism, points out that _"[t]he
hierarchies, classes, propertied forms, and statist institutions that emerged
with social domination were carried over conceptually into humanity's
relationship with nature. Nature too became increasingly regarded as a mere
resource, an object, a raw material to be exploited as ruthlessly as slaves on
a latifundium."_ [**Toward an Ecological Society** p. 41] In his view, without
uprooting the psychology of domination, all attempts to stave off ecological
catastrophe are likely to be mere palliatives and so doomed to failure.

Bookchin argues that _"the conflict between humanity and nature is an
extension of the conflict between human and human. Unless the ecology movement
encompasses the problem of domination in all its aspects, it will contribute
**nothing** toward eliminating the root causes of the ecological crisis of our
time. If the ecology movement stops at mere reformism in pollution and
conservation control - at mere 'environmentalism' - without dealing radically
with the need for an expanded concept of revolution, it will merely serve as a
safety value for the existing system of natural and human exploitation."_
[**Op. Cit.**, p. 43] Since capitalism is the vehicle through which the
psychology of domination finds its most ecologically destructive outlet, most
eco-anarchists give the highest priority to dismantling it:

> _"Literally, the system in its endless devouring of nature will reduce the
entire biosphere to the fragile simplicity of our desert and arctic biomes. We
will be reversing the process of organic evolution which has differentiated
flora and fauna into increasingly complex forms and relationships, thereby
creating a simpler and less stable world of life. The consequences of this
appalling regression are predictable enough in the long run -- the biosphere
will become so fragile that it will eventually collapse from the standpoint
human survival needs and remove the organic preconditions for human life. That
this will eventuate from a society based on production for the sake of
production is . . . merely a matter of time, although when it will occur is
impossible to predict."_ [**Op. Cit.**, p. 68]

This is not to say that ecological destruction did not exist before the rise
of capitalism. This is not the case. Social problems, and the environmental
destruction they create, _"lie not only in the conflict between wage labour
and capital"_ they also _"lie in the conflicts between age-groups and sexes
within the family, hierarchical modes of instruction in the schools, the
bureaucratic usurpation of power within the city, and ethnic divisions within
society. Ultimately, they stem from a hierarchical sensibility of command and
obedience that begins with the family and merely reaches its most visible
social form in the factory, bureaucracy and military. I cannot emphasise too
strongly that these problems emerged long before capitalism."_ However,
capitalism is the dominant economic form today and so the _"modern urban
crisis largely reflects the divisions that capitalism has produced between
society and nature."_ [**Op. Cit.**, p. 29 and p. 28]

Capitalism, unlike previous class and hierarchical systems, has an
expansionist nature which makes it incompatible with the planet's ecology. So
it is important to stress that capitalism must be **eliminated** because it
**cannot** reform itself so as to become "environment friendly," contrary to
the claims of so-called "green" capitalists. This is because _"[c]apitalism
not only validates precapitalist notions of the domination of nature, . . . it
turns the plunder of nature into society's law of life. To quibble with this
kind of system about its values, to try to frighten it with visions about the
consequences of growth is to quarrel with its very metabolism. One might more
easily persuade a green plant to desist from photosynthesis than to ask the
bourgeois economy to desist from capital accumulation."_ [**Op. Cit.**, p. 66]

Thus capitalism causes ecological destruction because it is based upon
domination (of human over human and so humanity over nature) and continual,
endless growth (for without growth, capitalism would die). This can be seen
from the fact that industrial production has increased fifty fold between 1950
and the 1990s. Obviously such expansion in a finite environment cannot go on
indefinitely without disastrous consequences. Yet it is impossible **in
principle** for capitalism to kick its addiction to growth. It is important to
understand why.

Capitalism is based on production for profit. In order to stay profitable, a
firm needs to make a profit. In other words, money must become more money.
This can be done in two ways. Firstly, a firm can produce new goods, either in
response to an existing need or (by means of advertising) by creating a new
one. Secondly, by producing a new good more cheaply than other firms in the
same industry in order to successfully compete. If one firm increases its
productivity (as all firms must try to do), it will be able to produce more
cheaply, thus undercutting its competition and capturing more market share
(until eventually it forces less profitable firms into bankruptcy). Hence,
constantly increasing productivity is essential for survival.

There are two ways to increase productivity, either by passing on costs to
third parties (externalities) or by investing in new means of production. The
former involves, for example, polluting the surrounding environment or
increasing the exploitation of workers (e.g. longer hours and/or more intense
work for the same amount of pay). The latter involves introducing new
technologies that reduce the amount of labour necessary to produce the same
product or service. Due to the struggle of workers to prevent increases in the
level of their exploitation and by citizens to stop pollution, new
technologies are usually the main way that productivity is increased under
capitalism (though of course capitalists are always looking for ways to avoid
regulations and to increase the exploitation of workers on a given technology
by other means as well).

But new technologies are expensive, which means that in order to pay for
continuous upgrades, a firm must continually sell **more** of what it
produces, and so must keep expanding its capital. To stay in the same place
under capitalism is to tempt crisis -- thus a firm must always strive for more
profits and thus must always expand and invest. In order to survive, a firm
must constantly expand and upgrade its capital and production levels so it can
sell enough to **keep** expanding and upgrading its capital -- i.e. "grow or
die," or _"production for the sake of production"_ (to user Marx's term). This
means that the accumulation of capital is at the heart of the system and so it
is impossible in principle for capitalism to solve the ecological crisis,
because "grow or die" is inherent in its nature:

> _"To speak of 'limits to growth' under a capitalistic market economy is as
meaningless as to speak of limits of warfare under a warrior society. The
moral pieties, that are voiced today by many well-meaning environmentalists,
are as naive as the moral pieties of multinationals are manipulative.
Capitalism can no more be 'persuaded' to limit growth than a human being can
be 'persuaded' to stop breathing. Attempts to 'green' capitalism, to make it
'ecological', are doomed by the very nature of the system as a system of
endless growth."_ [Bookchin, **Remaking Society**, pp. 93-94]

As long as capitalism exists, it will **necessarily** continue its _"endless
devouring of nature,"_ until it removes the _"organic preconditions for human
life."_ For this reason there can be no compromise with capitalism: We must
destroy it before it destroys us. And time is running out.

Capitalists, of course, do not accept this conclusion. Many simply ignore the
evidence or view the situation through rose-coloured spectacles, maintaining
that ecological problems are not as serious as they seem or that science will
find a way to solve them before it's too late. Some are aware of the problem,
but they fail to understand its roots and, as such, advocate reforms which are
based on either regulation or (more usually in these neo-liberal days) on
"market" based solutions. In [section E](secEcon.md) we will show why these
arguments are unsound and why libertarian socialism is our best hope for
preventing ecological catastrophe.

[‹ D.3 How does wealth influence the mass media?](secD3.md "Go to previous
page" ) [up](secDcon.md "Go to parent page" ) [D.5 What causes imperialism?
›](secD5.md "Go to next page" )

