/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "includes.h"

/* someday this function will parse the output appropriately			*/
int parse_pmsg() {
	int i;
	char *t_pmsg = NULL;
	/* make string == event.pmsg						*/
	char *str = event.pmsg;
	
	/* we should never wind up 8 times the length of the original event	*/
	t_pmsg = malloc(strlen(event.pmsg) * 8);
	bzero(t_pmsg, (strlen(event.pmsg) * 8));	

	/* void all colors that may be left over from last event		*/
	strcpy(t_pmsg, color.end);
	
	/* here is our main parsing loop; we'll run through the message, replacing \033 escapes	*/
	/* with the appropriate color.* relevant to the current output module			*/
	for(i = 0 ; str[i] != '\0'; ++i) {
		if(str[i] == '\033') {
			++i;
			switch(str[i]) {
				case '!':
					strcat(t_pmsg, color.beep);
					break;
				case 'r':
					strcat(t_pmsg, color.red);
					break;
				case 'R':
					strcat(t_pmsg, color.brightred);
					break;
				case 'g':
					strcat(t_pmsg, color.green);
					break;
				case 'G':
					strcat(t_pmsg, color.brightgreen);
					break;
				case 'y':
					strcat(t_pmsg, color.yellow);
					break;
				case 'Y':
					strcat(t_pmsg, color.brightyellow);
					break;
				case 'd':
					strcat(t_pmsg, color.dimwhite);
					break;
				case 'l':
					strcat(t_pmsg, color.dimwhite);
					break;
				case 'w':
					strcat(t_pmsg, color.white);
					break;
				case 'W':
					strcat(t_pmsg, color.brightwhite);
					break;
				case 'b':
					strcat(t_pmsg, color.blue);
					break;
				case 'B':
					strcat(t_pmsg, color.brightblue);
					break;
				case 'm':
					strcat(t_pmsg, color.magenta);
					break;
				case 'M':
					strcat(t_pmsg, color.brightmagenta);
					break;
				case 'c':
					strcat(t_pmsg, color.cyan);
					break;
				case 'C':
					strcat(t_pmsg, color.brightcyan);
					break;
				case 'u':
					strcat(t_pmsg, color.unknown);
					break;
				case 'e':
					strcat(t_pmsg, color.end);
					break;
				
				default: 
					/* oops, not one of our escape sequences 	*/
					/* we better rewind and just copy as-is		*/
					--i;
					sprintf(t_pmsg, "%s%c", t_pmsg, str[i]);
					break;
			}
		} else {
			/* just copy the existing string + the new char into t_pmsg)	*/
			sprintf(t_pmsg, "%s%c", t_pmsg,str[i]);
			/* ugly and inefficient programaticly*/
		}
	}
	/* make sure color is reset to default				*/
	strcat(t_pmsg, color.end);
	/* put what we got back into event.pmsg for output module	*/
	strcpy(event.pmsg, t_pmsg);
	/* free our t_pmsg						*/
	free(t_pmsg);
	return 0;
}
