/*
 * Copyright (C) 2020 Uniontech Technology Co., Ltd.
 *
 * Author:     xinbo wang <wangxinbo@uniontech.com>
 *
 * Maintainer: xinbo wang <wangxinbo@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef DTK_WMJACK_WAYLAND_H
#define DTK_WMJACK_WAYLAND_H

#ifdef __cplusplus
extern "C" {
#endif

#include "dtk_wmjack_p.h"

/**
 * @brief init wayland display content
 */
int wInitWmJack();

/**
 * @brief destory wayland display content
 */
void wDestoryWmJack();

/**
 * @brief Maximize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int wMaximizeWindow(WindowId wid);

/**
 * @brief Minimize Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int wMinimizeWindow(WindowId wid);

/**
 * @brief Restore Window.
 * @param wid: window ID
 * @return 0 success, -1 failure
 */
int wRestoreWindow(WindowId wid);

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
char *wGetWindowText(WindowId wid);

/**
 * @brief Get Window Size.
 * @param wid: window ID
 * @return x:-1,y:-1 failure, otherwise success
 */
Size wGetWindowSize(WindowId wid);

/**
 * @brief Get Window Position.
 * @param wid: window ID
 * @return w:-1,h:-1 failure, otherwise success
 */
Position wGetWindowPosition(WindowId wid);

/**
 * @brief Get Active Window ID.
 * @return 0 failure, otherwise success
 */
WindowId wGetActiveWindowID();

/**
 * @brief Get Desktop Window ID.
 * @return 0 failure, otherwise success
 */
WindowId wGetDesktopWindowID();

/**
 * @brief Get Window Title.
 * @param wid: window ID
 * @param pChildIDs: child data
 * @return -1 failure, otherwise success
 */
int wGetWindowChildren(WindowId wid, WindowId **pChildIDs);

/**
 * @brief Get Mouse Position.
 * @return w:-1,h:-1 failure, otherwise success
 */
Position wGetPointerPosition();

/**
 * @brief free data.
 * @param windownlist: windowlist
 */
void wFreeWindowList(WindowId *windownlist);

/**
 * @brief get all windows states
 */
struct dtk_array *wGetAllWindowStates();

/**
 * @brief get Window State
 * @param windowId window id
 * @return window state
 */
WindowState *wGetWindowState(WindowId wid);

/**
 * @brief Get Window PID.
 * @param wid: window ID
 * @return -1 failure, otherwise success
 */
int wGetWindowPID(WindowId wid);

WindowId wGetWindowFromPoint();

void wShowSplitMenu(int x, int y, int width, int height, WindowId wid);

void wHideSplitMenu(bool delay, WindowId wid);

char *wGetRendererString();

WindowState wGetSpecificWindowState(uint32_t wid);

int wGetAllWindowStatesList(WindowState **states);

#ifdef __cplusplus
}
#endif

#endif