Minutes from 22nd OpenVDB TSC meeting, June 27, 2019

Attendees: *Nick* A., *Dan* B., *Jeff* L., *Ken* M.

Additional Attendees: John Mertic (LF), Sean McPherson (Intel)

Absent: *Peter* C.

Agenda:

1) Quorum
2) Secretary
3)  CII Best Practices / TAC CI meeting
3b) CLA Process
4) Quick PR Review
5) Lambdas and ValueAccessors
Unplanned) Regression Tests
6) H18 + ABI=6
7) GCC and Dual ABI 
8) Metadata and .bgeo 
9) Next Meeting

1) Quorum was confirmed.

2) Secretary was Dan Bailey

3) CII Best Practices / TAC CI meeting

Making progress towards migration to Azure CI. A CMake issue with GLFW arose
from the transition from Ubuntu to CentOS 7. PR has just been merged that
addresses this. Waiting on Andrew from LF to setup authentication to produce
official ASWF images, then we'll add VFX 2019 CI using Azure.

Next steps will be adopting a similar CI workflow for VFX 2018 and VFX 2017.
Outstanding item relating to how to handle a Docker image with Houdini in it.
This is a legal issue, not a technical issue as these images cannot be public,
otherwise users can access the Houdini HDK without signing the EULA. One
approach is to use a private repository, Dan has experimented with this and it
works well. However as brought up in the CI meeting, this is sub-optimal because
it means that anyone using their own fork won't have access to a Houdini build
for testing. General agreement that there should be a better solution to this
problem. It was noted that the ASWF is actively investigating this and that the
LF has also looked into how to resolve this in the past. John to reach out to
Daniel Heckenberg to see if he can help with this effort. Current thinking is to
install Houdini HDK on every build so as to be able to complete the migration
from Circle to Azure.

CII Best Practices was discussed in the CI working group meeting yesterday.
We're still missing a few areas. Dan has submitted a PR to add the security
mailing alias to the website, Peter asked for a minor tweak to the wording. Ken
has requested an edit to the security policy document and approved it, this has
been merged now. It was noted that other ASWF projects are interested in this
document.

A question was raised about some of the wording in the CII Best Practices and
John clarified that it is acceptable to mark Unmet or N/A to "Suggested" items.
Only "Must" items have to be marked Met. As a result should be possible to
ignore the dynamic analysis section for now as this is not mandatory. Worth
adding a comment to any items being marked Unmet though.

Still some issues with getting static analysis up-and-running. Dan speculated
that this might be a problem to run on every commit because our unit tests take
a long time to run with the code coverage flags enabled. Further discussion on
this issue put off until Dan has had a chance to properly investigate.

3b) CLA Process

DWA and DNeg have digitally signed CLAs. Still awaiting Weta, SideFX and ILM
before switching on the automated CLA checks. John to resend the CLA
instructions and clarified that the LF will be managing the CLAs once this
system is in place. OpenCue are using it, OpenColorIO haven't switched it on
yet.

4) Quick PR Review

477 - Dan to follow up with Ken offline, as there appears to be some older
commits attached to this PR. 474 - All feedback addressed, ready to be merged
once the CI passes. 459 - John's PR to add the maintainers file is failing the
CI, but not clear why. Merge anyway.

Other PRs require Peter's input so moved on from this agenda point.

5) Lambdas and ValueAccessors

Discussion following the recent email thread about how to use ValueAccessors
with lambdas. Ken highlighted that provided the ValueAccessor is being used for
a reasonable number of accesses, the extra performance cost of construction vs
copy construction is almost negligible. Ken pointed out that another typically
negligible performance penalty in the ValueAccessor is registering them with the
tree which can be optionally disabled.

Ken recounted that Peter's original objection was that a user of the library
would expect copy-construction to perform a copy. Changing this behavior
wouldn't be ideal. In general, no major concerns with changing the
copy-constructor of the ValueAccessor anyway, but some brief discussions about
alternatives that might be favored instead. Ultimately, no decision made on
this. Ken proposed we start out by doing some benchmarking.

Dan asked about whether using a hash map at the root node as well as an ordered
map for faster access performance would alleviate much of the need for the
ValueAccessor. Ken replied that this had been attempted in an earlier version of
VDB, but that std map performance is fast with a small data set. This is
typically the case with the root node due to the high fan-out factor.
Nonetheless, the ValueAccessor would still represent a performance increase over
a hash map.

All in agreement that there are a number of different patterns of how
ValueAccessors are used throughout the library and no clear recommendations. It
would be worth providing some guidelines and improving the consistency of how
this is done, particularly around the use of lambdas.

Unplanned) Regression Tests

Ken would like to see regression tests included in the library. Weta and SideFX
are both using regression tests that involve rendering images and using image
difference algorithms.

Nick raised that VDB hashing would be a useful feature to add to the library to
help with regression testing. Ticket to be made to track this as this has been
mentioned before.

6) H18 + ABI=6

Jeff mentioned that the H18 alpha does not yet have a version of OpenVDB with
ABI=6. The major sticking point is the issue with how to handle metadata (as
discussed in 8).

7) GCC and Dual ABI 

The VFX Reference Platform specifically states to use the old C++ ABI (defining
the compiler flag -D_GLIBCXX_USE_CXX11_ABI=0). As a result Houdini is shipped
using this ABI. An issue was reported on the OpenVDB forum where a user was
using a later version of GCC (or a later OS such as Fedora 23) which uses the
newer ABI by default. This was causing confusion because the OpenVDB core
library was built with the new ABI but failed in attempting to link against
Houdini which was built with the old ABI. We agreed that the best option would
be to explicitly define the compiler flag for the old ABI when building the core
library for Houdini.

8) Metadata and .bgeo 

Jeff has encountered a regression attempting to upgrade VDB for Houdini where
the VDB Clip SOP has started outputting file_ primitive attributes as a result
of a bug fix Peter made some time ago. The proposed solution here is to drop all
file_ metadata when reading from a .bgeo file. No concerns with this solution.

9) Next Meeting

July 11th 2019.  3pm-4pm EDT (GMT-4).
