// Code generated by smithy-go-codegen DO NOT EDIT.

package bedrockagent

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/bedrockagent/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Retrieves information about a version of a flow. For more information, see [Deploy a flow in Amazon Bedrock] in
// the Amazon Bedrock User Guide.
//
// [Deploy a flow in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-deploy.html
func (c *Client) GetFlowVersion(ctx context.Context, params *GetFlowVersionInput, optFns ...func(*Options)) (*GetFlowVersionOutput, error) {
	if params == nil {
		params = &GetFlowVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetFlowVersion", params, optFns, c.addOperationGetFlowVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetFlowVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetFlowVersionInput struct {

	// The unique identifier of the flow for which to get information.
	//
	// This member is required.
	FlowIdentifier *string

	// The version of the flow for which to get information.
	//
	// This member is required.
	FlowVersion *string

	noSmithyDocumentSerde
}

type GetFlowVersionOutput struct {

	// The Amazon Resource Name (ARN) of the flow.
	//
	// This member is required.
	Arn *string

	// The time at which the flow was created.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service role with permissions to create a
	// flow. For more information, see [Create a service role for flows in Amazon Bedrock]in the Amazon Bedrock User Guide.
	//
	// [Create a service role for flows in Amazon Bedrock]: https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html
	//
	// This member is required.
	ExecutionRoleArn *string

	// The unique identifier of the flow.
	//
	// This member is required.
	Id *string

	// The name of the flow version.
	//
	// This member is required.
	Name *string

	// The status of the flow.
	//
	// This member is required.
	Status types.FlowStatus

	// The version of the flow for which information was retrieved.
	//
	// This member is required.
	Version *string

	// The Amazon Resource Name (ARN) of the KMS key that the version of the flow is
	// encrypted with.
	CustomerEncryptionKeyArn *string

	// The definition of the nodes and connections between nodes in the flow.
	Definition *types.FlowDefinition

	// The description of the flow.
	Description *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetFlowVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetFlowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetFlowVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetFlowVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpGetFlowVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetFlowVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opGetFlowVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetFlowVersion",
	}
}
