% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{html_esc}
\alias{html_esc}
\title{Escape Characters With Special HTML Meaning}
\usage{
html_esc(x)
}
\arguments{
\item{x}{character vector}
}
\value{
\code{x}, but with "<", ">", "&", "'", and "\"" characters replaced by
their HTML entity codes, and Encoding set to UTF-8.
}
\description{
Arbitrary text may contain characters with special meaning in HTML, which may
cause HTML display to be corrupted if they are included unescaped in a web
page.  This function escapes those special characters so they do not
interfere with the HTML markup generated by e.g. \code{\link{sgr_to_html}}.
}
\examples{
html_esc("day > night")
html_esc("<SPAN>hello world</SPAN>")
}
\seealso{
Other HTML functions: 
\code{\link{in_html}()},
\code{\link{make_styles}()},
\code{\link{sgr_to_html}()}
}
\concept{HTML functions}
