// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Atom, AxisFlags, AxisUse, DeviceManager, DeviceTool, DeviceType, Display, InputMode,
    InputSource, ModifierType, Screen, Seat, Window,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GdkDevice")]
    pub struct Device(Object<ffi::GdkDevice>);

    match fn {
        type_ => || ffi::gdk_device_get_type(),
    }
}

impl Device {
    pub const NONE: Option<&'static Device> = None;
}

pub trait DeviceExt: 'static {
    #[doc(alias = "gdk_device_get_associated_device")]
    #[doc(alias = "get_associated_device")]
    #[must_use]
    fn associated_device(&self) -> Option<Device>;

    #[doc(alias = "gdk_device_get_axes")]
    #[doc(alias = "get_axes")]
    fn axes(&self) -> AxisFlags;

    //#[doc(alias = "gdk_device_get_axis")]
    //#[doc(alias = "get_axis")]
    //fn axis(&self, axes: &[f64], use_: AxisUse) -> Option<f64>;

    #[doc(alias = "gdk_device_get_axis_use")]
    #[doc(alias = "get_axis_use")]
    fn axis_use(&self, index_: u32) -> AxisUse;

    //#[doc(alias = "gdk_device_get_axis_value")]
    //#[doc(alias = "get_axis_value")]
    //fn axis_value(&self, axes: &[f64], axis_label: &Atom) -> Option<f64>;

    #[doc(alias = "gdk_device_get_device_type")]
    #[doc(alias = "get_device_type")]
    fn device_type(&self) -> DeviceType;

    #[doc(alias = "gdk_device_get_display")]
    #[doc(alias = "get_display")]
    fn display(&self) -> Display;

    #[doc(alias = "gdk_device_get_has_cursor")]
    #[doc(alias = "get_has_cursor")]
    fn has_cursor(&self) -> bool;

    #[doc(alias = "gdk_device_get_key")]
    #[doc(alias = "get_key")]
    fn key(&self, index_: u32) -> Option<(u32, ModifierType)>;

    #[doc(alias = "gdk_device_get_last_event_window")]
    #[doc(alias = "get_last_event_window")]
    fn last_event_window(&self) -> Option<Window>;

    #[doc(alias = "gdk_device_get_mode")]
    #[doc(alias = "get_mode")]
    fn mode(&self) -> InputMode;

    #[doc(alias = "gdk_device_get_n_axes")]
    #[doc(alias = "get_n_axes")]
    fn n_axes(&self) -> i32;

    #[doc(alias = "gdk_device_get_n_keys")]
    #[doc(alias = "get_n_keys")]
    fn n_keys(&self) -> i32;

    #[doc(alias = "gdk_device_get_name")]
    #[doc(alias = "get_name")]
    fn name(&self) -> Option<glib::GString>;

    #[doc(alias = "gdk_device_get_position")]
    #[doc(alias = "get_position")]
    fn position(&self) -> (Screen, i32, i32);

    #[doc(alias = "gdk_device_get_position_double")]
    #[doc(alias = "get_position_double")]
    fn position_double(&self) -> (Screen, f64, f64);

    #[doc(alias = "gdk_device_get_product_id")]
    #[doc(alias = "get_product_id")]
    fn product_id(&self) -> Option<glib::GString>;

    #[doc(alias = "gdk_device_get_seat")]
    #[doc(alias = "get_seat")]
    fn seat(&self) -> Option<Seat>;

    #[doc(alias = "gdk_device_get_source")]
    #[doc(alias = "get_source")]
    fn source(&self) -> InputSource;

    //#[doc(alias = "gdk_device_get_state")]
    //#[doc(alias = "get_state")]
    //fn state(&self, window: &Window, axes: &[f64]) -> ModifierType;

    #[doc(alias = "gdk_device_get_vendor_id")]
    #[doc(alias = "get_vendor_id")]
    fn vendor_id(&self) -> Option<glib::GString>;

    #[doc(alias = "gdk_device_get_window_at_position")]
    #[doc(alias = "get_window_at_position")]
    fn window_at_position(&self) -> (Option<Window>, i32, i32);

    #[doc(alias = "gdk_device_get_window_at_position_double")]
    #[doc(alias = "get_window_at_position_double")]
    fn window_at_position_double(&self) -> (Option<Window>, f64, f64);

    #[doc(alias = "gdk_device_list_axes")]
    fn list_axes(&self) -> Vec<Atom>;

    #[doc(alias = "gdk_device_list_slave_devices")]
    fn list_slave_devices(&self) -> Vec<Device>;

    #[doc(alias = "gdk_device_set_axis_use")]
    fn set_axis_use(&self, index_: u32, use_: AxisUse);

    #[doc(alias = "gdk_device_set_key")]
    fn set_key(&self, index_: u32, keyval: u32, modifiers: ModifierType);

    #[doc(alias = "gdk_device_set_mode")]
    fn set_mode(&self, mode: InputMode) -> bool;

    #[doc(alias = "gdk_device_warp")]
    fn warp(&self, screen: &Screen, x: i32, y: i32);

    #[doc(alias = "device-manager")]
    fn device_manager(&self) -> Option<DeviceManager>;

    #[doc(alias = "input-mode")]
    fn input_mode(&self) -> InputMode;

    #[doc(alias = "input-mode")]
    fn set_input_mode(&self, input_mode: InputMode);

    #[doc(alias = "input-source")]
    fn input_source(&self) -> InputSource;

    #[doc(alias = "num-touches")]
    fn num_touches(&self) -> u32;

    fn set_seat<P: IsA<Seat>>(&self, seat: Option<&P>);

    fn tool(&self) -> Option<DeviceTool>;

    #[doc(alias = "type")]
    fn type_(&self) -> DeviceType;

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tool-changed")]
    fn connect_tool_changed<F: Fn(&Self, &DeviceTool) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "associated-device")]
    fn connect_associated_device_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "axes")]
    fn connect_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "input-mode")]
    fn connect_input_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "n-axes")]
    fn connect_n_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "seat")]
    fn connect_seat_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "tool")]
    fn connect_tool_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "type")]
    fn connect_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Device>> DeviceExt for O {
    fn associated_device(&self) -> Option<Device> {
        unsafe {
            from_glib_none(ffi::gdk_device_get_associated_device(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn axes(&self) -> AxisFlags {
        unsafe { from_glib(ffi::gdk_device_get_axes(self.as_ref().to_glib_none().0)) }
    }

    //fn axis(&self, axes: &[f64], use_: AxisUse) -> Option<f64> {
    //    unsafe { TODO: call ffi:gdk_device_get_axis() }
    //}

    fn axis_use(&self, index_: u32) -> AxisUse {
        unsafe {
            from_glib(ffi::gdk_device_get_axis_use(
                self.as_ref().to_glib_none().0,
                index_,
            ))
        }
    }

    //fn axis_value(&self, axes: &[f64], axis_label: &Atom) -> Option<f64> {
    //    unsafe { TODO: call ffi:gdk_device_get_axis_value() }
    //}

    fn device_type(&self) -> DeviceType {
        unsafe {
            from_glib(ffi::gdk_device_get_device_type(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn display(&self) -> Display {
        unsafe { from_glib_none(ffi::gdk_device_get_display(self.as_ref().to_glib_none().0)) }
    }

    fn has_cursor(&self) -> bool {
        unsafe {
            from_glib(ffi::gdk_device_get_has_cursor(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn key(&self, index_: u32) -> Option<(u32, ModifierType)> {
        unsafe {
            let mut keyval = mem::MaybeUninit::uninit();
            let mut modifiers = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::gdk_device_get_key(
                self.as_ref().to_glib_none().0,
                index_,
                keyval.as_mut_ptr(),
                modifiers.as_mut_ptr(),
            ));
            if ret {
                Some((keyval.assume_init(), from_glib(modifiers.assume_init())))
            } else {
                None
            }
        }
    }

    fn last_event_window(&self) -> Option<Window> {
        unsafe {
            from_glib_none(ffi::gdk_device_get_last_event_window(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn mode(&self) -> InputMode {
        unsafe { from_glib(ffi::gdk_device_get_mode(self.as_ref().to_glib_none().0)) }
    }

    fn n_axes(&self) -> i32 {
        unsafe { ffi::gdk_device_get_n_axes(self.as_ref().to_glib_none().0) }
    }

    fn n_keys(&self) -> i32 {
        unsafe { ffi::gdk_device_get_n_keys(self.as_ref().to_glib_none().0) }
    }

    fn name(&self) -> Option<glib::GString> {
        unsafe { from_glib_none(ffi::gdk_device_get_name(self.as_ref().to_glib_none().0)) }
    }

    fn position(&self) -> (Screen, i32, i32) {
        unsafe {
            let mut screen = ptr::null_mut();
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gdk_device_get_position(
                self.as_ref().to_glib_none().0,
                &mut screen,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (from_glib_none(screen), x.assume_init(), y.assume_init())
        }
    }

    fn position_double(&self) -> (Screen, f64, f64) {
        unsafe {
            let mut screen = ptr::null_mut();
            let mut x = mem::MaybeUninit::uninit();
            let mut y = mem::MaybeUninit::uninit();
            ffi::gdk_device_get_position_double(
                self.as_ref().to_glib_none().0,
                &mut screen,
                x.as_mut_ptr(),
                y.as_mut_ptr(),
            );
            (from_glib_none(screen), x.assume_init(), y.assume_init())
        }
    }

    fn product_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gdk_device_get_product_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn seat(&self) -> Option<Seat> {
        unsafe { from_glib_none(ffi::gdk_device_get_seat(self.as_ref().to_glib_none().0)) }
    }

    fn source(&self) -> InputSource {
        unsafe { from_glib(ffi::gdk_device_get_source(self.as_ref().to_glib_none().0)) }
    }

    //fn state(&self, window: &Window, axes: &[f64]) -> ModifierType {
    //    unsafe { TODO: call ffi:gdk_device_get_state() }
    //}

    fn vendor_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gdk_device_get_vendor_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn window_at_position(&self) -> (Option<Window>, i32, i32) {
        unsafe {
            let mut win_x = mem::MaybeUninit::uninit();
            let mut win_y = mem::MaybeUninit::uninit();
            let ret = from_glib_none(ffi::gdk_device_get_window_at_position(
                self.as_ref().to_glib_none().0,
                win_x.as_mut_ptr(),
                win_y.as_mut_ptr(),
            ));
            (ret, win_x.assume_init(), win_y.assume_init())
        }
    }

    fn window_at_position_double(&self) -> (Option<Window>, f64, f64) {
        unsafe {
            let mut win_x = mem::MaybeUninit::uninit();
            let mut win_y = mem::MaybeUninit::uninit();
            let ret = from_glib_none(ffi::gdk_device_get_window_at_position_double(
                self.as_ref().to_glib_none().0,
                win_x.as_mut_ptr(),
                win_y.as_mut_ptr(),
            ));
            (ret, win_x.assume_init(), win_y.assume_init())
        }
    }

    fn list_axes(&self) -> Vec<Atom> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_device_list_axes(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn list_slave_devices(&self) -> Vec<Device> {
        unsafe {
            FromGlibPtrContainer::from_glib_container(ffi::gdk_device_list_slave_devices(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn set_axis_use(&self, index_: u32, use_: AxisUse) {
        unsafe {
            ffi::gdk_device_set_axis_use(self.as_ref().to_glib_none().0, index_, use_.into_glib());
        }
    }

    fn set_key(&self, index_: u32, keyval: u32, modifiers: ModifierType) {
        unsafe {
            ffi::gdk_device_set_key(
                self.as_ref().to_glib_none().0,
                index_,
                keyval,
                modifiers.into_glib(),
            );
        }
    }

    fn set_mode(&self, mode: InputMode) -> bool {
        unsafe {
            from_glib(ffi::gdk_device_set_mode(
                self.as_ref().to_glib_none().0,
                mode.into_glib(),
            ))
        }
    }

    fn warp(&self, screen: &Screen, x: i32, y: i32) {
        unsafe {
            ffi::gdk_device_warp(
                self.as_ref().to_glib_none().0,
                screen.to_glib_none().0,
                x,
                y,
            );
        }
    }

    fn device_manager(&self) -> Option<DeviceManager> {
        glib::ObjectExt::property(self.as_ref(), "device-manager")
    }

    fn input_mode(&self) -> InputMode {
        glib::ObjectExt::property(self.as_ref(), "input-mode")
    }

    fn set_input_mode(&self, input_mode: InputMode) {
        glib::ObjectExt::set_property(self.as_ref(), "input-mode", input_mode)
    }

    fn input_source(&self) -> InputSource {
        glib::ObjectExt::property(self.as_ref(), "input-source")
    }

    fn num_touches(&self) -> u32 {
        glib::ObjectExt::property(self.as_ref(), "num-touches")
    }

    fn set_seat<P: IsA<Seat>>(&self, seat: Option<&P>) {
        glib::ObjectExt::set_property(self.as_ref(), "seat", seat)
    }

    fn tool(&self) -> Option<DeviceTool> {
        glib::ObjectExt::property(self.as_ref(), "tool")
    }

    fn type_(&self) -> DeviceType {
        glib::ObjectExt::property(self.as_ref(), "type")
    }

    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tool_changed<F: Fn(&Self, &DeviceTool) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn tool_changed_trampoline<
            P: IsA<Device>,
            F: Fn(&P, &DeviceTool) + 'static,
        >(
            this: *mut ffi::GdkDevice,
            tool: *mut ffi::GdkDeviceTool,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                Device::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(tool),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"tool-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    tool_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_associated_device_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_associated_device_trampoline<
            P: IsA<Device>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::associated-device\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_associated_device_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_axes_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::axes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_axes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_input_mode_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_input_mode_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::input-mode\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_input_mode_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_n_axes_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_n_axes_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::n-axes\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_n_axes_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_seat_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_seat_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::seat\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_seat_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_tool_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tool_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::tool\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_tool_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_type_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_type_trampoline<P: IsA<Device>, F: Fn(&P) + 'static>(
            this: *mut ffi::GdkDevice,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(Device::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::type\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_type_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for Device {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Device")
    }
}
