// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{
    Align, Bin, Buildable, CellArea, CellEditable, CellLayout, Container, ResizeMode, ScrollType,
    SensitivityType, TreeIter, TreeModel, Widget,
};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem::transmute};

glib::wrapper! {
    #[doc(alias = "GtkComboBox")]
    pub struct ComboBox(Object<ffi::GtkComboBox, ffi::GtkComboBoxClass>) @extends Bin, Container, Widget, @implements Buildable, CellEditable, CellLayout;

    match fn {
        type_ => || ffi::gtk_combo_box_get_type(),
    }
}

impl ComboBox {
    pub const NONE: Option<&'static ComboBox> = None;

    #[doc(alias = "gtk_combo_box_new")]
    pub fn new() -> ComboBox {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_combo_box_new()).unsafe_cast() }
    }

    #[doc(alias = "gtk_combo_box_new_with_area")]
    #[doc(alias = "new_with_area")]
    pub fn with_area(area: &impl IsA<CellArea>) -> ComboBox {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_combo_box_new_with_area(
                area.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_combo_box_new_with_area_and_entry")]
    #[doc(alias = "new_with_area_and_entry")]
    pub fn with_area_and_entry(area: &impl IsA<CellArea>) -> ComboBox {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_combo_box_new_with_area_and_entry(
                area.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_combo_box_new_with_entry")]
    #[doc(alias = "new_with_entry")]
    pub fn with_entry() -> ComboBox {
        assert_initialized_main_thread!();
        unsafe { Widget::from_glib_none(ffi::gtk_combo_box_new_with_entry()).unsafe_cast() }
    }

    #[doc(alias = "gtk_combo_box_new_with_model")]
    #[doc(alias = "new_with_model")]
    pub fn with_model(model: &impl IsA<TreeModel>) -> ComboBox {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_combo_box_new_with_model(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    #[doc(alias = "gtk_combo_box_new_with_model_and_entry")]
    #[doc(alias = "new_with_model_and_entry")]
    pub fn with_model_and_entry(model: &impl IsA<TreeModel>) -> ComboBox {
        skip_assert_initialized!();
        unsafe {
            Widget::from_glib_none(ffi::gtk_combo_box_new_with_model_and_entry(
                model.as_ref().to_glib_none().0,
            ))
            .unsafe_cast()
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`ComboBox`] objects.
    ///
    /// This method returns an instance of [`ComboBoxBuilder`](crate::builders::ComboBoxBuilder) which can be used to create [`ComboBox`] objects.
    pub fn builder() -> ComboBoxBuilder {
        ComboBoxBuilder::new()
    }
}

impl Default for ComboBox {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`ComboBox`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct ComboBoxBuilder {
    builder: glib::object::ObjectBuilder<'static, ComboBox>,
}

impl ComboBoxBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn active(self, active: i32) -> Self {
        Self {
            builder: self.builder.property("active", active),
        }
    }

    pub fn active_id(self, active_id: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("active-id", active_id.into()),
        }
    }

    pub fn button_sensitivity(self, button_sensitivity: SensitivityType) -> Self {
        Self {
            builder: self
                .builder
                .property("button-sensitivity", button_sensitivity),
        }
    }

    pub fn cell_area(self, cell_area: &impl IsA<CellArea>) -> Self {
        Self {
            builder: self
                .builder
                .property("cell-area", cell_area.clone().upcast()),
        }
    }

    pub fn column_span_column(self, column_span_column: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("column-span-column", column_span_column),
        }
    }

    pub fn entry_text_column(self, entry_text_column: i32) -> Self {
        Self {
            builder: self
                .builder
                .property("entry-text-column", entry_text_column),
        }
    }

    pub fn has_entry(self, has_entry: bool) -> Self {
        Self {
            builder: self.builder.property("has-entry", has_entry),
        }
    }

    pub fn has_frame(self, has_frame: bool) -> Self {
        Self {
            builder: self.builder.property("has-frame", has_frame),
        }
    }

    pub fn id_column(self, id_column: i32) -> Self {
        Self {
            builder: self.builder.property("id-column", id_column),
        }
    }

    pub fn model(self, model: &impl IsA<TreeModel>) -> Self {
        Self {
            builder: self.builder.property("model", model.clone().upcast()),
        }
    }

    pub fn popup_fixed_width(self, popup_fixed_width: bool) -> Self {
        Self {
            builder: self
                .builder
                .property("popup-fixed-width", popup_fixed_width),
        }
    }

    pub fn row_span_column(self, row_span_column: i32) -> Self {
        Self {
            builder: self.builder.property("row-span-column", row_span_column),
        }
    }

    pub fn wrap_width(self, wrap_width: i32) -> Self {
        Self {
            builder: self.builder.property("wrap-width", wrap_width),
        }
    }

    pub fn border_width(self, border_width: u32) -> Self {
        Self {
            builder: self.builder.property("border-width", border_width),
        }
    }

    pub fn child(self, child: &impl IsA<Widget>) -> Self {
        Self {
            builder: self.builder.property("child", child.clone().upcast()),
        }
    }

    pub fn resize_mode(self, resize_mode: ResizeMode) -> Self {
        Self {
            builder: self.builder.property("resize-mode", resize_mode),
        }
    }

    pub fn app_paintable(self, app_paintable: bool) -> Self {
        Self {
            builder: self.builder.property("app-paintable", app_paintable),
        }
    }

    pub fn can_default(self, can_default: bool) -> Self {
        Self {
            builder: self.builder.property("can-default", can_default),
        }
    }

    pub fn can_focus(self, can_focus: bool) -> Self {
        Self {
            builder: self.builder.property("can-focus", can_focus),
        }
    }

    pub fn events(self, events: gdk::EventMask) -> Self {
        Self {
            builder: self.builder.property("events", events),
        }
    }

    pub fn expand(self, expand: bool) -> Self {
        Self {
            builder: self.builder.property("expand", expand),
        }
    }

    pub fn focus_on_click(self, focus_on_click: bool) -> Self {
        Self {
            builder: self.builder.property("focus-on-click", focus_on_click),
        }
    }

    pub fn halign(self, halign: Align) -> Self {
        Self {
            builder: self.builder.property("halign", halign),
        }
    }

    pub fn has_default(self, has_default: bool) -> Self {
        Self {
            builder: self.builder.property("has-default", has_default),
        }
    }

    pub fn has_focus(self, has_focus: bool) -> Self {
        Self {
            builder: self.builder.property("has-focus", has_focus),
        }
    }

    pub fn has_tooltip(self, has_tooltip: bool) -> Self {
        Self {
            builder: self.builder.property("has-tooltip", has_tooltip),
        }
    }

    pub fn height_request(self, height_request: i32) -> Self {
        Self {
            builder: self.builder.property("height-request", height_request),
        }
    }

    pub fn hexpand(self, hexpand: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand", hexpand),
        }
    }

    pub fn hexpand_set(self, hexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("hexpand-set", hexpand_set),
        }
    }

    pub fn is_focus(self, is_focus: bool) -> Self {
        Self {
            builder: self.builder.property("is-focus", is_focus),
        }
    }

    pub fn margin(self, margin: i32) -> Self {
        Self {
            builder: self.builder.property("margin", margin),
        }
    }

    pub fn margin_bottom(self, margin_bottom: i32) -> Self {
        Self {
            builder: self.builder.property("margin-bottom", margin_bottom),
        }
    }

    pub fn margin_end(self, margin_end: i32) -> Self {
        Self {
            builder: self.builder.property("margin-end", margin_end),
        }
    }

    pub fn margin_start(self, margin_start: i32) -> Self {
        Self {
            builder: self.builder.property("margin-start", margin_start),
        }
    }

    pub fn margin_top(self, margin_top: i32) -> Self {
        Self {
            builder: self.builder.property("margin-top", margin_top),
        }
    }

    pub fn name(self, name: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("name", name.into()),
        }
    }

    pub fn no_show_all(self, no_show_all: bool) -> Self {
        Self {
            builder: self.builder.property("no-show-all", no_show_all),
        }
    }

    pub fn opacity(self, opacity: f64) -> Self {
        Self {
            builder: self.builder.property("opacity", opacity),
        }
    }

    pub fn parent(self, parent: &impl IsA<Container>) -> Self {
        Self {
            builder: self.builder.property("parent", parent.clone().upcast()),
        }
    }

    pub fn receives_default(self, receives_default: bool) -> Self {
        Self {
            builder: self.builder.property("receives-default", receives_default),
        }
    }

    pub fn sensitive(self, sensitive: bool) -> Self {
        Self {
            builder: self.builder.property("sensitive", sensitive),
        }
    }

    pub fn tooltip_markup(self, tooltip_markup: impl Into<glib::GString>) -> Self {
        Self {
            builder: self
                .builder
                .property("tooltip-markup", tooltip_markup.into()),
        }
    }

    pub fn tooltip_text(self, tooltip_text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("tooltip-text", tooltip_text.into()),
        }
    }

    pub fn valign(self, valign: Align) -> Self {
        Self {
            builder: self.builder.property("valign", valign),
        }
    }

    pub fn vexpand(self, vexpand: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand", vexpand),
        }
    }

    pub fn vexpand_set(self, vexpand_set: bool) -> Self {
        Self {
            builder: self.builder.property("vexpand-set", vexpand_set),
        }
    }

    pub fn visible(self, visible: bool) -> Self {
        Self {
            builder: self.builder.property("visible", visible),
        }
    }

    pub fn width_request(self, width_request: i32) -> Self {
        Self {
            builder: self.builder.property("width-request", width_request),
        }
    }

    pub fn editing_canceled(self, editing_canceled: bool) -> Self {
        Self {
            builder: self.builder.property("editing-canceled", editing_canceled),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`ComboBox`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> ComboBox {
        self.builder.build()
    }
}

pub trait ComboBoxExt: 'static {
    #[doc(alias = "gtk_combo_box_get_active_id")]
    #[doc(alias = "get_active_id")]
    fn active_id(&self) -> Option<glib::GString>;

    #[doc(alias = "gtk_combo_box_get_active_iter")]
    #[doc(alias = "get_active_iter")]
    fn active_iter(&self) -> Option<TreeIter>;

    #[doc(alias = "gtk_combo_box_get_button_sensitivity")]
    #[doc(alias = "get_button_sensitivity")]
    fn button_sensitivity(&self) -> SensitivityType;

    #[doc(alias = "gtk_combo_box_get_column_span_column")]
    #[doc(alias = "get_column_span_column")]
    fn column_span_column(&self) -> i32;

    #[doc(alias = "gtk_combo_box_get_entry_text_column")]
    #[doc(alias = "get_entry_text_column")]
    fn entry_text_column(&self) -> i32;

    #[doc(alias = "gtk_combo_box_get_has_entry")]
    #[doc(alias = "get_has_entry")]
    fn has_entry(&self) -> bool;

    #[doc(alias = "gtk_combo_box_get_id_column")]
    #[doc(alias = "get_id_column")]
    fn id_column(&self) -> i32;

    #[doc(alias = "gtk_combo_box_get_model")]
    #[doc(alias = "get_model")]
    fn model(&self) -> Option<TreeModel>;

    #[doc(alias = "gtk_combo_box_get_popup_accessible")]
    #[doc(alias = "get_popup_accessible")]
    fn popup_accessible(&self) -> Option<atk::Object>;

    #[doc(alias = "gtk_combo_box_get_popup_fixed_width")]
    #[doc(alias = "get_popup_fixed_width")]
    fn is_popup_fixed_width(&self) -> bool;

    //#[doc(alias = "gtk_combo_box_get_row_separator_func")]
    //#[doc(alias = "get_row_separator_func")]
    //fn row_separator_func(&self) -> Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>>;

    #[doc(alias = "gtk_combo_box_get_row_span_column")]
    #[doc(alias = "get_row_span_column")]
    fn row_span_column(&self) -> i32;

    #[doc(alias = "gtk_combo_box_get_wrap_width")]
    #[doc(alias = "get_wrap_width")]
    fn wrap_width(&self) -> i32;

    #[doc(alias = "gtk_combo_box_popdown")]
    fn popdown(&self);

    #[doc(alias = "gtk_combo_box_popup")]
    fn popup(&self);

    #[doc(alias = "gtk_combo_box_popup_for_device")]
    fn popup_for_device(&self, device: &gdk::Device);

    #[doc(alias = "gtk_combo_box_set_active_id")]
    fn set_active_id(&self, active_id: Option<&str>) -> bool;

    #[doc(alias = "gtk_combo_box_set_active_iter")]
    fn set_active_iter(&self, iter: Option<&TreeIter>);

    #[doc(alias = "gtk_combo_box_set_button_sensitivity")]
    fn set_button_sensitivity(&self, sensitivity: SensitivityType);

    #[doc(alias = "gtk_combo_box_set_column_span_column")]
    fn set_column_span_column(&self, column_span: i32);

    #[doc(alias = "gtk_combo_box_set_entry_text_column")]
    fn set_entry_text_column(&self, text_column: i32);

    #[doc(alias = "gtk_combo_box_set_id_column")]
    fn set_id_column(&self, id_column: i32);

    #[doc(alias = "gtk_combo_box_set_model")]
    fn set_model(&self, model: Option<&impl IsA<TreeModel>>);

    #[doc(alias = "gtk_combo_box_set_popup_fixed_width")]
    fn set_popup_fixed_width(&self, fixed: bool);

    #[doc(alias = "gtk_combo_box_set_row_separator_func")]
    fn set_row_separator_func<P: Fn(&TreeModel, &TreeIter) -> bool + 'static>(&self, func: P);

    #[doc(alias = "gtk_combo_box_set_row_span_column")]
    fn set_row_span_column(&self, row_span: i32);

    #[doc(alias = "gtk_combo_box_set_wrap_width")]
    fn set_wrap_width(&self, width: i32);

    #[doc(alias = "cell-area")]
    fn cell_area(&self) -> Option<CellArea>;

    #[doc(alias = "has-frame")]
    fn has_frame(&self) -> bool;

    #[doc(alias = "has-frame")]
    fn set_has_frame(&self, has_frame: bool);

    #[doc(alias = "popup-shown")]
    fn is_popup_shown(&self) -> bool;

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "format-entry-text")]
    fn connect_format_entry_text<F: Fn(&Self, &str) -> String + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "move-active")]
    fn connect_move_active<F: Fn(&Self, ScrollType) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_move_active(&self, scroll_type: ScrollType);

    #[doc(alias = "popdown")]
    fn connect_popdown<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_popdown(&self) -> bool;

    #[doc(alias = "popup")]
    fn connect_popup<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    fn emit_popup(&self);

    #[doc(alias = "active")]
    fn connect_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "active-id")]
    fn connect_active_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "button-sensitivity")]
    fn connect_button_sensitivity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "column-span-column")]
    fn connect_column_span_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "entry-text-column")]
    fn connect_entry_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-frame")]
    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "id-column")]
    fn connect_id_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "model")]
    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-fixed-width")]
    fn connect_popup_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "popup-shown")]
    fn connect_popup_shown_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "row-span-column")]
    fn connect_row_span_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrap-width")]
    fn connect_wrap_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<ComboBox>> ComboBoxExt for O {
    fn active_id(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::gtk_combo_box_get_active_id(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn active_iter(&self) -> Option<TreeIter> {
        unsafe {
            let mut iter = TreeIter::uninitialized();
            let ret = from_glib(ffi::gtk_combo_box_get_active_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ));
            if ret {
                Some(iter)
            } else {
                None
            }
        }
    }

    fn button_sensitivity(&self) -> SensitivityType {
        unsafe {
            from_glib(ffi::gtk_combo_box_get_button_sensitivity(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn column_span_column(&self) -> i32 {
        unsafe { ffi::gtk_combo_box_get_column_span_column(self.as_ref().to_glib_none().0) }
    }

    fn entry_text_column(&self) -> i32 {
        unsafe { ffi::gtk_combo_box_get_entry_text_column(self.as_ref().to_glib_none().0) }
    }

    fn has_entry(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_combo_box_get_has_entry(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn id_column(&self) -> i32 {
        unsafe { ffi::gtk_combo_box_get_id_column(self.as_ref().to_glib_none().0) }
    }

    fn model(&self) -> Option<TreeModel> {
        unsafe { from_glib_none(ffi::gtk_combo_box_get_model(self.as_ref().to_glib_none().0)) }
    }

    fn popup_accessible(&self) -> Option<atk::Object> {
        unsafe {
            from_glib_none(ffi::gtk_combo_box_get_popup_accessible(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn is_popup_fixed_width(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_combo_box_get_popup_fixed_width(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    //fn row_separator_func(&self) -> Option<Box_<dyn Fn(&TreeModel, &TreeIter) -> bool + 'static>> {
    //    unsafe { TODO: call ffi:gtk_combo_box_get_row_separator_func() }
    //}

    fn row_span_column(&self) -> i32 {
        unsafe { ffi::gtk_combo_box_get_row_span_column(self.as_ref().to_glib_none().0) }
    }

    fn wrap_width(&self) -> i32 {
        unsafe { ffi::gtk_combo_box_get_wrap_width(self.as_ref().to_glib_none().0) }
    }

    fn popdown(&self) {
        unsafe {
            ffi::gtk_combo_box_popdown(self.as_ref().to_glib_none().0);
        }
    }

    fn popup(&self) {
        unsafe {
            ffi::gtk_combo_box_popup(self.as_ref().to_glib_none().0);
        }
    }

    fn popup_for_device(&self, device: &gdk::Device) {
        unsafe {
            ffi::gtk_combo_box_popup_for_device(
                self.as_ref().to_glib_none().0,
                device.to_glib_none().0,
            );
        }
    }

    fn set_active_id(&self, active_id: Option<&str>) -> bool {
        unsafe {
            from_glib(ffi::gtk_combo_box_set_active_id(
                self.as_ref().to_glib_none().0,
                active_id.to_glib_none().0,
            ))
        }
    }

    fn set_active_iter(&self, iter: Option<&TreeIter>) {
        unsafe {
            ffi::gtk_combo_box_set_active_iter(
                self.as_ref().to_glib_none().0,
                mut_override(iter.to_glib_none().0),
            );
        }
    }

    fn set_button_sensitivity(&self, sensitivity: SensitivityType) {
        unsafe {
            ffi::gtk_combo_box_set_button_sensitivity(
                self.as_ref().to_glib_none().0,
                sensitivity.into_glib(),
            );
        }
    }

    fn set_column_span_column(&self, column_span: i32) {
        unsafe {
            ffi::gtk_combo_box_set_column_span_column(self.as_ref().to_glib_none().0, column_span);
        }
    }

    fn set_entry_text_column(&self, text_column: i32) {
        unsafe {
            ffi::gtk_combo_box_set_entry_text_column(self.as_ref().to_glib_none().0, text_column);
        }
    }

    fn set_id_column(&self, id_column: i32) {
        unsafe {
            ffi::gtk_combo_box_set_id_column(self.as_ref().to_glib_none().0, id_column);
        }
    }

    fn set_model(&self, model: Option<&impl IsA<TreeModel>>) {
        unsafe {
            ffi::gtk_combo_box_set_model(
                self.as_ref().to_glib_none().0,
                model.map(|p| p.as_ref()).to_glib_none().0,
            );
        }
    }

    fn set_popup_fixed_width(&self, fixed: bool) {
        unsafe {
            ffi::gtk_combo_box_set_popup_fixed_width(
                self.as_ref().to_glib_none().0,
                fixed.into_glib(),
            );
        }
    }

    fn set_row_separator_func<P: Fn(&TreeModel, &TreeIter) -> bool + 'static>(&self, func: P) {
        let func_data: Box_<P> = Box_::new(func);
        unsafe extern "C" fn func_func<P: Fn(&TreeModel, &TreeIter) -> bool + 'static>(
            model: *mut ffi::GtkTreeModel,
            iter: *mut ffi::GtkTreeIter,
            data: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let model = from_glib_borrow(model);
            let iter = from_glib_borrow(iter);
            let callback: &P = &*(data as *mut _);
            (*callback)(&model, &iter).into_glib()
        }
        let func = Some(func_func::<P> as _);
        unsafe extern "C" fn destroy_func<P: Fn(&TreeModel, &TreeIter) -> bool + 'static>(
            data: glib::ffi::gpointer,
        ) {
            let _callback: Box_<P> = Box_::from_raw(data as *mut _);
        }
        let destroy_call3 = Some(destroy_func::<P> as _);
        let super_callback0: Box_<P> = func_data;
        unsafe {
            ffi::gtk_combo_box_set_row_separator_func(
                self.as_ref().to_glib_none().0,
                func,
                Box_::into_raw(super_callback0) as *mut _,
                destroy_call3,
            );
        }
    }

    fn set_row_span_column(&self, row_span: i32) {
        unsafe {
            ffi::gtk_combo_box_set_row_span_column(self.as_ref().to_glib_none().0, row_span);
        }
    }

    fn set_wrap_width(&self, width: i32) {
        unsafe {
            ffi::gtk_combo_box_set_wrap_width(self.as_ref().to_glib_none().0, width);
        }
    }

    fn cell_area(&self) -> Option<CellArea> {
        glib::ObjectExt::property(self.as_ref(), "cell-area")
    }

    fn has_frame(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "has-frame")
    }

    fn set_has_frame(&self, has_frame: bool) {
        glib::ObjectExt::set_property(self.as_ref(), "has-frame", has_frame)
    }

    fn is_popup_shown(&self) -> bool {
        glib::ObjectExt::property(self.as_ref(), "popup-shown")
    }

    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_format_entry_text<F: Fn(&Self, &str) -> String + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn format_entry_text_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P, &str) -> String + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            path: *mut libc::c_char,
            f: glib::ffi::gpointer,
        ) -> *mut libc::c_char {
            let f: &F = &*(f as *const F);
            f(
                ComboBox::from_glib_borrow(this).unsafe_cast_ref(),
                &glib::GString::from_glib_borrow(path),
            )
            .to_glib_full()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"format-entry-text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    format_entry_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_move_active<F: Fn(&Self, ScrollType) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn move_active_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P, ScrollType) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            scroll_type: ffi::GtkScrollType,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                ComboBox::from_glib_borrow(this).unsafe_cast_ref(),
                from_glib(scroll_type),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"move-active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    move_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_move_active(&self, scroll_type: ScrollType) {
        self.emit_by_name::<()>("move-active", &[&scroll_type]);
    }

    fn connect_popdown<F: Fn(&Self) -> bool + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn popdown_trampoline<P: IsA<ComboBox>, F: Fn(&P) -> bool + 'static>(
            this: *mut ffi::GtkComboBox,
            f: glib::ffi::gpointer,
        ) -> glib::ffi::gboolean {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref()).into_glib()
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"popdown\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    popdown_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_popdown(&self) -> bool {
        self.emit_by_name("popdown", &[])
    }

    fn connect_popup<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn popup_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"popup\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    popup_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn emit_popup(&self) {
        self.emit_by_name::<()>("popup", &[]);
    }

    fn connect_active_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::active\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_active_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_active_id_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_active_id_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::active-id\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_active_id_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_button_sensitivity_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_button_sensitivity_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::button-sensitivity\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_button_sensitivity_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_column_span_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_column_span_column_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::column-span-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_column_span_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_entry_text_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_entry_text_column_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::entry-text-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_entry_text_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_frame_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_frame_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-frame\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_frame_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_id_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_id_column_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::id-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_id_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_model_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_model_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::model\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_model_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_fixed_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_popup_fixed_width_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::popup-fixed-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_popup_fixed_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_popup_shown_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_popup_shown_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::popup-shown\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_popup_shown_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_row_span_column_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_row_span_column_trampoline<
            P: IsA<ComboBox>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::row-span-column\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_row_span_column_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_wrap_width_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_wrap_width_trampoline<P: IsA<ComboBox>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkComboBox,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(ComboBox::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::wrap-width\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_wrap_width_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for ComboBox {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("ComboBox")
    }
}
