// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Clipboard, TargetList, TextChildAnchor, TextIter, TextMark, TextTag, TextTagTable};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, fmt, mem, mem::transmute, ptr};

glib::wrapper! {
    #[doc(alias = "GtkTextBuffer")]
    pub struct TextBuffer(Object<ffi::GtkTextBuffer, ffi::GtkTextBufferClass>);

    match fn {
        type_ => || ffi::gtk_text_buffer_get_type(),
    }
}

impl TextBuffer {
    pub const NONE: Option<&'static TextBuffer> = None;

    #[doc(alias = "gtk_text_buffer_new")]
    pub fn new(table: Option<&impl IsA<TextTagTable>>) -> TextBuffer {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_new(
                table.map(|p| p.as_ref()).to_glib_none().0,
            ))
        }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`TextBuffer`] objects.
    ///
    /// This method returns an instance of [`TextBufferBuilder`](crate::builders::TextBufferBuilder) which can be used to create [`TextBuffer`] objects.
    pub fn builder() -> TextBufferBuilder {
        TextBufferBuilder::new()
    }
}

impl Default for TextBuffer {
    fn default() -> Self {
        glib::object::Object::new::<Self>()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`TextBuffer`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct TextBufferBuilder {
    builder: glib::object::ObjectBuilder<'static, TextBuffer>,
}

impl TextBufferBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    pub fn tag_table(self, tag_table: &impl IsA<TextTagTable>) -> Self {
        Self {
            builder: self
                .builder
                .property("tag-table", tag_table.clone().upcast()),
        }
    }

    pub fn text(self, text: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("text", text.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`TextBuffer`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> TextBuffer {
        self.builder.build()
    }
}

pub trait TextBufferExt: 'static {
    #[doc(alias = "gtk_text_buffer_add_mark")]
    fn add_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_add_selection_clipboard")]
    fn add_selection_clipboard(&self, clipboard: &Clipboard);

    #[doc(alias = "gtk_text_buffer_apply_tag")]
    fn apply_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_apply_tag_by_name")]
    fn apply_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_backspace")]
    fn backspace(&self, iter: &mut TextIter, interactive: bool, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_begin_user_action")]
    fn begin_user_action(&self);

    #[doc(alias = "gtk_text_buffer_copy_clipboard")]
    fn copy_clipboard(&self, clipboard: &Clipboard);

    #[doc(alias = "gtk_text_buffer_create_child_anchor")]
    fn create_child_anchor(&self, iter: &mut TextIter) -> Option<TextChildAnchor>;

    #[doc(alias = "gtk_text_buffer_create_mark")]
    fn create_mark(
        &self,
        mark_name: Option<&str>,
        where_: &TextIter,
        left_gravity: bool,
    ) -> Option<TextMark>;

    #[doc(alias = "gtk_text_buffer_cut_clipboard")]
    fn cut_clipboard(&self, clipboard: &Clipboard, default_editable: bool);

    #[doc(alias = "gtk_text_buffer_delete")]
    fn delete(&self, start: &mut TextIter, end: &mut TextIter);

    #[doc(alias = "gtk_text_buffer_delete_interactive")]
    fn delete_interactive(
        &self,
        start_iter: &mut TextIter,
        end_iter: &mut TextIter,
        default_editable: bool,
    ) -> bool;

    #[doc(alias = "gtk_text_buffer_delete_mark")]
    fn delete_mark(&self, mark: &impl IsA<TextMark>);

    #[doc(alias = "gtk_text_buffer_delete_mark_by_name")]
    fn delete_mark_by_name(&self, name: &str);

    #[doc(alias = "gtk_text_buffer_delete_selection")]
    fn delete_selection(&self, interactive: bool, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_deserialize")]
    fn deserialize(
        &self,
        content_buffer: &impl IsA<TextBuffer>,
        format: &gdk::Atom,
        iter: &mut TextIter,
        data: &[u8],
    ) -> Result<(), glib::Error>;

    #[doc(alias = "gtk_text_buffer_deserialize_get_can_create_tags")]
    fn deserialize_get_can_create_tags(&self, format: &gdk::Atom) -> bool;

    #[doc(alias = "gtk_text_buffer_deserialize_set_can_create_tags")]
    fn deserialize_set_can_create_tags(&self, format: &gdk::Atom, can_create_tags: bool);

    #[doc(alias = "gtk_text_buffer_end_user_action")]
    fn end_user_action(&self);

    #[doc(alias = "gtk_text_buffer_get_bounds")]
    #[doc(alias = "get_bounds")]
    fn bounds(&self) -> (TextIter, TextIter);

    #[doc(alias = "gtk_text_buffer_get_char_count")]
    #[doc(alias = "get_char_count")]
    fn char_count(&self) -> i32;

    #[doc(alias = "gtk_text_buffer_get_copy_target_list")]
    #[doc(alias = "get_copy_target_list")]
    fn copy_target_list(&self) -> Option<TargetList>;

    #[doc(alias = "gtk_text_buffer_get_deserialize_formats")]
    #[doc(alias = "get_deserialize_formats")]
    fn deserialize_formats(&self) -> Vec<gdk::Atom>;

    #[doc(alias = "gtk_text_buffer_get_end_iter")]
    #[doc(alias = "get_end_iter")]
    fn end_iter(&self) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_has_selection")]
    #[doc(alias = "get_has_selection")]
    fn has_selection(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_insert")]
    fn get_insert(&self) -> Option<TextMark>;

    #[doc(alias = "gtk_text_buffer_get_iter_at_child_anchor")]
    #[doc(alias = "get_iter_at_child_anchor")]
    fn iter_at_child_anchor(&self, anchor: &impl IsA<TextChildAnchor>) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line")]
    #[doc(alias = "get_iter_at_line")]
    fn iter_at_line(&self, line_number: i32) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line_index")]
    #[doc(alias = "get_iter_at_line_index")]
    fn iter_at_line_index(&self, line_number: i32, byte_index: i32) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_line_offset")]
    #[doc(alias = "get_iter_at_line_offset")]
    fn iter_at_line_offset(&self, line_number: i32, char_offset: i32) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_mark")]
    #[doc(alias = "get_iter_at_mark")]
    fn iter_at_mark(&self, mark: &impl IsA<TextMark>) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_iter_at_offset")]
    #[doc(alias = "get_iter_at_offset")]
    fn iter_at_offset(&self, char_offset: i32) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_line_count")]
    #[doc(alias = "get_line_count")]
    fn line_count(&self) -> i32;

    #[doc(alias = "gtk_text_buffer_get_mark")]
    #[doc(alias = "get_mark")]
    fn mark(&self, name: &str) -> Option<TextMark>;

    #[doc(alias = "gtk_text_buffer_get_modified")]
    #[doc(alias = "get_modified")]
    fn is_modified(&self) -> bool;

    #[doc(alias = "gtk_text_buffer_get_paste_target_list")]
    #[doc(alias = "get_paste_target_list")]
    fn paste_target_list(&self) -> Option<TargetList>;

    #[doc(alias = "gtk_text_buffer_get_selection_bound")]
    #[doc(alias = "get_selection_bound")]
    fn selection_bound(&self) -> Option<TextMark>;

    #[doc(alias = "gtk_text_buffer_get_selection_bounds")]
    #[doc(alias = "get_selection_bounds")]
    fn selection_bounds(&self) -> Option<(TextIter, TextIter)>;

    #[doc(alias = "gtk_text_buffer_get_serialize_formats")]
    #[doc(alias = "get_serialize_formats")]
    fn serialize_formats(&self) -> Vec<gdk::Atom>;

    #[doc(alias = "gtk_text_buffer_get_slice")]
    #[doc(alias = "get_slice")]
    fn slice(
        &self,
        start: &TextIter,
        end: &TextIter,
        include_hidden_chars: bool,
    ) -> Option<glib::GString>;

    #[doc(alias = "gtk_text_buffer_get_start_iter")]
    #[doc(alias = "get_start_iter")]
    fn start_iter(&self) -> TextIter;

    #[doc(alias = "gtk_text_buffer_get_tag_table")]
    #[doc(alias = "get_tag_table")]
    fn tag_table(&self) -> Option<TextTagTable>;

    #[doc(alias = "gtk_text_buffer_get_text")]
    #[doc(alias = "get_text")]
    fn text(
        &self,
        start: &TextIter,
        end: &TextIter,
        include_hidden_chars: bool,
    ) -> Option<glib::GString>;

    #[doc(alias = "gtk_text_buffer_insert")]
    fn insert(&self, iter: &mut TextIter, text: &str);

    #[doc(alias = "gtk_text_buffer_insert_at_cursor")]
    fn insert_at_cursor(&self, text: &str);

    #[doc(alias = "gtk_text_buffer_insert_child_anchor")]
    fn insert_child_anchor(&self, iter: &mut TextIter, anchor: &impl IsA<TextChildAnchor>);

    #[doc(alias = "gtk_text_buffer_insert_interactive")]
    fn insert_interactive(&self, iter: &mut TextIter, text: &str, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_insert_interactive_at_cursor")]
    fn insert_interactive_at_cursor(&self, text: &str, default_editable: bool) -> bool;

    #[doc(alias = "gtk_text_buffer_insert_markup")]
    fn insert_markup(&self, iter: &mut TextIter, markup: &str);

    #[doc(alias = "gtk_text_buffer_insert_pixbuf")]
    fn insert_pixbuf(&self, iter: &mut TextIter, pixbuf: &gdk_pixbuf::Pixbuf);

    #[doc(alias = "gtk_text_buffer_insert_range")]
    fn insert_range(&self, iter: &mut TextIter, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_insert_range_interactive")]
    fn insert_range_interactive(
        &self,
        iter: &mut TextIter,
        start: &TextIter,
        end: &TextIter,
        default_editable: bool,
    ) -> bool;

    //#[doc(alias = "gtk_text_buffer_insert_with_tags_by_name")]
    //fn insert_with_tags_by_name(&self, iter: &mut TextIter, text: &str, first_tag_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs);

    #[doc(alias = "gtk_text_buffer_move_mark")]
    fn move_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_move_mark_by_name")]
    fn move_mark_by_name(&self, name: &str, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_paste_clipboard")]
    fn paste_clipboard(
        &self,
        clipboard: &Clipboard,
        override_location: Option<&TextIter>,
        default_editable: bool,
    );

    #[doc(alias = "gtk_text_buffer_place_cursor")]
    fn place_cursor(&self, where_: &TextIter);

    #[doc(alias = "gtk_text_buffer_register_deserialize_tagset")]
    fn register_deserialize_tagset(&self, tagset_name: Option<&str>) -> gdk::Atom;

    #[doc(alias = "gtk_text_buffer_register_serialize_tagset")]
    fn register_serialize_tagset(&self, tagset_name: Option<&str>) -> gdk::Atom;

    #[doc(alias = "gtk_text_buffer_remove_all_tags")]
    fn remove_all_tags(&self, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_remove_selection_clipboard")]
    fn remove_selection_clipboard(&self, clipboard: &Clipboard);

    #[doc(alias = "gtk_text_buffer_remove_tag")]
    fn remove_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_remove_tag_by_name")]
    fn remove_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter);

    #[doc(alias = "gtk_text_buffer_select_range")]
    fn select_range(&self, ins: &TextIter, bound: &TextIter);

    #[doc(alias = "gtk_text_buffer_serialize")]
    fn serialize(
        &self,
        content_buffer: &impl IsA<TextBuffer>,
        format: &gdk::Atom,
        start: &TextIter,
        end: &TextIter,
    ) -> Vec<u8>;

    #[doc(alias = "gtk_text_buffer_set_modified")]
    fn set_modified(&self, setting: bool);

    #[doc(alias = "gtk_text_buffer_set_text")]
    fn set_text(&self, text: &str);

    #[doc(alias = "gtk_text_buffer_unregister_deserialize_format")]
    fn unregister_deserialize_format(&self, format: &gdk::Atom);

    #[doc(alias = "gtk_text_buffer_unregister_serialize_format")]
    fn unregister_serialize_format(&self, format: &gdk::Atom);

    #[doc(alias = "cursor-position")]
    fn cursor_position(&self) -> i32;

    #[doc(alias = "begin-user-action")]
    fn connect_begin_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "changed")]
    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "end-user-action")]
    fn connect_end_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mark-deleted")]
    fn connect_mark_deleted<F: Fn(&Self, &TextMark) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "mark-set")]
    fn connect_mark_set<F: Fn(&Self, &TextIter, &TextMark) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId;

    #[doc(alias = "modified-changed")]
    fn connect_modified_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paste-done")]
    fn connect_paste_done<F: Fn(&Self, &Clipboard) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "copy-target-list")]
    fn connect_copy_target_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "cursor-position")]
    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "has-selection")]
    fn connect_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "paste-target-list")]
    fn connect_paste_target_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "text")]
    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<TextBuffer>> TextBufferExt for O {
    fn add_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_add_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn add_selection_clipboard(&self, clipboard: &Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_add_selection_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn apply_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_apply_tag(
                self.as_ref().to_glib_none().0,
                tag.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn apply_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_apply_tag_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn backspace(&self, iter: &mut TextIter, interactive: bool, default_editable: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_backspace(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                interactive.into_glib(),
                default_editable.into_glib(),
            ))
        }
    }

    fn begin_user_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_begin_user_action(self.as_ref().to_glib_none().0);
        }
    }

    fn copy_clipboard(&self, clipboard: &Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_copy_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn create_child_anchor(&self, iter: &mut TextIter) -> Option<TextChildAnchor> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_create_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            ))
        }
    }

    fn create_mark(
        &self,
        mark_name: Option<&str>,
        where_: &TextIter,
        left_gravity: bool,
    ) -> Option<TextMark> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_create_mark(
                self.as_ref().to_glib_none().0,
                mark_name.to_glib_none().0,
                where_.to_glib_none().0,
                left_gravity.into_glib(),
            ))
        }
    }

    fn cut_clipboard(&self, clipboard: &Clipboard, default_editable: bool) {
        unsafe {
            ffi::gtk_text_buffer_cut_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
                default_editable.into_glib(),
            );
        }
    }

    fn delete(&self, start: &mut TextIter, end: &mut TextIter) {
        unsafe {
            ffi::gtk_text_buffer_delete(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
        }
    }

    fn delete_interactive(
        &self,
        start_iter: &mut TextIter,
        end_iter: &mut TextIter,
        default_editable: bool,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_delete_interactive(
                self.as_ref().to_glib_none().0,
                start_iter.to_glib_none_mut().0,
                end_iter.to_glib_none_mut().0,
                default_editable.into_glib(),
            ))
        }
    }

    fn delete_mark(&self, mark: &impl IsA<TextMark>) {
        unsafe {
            ffi::gtk_text_buffer_delete_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
            );
        }
    }

    fn delete_mark_by_name(&self, name: &str) {
        unsafe {
            ffi::gtk_text_buffer_delete_mark_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            );
        }
    }

    fn delete_selection(&self, interactive: bool, default_editable: bool) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_delete_selection(
                self.as_ref().to_glib_none().0,
                interactive.into_glib(),
                default_editable.into_glib(),
            ))
        }
    }

    fn deserialize(
        &self,
        content_buffer: &impl IsA<TextBuffer>,
        format: &gdk::Atom,
        iter: &mut TextIter,
        data: &[u8],
    ) -> Result<(), glib::Error> {
        let length = data.len() as _;
        unsafe {
            let mut error = ptr::null_mut();
            let is_ok = ffi::gtk_text_buffer_deserialize(
                self.as_ref().to_glib_none().0,
                content_buffer.as_ref().to_glib_none().0,
                format.to_glib_none().0,
                iter.to_glib_none_mut().0,
                data.to_glib_none().0,
                length,
                &mut error,
            );
            debug_assert_eq!(is_ok == glib::ffi::GFALSE, !error.is_null());
            if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            }
        }
    }

    fn deserialize_get_can_create_tags(&self, format: &gdk::Atom) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_deserialize_get_can_create_tags(
                self.as_ref().to_glib_none().0,
                format.to_glib_none().0,
            ))
        }
    }

    fn deserialize_set_can_create_tags(&self, format: &gdk::Atom, can_create_tags: bool) {
        unsafe {
            ffi::gtk_text_buffer_deserialize_set_can_create_tags(
                self.as_ref().to_glib_none().0,
                format.to_glib_none().0,
                can_create_tags.into_glib(),
            );
        }
    }

    fn end_user_action(&self) {
        unsafe {
            ffi::gtk_text_buffer_end_user_action(self.as_ref().to_glib_none().0);
        }
    }

    fn bounds(&self) -> (TextIter, TextIter) {
        unsafe {
            let mut start = TextIter::uninitialized();
            let mut end = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            );
            (start, end)
        }
    }

    fn char_count(&self) -> i32 {
        unsafe { ffi::gtk_text_buffer_get_char_count(self.as_ref().to_glib_none().0) }
    }

    fn copy_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_copy_target_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn deserialize_formats(&self) -> Vec<gdk::Atom> {
        unsafe {
            let mut n_formats = mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_container_num(
                ffi::gtk_text_buffer_get_deserialize_formats(
                    self.as_ref().to_glib_none().0,
                    n_formats.as_mut_ptr(),
                ),
                n_formats.assume_init() as _,
            );
            ret
        }
    }

    fn end_iter(&self) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_end_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    fn has_selection(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_has_selection(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn get_insert(&self) -> Option<TextMark> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_insert(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn iter_at_child_anchor(&self, anchor: &impl IsA<TextChildAnchor>) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                anchor.as_ref().to_glib_none().0,
            );
            iter
        }
    }

    fn iter_at_line(&self, line_number: i32) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_line(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
            );
            iter
        }
    }

    fn iter_at_line_index(&self, line_number: i32, byte_index: i32) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_line_index(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
                byte_index,
            );
            iter
        }
    }

    fn iter_at_line_offset(&self, line_number: i32, char_offset: i32) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_line_offset(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                line_number,
                char_offset,
            );
            iter
        }
    }

    fn iter_at_mark(&self, mark: &impl IsA<TextMark>) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_mark(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                mark.as_ref().to_glib_none().0,
            );
            iter
        }
    }

    fn iter_at_offset(&self, char_offset: i32) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_iter_at_offset(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                char_offset,
            );
            iter
        }
    }

    fn line_count(&self) -> i32 {
        unsafe { ffi::gtk_text_buffer_get_line_count(self.as_ref().to_glib_none().0) }
    }

    fn mark(&self, name: &str) -> Option<TextMark> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_mark(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
            ))
        }
    }

    fn is_modified(&self) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_get_modified(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn paste_target_list(&self) -> Option<TargetList> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_paste_target_list(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selection_bound(&self) -> Option<TextMark> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_selection_bound(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn selection_bounds(&self) -> Option<(TextIter, TextIter)> {
        unsafe {
            let mut start = TextIter::uninitialized();
            let mut end = TextIter::uninitialized();
            let ret = from_glib(ffi::gtk_text_buffer_get_selection_bounds(
                self.as_ref().to_glib_none().0,
                start.to_glib_none_mut().0,
                end.to_glib_none_mut().0,
            ));
            if ret {
                Some((start, end))
            } else {
                None
            }
        }
    }

    fn serialize_formats(&self) -> Vec<gdk::Atom> {
        unsafe {
            let mut n_formats = mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_container_num(
                ffi::gtk_text_buffer_get_serialize_formats(
                    self.as_ref().to_glib_none().0,
                    n_formats.as_mut_ptr(),
                ),
                n_formats.assume_init() as _,
            );
            ret
        }
    }

    fn slice(
        &self,
        start: &TextIter,
        end: &TextIter,
        include_hidden_chars: bool,
    ) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_get_slice(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                include_hidden_chars.into_glib(),
            ))
        }
    }

    fn start_iter(&self) -> TextIter {
        unsafe {
            let mut iter = TextIter::uninitialized();
            ffi::gtk_text_buffer_get_start_iter(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
            );
            iter
        }
    }

    fn tag_table(&self) -> Option<TextTagTable> {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_get_tag_table(
                self.as_ref().to_glib_none().0,
            ))
        }
    }

    fn text(
        &self,
        start: &TextIter,
        end: &TextIter,
        include_hidden_chars: bool,
    ) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::gtk_text_buffer_get_text(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                include_hidden_chars.into_glib(),
            ))
        }
    }

    fn insert(&self, iter: &mut TextIter, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_at_cursor(&self, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert_at_cursor(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_child_anchor(&self, iter: &mut TextIter, anchor: &impl IsA<TextChildAnchor>) {
        unsafe {
            ffi::gtk_text_buffer_insert_child_anchor(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                anchor.as_ref().to_glib_none().0,
            );
        }
    }

    fn insert_interactive(&self, iter: &mut TextIter, text: &str, default_editable: bool) -> bool {
        let len = text.len() as _;
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_interactive(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                text.to_glib_none().0,
                len,
                default_editable.into_glib(),
            ))
        }
    }

    fn insert_interactive_at_cursor(&self, text: &str, default_editable: bool) -> bool {
        let len = text.len() as _;
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_interactive_at_cursor(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
                default_editable.into_glib(),
            ))
        }
    }

    fn insert_markup(&self, iter: &mut TextIter, markup: &str) {
        let len = markup.len() as _;
        unsafe {
            ffi::gtk_text_buffer_insert_markup(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                markup.to_glib_none().0,
                len,
            );
        }
    }

    fn insert_pixbuf(&self, iter: &mut TextIter, pixbuf: &gdk_pixbuf::Pixbuf) {
        unsafe {
            ffi::gtk_text_buffer_insert_pixbuf(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                pixbuf.to_glib_none().0,
            );
        }
    }

    fn insert_range(&self, iter: &mut TextIter, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_insert_range(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn insert_range_interactive(
        &self,
        iter: &mut TextIter,
        start: &TextIter,
        end: &TextIter,
        default_editable: bool,
    ) -> bool {
        unsafe {
            from_glib(ffi::gtk_text_buffer_insert_range_interactive(
                self.as_ref().to_glib_none().0,
                iter.to_glib_none_mut().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
                default_editable.into_glib(),
            ))
        }
    }

    //fn insert_with_tags_by_name(&self, iter: &mut TextIter, text: &str, first_tag_name: &str, : /*Unknown conversion*//*Unimplemented*/Basic: VarArgs) {
    //    unsafe { TODO: call ffi:gtk_text_buffer_insert_with_tags_by_name() }
    //}

    fn move_mark(&self, mark: &impl IsA<TextMark>, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_move_mark(
                self.as_ref().to_glib_none().0,
                mark.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn move_mark_by_name(&self, name: &str, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_move_mark_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn paste_clipboard(
        &self,
        clipboard: &Clipboard,
        override_location: Option<&TextIter>,
        default_editable: bool,
    ) {
        unsafe {
            ffi::gtk_text_buffer_paste_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
                mut_override(override_location.to_glib_none().0),
                default_editable.into_glib(),
            );
        }
    }

    fn place_cursor(&self, where_: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_place_cursor(
                self.as_ref().to_glib_none().0,
                where_.to_glib_none().0,
            );
        }
    }

    fn register_deserialize_tagset(&self, tagset_name: Option<&str>) -> gdk::Atom {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_register_deserialize_tagset(
                self.as_ref().to_glib_none().0,
                tagset_name.to_glib_none().0,
            ))
        }
    }

    fn register_serialize_tagset(&self, tagset_name: Option<&str>) -> gdk::Atom {
        unsafe {
            from_glib_none(ffi::gtk_text_buffer_register_serialize_tagset(
                self.as_ref().to_glib_none().0,
                tagset_name.to_glib_none().0,
            ))
        }
    }

    fn remove_all_tags(&self, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_all_tags(
                self.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn remove_selection_clipboard(&self, clipboard: &Clipboard) {
        unsafe {
            ffi::gtk_text_buffer_remove_selection_clipboard(
                self.as_ref().to_glib_none().0,
                clipboard.to_glib_none().0,
            );
        }
    }

    fn remove_tag(&self, tag: &impl IsA<TextTag>, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_tag(
                self.as_ref().to_glib_none().0,
                tag.as_ref().to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn remove_tag_by_name(&self, name: &str, start: &TextIter, end: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_remove_tag_by_name(
                self.as_ref().to_glib_none().0,
                name.to_glib_none().0,
                start.to_glib_none().0,
                end.to_glib_none().0,
            );
        }
    }

    fn select_range(&self, ins: &TextIter, bound: &TextIter) {
        unsafe {
            ffi::gtk_text_buffer_select_range(
                self.as_ref().to_glib_none().0,
                ins.to_glib_none().0,
                bound.to_glib_none().0,
            );
        }
    }

    fn serialize(
        &self,
        content_buffer: &impl IsA<TextBuffer>,
        format: &gdk::Atom,
        start: &TextIter,
        end: &TextIter,
    ) -> Vec<u8> {
        unsafe {
            let mut length = mem::MaybeUninit::uninit();
            let ret = FromGlibContainer::from_glib_full_num(
                ffi::gtk_text_buffer_serialize(
                    self.as_ref().to_glib_none().0,
                    content_buffer.as_ref().to_glib_none().0,
                    format.to_glib_none().0,
                    start.to_glib_none().0,
                    end.to_glib_none().0,
                    length.as_mut_ptr(),
                ),
                length.assume_init() as _,
            );
            ret
        }
    }

    fn set_modified(&self, setting: bool) {
        unsafe {
            ffi::gtk_text_buffer_set_modified(self.as_ref().to_glib_none().0, setting.into_glib());
        }
    }

    fn set_text(&self, text: &str) {
        let len = text.len() as _;
        unsafe {
            ffi::gtk_text_buffer_set_text(
                self.as_ref().to_glib_none().0,
                text.to_glib_none().0,
                len,
            );
        }
    }

    fn unregister_deserialize_format(&self, format: &gdk::Atom) {
        unsafe {
            ffi::gtk_text_buffer_unregister_deserialize_format(
                self.as_ref().to_glib_none().0,
                format.to_glib_none().0,
            );
        }
    }

    fn unregister_serialize_format(&self, format: &gdk::Atom) {
        unsafe {
            ffi::gtk_text_buffer_unregister_serialize_format(
                self.as_ref().to_glib_none().0,
                format.to_glib_none().0,
            );
        }
    }

    fn cursor_position(&self) -> i32 {
        glib::ObjectExt::property(self.as_ref(), "cursor-position")
    }

    fn connect_begin_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn begin_user_action_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"begin-user-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    begin_user_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn changed_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_end_user_action<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn end_user_action_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"end-user-action\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    end_user_action_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mark_deleted<F: Fn(&Self, &TextMark) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn mark_deleted_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextMark) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            mark: *mut ffi::GtkTextMark,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(mark),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mark-deleted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mark_deleted_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_mark_set<F: Fn(&Self, &TextIter, &TextMark) + 'static>(
        &self,
        f: F,
    ) -> SignalHandlerId {
        unsafe extern "C" fn mark_set_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &TextIter, &TextMark) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            location: *mut ffi::GtkTextIter,
            mark: *mut ffi::GtkTextMark,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(location),
                &from_glib_borrow(mark),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"mark-set\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    mark_set_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_modified_changed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn modified_changed_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"modified-changed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    modified_changed_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paste_done<F: Fn(&Self, &Clipboard) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn paste_done_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P, &Clipboard) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            clipboard: *mut ffi::GtkClipboard,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(
                TextBuffer::from_glib_borrow(this).unsafe_cast_ref(),
                &from_glib_borrow(clipboard),
            )
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"paste-done\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    paste_done_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_copy_target_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_copy_target_list_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::copy-target-list\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_copy_target_list_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_cursor_position_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_cursor_position_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::cursor-position\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_cursor_position_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_has_selection_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_has_selection_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::has-selection\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_has_selection_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_paste_target_list_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_paste_target_list_trampoline<
            P: IsA<TextBuffer>,
            F: Fn(&P) + 'static,
        >(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::paste-target-list\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_paste_target_list_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    fn connect_text_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_text_trampoline<P: IsA<TextBuffer>, F: Fn(&P) + 'static>(
            this: *mut ffi::GtkTextBuffer,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(TextBuffer::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::text\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(
                    notify_text_trampoline::<Self, F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

impl fmt::Display for TextBuffer {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("TextBuffer")
    }
}
