#ifndef MCPSERVERITEM_H
#define MCPSERVERITEM_H

#include "uosai_global.h"

#include <DWidget>
#include <DSwitchButton>
#include <DLabel>
#include <DSuggestButton>
#include <DPushButton>

#include <QProcess>
#include <QTimer>

DWIDGET_USE_NAMESPACE

namespace uos_ai {
class McpServerItem: public DWidget
{
    Q_OBJECT

public:
    explicit McpServerItem(DWidget *parent = nullptr);
    ~McpServerItem() override;

    void updateStatus();
    void setText(const QString &theme, const QString &summary);
    void setAppName(const QString &appName);

private slots:
    void onInstall();
    void onUninstall();
    void onUpdate();
    void checkStatusOntime();

private:
    void initUI();
    void initConnect();

    void checkInstallStatus();
    void changeInstallStatus();
    void beginTimer(const int &time);
    void stopTimer();

    void checkUpdateStatus();
    QString getUpdateVersion(const QByteArray& reply);

private:
    DLabel *m_pNameLabel = nullptr;
    DLabel *m_pDescLabel = nullptr;
    DSuggestButton *m_pBtnInstall = nullptr;
    DPushButton *m_pBtnUninstall = nullptr;
    DSuggestButton *m_pBtnUpdate = nullptr;

    QProcess *m_pProcess = nullptr;
    QTimer *m_timer = nullptr;

    QString m_appName = "uos-ai-agent";  // MCP服务的包名
    bool m_isInstalled = false;
    int m_timerCount = 0;

    QString m_updateVersion;
};
}

#endif // MCPSERVERITEM_H