//
// Created by dtx on 2022/3/24.
//

#ifndef UOS_RECOVERY_EXTRACTSQUASHFSTASKTEST_H
#define UOS_RECOVERY_EXTRACTSQUASHFSTASKTEST_H

#include "utils/SquashfsTask.h"
#include <gtest/gtest.h>
#include <QTimer>
#include <QObject>
#include <QEventLoop>

class ExtractSquashfsTaskTestHandle : public QObject
{
Q_OBJECT
public:
    explicit ExtractSquashfsTaskTestHandle(QEventLoop *eventLoop);
    ~ExtractSquashfsTaskTestHandle();
    bool doExtractSquashfs(const QString &srcfile, const QString &destdir);

signals:
    void error();
    void finished();

public:
    bool isDone();

private:
    SquashfsTask *m_squashfsTask = nullptr;
    QEventLoop *m_eventLoop;
};

class ExtractSquashfsTaskTest  : public testing::Test
{
public:
    void SetUp() override
    {
        m_loop = new QEventLoop;
        m_squashfsTaskTestHandle = new ExtractSquashfsTaskTestHandle(m_loop);
    }

    void TearDown() override
    {
        if (m_squashfsTaskTestHandle != nullptr) {
            delete m_squashfsTaskTestHandle;
            m_squashfsTaskTestHandle = nullptr;
        }
        if (m_loop != nullptr) {
            delete m_loop;
            m_loop = nullptr;
        }
    }

public:
    ExtractSquashfsTaskTestHandle *m_squashfsTaskTestHandle = nullptr;
    QEventLoop *m_loop = nullptr;
};


#endif //UOS_RECOVERY_EXTRACTSQUASHFSTASKTEST_H
