#include "UImgOperateTest.h"
#include "uimg-installer/UImgOperate.h"
#include "utils/Device.h"

TEST_F(UImgOperateTest, installImgFile)
{
    // ghost 文件要放在非安装的磁盘里，即不在destDevices列表中
    // 手动将ghost 文件 mount 到 /mnt目录下
    bool retCode = false;
    QString ghostDir = "/media/zxm/837131d7-3826-4c1a-880d-c68cb0f0d6df/soft/";
    QString ghostName = "ghost_23_Community_2000_100_amd64_20221016-162515_legacy_twodiskfull.uimg";
    QString imgFile = ghostDir + ghostName;
    QStringList destDevices;
    destDevices<<"/dev/sda";
    destDevices<<"/dev/sdb";
    UImgOperate uop;
    uop.installImgFile(imgFile, destDevices);
    EXPECT_TRUE(retCode);
}

TEST_F(UImgOperateTest, renameVgName)
{
    bool retCode = false;
    // 对应ghost里的partition
    QString partitionFile = "/home/zxm/Desktop/test_partition.json";
    QStringList sysVgNameList;
    retCode = Device::getVGNames(sysVgNameList);
    EXPECT_TRUE(retCode);

    UImgOperate uop;
    uop.renameVgName(partitionFile, sysVgNameList);
    EXPECT_TRUE(retCode);
}

TEST_F(UImgOperateTest, updateCrypttab)
{
    bool retCode = false;
    retCode = UImgOperate::updateCrypttab();
    EXPECT_TRUE(retCode);
}

TEST_F(UImgOperateTest, updateUdisksRules)
{
    bool retCode = false;
    QString fstabPath = "/etc/fstab";
    QString udiskRulePath = "/home/zxm/Desktop/80-udisks-installer.rules";
    QString rootPath = "/";
    retCode = UImgOperate::updateUdisksRules(rootPath, fstabPath, udiskRulePath);
    EXPECT_TRUE(retCode);
}
