//
// Created by uos on 2022/3/17.
//

#ifndef UOS_RECOVERY_ADVANCEDWIDGET_H
#define UOS_RECOVERY_ADVANCEDWIDGET_H

#include <DPushButton>
#include <DGuiApplicationHelper>
#include <DWidget>
#include <QMouseEvent>

DTK_USE_NAMESPACE
DWIDGET_USE_NAMESPACE

class QLabel;
class ItemFrame;
class HelpDialog;

class AdvancedWidget : public DWidget
{
    Q_OBJECT
public:
    explicit AdvancedWidget(DWidget *parent = nullptr);

private:
    void initUI();
    void initConnect();
    int getAdvanceUiLayoutType();
    void initHelpLayout();

signals:
    void showGhostWidgetSignal();
    void enter();
    void leave();

private Q_SLOTS:
    void onItemIcoBtnClicked();
    void onNextBtnBtnClicked();
    void onThemeChange(Dtk::Gui::DGuiApplicationHelper::ColorType themeType);

protected:
    bool eventFilter(QObject* watched, QEvent* event);

private:
    Dtk::Gui::DGuiApplicationHelper *m_guiHelper;
    QLabel *m_title = nullptr;
    QLabel *m_subTitle = nullptr;
    QLabel *m_helpLabel = nullptr;
    DPushButton *m_nextBtn = nullptr;
    QWidget *m_nextButtonWidget = nullptr;
    ItemFrame *m_itemGhostFrame = nullptr;
    HelpDialog* m_helpDialog = nullptr;
    bool m_bDirectionRTL = false;
};

#endif //UOS_RECOVERY_ADVANCEDWIDGET_H
