#pragma once
#include "SystemRecovery.h"
#include "utils/RemoveTask.h"

class RsyncTask;
class SquashfsTask;
class CheckTask;

class RsyncSystem : public SystemRecovery
{
    Q_OBJECT
public:
    RsyncSystem();
    ~RsyncSystem();

    //分区方式是否支持rsync
    bool supported(FSTabInfoList &fsTabInfoList) override;
    //获取备份默认存放路径
    QString getDefaultBackupDeviceUUID(const QString &rootPath) override;
    //备份系统
    ErrorCode systemBackup(SystemBackupRequest &request) override;
    //还原系统
    ErrorCode systemRestore(SystemRestoreRequest &request) override;
    //制作uimg
    ErrorCode createUImg(const QString &backupDir) override;

    BackupInfoList listSystemBackup(QStringList &destUUIDs) override;

    ErrorCode removeSystemBackup(RemoveUserDataBackupRequest &request) override;
    ErrorCode checkFullSystemBackupSpace(SystemBackupRequest &request) override;
    ErrorCode checkIncSystemBackupSpace(SystemBackupRequest &request) override;

    void writeBackupInfo();
private:
    QStringList getRsyncSystemBackupArgs();
    QStringList getRsyncSystemBackupExcludes();
    QStringList getOStreeRsyncSystemBackupExcludes();
    ErrorCode fillBackupInfo(const SystemBackupRequest &request);

private:
    RsyncTask *m_pSystemBackupTask = nullptr;
    RemoveTask *m_pRemoveTask = nullptr;
    SquashfsTask *m_pSquashfsTask = nullptr;
    CheckTask *m_checkTask = nullptr;
    QString m_destDir;
    QString m_last;
    SystemBackupRequest m_request;
    BackupInfo m_backupInfo;
};
