#pragma once
#include "UserDataRecovery.h"
#include "utils/RsyncTask.h"
#include "utils/RemoveTask.h"
#include "utils/RsyncDryRunTask.h"

class RsyncUserData : public UserDataRecovery
{
    Q_OBJECT
public:
    explicit RsyncUserData();
    virtual ~RsyncUserData();

    bool supported(FSTabInfoList &fsTabInfoList) override;
    //备份用户数据
    ErrorCode userDataBackup(UserDataBackupRequest &request) override;
    ErrorCode checkUserDataBackupSpace(UserDataBackupRequest &request) override;
    //还原用户数据
    ErrorCode userDataRestore(UserDataRestoreRequest &request) override;
    BackupInfoList listUserDataBackup(const QString &username) override;
    ErrorCode removeUserDataBackup(RemoveUserDataBackupRequest &request) override;

private:
    void writeBackupInfo();
    ErrorCode fillBackupInfo();
    ErrorCode parseUserDataBackupReq(const UserDataBackupRequest &request);

private:
    RsyncTask *m_pUserDataBackTask = nullptr;
    RsyncTask *m_pUserDataRestoreTask = nullptr;
    RemoveTask *m_pRemoveTask = nullptr;
    RsyncDryRunTask *m_pTryBackupTask = nullptr;
    QString m_fromDir;
    QString m_toDir;
    QString m_destDir;
    QString m_last;
    BackupInfo m_backupInfo;
    UserDataBackupRequest m_request;
};


