
# fakequery.py
# answer a question by looking at a keymap

# Copyright (c) 2005 by Matthias Urlichs <smurf@smurf.noris.de>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of Version 2 of the GNU General Public License as
# published by the Free Software Foundation. See the file COPYING.txt
# or (on Debian systems) /usr/share/common-licenses/GPL-2 for details.

"""\
This module answers questions by looking them up in the supplied keymap.
"""

from keymapper.query import Query
from random import uniform

class FakeQuery(Query):
	"""A fake keyboard inquiry which actually looks at a keymap.
	   Used for testing."""

	def __init__(self, map):
		Query.__init__(self)
		self.map = map

	def press(self,syms):
		print "* Press one of '"+"' '".join(syms)+"' !"
		syms = [ sym for sym in syms if sym in self.map.sym2code ]
		print "I have '"+"' '".join(syms)+"'."
		sym = syms[int(uniform(0,len(syms)))]
		code = self.map.sym2code[sym]
		code = code[int(uniform(0,len(code)))][0]
		print "I choose %s => %d" % (sym,code)
		return code

	def ask(self,sym):
		print "* Do I see '"+sym+"' ?"
		if sym in self.map.sym2code:
			print "Yes"
		else:
			print "No"
		return sym in self.map.sym2code

