% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv_error.R
\name{cv_error}
\alias{cv_error}
\alias{cv_compare}
\title{Test and training error from model cross-validation}
\usage{
cv_error(data, formula, k = 5)

cv_compare(data, formulas, k = 5)
}
\arguments{
\item{data}{A data frame.}

\item{formula}{The formula to fit the linear model for the test and training data.}

\item{k}{The number of folds for the kfold-crossvalidation.}

\item{formulas}{A list of formulas, to fit linear models for the test and training data.}
}
\value{
A data frame with the root mean squared errors for the training and test data.
}
\description{
\code{cv_error()} computes the root mean squared error from a model fitted
         to kfold cross-validated test-training-data. \code{cv_compare()}
         does the same, for multiple formulas at once (by calling \code{cv_error()}
         for each formula).
}
\details{
\code{cv_error()} first generates cross-validated test-training pairs, using
         \code{\link[modelr]{crossv_kfold}} and then fits a linear model, which
         is described in \code{formula}, to the training data. Then, predictions
         for the test data are computed, based on the trained models.
         The \emph{training error} is the mean value of the \code{\link{rmse}} for
         all \emph{trained} models; the \emph{test error} is the rmse based on all
         residuals from the test data.
}
\examples{
data(efc)
cv_error(efc, neg_c_7 ~ barthtot + c161sex)

cv_compare(efc, formulas = list(
  neg_c_7 ~ barthtot + c161sex,
  neg_c_7 ~ barthtot + c161sex + e42dep,
  neg_c_7 ~ barthtot + c12hour
))

}
\seealso{
\code{\link{pred_accuracy}}
}
